# -*- coding: utf-8 -*-
import sys
from pyqtgraph.Qt import QtCore, QtGui, uic
from PyQt4.QtCore import pyqtSignal, QSize, Qt
import pyqtgraph as pg
import pyqtgraph.opengl as gl
import numpy as np
from OpenGL.GL import *
import SliceData
import FreeSliceData
import ViewSubData

import Manyo
import Manyo.Utsusemi
import PlaneSlicer
import vis.M2Plot as mp
import threading
import math
import time
import os
import subprocess

class ViewMainData(QtCore.QObject):
    SLICE_XY = 0
    SLICE_YZ = 1
    SLICE_ZX = 2
    
    PROCESS_MAIN       = 0
    PROCESS_M2PLOT     = 1
    PROCESS_OUT_IMAGE  = 2
    PROCESS_OUT_BINARY = 3

    DATA_ORI_XYZ = 0
    DATA_ORI_XZY = 1
    DATA_ORI_YXZ = 2
    DATA_ORI_YZX = 3
    DATA_ORI_ZXY = 4
    DATA_ORI_ZYX = 5

    def __init__(self,ecm_in=None):
        super(ViewMainData, self).__init__()
        self.filePath = ""
        self.stop_event = threading.Event()
        self.data_xy = np.zeros((1, 1))
        self.data_xy_pos = 0.0
        self.data_xy_range = [0.0, 1.0, 0.0, 1.0]
        self.data_yz = np.zeros((1, 1))
        self.data_yz_pos = 0.0
        self.data_yz_range = [0.0, 1.0, 0.0, 1.0]
        self.data_zx = np.zeros((1, 1))
        self.data_zx_pos = 0.0
        self.data_zx_range = [0.0, 1.0, 0.0, 1.0]
        self.data_ax1bin = 1.0
        self.data_ax2bin = 1.0
        self.data_ax3bin = 1.0
        self.data_free = np.zeros((1, 1))
      
        self.intensityMin = 9999
        self.intensityMax = -9999
        self.imageID = 0
        
        self.basicSliceAx1From = 0.0
        self.basicSliceAx1To   = 0.0
        self.basicSliceAx2From = 0.0
        self.basicSliceAx2To   = 0.0
        self.basicSliceAx3From = 0.0
        self.basicSliceAx3To   = 0.0

        # 3面スライス用共通データ
        self.basicSliceAx1bin = 0.01
        self.basicSliceAx2bin = 0.01
        self.basicSliceAx3bin = 0.01
        
        self.basicSliceAx1Scale = 1.0
        self.basicSliceAx2Scale = 1.0
        self.basicSliceAx3Scale = 1.0

        # 3面スライス用データ(各軸)
        self.ax1Slice = SliceData.SliceData()
        self.ax1Slice.axisTitle = "ax1"
        self.ax2Slice = SliceData.SliceData()
        self.ax2Slice.axisTitle = "ax2"
        self.ax3Slice = SliceData.SliceData()
        self.ax3Slice.axisTitle = "ax3"

        self.slicePlane = ViewMainData.SLICE_XY


        self.freeSlice = FreeSliceData.FreeSliceData()
        
        self.ax1Key = "Xval"
        self.ax2Key = "Yval"
        self.ax3Key = "Zval"

        #--------- 
        self.update_slice_view_flag = False
        # signals

        self.update_scrollbar_signal   = QtCore.SIGNAL("update_scrollbar_signal")
        self.update_scrollbar_range_signal = QtCore.SIGNAL("update_scrollbar_range_signal")
        self.update_data_info_signal   = QtCore.SIGNAL("update_data_information_signal")
        self.update_basic_slice_signal = QtCore.SIGNAL("update_basic_slice_signal")
        self.update_axis_grid_signal   = QtCore.SIGNAL("update_axis_grid_signal")
        self.status_bar_signal         = QtCore.SIGNAL("status_bar_signal")
        self.create_slice_signal       = QtCore.SIGNAL("create_slice_signal")
        self.create_free_slice_signal  = QtCore.SIGNAL("create_free_slice_signal")
        self.update_slice_view_signal  = QtCore.SIGNAL("update_slice_view_signal")
        self.update_glview_signal      = QtCore.SIGNAL("update_glview_signal")
        self.save_glview_signal        = QtCore.SIGNAL("save_glview_signal")
        self.update_autoscale_signal   = QtCore.SIGNAL("update_autoscale_signal")

        self.update_grid_size_signal   = QtCore.SIGNAL("update_grid_size_signal")
        self.update_grid_signal        = QtCore.SIGNAL("update_grid_signal")

        #[inamura 170227]-->
        self.data_ecm = None
        if (ecm_in!=None):
            self.SetData( ecm_in )
        #<--[inamura 170227]

    #[inamura 170227]-->
    def SetData(self, ecm_in, xkey="-", ykey="-", zkey="-", isFromFile=False):
        if self.data_ecm!=None:
            del self.data_ecm

        self.data_ecm = ecm_in

        if not isFromFile:
            self.filePath="Direct"

        ecm_hh = self.data_ecm.PutHeaderPointer()
        if ( xkey=="-" and ykey=="-" and zkey=="-" ):
            if ecm_hh.CheckKey("SLICE3DKEYS")==1:
                key_vect = ecm_hh.PutStringVector("SLICE3DKEYS")
                self.ax1Key = key_vect[0]
                self.ax2Key = key_vect[1]
                self.ax3Key = key_vect[2]
            else:
                self.data_ecm = None
                return
        else:
            self.ax1Key = xkey
            self.ax2Key = ykey
            self.ax3Key = zkey

        
        self.rangex = [-0.5, 3.0]
        self.rangey = [-1.0, 1.5]
        self.rangez = [0.1, 30.1]

        self.getDataInformation()
        self.getDataKeys() 

        # set view scale
        lenX = self.rangex[1] - self.rangex[0]
        lenY = self.rangey[1] - self.rangey[0]
        lenZ = self.rangez[1] - self.rangez[0]

        scaleExp = 3
        if lenX < lenY and lenX < lenZ:
           self.basicSliceAx1Scale = 1.0
           self.basicSliceAx2Scale = lenX/lenY
           self.basicSliceAx3Scale = lenX/lenZ
        elif lenY < lenZ:
           self.basicSliceAx1Scale = lenY/lenX
           self.basicSliceAx2Scale = 1.0
           self.basicSliceAx3Scale = lenY/lenZ
        else:
           self.basicSliceAx1Scale = lenZ/lenX
           self.basicSliceAx2Scale = lenZ/lenY
           self.basicSliceAx3Scale = 1.0

        self.basicSliceAx1Scale = round(self.basicSliceAx1Scale, scaleExp)
        self.basicSliceAx2Scale = round(self.basicSliceAx2Scale, scaleExp)
        self.basicSliceAx3Scale = round(self.basicSliceAx3Scale, scaleExp)

        self.basicSliceAx1From = self.rangex[0]
        self.basicSliceAx1To   = self.rangex[1]
        self.basicSliceAx2From = self.rangey[0]
        self.basicSliceAx2To   = self.rangey[1]
        self.basicSliceAx3From = self.rangez[0]
        self.basicSliceAx3To   = self.rangez[1]

        self.ax1Slice.thickness = self.basicSliceAx1bin * 1.0
        self.ax2Slice.thickness = self.basicSliceAx2bin * 1.0
        self.ax3Slice.thickness = self.basicSliceAx3bin * 1.0


        lenX = self.rangex[1] - self.rangex[0]
        lenY = self.rangey[1] - self.rangey[0]
        lenZ = self.rangez[1] - self.rangez[0]

        self.emit(self.update_data_info_signal)
        self.emit(self.update_basic_slice_signal)
        self.emit(self.update_axis_grid_signal)
        self.emit(self.update_scrollbar_range_signal)
        QtGui.QApplication.restoreOverrideCursor()

    def ReadSerializationFileBinary(self, filePath):
        QtGui.QApplication.setOverrideCursor(QtGui.QCursor(QtCore.Qt.WaitCursor))
        self.filePath = filePath
        data_ecm = None
        root, ext = os.path.splitext(str(filePath))
        if ext == ".txt":
            data_ecm = Manyo.ElementContainerMatrix()
            tt = Manyo.Utsusemi.UtsusemiContainerTextConverter()
            tt.Load( str(filePath), data_ecm )
            del tt
        elif ext == ".srlz":
            data_ecm = Manyo.ElementContainerMatrix()
            file = Manyo.ReadSerializationFileBinary(str(filePath))
            file.Load(data_ecm)            
            del file
        elif ext == ".mbd":
            ff = Manyo.ManyoDataIO()
            data_ecm = ff.ReadElementContainerMatrix(str(filePath))
            del ff
        
        self.SetData(data_ecm)
    #<--[inamura 170227]

    def getDataInformation(self):
        if not hasattr(self, 'data_ecm'):
            return
        
        ecaNum = self.data_ecm.PutSize()
        eca0 = self.data_ecm.Put(0)
        ecNum = eca0.PutSize()

        ec0  = eca0.Put(0)
        ec0.SetKeys(self.ax1Key, self.ax2Key, self.ax3Key)
        x = ec0.PutXList()
        y = ec0.PutYList()
        z = ec0.PutEList()

        xmin = min(x)
        xmax = max(x)
        ymin = min(y)
        ymax = max(y)
        zmin = min(z)
        zmax = max(z)
        
        ec1 = eca0.Put(1)

        if xmin != xmax:
            self.xlist = x
            ec1.SetKeys(self.ax2Key, self.ax3Key, self.ax1Key)
            x1 = ec1.PutXList()
            y1 = ec1.PutYList()
            xmin1 = min(x1)
            ymin1 = min(y1)
            if xmin != xmin1:
               self.data_orientation = ViewMainData.DATA_ORI_XYZ
               self.ylist = [0] * ecNum
               self.zlist = [0] * ecaNum
            else:
               self.data_orientation = ViewMainData.DATA_ORI_XZY
               self.ylist = [0] * ecaNum
               self.zlist = [0] * ecNum
        elif ymin != ymax:
            self.ylist = y
            ec1.SetKeys(self.ax1Key, self.ax3Key, self.ax2Key)
            x1 = ec1.PutXList()
            y1 = ec1.PutYList()
            xmin1 = min(x1)
            ymin1 = min(y1)
            if xmin != xmin1:
               self.data_orientation = ViewMainData.DATA_ORI_YXZ
               self.xlist = [0] * ecNum
               self.zlist = [0] * ecaNum
            else:
               self.data_orientation = ViewMainData.DATA_ORI_YZX
               self.xlist = [0] * ecaNum
               self.zlist = [0] * ecNum
        elif zmin != zmax:
            self.zlist = z
            ec1.SetKeys(self.ax1Key, self.ax2Key, self.ax3Key)
            x1 = ec1.PutXList()
            y1 = ec1.PutYList()
            xmin1 = min(x1)
            ymin1 = min(y1)
            if xmin != xmin1:
               self.data_orientation = ViewMainData.DATA_ORI_ZXY
               self.xlist = [0] * ecNum
               self.ylist = [0] * ecaNum
            else:
               self.data_orientation = ViewMainData.DATA_ORI_ZYX
               self.xlist = [0] * ecaNum
               self.ylist = [0] * ecNum
        
        for id in range(ecNum):
            ec_id = eca0.Put(id)
            ec_id.SetKeys(self.ax1Key, self.ax2Key, self.ax3Key)
            x = ec_id.PutXList()
            y = ec_id.PutYList()
            z = ec_id.PutEList()
            if self.data_orientation == ViewMainData.DATA_ORI_ZXY or \
               self.data_orientation == ViewMainData.DATA_ORI_YXZ:
                self.xlist[id] = min(x)
            elif self.data_orientation == ViewMainData.DATA_ORI_XYZ or \
                 self.data_orientation == ViewMainData.DATA_ORI_ZYX:
                self.ylist[id] = min(y)
            elif self.data_orientation == ViewMainData.DATA_ORI_XZY or \
                 self.data_orientation == ViewMainData.DATA_ORI_YZX:
                self.zlist[id] = min(z)

        for id in range(ecaNum):
            eca_id = self.data_ecm.Put(id)
            ec = eca_id.Put(0)
            ec.SetKeys(self.ax1Key, self.ax2Key, self.ax3Key)
            x = ec.PutXList()
            y = ec.PutYList()
            z = ec.PutEList()
            if self.data_orientation == ViewMainData.DATA_ORI_ZYX or \
               self.data_orientation == ViewMainData.DATA_ORI_YZX:
                self.xlist[id] = min(x)
            elif self.data_orientation == ViewMainData.DATA_ORI_XZY or \
                 self.data_orientation == ViewMainData.DATA_ORI_ZXY:
                self.ylist[id] = min(y)
            elif self.data_orientation == ViewMainData.DATA_ORI_XYZ or \
                 self.data_orientation == ViewMainData.DATA_ORI_YXZ:
                self.zlist[id] = min(z)



        # get minimum bin size
        size = len(self.xlist)
        tmp1 = np.array(self.xlist[0:size-1])
        tmp2 = np.array(self.xlist[1:size])
        tmp3 = tmp2 - tmp1
        self.basicSliceAx1bin = min(tmp3)

        size = len(self.ylist)
        tmp1 = np.array(self.ylist[0:size-1])
        tmp2 = np.array(self.ylist[1:size])
        tmp3 = tmp2 - tmp1
        self.basicSliceAx2bin = min(tmp3)

        size = len(self.zlist)
        tmp1 = np.array(self.zlist[0:size-1])
        tmp2 = np.array(self.zlist[1:size])
        tmp3 = tmp2 - tmp1
        self.basicSliceAx3bin = min(tmp3)
        
        # get xrange, yrange, zrange
        self.rangex = [min(self.xlist), max(self.xlist)]
        self.rangey = [min(self.ylist), max(self.ylist)]
        self.rangez = [min(self.zlist), max(self.zlist)]
        #print "len(self.xlist), len(self.ylist), len(self.zlist)=",len(self.xlist), len(self.ylist), len(self.zlist)


        eca   = self.data_ecm.Put(0)
        ecNum = eca.PutSize()
        self.minIntensity = np.zeros((ecaNum, ecNum))
        self.maxIntensity = np.zeros((ecaNum, ecNum))
        for id in range(ecaNum):
            eca = self.data_ecm.Put(id)
            ecNum = eca.PutSize()
            for i in range(ecNum):
                ec = eca.Put(i)
                intensity = ec.PutList("Intensity")
                #intensity = ec.PutYList()
                error     = ec.PutList("Error")
                tmp  = np.array(intensity)
                tmp2 = tmp[np.where(tmp < 1.0)]
                if tmp2.size > 0:
                    self.minIntensity[id, i] = tmp2.min()
                    self.maxIntensity[id, i] = tmp2.max()

    def getDataKeys(self):
        #self.ax1Key = "Xval"
        #self.ax2Key = "Yval"
        #self.ax3Key = "Zval"
        
        self.ax1Slice.axisTitle = self.ax1Key
        self.ax2Slice.axisTitle = self.ax2Key
        self.ax3Slice.axisTitle = self.ax3Key

    def isThreadRunning(self):
        running = False
        if hasattr(self, "sliceThread"):
           if self.sliceThread.is_alive():
               running = True
        
        return running

        #tlist = threading.enumerate()
        #if 1 < len(tlist):
        #     return True
        #else:
        #     return False
        #for t in tlist:
        #        print t.name        
    
    def getThreadName(self, process, planeID):
        procName = ""
        if process == ViewMainData.PROCESS_MAIN:
           procName = "main"
        elif process == ViewMainData.PROCESS_M2PLOT:
           procName = "m2plot"
        elif process == ViewMainData.PROCESS_OUT_IMAGE:
           procName = "image"
        elif process == ViewMainData.PROCESS_OUT_BINARY:
           procName = "binary"
        
        procName += "-%d" % planeID
        return procName

    def doFreeSliceView(self, process, outputPath):
        if self.isThreadRunning():
            #QtGui.QMessageBox.warning(self, 'Error', 'Other thread is running. Please wait.')
            return False
        
        if process == ViewMainData.PROCESS_M2PLOT:
            self.showFreeSliceView(process, outputPath)
        else:
            self.sliceThread = threading.Thread(target = self.showFreeSliceView, \
                                                args=(process, outputPath))
            self.sliceThread.start()
        return True

    def showFreeSliceView(self, process, outputPath):
        QtGui.QApplication.setOverrideCursor(QtGui.QCursor(QtCore.Qt.WaitCursor))
        self.stop_event.clear()
        ps = PlaneSlicer.PlaneSlicer(self.data_ecm)

        org = self.freeSlice.org
        x   = self.freeSlice.x
        y   = self.freeSlice.y
        xbin   = self.freeSlice.xbin
        ybin   = self.freeSlice.ybin
        rngx  = self.freeSlice.rangex
        rngy  = self.freeSlice.rangey
        thick = self.freeSlice.thickness

        ps.SetAxes(self.ax1Key, self.ax2Key, self.ax3Key)
        ps.SetPlaneKeys(self.ax1Key, self.ax2Key)
            
        eca  = ps.GetPlane(org, x, y, xbin, ybin, rngx, rngy, thick)

        root, ext = os.path.splitext(str(outputPath))

        current = 0
        if process == ViewMainData.PROCESS_M2PLOT:
            p    = mp.M2Plot(eca)
#            subprocess.call("mp.M2PLot(eca)")
        elif process == ViewMainData.PROCESS_OUT_BINARY:
            path = root + "-f%03d.eca" % (current -1)
            eca.SaveToBinFile("Intensity", path)
            #filePath = "‾/test.srlz"
            #write_binary = Manyo.WriteSerializationFileBinary(str(filePath))
            #write_binary.Save(eca)
        elif process == ViewMainData.PROCESS_MAIN:
            self.extractIntensityForFreeSlice(eca)
            self.emit(self.create_free_slice_signal, (0,))
            self.emit(self.update_glview_signal)
#             if self.update_slice_view_flag:
#                 self.emit(self.update_slice_view_signal, (planeID, ))
#             time.sleep(1) 
        elif process == ViewMainData.PROCESS_OUT_IMAGE:
            self.extractIntensityForFreeSlice(eca)
            self.emit(self.create_free_slice_signal, (0,))
            self.emit(self.update_glview_signal)

#             if self.update_slice_view_flag:
#                 self.emit(self.update_slice_view_signal, (planeID, ))
# #            path = root + "%03d.png" % (current -1)
#             path = root + "%03d.png" % self.imageID
#             self.emit(self.save_glview_signal, path)
#             time.sleep(1) 

#        message = "%d/%d done  @ %s = %g" % (current, totalNum, posStr, pos)
#        self.emit(self.status_bar_signal, message)

#        self.emit(self.update_scrollbar_signal)

        QtGui.QApplication.restoreOverrideCursor() 


    def doBasicSliceView(self, process, planeID, outputPath, ax1Changed = False, ax2Changed = False, ax3Changed = False):
        if self.isThreadRunning():
            #QtGui.QMessageBox.warning(self, 'Error', 'Other thread is running. Please wait.')
            return False

        #threadName = self.getThreadName(process, planeID)
        #self.sliceThread = threading.Thread(target = self.showBasicSliceViewThread, 
        #                   args=(process, planeID, outputPath), name=threadName)
        #self.sliceThread.start()
        if process == ViewMainData.PROCESS_M2PLOT: 
            self.showBasicSliceView(process, planeID, outputPath)
        else:
            threadName = self.getThreadName(process, planeID)
            self.sliceThread = threading.Thread(target = self.showBasicSliceViewThread, \
                                                args=(process, planeID, outputPath, ax1Changed, ax2Changed, ax3Changed), name=threadName)
            self.sliceThread.start()
        return True

    def showBasicSliceViewThread(self, process, planeID, outputPath, ax1Changed, ax2Changed, ax3Changed):
        self.imageID = 0
#        if process == ViewMainData.PROCESS_MAIN:
        if process == ViewMainData.PROCESS_MAIN or \
           process == ViewMainData.PROCESS_OUT_IMAGE:
            if ax3Changed:
                planeID = ViewMainData.SLICE_XY   
                self.showBasicSliceView(process, planeID, outputPath)
            if ax1Changed:
                planeID = ViewMainData.SLICE_YZ
                self.showBasicSliceView(process, planeID, outputPath)
            if ax2Changed:
                planeID = ViewMainData.SLICE_ZX   
                self.showBasicSliceView(process, planeID, outputPath)
        else:
            self.showBasicSliceView(process, planeID, outputPath)

        
    def showBasicSliceView(self, process, planeID, outputPath):
        QtGui.QApplication.setOverrideCursor(QtGui.QCursor(QtCore.Qt.WaitCursor))
        self.stop_event.clear()
        ps = PlaneSlicer.PlaneSlicer(self.data_ecm)

        pos = 0.0
        org = []
        x   = []
        y   = []
        xbin = 0.01
        ybin = 0.01
        rngx = []
        rngy = []
        thick = 1.0
       
        pos_str = ""
        pos_min  = 0.0
        pos_max  = 0.0
        pos_step = 0.0

        self.data_ax1bin = self.basicSliceAx1bin
        self.data_ax2bin = self.basicSliceAx2bin
        self.data_ax3bin = self.basicSliceAx3bin

        ps.SetAxes(self.ax1Key, self.ax2Key, self.ax3Key)
        if planeID == ViewMainData.SLICE_XY:
            #ps.SetAxes(self.ax1Key, self.ax2Key, self.ax3Key)
            ps.SetPlaneKeys(self.ax1Key, self.ax2Key)
            pos_str = self.ax3Slice.position
            xbin = self.basicSliceAx1bin
            ybin = self.basicSliceAx2bin
            rngx = self.rangex
            rngy = self.rangey
            #rngx = [self.basicSliceAx1From, self.basicSliceAx1To]
            #rngy = [self.basicSliceAx2From, self.basicSliceAx2To]
            thick = self.ax3Slice.thickness
        elif planeID == ViewMainData.SLICE_YZ:
            #ps.SetAxes(self.ax2Key, self.ax3Key, self.ax1Key)
            ps.SetPlaneKeys(self.ax2Key, self.ax3Key)
            pos_str = self.ax1Slice.position
            xbin = self.basicSliceAx2bin
            ybin = self.basicSliceAx3bin
            rngx = self.rangey
            rngy = self.rangez
            thick = self.ax1Slice.thickness
        elif planeID == ViewMainData.SLICE_ZX:
            #ps.SetAxes(self.ax3Key, self.ax1Key, self.ax2Key)
            ps.SetPlaneKeys(self.ax1Key, self.ax3Key)
            pos_str = self.ax2Slice.position
            xbin = self.basicSliceAx1bin
            ybin = self.basicSliceAx3bin
            rngx = self.rangex
            rngy = self.rangez
            thick = self.ax2Slice.thickness 

        pos_list = pos_str.split(":")
        if len(pos_list) == 3:
            pos_min = float(pos_list[0])
            pos_max = float(pos_list[1])
            pos_step = float(pos_list[2])
        else:
            pos_min = pos_max = float(pos_list[0])
            pos_step = 1.0

        pos = pos_min

        totalNum = 0
        tmppos = pos
        while tmppos <= pos_max:
           totalNum += 1
           tmppos += pos_step

        root, ext = os.path.splitext(str(outputPath))
        current = 1
        posStr = ""
        x0 = rngx[0]-xbin/2.0 #[inamura 170227]
        y0 = rngy[0]-ybin/2.0 #[inamura 170227]
        while pos <= pos_max:
            if self.stop_event.is_set():
                self.stop_event.clear()
                break

            if planeID == ViewMainData.SLICE_XY:
#                org = [0.0, 0.0, pos]
#                x   = [1.0, 0.0, pos]
#                y   = [0.0, 1.0, pos]
               
                org = [x0,     y0, pos]
                x   = [x0+1.0, y0, pos]
                y   = [x0, y0+1.0, pos]
                posStr = "z"
            elif planeID == ViewMainData.SLICE_YZ:
#                org = [pos, 0.0, 0.0]
#                x   = [pos, 1.0, 0.0]
#                y   = [pos, 0.0, 1.0]
                org = [pos, x0,     y0]
                x   = [pos, x0+1.0, y0]
                y   = [pos, x0, y0+1.0]
                posStr = "x"
            elif planeID == ViewMainData.SLICE_ZX:
#                org = [0.0, pos, 0.0]
#                x   = [1.0, pos, 0.0]
#                y   = [0.0, pos, 1.0]
                org = [x0,     pos, y0]
                x   = [x0+1.0, pos, y0]
                y   = [x0,     pos, y0+1.0]
                posStr = "y"
            
            eca  = ps.GetPlane(org, x, y, xbin, ybin, rngx, rngy, thick)
            #print "org = ", org
            #print "x = ", x
            #print "y = ", y
            #print "xbin, ybin = ", xbin, ybin
            #print "rngx = ", rngx
            #print "rngy = ", rngy
            #print "thick = ", thick

            if process == ViewMainData.PROCESS_M2PLOT:
                p    = mp.M2Plot(eca)
#                subprocess.call("mp.M2PLot(eca)")
            elif process == ViewMainData.PROCESS_OUT_BINARY:
                path = root + "%03d.eca" % (current -1)
                eca.SaveToBinFile("Intensity", path)
                #filePath = "‾/test.srlz"
                #write_binary = Manyo.WriteSerializationFileBinary(str(filePath))
                #write_binary.Save(eca)
            elif process == ViewMainData.PROCESS_MAIN:
                self.extractIntensity(eca, pos, planeID)
#                self.emit(self.create_slice_signal, (planeID, pos))
                self.emit(self.create_slice_signal, (planeID,))
                self.emit(self.update_grid_size_signal)
                self.emit(self.update_grid_signal)
                self.emit(self.update_glview_signal)
                if self.update_slice_view_flag:
                    self.emit(self.update_slice_view_signal, (planeID, ))
                time.sleep(1) 
            elif process == ViewMainData.PROCESS_OUT_IMAGE:
                self.extractIntensity(eca, pos, planeID)
                self.emit(self.create_slice_signal, (planeID,))
                self.emit(self.update_glview_signal)
                if self.update_slice_view_flag:
                    self.emit(self.update_slice_view_signal, (planeID, ))
#                path = root + "%03d.png" % (current -1)
                path = root + "%03d.png" % self.imageID
                self.emit(self.save_glview_signal, path)
                time.sleep(1) 

            message = "%d/%d done  @ %s = %g" % (current, totalNum, posStr, pos)
            self.emit(self.status_bar_signal, message)
            pos += pos_step
            current += 1
            self.imageID += 1

        self.emit(self.update_scrollbar_signal)
        QtGui.QApplication.restoreOverrideCursor() 

    def extractIntensityForFreeSlice(self, eca):
        ecNum = eca.PutSize()        
        x = np.array([0])
        #print ecNum

        ec = eca.Put(0)
        y  = ec.PutXList()
        ylen = len(y)

        xval = eca.PutHeader().PutDoubleVector(self.ax1Key)
        xval_list = Manyo.DoubleVectorToList(xval)

        x = xval_list
        xlen = len(x)

        # print len(x)
        # print x
        # print len(y)
        # print y

        self.data_free = np.zeros((xlen, ylen))

        tmpMin = 9999.0
        tmpMax = -9999.0
        #self.intensityMin = tmpMin
        #self.intensityMax = tmpMax 

        for xid in range(xlen):
           ec = eca.Put(xid)
           intensity = ec.PutYList()
           #tmpMin = min(intensity)
           #tmpMax = max(intensity)

           for yid in range(len(intensity)):
              val = intensity[yid]
              if val > 1.0: # 1e+100 ... Invalid Value ???
                  val = 1e-16

              if val < tmpMin:
                  tmpMin = val
              elif tmpMax < val:
                  if val <= 1.0:
                      tmpMax = val
              self.data_free[xid,yid] = val

#           if tmpMin < self.intensityMin:
#               self.intensityMin = tmpMin
#           if self.intensityMax < tmpMax:
#               self.intensityMax = tmpMax





    def extractIntensity(self, eca, pos, planeID):
        ecNum = eca.PutSize()

        x = np.array([0])
        xvalKey = ""
        if planeID == ViewMainData.SLICE_XY:
            minx = min(self.rangex)
            maxx = max(self.rangex)
            minx -= self.basicSliceAx1bin        
            maxx += self.basicSliceAx1bin        
            x  = np.arange(minx, maxx, self.basicSliceAx1bin)
            xvalKey = self.ax1Key
        elif planeID == ViewMainData.SLICE_YZ:
            minx = min(self.rangey)
            maxx = max(self.rangey)
            minx -= self.basicSliceAx2bin        
            maxx += self.basicSliceAx2bin        
            x  = np.arange(minx, maxx, self.basicSliceAx2bin)
            xvalKey = self.ax2Key
        elif planeID == ViewMainData.SLICE_ZX:
            minx = min(self.rangex)
            maxx = max(self.rangex)
            minx -= self.basicSliceAx1bin        
            maxx += self.basicSliceAx1bin        
            x  = np.arange(minx, maxx, self.basicSliceAx1bin)
            xvalKey = self.ax1Key

        if ecNum < len(x):
           x = x[0:ecNum]  # OLD...

        xlen = len(x)
        ec = eca.Put(0)
        y  = ec.PutXList()
        ylen = len(y)

        xval = eca.PutHeader().PutDoubleVector(xvalKey)
        xval_list = Manyo.DoubleVectorToList(xval)

        x = xval_list
#        print xval_list
#        print eca.PutHeader().Dump()
#        print ec.PutHeader().Dump()

        if planeID == ViewMainData.SLICE_XY:    
            self.data_xy = np.zeros((xlen, ylen))
            self.data_xy_range = [min(x), max(x), min(y), max(y)]
            self.data_xy_pos = pos
        elif planeID == ViewMainData.SLICE_YZ:    
            self.data_yz = np.zeros((xlen, ylen))
            self.data_yz_range = [min(x), max(x), min(y), max(y)]
            self.data_yz_pos = pos
        elif planeID == ViewMainData.SLICE_ZX:
#           self.data_zx = np.zeros((xlen, ylen))
#           variable x means z, variable y means x.       
#           data_zx[X][Y]: [X] have to be x and [y] have to be z:
            self.data_zx = np.zeros((xlen, ylen))
            self.data_zx_range = [min(x), max(x), min(y), max(y)]
            self.data_zx_pos = pos

        tmpMin = 9999.0
        tmpMax = -9999.0
        self.intensityMin = tmpMin
        self.intensityMax = tmpMax 

        for xid in range(xlen):
           ec = eca.Put(xid)
           intensity = ec.PutYList()
           #tmpMin = min(intensity)
           #tmpMax = max(intensity)

           for yid in range(len(intensity)):
              val = intensity[yid]
              #if val > 1.0: # 1e+100 ... Invalid Value ???
              if val > 1.0e+30:
                  val = 1e-16

              if val < tmpMin:
                  tmpMin = val
              elif tmpMax < val:
                  if val <= 1.0:
                      tmpMax = val
              if planeID == ViewMainData.SLICE_XY:    
                  self.data_xy[xid,yid] = val
              elif planeID == ViewMainData.SLICE_YZ:    
                  self.data_yz[xid,yid] = val
              elif planeID == ViewMainData.SLICE_ZX:    
#                  self.data_zx[xid,yid] = val
                  self.data_zx[xid,yid] = val

           if tmpMin < self.intensityMin:
               self.intensityMin = tmpMin
           if self.intensityMax < tmpMax:
               self.intensityMax = tmpMax

        if self.viewSubData.autoScale == True:
            self.viewSubData.scalarRangeMin = self.intensityMin
            self.viewSubData.scalarRangeMax = self.intensityMax
            self.emit(self.update_autoscale_signal)

