from numpy import exp, log
# [inamura 170918]
# Function uses A1() to A8() as fitting parameters in the code.

# FittingFunc1 Liner function
def FittingFunc1(x): return A1()+(A2()*x)

# FittingFunc2 Linear and Gaussian
def FittingFunc2(x): return A1()+(A2()*x)+A3()*exp( -log(2)*( ((x-A4())/(A5()/2.0))**2 ) )

# FittingFunc3 Linear and Lorentz
def FittingFunc3(x): return A1()+(A2()*x)+A3()*((A5()/2.0)/( ((x-A4())**2) +(A5()*A5()/4.0) ) )

# FittingFunc4 Linear, Gaussian and Lorentz
def FittingFunc4(x): return A1()+(A2()*x)+A3()*exp(-log(2)*( ((x-A4())/(A5()/2.0))**2 ) )+A6()*((A8()/2.0)/( ((x-A7())**2) +(A8()/2.0)**2 ) )

# FittingFunc5 Linear and two Gaussians
def FittingFunc5(x): return A1()+(A2()*x)+A3()*exp(-log(2)*( ((x-A4())/(A5()/2.0))**2 ) )+A6()*exp(-log(2)*( ((x-A7())/(A8()/2.0))**2 ) )

# params is list of information for each function
# information has a structure like
# [ <Title>, <defined function above>, <the number of parameters>, <figure name> ]
# if figure is not existed, give ""
params = [
    ["Linear"          ,FittingFunc1, 2, "FittingFunc1.png"],
    ["Linear+Gauss"    ,FittingFunc2, 5, "FittingFunc2.png"],
    ["Linear+Lorentz"  ,FittingFunc3, 5, "FittingFunc3.png"],
    ["Gauss+Lorentz"   ,FittingFunc4, 8, "FittingFunc4.png"],
    ["Gauss+Gauss"     ,FittingFunc5, 8, "FittingFunc5.png"]
    ]


