# -*- coding: utf-8 -*-
"""

"""
import time
import uGao.MPlot as mp


# 予約語の定義
ret = None
mp1 = None

x = [0, 3, 5, 6, 9, 11, 12, 13, 14, 16, 18, 21, 22, 23, 24, 38, 40]
y = [0, -0.1, 1.1, 5, 0, 0, 100, 250, 180.3, 90, 0, 0, 2, 14, 0, 0]
er = [1, 1, 1, 2, 1, 1, 6, 7.1, 5, 4, 2, 0, 2, 3, 2, 1]

header = {'RunNo': 'AMT00001',
          'Label': '5-12(24)',
          'Counts': "512",
          '2Theater': "0.125",
          'L2': "65.3215",
          'Fai': "0.879"
          }

xunit = "micro-sec"
yunit = "neutrons"

ec = (x, y, er, header, xunit, yunit)

matrix = None

###################################################


def MPlot(ematrix=ret, psd=0, pixel=64):
    """
    Create 1D Plotter and Draw EC
    @param  ematrix  ElementContainerMatrix
    @param  psd      PSD No.
    @param  pixel    Pixel No.
    @retval mp1    Instance of Plotter
    """
    # 親プロセス終了時に、プロッタを終了させない
    return mp.MPlot(ematrix(psd, pixel), False)

###################################################


def AddToMPlot(mp1=mp1, ematrix=ret, psd=0, pixel=64):
    """
    Add EC to 1D Plotter
    @param  mp1       Instance of 1D Plotter
    @param  ematrix  ElementContainerMatrix
    @param  psd      PSD No.
    @param  pixel    Pixel No.
    @retval None
    """
    mp1.AddData(ec)

###################################################


def NewPlot(mp1=mp1, ematrix=ret, psd=0, pixel=64):
    """
    Add EC to 1D Plotter
    @param  mp1       Instance of 1D Plotter
    @param  ematrix  ElementContainerMatrix
    @param  psd      PSD No.
    @param  pixel    Pixel No.
    @retval None
    """
    # 親プロセス終了時に、プロッタを終了させない
    mp1.NewPlot(ec, False)

###################################################


def ChangePlot(mp1=mp1, pno=1):
    """
    Add EC to 1D Plotter
    @param  mp1        Instance of 1D Plotter
    @param  pno  Plotter No. (1 to max. Plotter No.)
    @retval None
    """
    mp1.ChangePlot(pno)


# 関数名登録ディクショナリ
_functions = {"MPlot": MPlot,
              "AddToMPlot": AddToMPlot,
              "NewPlot": NewPlot,
              "ChangePlot": ChangePlot}
