#ifndef TOPOWDERCHOPPERS
#define TOPOWDERCHOPPERS

#include <math.h>

#include "UtsusemiHeader.hh"

#include "AverageElementContainerChoppers.hh"

//////////////////////////////////
// ToPowderChoppers
//////////////////////////////////

//! converts S(phi,psi,E) to S(Q,E) for choppers
/*! 
 *  This executes the convertion with powder averaging
 *  using AverageElementContainerChopper.
 *  
 *  TPC = Manyo.ToPowderChoppers( 373 ) <- run number
 *  ecm = TPC.Execute(0.05) <-- give Q step
 */
class ToPowderChoppers:
    public OperatorBase< ElementContainerMatrix, ElementContainerMatrix >
{
private:
    bool isDebugMode;
    Int4 _Execute( Double startQ, Double endQ, Double deltaQ );

public:
    ToPowderChoppers();
        //!< Constructor
        /*!<
         */
    ~ToPowderChoppers();
        //!< Destructor
        /*!<
         */

    ToPowderChoppers( ElementContainerMatrix* ecm );
        //!< Constructor
        /*!<
         *   @param ecm   Target ElementContainerMatrix
         */
    ElementContainerMatrix Execute( Double startQ, Double endQ, Double deltaQ );
        //!< Executes powder averaging
        /*!<
         *   @param startQ   minimam Q value ( -1.0 for auto range )
         *   @param endQ     maximam Q value ( -1.0 for auto range )
         *   @param deltaQ   width of Q step
         */
    ElementContainerMatrix Execute( Double deltaQ );
        //!< Executes powder averaging
        /*!<
         *   Give deltaQ only. Other parameters are automatically calculated.
         *   @param deltaQ   width of Q step
         */
};
#endif
