#include "KiKfCorrection.hh"
//////////////////////////////////////////////////////////
KiKfCorrection::
KiKfCorrection()
{
}

//////////////////////////////////////////////////////////
KiKfCorrection::
KiKfCorrection(ElementContainerMatrix *ecm)
{
    SetTarget(ecm);
}

//////////////////////////////////////////////////////////
KiKfCorrection::
~KiKfCorrection()
{
}

//////////////////////////////////////////////////////////
void KiKfCorrection::
KiKfCorrect(){
    ElementContainerMatrix *ecm = Put();
    ElementContainerArray *eca;
    ElementContainer *ec;
    HeaderBase *h, *ech;
    bool isDirectGeometry = true;
    Double Ei,ki_over_kf,Ef;
    UInt4 num_of_psd, num_of_pixel;
    string xkey,ykey,ekey;
    vector<Double> hw,intensity,error;
    vector<string> process;

    h = ecm->PutHeaderPointer();
    ech = NULL;
    if ((ecm->PutSize()!=0)&&(ecm->PutPointer(0)->PutSize()!=0)){
        ech = ecm->PutPointer(0)->PutPointer(0)->PutHeaderPointer();
        if (ech->CheckKey(UTSUSEMI_KEY_HEAD_EF)==1)
            isDirectGeometry = false;
    }
    if (isDirectGeometry){
        if (h->CheckKey(UTSUSEMI_KEY_HEAD_EI)==0){
            UtsusemiError("KiKfCorrection >> Ei is not set in ElementContainerMatrix.");
            return;
        }
        Ei = h->PutDouble(UTSUSEMI_KEY_HEAD_EI);
    }
    
    num_of_psd = ecm->PutTableSize();
    for (UInt4 psd=0;psd<num_of_psd;psd++){
        eca = ecm->PutPointer(psd);
        num_of_pixel = eca->PutTableSize();
        if (isDirectGeometry){
            for (UInt4 pixel=0;pixel<num_of_pixel;pixel++){
                ec = eca->PutPointer(pixel);
                xkey = ec->PutXKey();
                ykey = ec->PutYKey();
                ekey = ec->PutEKey();
                hw = ec->PutX();
                intensity = ec->PutY();
                error = ec->PutE();
                for (UInt4 i=0;i<(hw.size()-1);i++){
                    ki_over_kf = sqrt( Ei/(Ei - (hw[i+1]+hw[i])/2.0) );
                    intensity[i]=intensity[i]*ki_over_kf;
                    error[i]=error[i]*ki_over_kf;
                }
                ec->Remove(ykey);
                ec->Remove(ekey);
                ec->Add(ykey,intensity);
                ec->Add(ekey,error);
                ec->SetKeys(xkey,ykey,ekey);
            }
        }else{
            for (UInt4 pixel=0;pixel<num_of_pixel;pixel++){
                ec = eca->PutPointer(pixel);
                ech = ec->PutHeaderPointer();
                Ef = ech->PutDouble(UTSUSEMI_KEY_HEAD_EF);
                xkey = ec->PutXKey();
                ykey = ec->PutYKey();
                ekey = ec->PutEKey();
                hw = ec->PutX();
                intensity = ec->PutY();
                error = ec->PutE();
                for (UInt4 i=0;i<(hw.size()-1);i++){
                    //ki_over_kf = sqrt( Ei/(Ei - (hw[i+1]+hw[i])/2.0) );
                    ki_over_kf = sqrt( (Ef + (hw[i+1]+hw[i])/2.0)/Ef );
                    intensity[i]=intensity[i]*ki_over_kf;
                    error[i]=error[i]*ki_over_kf;
                }
                ec->Remove(ykey);
                ec->Remove(ekey);
                ec->Add(ykey,intensity);
                ec->Add(ekey,error);
                ec->SetKeys(xkey,ykey,ekey);
            }
        }
    }
    process = h->PutStringVector(UTSUSEMI_KEY_HEAD_DATAPROCESSED);
    process.push_back("Ki/kf Correction");
    h->OverWrite(UTSUSEMI_KEY_HEAD_DATAPROCESSED,process);


}
