#ifndef CALCSPHERICALCHOPPER
#define CALCSPHERICALCHOPPER

#include "UtsusemiHeader.hh"

//////////////////////////////////
// Calculate angles from rectanglar to spherical coordinates
/////////////////////////////////

//! Function to calculate angles on spherical coordinates from Pixel position
/*! 
 * 
 */
class CalcSphericalCoordinates :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    double delta_px, delta_py, delta_pz;   /**< Ambiguities for each pixel of PSD */
    string commentHead; 
    string HeadNameHorzAngle;              /**< Name for an direction angle in header */
    string HeadNameElevAngle;              /**< Name for an elevation angle in header */

    void Initialize();
public:
    CalcSphericalCoordinates();
        //!< Constructor
        /*!<
         */
    CalcSphericalCoordinates(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    CalcSphericalCoordinates(ElementContainerMatrix *ecm, double d_px, double d_py, double d_pz);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         *  @param d_px delta-x of volume of a pixel
         *  @param d_py delta-y of volume of a pixel
         *  @param d_pz delta-z of volume of a pixel
         */
    ~CalcSphericalCoordinates();
        //!< Destructor
        /*!<
         */
    void CalcAngles();
        //!< Calculat angles and ambiguities
        /*!< Calculat angles and ambiguities and add these into header information
         */
    void SetPositionDeviationConstant(double d_px, double d_py, double d_pz);
        //!< Set Deviation of volume of a pixel
        /*!<
         *  @param d_px delta-x of volume of a pixel
         *  @param d_py delta-y of volume of a pixel
         *  @param d_pz delta-z of volume of a pixel
         */
};
#endif
