#ifndef AVERAGEELEMENTCONTAINERCHOPPERS
#define AVERAGEELEMENTCONTAINERCHOPPERS

#include "UtsusemiHeader.hh"

//////////////////////////////////
// AverageElementContainerChopper
//////////////////////////////////

//! Average ElementContainer for choppers
/*! 
 * Function to get average of a seriese of ElementContainers
 * 
 */
class AverageElementContainerChoppers :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    vector<UInt4> psd_vec, pixel_vec;
    Int4 DebugFlag;
    UInt4 _NumOfMulTh;
    void Initialize(Int4 debug);
    bool _Calculate( ElementContainer* _ec, bool isAve=true );

public:
    AverageElementContainerChoppers();
        //!< Constructor
        /*!<
         */
    AverageElementContainerChoppers(Int4 debug);
        //!< Constructor
        /*!<
         *  @param debug flag for debug 0 for not-use.
         */
    AverageElementContainerChoppers(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    AverageElementContainerChoppers(ElementContainerMatrix *ecm, vector<UInt4> psd_vec, vector<UInt4> pixel_vec);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         *  @param psd_vec    vector of psd id for pixels
         *  @param pixel_vec  vector of pixel number at a Psd Id
         */
    AverageElementContainerChoppers(ElementContainerMatrix *ecm, vector<UInt4> psd_vec, vector<UInt4> pixel_vec, Int4 debug);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         *  @param psd_vec    vector of psd id for pixels
         *  @param pixel_vec  vector of pixel number at a Psd Id
         *  @param debug flag for debug
         */
    ~AverageElementContainerChoppers();
        //!< Destructor
        /*!<
         */
    ElementContainer GetAverage();
        //!< Put averaged data
        /*!<
         *  @return ElementContainer
         */
    ElementContainer GetSum();
        //!< Put sum data
        /*!<
         *  @return ElementContainer
         */
    void SetPoints(vector<UInt4> psd_vec, vector<UInt4> pixel_vec);
        //!< Set pixels to be averaged
        /*!<
         *  @param psd_vec    vector of psd id for pixels
         *  @param pixel_vec  vector of pixel number at a Psd Id
         *  @return None
         */
};
#endif
