#include "WiringInfoDataBase.hh"
//////////////////////////////////////////////////////////
WiringInfoTagDefineBase::
WiringInfoTagDefineBase(){
}
//////////////////////////////////////////////////////////
WiringInfoTagDefineBase::
~WiringInfoTagDefineBase(){
}
//////////////////////////////////////////////////////////
const std::string WiringInfoTagDefineBase::WINFO="/wiringInfo";
const std::string WiringInfoTagDefineBase::WINFO_AT_INST="inst";
const std::string WiringInfoTagDefineBase::WINFO_AT_VER="version";
const std::string WiringInfoTagDefineBase::WINFO_AT_DATE="update";

const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO="pixelInfo";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ="daq";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_AT_ID="daqId";

const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD="module";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_AT_NO="moduleNo";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_AT_TYPE="detType";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_AT_NUMBER_DET="n";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_AT_TRIGINDEX="trigIndex";

const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET="detector";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AT_INDEX="i";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AT_ID="detId";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AT_AXIS="numAxis";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AT_HEAD="headPixelId";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AT_NUM="numPixel";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AXIS="axis";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_SIZE="size";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_LABEL="label";
const std::string WiringInfoTagDefineBase::WINFO_PIXELINFO_DAQ_MOD_DET_AXIS_AT_START="start";

const std::string WiringInfoTagDefineBase::WINFO_TOFBININFO="tofBinInfo";
const std::string WiringInfoTagDefineBase::WINFO_TOFBININFO_TOFBIN="tofBin";
const std::string WiringInfoTagDefineBase::WINFO_TOFBININFO_TOFBIN_AT_PAT="patternId";
const std::string WiringInfoTagDefineBase::WINFO_TOFBININFO_TOFBIN_AT_OFFSET="offsetBin";
const std::string WiringInfoTagDefineBase::WINFO_TOFBININFO_TOFBIN_AT_MASKID="maskPtnId";

const std::string WiringInfoTagDefineBase::WINFO_TOFBINPATLIST="tofBinPatternList";
const std::string WiringInfoTagDefineBase::WINFO_TOFBINPATLIST_PAT="tofBinPattern";
const std::string WiringInfoTagDefineBase::WINFO_TOFBINPATLIST_PAT_AT_ID="patternId";
const std::string WiringInfoTagDefineBase::WINFO_TOFBINPATLIST_PAT_AT_TYPE="type";

const std::string WiringInfoTagDefineBase::WINFO_TOFMASKPATLIST="tofMaskPatternList";
const std::string WiringInfoTagDefineBase::WINFO_TOFMASKPATLIST_PAT="tofMaskPattern";
const std::string WiringInfoTagDefineBase::WINFO_TOFMASKPATLIST_PAT_AT_ID="maskPtnId";

const std::string WiringInfoTagDefineBase::WINFO_TOFDOUBLEFRAME="tofDoubleFrameBoundary";

const std::string WiringInfoTagDefineBase::WINFO_FRAMEINFO="frameInfo";
const std::string WiringInfoTagDefineBase::WINFO_FRAMEINFO_AT_FRAMENO="frameNo";
const std::string WiringInfoTagDefineBase::WINFO_FRAMEINFO_AT_BOUNDARY="boundary";
const std::string WiringInfoTagDefineBase::WINFO_FRAMEINFO_AT_TYPE="type"; //[inamura 170410]

const std::string WiringInfoTagDefineBase::WINFO_TOFTIMEDEPNDBACKGROUND="tofTimeDependBackGround";
const std::string WiringInfoTagDefineBase::WINFO_TOFTIMEDEPNDBACKGROUND_REGION="region";

//////////////////////////////////////////////////////////
UtsusemiDetAxisInfo::
UtsusemiDetAxisInfo(){
    size = 0;
    label = "";
    start = 0;
}
//////////////////////////////////////////////////////////
UtsusemiDetAxisInfo::
UtsusemiDetAxisInfo( const UtsusemiDetAxisInfo& obj ){
    size = obj.size;
    label = obj.label;
    start = obj.start;
}
//////////////////////////////////////////////////////////
UtsusemiDetAxisInfo::
~UtsusemiDetAxisInfo(){
}
//////////////////////////////////////////////////////////
UtsusemiDetInfo::
UtsusemiDetInfo(){
    detType = "";
    isAlive = true;
    detId = -1;
    headPixelId = -1;
    numPixel = -1;
    numAxis = 0;
    multiAxes.clear();
}
//////////////////////////////////////////////////////////
UtsusemiDetInfo::
UtsusemiDetInfo(const UtsusemiDetInfo& obj){
    detType = obj.detType;
    isAlive = obj.isAlive;
    detId = obj.detId;
    headPixelId = obj.headPixelId;
    numPixel = obj.numPixel;
    numAxis = obj.numAxis;
    for (UInt4 i=0; i<obj.multiAxes.size(); i++)
        multiAxes.push_back(obj.multiAxes[i]);
}
//////////////////////////////////////////////////////////
UtsusemiDetInfo::
~UtsusemiDetInfo(){
}
//////////////////////////////////////////////////////////
UtsusemiModInfo::
UtsusemiModInfo(){
    isAlive = true;
    type = "";
}
//////////////////////////////////////////////////////////
UtsusemiModInfo::
UtsusemiModInfo(const UtsusemiModInfo& obj){
    isAlive = obj.isAlive;
    type = obj.type;
    for (UInt4 i=0; i<obj.DetList.size(); i++){
        UtsusemiDetInfo* tmp = new UtsusemiDetInfo( *(obj.DetList[i]) );
        DetList.push_back( tmp );
    }
    attributes.clear();
    for (UInt4 i=0; i<obj.attributes.size(); i++)
        attributes.push_back( obj.attributes[i] );
}
//////////////////////////////////////////////////////////
UtsusemiModInfo::
~UtsusemiModInfo(){
    ClearList();
}
//////////////////////////////////////////////////////////
void UtsusemiModInfo::
ClearList(){
    for (UInt4 i=0; i<DetList.size(); i++){
        if (DetList[i]!=NULL){
            //std::cout << "delete detId="<< DetList[i]->detId << std::endl;
            delete DetList[i];
        }
    }
    DetList.clear();
}
//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiModInfo::
PutAliveList(){
    std::vector<UInt4> ret;
    for (UInt4 i=0; i<DetList.size(); i++)
        if ((DetList[i]!=NULL)&&(DetList[i]->isAlive))
            ret.push_back(i);
    return ret;
}
//////////////////////////////////////////////////////////
UtsusemiDaqInfo::
UtsusemiDaqInfo(){
    isAlive = true;
}
//////////////////////////////////////////////////////////
UtsusemiDaqInfo::
UtsusemiDaqInfo(const UtsusemiDaqInfo& obj){
    isAlive = obj.isAlive;
    for (UInt4 i=0; i<obj.ModList.size(); i++){
        UtsusemiModInfo* tmp = new UtsusemiModInfo( *(obj.ModList[i]) );
        ModList.push_back( tmp );
    }
}
//////////////////////////////////////////////////////////
UtsusemiDaqInfo::
~UtsusemiDaqInfo(){
    ClearList();
}
//////////////////////////////////////////////////////////
void UtsusemiDaqInfo::
ClearList(){
    for (UInt4 i=0; i<ModList.size(); i++){
        if (ModList[i]!=NULL){
            delete ModList[i];
        }
    }
    ModList.clear();
}
//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiDaqInfo::
PutAliveList(){
    std::vector<UInt4> ret;
    for (UInt4 i=0; i<ModList.size(); i++)
        if ((ModList[i]!=NULL)&&(ModList[i]->isAlive))
            ret.push_back(i);
    return ret;
}
//////////////////////////////////////////////////////////
UtsusemiTofBinInfo::
UtsusemiTofBinInfo(){
    patternId = 0;
    offset = 0;
    maskPtnId = -1;
    conts = "";
}
//////////////////////////////////////////////////////////
UtsusemiTofBinInfo::
UtsusemiTofBinInfo( const UtsusemiTofBinInfo& obj ){
    patternId = obj.patternId;
    offset = obj.offset;
    maskPtnId = obj.maskPtnId;
    conts = obj.conts;
}
//////////////////////////////////////////////////////////
UtsusemiTofBinInfo::
~UtsusemiTofBinInfo(){
}
//////////////////////////////////////////////////////////
UtsusemiTofBinPattern::
UtsusemiTofBinPattern(){
    patternId = 0;
    type = 0;
    PatternVect = new std::vector<Double>;
}
//////////////////////////////////////////////////////////
UtsusemiTofBinPattern::
UtsusemiTofBinPattern( const UtsusemiTofBinPattern& obj ){
    patternId = obj.patternId;
    type = obj.type;
    PatternVect->clear();
    for (UInt4 i=0; i<(obj.PatternVect->size()); i++)
        PatternVect->push_back( obj.PatternVect->at(i) );
}
//////////////////////////////////////////////////////////
UtsusemiTofBinPattern::
~UtsusemiTofBinPattern(){
    delete PatternVect;
}
//////////////////////////////////////////////////////////
UtsusemiTofMaskPattern::
UtsusemiTofMaskPattern(){
    patternId = 0;
    PatternVect.clear();
}
//////////////////////////////////////////////////////////
UtsusemiTofMaskPattern::
UtsusemiTofMaskPattern( const UtsusemiTofMaskPattern& obj ){
    patternId = obj.patternId;
    PatternVect.clear();
    for (UInt4 i=0; i<obj.PatternVect.size(); i++)
        PatternVect.push_back( obj.PatternVect[i] );
}
//////////////////////////////////////////////////////////
UtsusemiTofMaskPattern::
~UtsusemiTofMaskPattern(){
}
//////////////////////////////////////////////////////////
UtsusemiTimeDependBackGround::
UtsusemiTimeDependBackGround(){
    TofRegion.first = 0.0;
    TofRegion.second = 0.0;
}
//////////////////////////////////////////////////////////
UtsusemiTimeDependBackGround::
UtsusemiTimeDependBackGround( const UtsusemiTimeDependBackGround& obj ){
    TofRegion.first = obj.TofRegion.first;
    TofRegion.second = obj.TofRegion.second;
}
//////////////////////////////////////////////////////////
UtsusemiTimeDependBackGround::
~UtsusemiTimeDependBackGround(){
}
//////////////////////////////////////////////////////////
UtsusemiFrameBoundaryInfo::UtsusemiFrameBoundaryInfo(){
    frameNo = 0;
    boundaryValue = 0.0;
    boundaryType = BOUNDARYTYPE_TOF;
}
//////////////////////////////////////////////////////////
UtsusemiFrameBoundaryInfo::
UtsusemiFrameBoundaryInfo(const UtsusemiFrameBoundaryInfo& obj ){
    frameNo = obj.frameNo;
    boundaryValue = obj.boundaryValue;
    boundaryType = obj.boundaryType;
}
const std::string UtsusemiFrameBoundaryInfo::BOUNDARYTYPE_TOF = "tof";
const std::string UtsusemiFrameBoundaryInfo::BOUNDARYTYPE_ENERGY = "energy";
const std::string UtsusemiFrameBoundaryInfo::BOUNDARYTYPE_LAMBDA = "lambda";
const std::string UtsusemiFrameBoundaryInfo::BOUNDARYTYPE_EI = "ei";
//////////////////////////////////////////////////////////
UtsusemiFrameBoundaryInfo::~UtsusemiFrameBoundaryInfo(){
}
//////////////////////////////////////////////////////////
bool UtsusemiFrameBoundaryInfo::
SetParams( UInt4 fn, Double bv, std::string bt ){
    if (fn==0) {
        frameNo=0;
        boundaryValue = 0.0;
        boundaryType = BOUNDARYTYPE_TOF;
        return true;
    }else if (fn==1){
        if (bv<0.0){
            UtsusemiError( "UtsusemiFrameBoundaryInfo::SetParams >> invalid param (boundary Value is minus) " );
            return false;
        }
        transform( bt.begin(), bt.end(), bt.begin(), ::tolower);
        if ((bt!="")&&(bt!=BOUNDARYTYPE_TOF)&&(bt!=BOUNDARYTYPE_LAMBDA)&&(bt!=BOUNDARYTYPE_ENERGY)&&(bt!=BOUNDARYTYPE_EI)){
            UtsusemiError( "UtsusemiFrameBoundaryInfo::SetParams >> invalid param (boundary type must be tof, lambda, energy and ei) " );
            return false;
        }
        frameNo=1;
        boundaryValue = bv;
        boundaryType = bt;
        return true;
    }else if ((fn==2)||(fn==3)){
        if (bv<0.0){
            UtsusemiError( "UtsusemiFrameBoundaryInfo::SetParams >> invalid param (boundary Value is minus) " );
            return false;
        }
        frameNo=fn;
        boundaryValue = bv;
        boundaryType = BOUNDARYTYPE_TOF;
        return true;
    }else{
        UtsusemiError( "UtsusemiFrameBoundaryInfo::SetParams >> invalid param (frameNo is invalid.) " );
        return false;
    }
    return false;
}
