#include "WiringInfoConversionDictionary.hh"
//////////////////////////////////////////////////////////
WiringInfoConversionTemplate::WiringInfoConversionTemplate(){
    ConvType = -1;
    KeyCode = "";
    NumOfParams.clear();
    Memo = "";
    isReversed = false;
    isRequiredPixelPosi = false;
    CheckParamsFunc = NULL;
    PutXaxisFunc = NULL;
    PutTofFunc = NULL;
    PutLambdaFunc = NULL;
    _UUC = new UtsusemiUnitConverter();
    LabelsOfEC.resize( 3 );
    LabelsOfEC[0].first = "xaxis";
    LabelsOfEC[0].second = UTSUSEMI_KEY_TOF_UNIT;
    LabelsOfEC[1].first = "yaxis";
    LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    LabelsOfEC[2].first = "error";
    LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;

}
//////////////////////////////////////////////////////////
WiringInfoConversionTemplate::
WiringInfoConversionTemplate( const WiringInfoConversionTemplate& obj){
    ConvType = obj.ConvType;
    KeyCode = obj.KeyCode;
    NumOfParams.resize( obj.NumOfParams.size() );
    copy( obj.NumOfParams.begin(), obj.NumOfParams.end(), NumOfParams.begin() );
    CheckParamsFunc = obj.CheckParamsFunc;
    PutXaxisFunc = obj.PutXaxisFunc;
    PutTofFunc = obj.PutTofFunc;
    PutLambdaFunc = obj.PutLambdaFunc;
    Memo = obj.Memo;
    isReversed = obj.isReversed;
    LabelsOfEC[0].first = obj.LabelsOfEC[0].first;
    LabelsOfEC[0].second = obj.LabelsOfEC[0].second;
    LabelsOfEC[1].first = obj.LabelsOfEC[1].first;
    LabelsOfEC[1].second = obj.LabelsOfEC[1].second;
    LabelsOfEC[2].first = obj.LabelsOfEC[2].first;
    LabelsOfEC[2].second = obj.LabelsOfEC[2].second;
}

//////////////////////////////////////////////////////////
WiringInfoConversionTemplate::~WiringInfoConversionTemplate(){
    delete _UUC;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionTemplate::
CheckParams( std::vector<Double> params ){

    return (*CheckParamsFunc)( params, _UUC );

}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionTemplate::
PutXaxisVect(std::vector<Double> params, Double tof_offset){
    bool isReady = false;
    for (UInt4 i=0; i<NumOfParams.size(); i++)
        if ((NumOfParams[i]==0)||(params.size()==NumOfParams[i])){ //[inamura 161208]
            isReady=true;
            break;
        }
    if ((isReady)&&(PutXaxisFunc!=NULL))
        return (*PutXaxisFunc)(params,tof_offset);
    else {
        std::vector<Double> ret;
        return ret;
    }
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionTemplate::
PutTofBin(std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* posi_vect, std::vector<Double>* out_params ){
    bool isReady = false;
    for (UInt4 i=0; i<NumOfParams.size(); i++)
        if ((NumOfParams[i]==0)||(params->size()==NumOfParams[i])){ //[inamura 161208]
            isReady=true;
            break;
        }

    if (isReady)
        if (isRequiredPixelPosi)
            if (posi_vect->size()<3) isReady=false;

    if ((isReady)&&(PutTofFunc!=NULL))
        return (*PutTofFunc)(xaxis,params,posi_vect, out_params, _UUC);
    else{
        std::vector<Double> ret;
        return ret;
    }
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionTemplate::
PutLambdaVec(std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* posi_vect, std::vector<Double>* out_params ){
    bool isReady = false;
    for (UInt4 i=0; i<NumOfParams.size(); i++)
        if ((NumOfParams[i]==0)||(params->size()==NumOfParams[i])){ //[inamura 161208]
            isReady=true;
            break;
        }
    if (isReady)
        if (posi_vect->size()<3) isReady=false;

    if ((isReady)&&(PutLambdaFunc!=NULL))
        return (*PutLambdaFunc)(xaxis,params,posi_vect, out_params, _UUC);
    else{
        std::vector<Double> ret;
        return ret;
    }
}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
WiringInfoConversionDictionary::
WiringInfoConversionDictionary(){
    Initialize();
}
//////////////////////////////////////////////////////////
WiringInfoConversionDictionary::
~WiringInfoConversionDictionary(){
    _Clear();
    for (UInt4 i=0; i<Dict.size(); i++)
        if (Dict[i]!=NULL) delete Dict[i];
    //[inamura 160809]-->
    if (TimeDependBackGroundRegion!=NULL){
        for (UInt4 i=0; i<(TimeDependBackGroundRegion->size()); i++)
            if (TimeDependBackGroundRegion->at(i)!=NULL)
                delete TimeDependBackGroundRegion->at(i);
        TimeDependBackGroundRegion->clear();
    }
    //<--[inamura 160809]
    //[inamura 170410]-->
    for (UInt4 i=0; i<(FrameBoundaryInfoList.size()); i++)
        if (FrameBoundaryInfoList[i]!=NULL)
            delete FrameBoundaryInfoList[i];
    FrameBoundaryInfoList.clear();
    //<--[inamura 170410]

}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
Initialize(){
    _UTO = NULL;
    SetDict();
    _KeyCode="";
    _Xaxis.clear();
    _MessageTag = "WiringInfoConversionDictionary::";
    _Clear();
    _timeFocParam.clear();
    _L1 = 0.0;
    _SamplePosition.clear();
    _SamplePosition.resize(3,0.0);
    isSetTimeDependBackGroundRegion = false; //[inamura 160809]
    TimeDependBackGroundRegion = NULL; //[inamura 160809]
    FrameBoundaryInfoList.clear();//[inamura 170410]
}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
_Clear(){
    if (!(_pixelPositionVect.empty())){
        for (UInt4 i=0;i<_pixelPositionVect.size();i++) {
            if (_pixelPositionVect[i]!=NULL) delete _pixelPositionVect[i];
        }
        _pixelPositionVect.clear();
    }
    if (_UTO!=NULL) delete _UTO;
}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
SetDict(){
    WiringInfoConversionTemplate* tmp=NULL;

    // ConvType = 1 : List of histogram
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 1;
    tmp->KeyCode = "list";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 0;
    tmp->Memo = "List of histogram";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = false;
    tmp->CheckParamsFunc = CheckParamsType001;
    tmp->PutTofFunc = PutTofBinConvType001;
    tmp->PutXaxisFunc = PutXaxisConvType001;
    tmp->PutLambdaFunc = PutLambdaConvType001;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_TOF;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_TOF_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 2 : delta T const
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 2;
    tmp->KeyCode = "tof";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "delta-T const. : start_tof, end_tof, delta_tof";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = false;
    tmp->CheckParamsFunc = CheckParamsType002;
    tmp->PutTofFunc = PutTofBinConvType002;
    tmp->PutXaxisFunc = PutXaxisConvType002;
    tmp->PutLambdaFunc = PutLambdaConvType001;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_TOF;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_TOF_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 3 : (delta T)/T const
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 3;
    tmp->KeyCode = "rtof";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "delta-T const. : start_tof, end_tof, racio_of_(dtof/tof)";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = false;
    tmp->CheckParamsFunc = CheckParamsType003;
    tmp->PutTofFunc = PutTofBinConvType003;
    tmp->PutXaxisFunc = PutXaxisConvType003;
    tmp->PutLambdaFunc = PutLambdaConvType001;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_TOF;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_TOF_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 12 : delta T const with time focusing
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 12;
    tmp->KeyCode = "tf-tof";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "delta-T const. : start_tof, end_tof, delta_tof";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = false;
    tmp->CheckParamsFunc = CheckParamsType002;
    tmp->PutTofFunc = PutTofBinConvType012Type013;
    tmp->PutXaxisFunc = PutXaxisConvType002;
    tmp->PutLambdaFunc = PutLambdaConvType012Type013;
    tmp->LabelsOfEC[0].first = "TF-TOF";
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_TOF_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 13 : (delta T)/T const with time focusing
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 13;
    tmp->KeyCode = "tf-rtof";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "(delta-T)/T const. : start_tof, end_tof, racio_of_(dtof/tof)";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = false;
    tmp->CheckParamsFunc = CheckParamsType003;
    tmp->PutTofFunc = PutTofBinConvType012Type013;
    tmp->PutXaxisFunc = PutXaxisConvType003;
    tmp->PutLambdaFunc = PutLambdaConvType012Type013;
    tmp->LabelsOfEC[0].first = "TF-TOF";
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_TOF_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 20 : Energy Transfer
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 20;
    tmp->KeyCode = UTSUSEMI_KEY_HW;
    tmp->NumOfParams.resize(3);
    tmp->NumOfParams[0] = 5;
    tmp->NumOfParams[1] = 6;
    tmp->NumOfParams[2] = 4;
    tmp->Memo = "Energy Transfer : Ei, min_hw, max_hw, delta_hw [,L1], T0shift";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType020;
    tmp->PutTofFunc = PutTofBinConvType020;
    tmp->PutXaxisFunc = PutXaxisConvType020;
    tmp->PutLambdaFunc = PutLambdaConvType020;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_ENERGY;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_ENERGY_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 21 : Energy
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 21;
    tmp->KeyCode = "energy";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "Energy : start_energy, end_energy, delta_energy";
    tmp->isReversed = true;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType021;
    tmp->PutTofFunc = PutTofBinConvType021;
    tmp->PutXaxisFunc = PutXaxisConvType021;
    tmp->PutLambdaFunc = PutLambdaConvType021;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_ENERGY;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_ENERGY_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((UInt4)(tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ (UInt4)(tmp->ConvType) ] = tmp;

    // ConvType = 22 : Q
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 22;
    tmp->KeyCode = "q";
    tmp->NumOfParams.resize(2);
    tmp->NumOfParams[0] = 6;
    tmp->NumOfParams[1] = 3;
    tmp->Memo = "Momentum Transfer Q : min_Q, max_Q, delta_Q, Ki_x, Ki_y, Ki_z";
    tmp->isReversed = true;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType022;
    tmp->PutTofFunc = PutTofBinConvType022;
    tmp->PutXaxisFunc = PutXaxisConvType022;
    tmp->PutLambdaFunc = PutLambdaConvType022;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_MOMENTTRANSFER;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_MOMENTTRANSFER_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ tmp->ConvType ] = tmp;

    // ConvType = 23 : delta Lambda const
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 23;
    tmp->KeyCode = "lambda";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "delta-Lambda const. : start_lam, end_lam, delta_lam";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType023;
    tmp->PutTofFunc = PutTofBinConvType023;
    tmp->PutXaxisFunc = PutXaxisConvType023;
    tmp->PutLambdaFunc = PutLambdaConvType023;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_LAMBDA;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_LAMBDA_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ tmp->ConvType ] = tmp;

    // ConvType = 24 : (delta Lambda)/Lambda const
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 24;
    tmp->KeyCode = "rlambda";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "(delta-Lambda)/Lambda const. : start_lam, end_lam, racio_of_(dlamda/lambda)";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType024;
    tmp->PutTofFunc = PutTofBinConvType024;
    tmp->PutXaxisFunc = PutXaxisConvType024;
    tmp->PutLambdaFunc = PutLambdaConvType024;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_LAMBDA;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_LAMBDA_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ tmp->ConvType ] = tmp;

    // ConvType = 25 : d value
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 25;
    tmp->KeyCode = UTSUSEMI_KEY_DVALUE;
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "d value : start_d, end_d, delta-d";
    tmp->isReversed = false;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType025;
    tmp->PutTofFunc = PutTofBinConvType025;
    tmp->PutXaxisFunc = PutXaxisConvType025;
    tmp->PutLambdaFunc = PutLambdaConvType025;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_DVALUE;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_LAMBDA_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ tmp->ConvType ] = tmp;

    // ConvType = 27 : inverted geometry (for DNA)
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 27;
    tmp->KeyCode = "ihw";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "Energy Transfer for inverted geometory: dummy function";
    tmp->isReversed = true;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType027;
    tmp->PutTofFunc = PutTofBinConvType027;
    tmp->PutXaxisFunc = PutXaxisConvType027;
    tmp->PutLambdaFunc = PutLambdaConvType027;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_ENERGYTRANSFER;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_ENERGY_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ tmp->ConvType ] = tmp;

    // ConvType = 28 : inverted geometry (for DNA)
    tmp = new WiringInfoConversionTemplate();
    tmp->ConvType = 28;
    tmp->KeyCode = "ihw2";
    tmp->NumOfParams.resize(1);
    tmp->NumOfParams[0] = 3;
    tmp->Memo = "Energy Transfer for inverted geometory: dummy function";
    tmp->isReversed = true;
    tmp->isRequiredPixelPosi = true;
    tmp->CheckParamsFunc = CheckParamsType028;
    tmp->PutTofFunc = PutTofBinConvType028;
    tmp->PutXaxisFunc = PutXaxisConvType028;
    tmp->PutLambdaFunc = PutLambdaConvType028;
    tmp->LabelsOfEC[0].first = UTSUSEMI_KEY_ENERGYTRANSFER;
    tmp->LabelsOfEC[0].second = UTSUSEMI_KEY_ENERGY_UNIT;
    tmp->LabelsOfEC[1].first = UTSUSEMI_KEY_INTENSITY;
    tmp->LabelsOfEC[1].second = UTSUSEMI_KEY_COUNTS_UNIT;
    tmp->LabelsOfEC[2].first = UTSUSEMI_KEY_ERROR;
    tmp->LabelsOfEC[2].second = UTSUSEMI_KEY_COUNTS_UNIT;
    if ((tmp->ConvType)>=(Dict.size())) Dict.resize( (tmp->ConvType)+1, NULL );
    Dict[ tmp->ConvType ] = tmp;

}
//////////////////////////////////////////////////////////
WiringInfoConversionTemplate* WiringInfoConversionDictionary::
_Search( std::string keycode ){
    transform( keycode.begin(), keycode.end(), keycode.begin(), ::tolower );
    WiringInfoConversionTemplate* ret = NULL;
    for (std::vector<WiringInfoConversionTemplate*>::iterator it=Dict.begin(); it!=Dict.end(); ++it )
        if ((*it)!=NULL)
            if (((*it)->KeyCode.find(keycode))==0)
                ret = (*it);
    return ret;
}
//////////////////////////////////////////////////////////
WiringInfoConversionTemplate* WiringInfoConversionDictionary::
_Search( Int4 convtype ){
    WiringInfoConversionTemplate* ret = NULL;
    if (convtype>=0)
        if ((convtype<Dict.size())&&(Dict[convtype]!=NULL))
            ret = Dict[convtype];

    return ret;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
isValidConvType( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp==NULL) return false;
    else return true;
}
//////////////////////////////////////////////////////////
Int4 WiringInfoConversionDictionary::
PutConvType( std::string keycode ){
    WiringInfoConversionTemplate* tmp = _Search( keycode );
    if (tmp==NULL){
        UtsusemiError(_MessageTag+"PutKeyCode >> no KeyCode ("+keycode+")");
        return -1;
    }else return tmp->ConvType;
}
//////////////////////////////////////////////////////////
std::string WiringInfoConversionDictionary::
PutKeyCode( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp==NULL){
        StringTools st;
        UtsusemiError(_MessageTag+"PutKeyCode >> no ConvType ("+st.Int4ToString(convtype)+")");
        return "";
    }else return tmp->KeyCode;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParams( Int4 convtype, std::vector<Double> params ){
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp==NULL){
        StringTools st;
        UtsusemiError(_MessageTag+"CheckParams >> no such convtype ("+st.Int4ToString(convtype)+")");
        return false;
    }else return tmp->CheckParams( params );
}
//////////////////////////////////////////////////////////
std::vector<UInt4> WiringInfoConversionDictionary::
PutNumOfParams( std::string keycode ){
    WiringInfoConversionTemplate* tmp = _Search( keycode );
    if (tmp==NULL){
        UtsusemiError(_MessageTag+"PutNumOfParams >> no such keycode ("+keycode+")");
        std::vector<UInt4> ret;
        return ret;
    }else return tmp->NumOfParams;
}
//////////////////////////////////////////////////////////
std::vector<UInt4> WiringInfoConversionDictionary::
PutNumOfParams( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp==NULL){
        StringTools st;
        UtsusemiError(_MessageTag+"PutNumOfParams >> no such convtype ("+st.Int4ToString(convtype)+")");
        std::vector<UInt4> ret;
        return ret;
    }else return tmp->NumOfParams;
}

//////////////////////////////////////////////////////////
std::string WiringInfoConversionDictionary::
PutMemo( std::string keycode ){
    WiringInfoConversionTemplate* tmp = _Search( keycode );
    if (tmp==NULL){
        UtsusemiError(_MessageTag+"PutMemo >> no such keycode ("+keycode+")");
        return "";
    }else return tmp->Memo;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
isReverseXaxis( std::string keycode ){
    WiringInfoConversionTemplate* tmp = _Search( keycode );
    if (tmp!=NULL) return tmp->isReversed;
    return false;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
isReverseXaxis( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp!=NULL) return tmp->isReversed;
    return false;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
SetParams( Int4 convtype, std::vector<Double> *params ){
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp==NULL){
        StringTools st;
        UtsusemiError(_MessageTag+"SetParams( convtype ) >> no such convtype ("+st.Int4ToString(convtype)+")");
        return false;
    }else{
        _KeyCode = PutKeyCode( convtype );
        _ConvParams.clear();
        _ConvParams.resize(params->size());
        copy(params->begin(),params->end(),_ConvParams.begin());
        _Xaxis.clear();
        _Xaxis = tmp->PutXaxisVect( _ConvParams );
        return true;
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
SetParams( std::string keycode, std::vector<Double> *params ){
    return SetParams( PutConvType( keycode ), params );
}

//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutParams( Int4 convtype ){
    std::vector<Double> ret;
    WiringInfoConversionTemplate* tmp = _Search( convtype );
    if (tmp!=NULL){
        ret.resize( _ConvParams.size() );
        copy( _ConvParams.begin(), _ConvParams.end(), ret.begin() );
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxis( Double tof_offset ){
    return _Xaxis;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
_PutTofBinOrLambda( UInt4 _pixel_id, bool isTof ){
    std::vector<Double> ret_empty;
    WiringInfoConversionTemplate* tmp = _Search( _KeyCode );
    if (tmp==NULL){
        UtsusemiError(_MessageTag+"PutTofBin >> No definition for key code = "+_KeyCode);
        return ret_empty;
    }

    if (_Xaxis.empty()){
        UtsusemiError(_MessageTag+"PutTofBin >> At first SetParams must be executed.");
        return ret_empty;
    }

    std::vector<Double>* pixel_posi = NULL;
    if ( (_pixel_id)<_pixelPositionVect.size() )
        pixel_posi = _pixelPositionVect[_pixel_id];

    std::vector<Double> out_params;
    UInt4 conv_type = tmp->ConvType;
    if ( (conv_type>=1)&&(conv_type<=3) ){
        out_params.resize( 1 );
        if (pixel_posi!=NULL)
            out_params[0] = (_L1 + sqrt((pixel_posi->at(0))*(pixel_posi->at(0)) + (pixel_posi->at(1))*(pixel_posi->at(1)) + (pixel_posi->at(2))*(pixel_posi->at(2)) ))/1000.0;

    }else if ( ( conv_type==12 )||( conv_type==13 ) ){
        if (_timeFocParam.empty()){
            UtsusemiError(_MessageTag+"PutTofBin >> SetTimeFocusingParam  must be executed.");
            return ret_empty;
        }else if (_timeFocParam.size()==1){
            out_params.resize(_timeFocParam[0].size(), 0.0);
            copy( _timeFocParam[0].begin(), _timeFocParam[0].end(), out_params.begin() );
        }else if ( (_pixel_id)<_timeFocParam.size() ){
            out_params.resize(_timeFocParam[_pixel_id].size(), 0.0);
            copy( _timeFocParam[_pixel_id].begin(), _timeFocParam[_pixel_id].end(), out_params.begin() );
        }else{
            UtsusemiError(_MessageTag+"PutTofBin >> Correct SetTimeFocusingParam  must be executed.");
            return ret_empty;
        }
        if (pixel_posi!=NULL)
            out_params.push_back( (_L1 + sqrt((pixel_posi->at(0))*(pixel_posi->at(0)) + (pixel_posi->at(1))*(pixel_posi->at(1)) + (pixel_posi->at(2))*(pixel_posi->at(2)) ))/1000.0 );

    }else if ( (conv_type>=20)&&(conv_type<=25) ){
        out_params.resize( 1 );
        out_params[0] = _L1;
    }

    if (isTof) {
        //[inamura 160809]-->
        //if (_UTO==NULL) return tmp->PutTofBin( &_Xaxis, &_ConvParams, pixel_posi, &out_params );
        //else{
        if (_UTO==NULL){
            if (isSetTimeDependBackGroundRegion){
                if (TimeDependBackGroundRegion->size()==1){
                    Double ptn  = TimeDependBackGroundRegion->at(0)->at(0);
                    Double tof0 = TimeDependBackGroundRegion->at(0)->at(1);
                    Double tof1 = TimeDependBackGroundRegion->at(0)->at(2);
                    TimeDependBackGroundRegion->resize( _pixelPositionVect.size(), NULL );
                    for (UInt4 i=1; i<TimeDependBackGroundRegion->size(); i++){
                        TimeDependBackGroundRegion->at(i) = new std::vector<Double>(3,0.0);
                        TimeDependBackGroundRegion->at(i)->at(0) = ptn;
                        TimeDependBackGroundRegion->at(i)->at(1) = tof0;
                        TimeDependBackGroundRegion->at(i)->at(2) = tof1;
                    }
                }
                std::vector<Double> tof_vec = tmp->PutTofBin( &_Xaxis, &_ConvParams, pixel_posi, &out_params );
                if (TimeDependBackGroundRegion->at(_pixel_id)!=NULL){
                    Double tof0 = TimeDependBackGroundRegion->at(_pixel_id)->at(1);
                    Double tof1 = TimeDependBackGroundRegion->at(_pixel_id)->at(2);
                    if (tof1<tof_vec[0]){ // tof0<tof1<tof_vec[0]<... : Pattern = 1
                        TimeDependBackGroundRegion->at(_pixel_id)->at(0) = 1;
                        std::vector<Double> ret_vec( tof_vec.size()+2 );
                        ret_vec[0] = tof0;
                        ret_vec[1] = tof1;
                        copy( tof_vec.begin(), tof_vec.end(), ret_vec.begin()+2 );
                        return ret_vec;
                    }else if (tof0>tof_vec.back()){ // tof_vec[last]<tof0<tof1 : pattern = 2
                        TimeDependBackGroundRegion->at(_pixel_id)->at(0) = 2;
                        tof_vec.push_back(tof0);
                        tof_vec.push_back(tof1);
                        return tof_vec;
                    }else if ( (tof0<tof_vec.front())&&(tof1>=tof_vec.front()) ){ // tof0<tof_vec.front()<=tof1 : pattern = 3
                        TimeDependBackGroundRegion->at(_pixel_id)->at(0) = 3;
                        std::vector<Double> ret_vec( tof_vec.size()+1 );
                        ret_vec[0] = tof0;
                        copy( tof_vec.begin(), tof_vec.end(), ret_vec.begin()+1 );
                        return ret_vec;
                    }else if ( (tof0<=tof_vec.back())&&(tof1>tof_vec.back()) ){  // tof0<=tof_vec[last]<tof1 : pattern = 4
                        TimeDependBackGroundRegion->at(_pixel_id)->at(0) = 4;
                        tof_vec.push_back(tof1);
                        return tof_vec;
                    }else{   // tof_vec[first]<tof0<tof1<tof_vec[last] : pattern = 5
                        TimeDependBackGroundRegion->at(_pixel_id)->at(0) = 5;
                        return tmp->PutTofBin( &_Xaxis, &_ConvParams, pixel_posi, &out_params );
                    }
                }
            }else{
                return tmp->PutTofBin( &_Xaxis, &_ConvParams, pixel_posi, &out_params );
            }
        }else{
        //<--[inamura 160809]
            std::vector<Double> tof = tmp->PutTofBin( &_Xaxis, &_ConvParams, pixel_posi, &out_params );
            std::vector<Double> tof_shift = _UTO->TofOriginShiftByLambda( tmp->PutLambdaVec( &_Xaxis, &_ConvParams, pixel_posi, &out_params ) );
            if (tof.size()==tof_shift.size()){
                for (UInt4 i=0; i<tof.size(); i++)
                    tof[i] += tof_shift[i];
                return tof;
            }
        }
        return ret_empty;
    }
    else return tmp->PutLambdaVec( &_Xaxis, &_ConvParams, pixel_posi, &out_params );

}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBin( UInt4 _pixel_id){
    return _PutTofBinOrLambda( _pixel_id, true );
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambda( UInt4 _pixel_id){
    return _PutTofBinOrLambda( _pixel_id, false );
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBin( UInt4 pixelId, Int4 convtype, std::vector<Double> *params ){
    if (SetParams( convtype, params )){
        return PutTofBin( pixelId );
    }else{
        UtsusemiError("WiringInfoConversionDictionary::PutTofBin");
        std::vector<Double> tmp;
        return tmp;
    }
}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
SetL1( Double L1 ){
    _L1 = L1;
}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
SetSamplePosition( Double px, Double py, Double pz ){
    _SamplePosition[0] = px;
    _SamplePosition[1] = py;
    _SamplePosition[2] = pz;
}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
SetPixelPosition( std::vector< std::vector<Double>* > pixelPositionVect ){
    _Clear();
    _pixelPositionVect.resize( pixelPositionVect.size(), NULL );
    for (UInt4 i=0; i<pixelPositionVect.size(); i++){
        if (pixelPositionVect[i]!=NULL){
            _pixelPositionVect[i] = new std::vector<Double>;
            for (UInt4 j=0;j<pixelPositionVect[i]->size();j++){
                _pixelPositionVect[i]->push_back( pixelPositionVect[i]->at(j) );
            }
        }
    }
}
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
SetTimeFocusingParam( std::vector< std::vector<Double> >* timeFocusParam ){
    _timeFocParam.clear();
    if (timeFocusParam==NULL) return;
    for (UInt4 i=0; i<timeFocusParam->size() ;i++){
        std::vector<Double> tmp( timeFocusParam->at(i).size(),0.0);
        for (UInt4 j=0; j<(timeFocusParam->at(i).size()); j++) tmp[j]=(timeFocusParam->at(i))[j];
        _timeFocParam.push_back(tmp);
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
SetFrameBoundaryInfoList( UInt4 frameNo, Double boundary, std::string type_in ){
    if (_pixelPositionVect.empty()){
        UtsusemiError(_MessageTag+"SetFrameBoundaryInfoList >> Not yet SetPixelPosition.");
        return false;
    }
    if (frameNo==0) return true; // Do Nothing frameNo=0;

    std::string _type(type_in);
    UtsusemiFrameBoundaryInfo uf;
    if (_type=="") _type=uf.BOUNDARYTYPE_TOF;

    transform( _type.begin(), _type.end(), _type.begin(), ::tolower );
    if ((_type!=uf.BOUNDARYTYPE_TOF)&&(_L1==0.0)){
        UtsusemiError(_MessageTag+"SetFrameBoundaryInfoList >> Not yet SetL1.");
        return false;
    }

    if ((_type!="tof")&&(_type!="lambda")&&(_type!="energy")&&(_type!="ei")){
        UtsusemiError(_MessageTag+"SetFrameBoundaryInfoList >> Type is invalid.");
        return false;
    }
    for (UInt4 i=0; i<(FrameBoundaryInfoList.size()); i++)
        if (FrameBoundaryInfoList[i]!=NULL)
            delete FrameBoundaryInfoList[i];
    FrameBoundaryInfoList.clear();

    FrameBoundaryInfoList.resize(_pixelPositionVect.size(),NULL);

    UtsusemiUnitConverter uc;
    for (UInt4 i=0; i<(FrameBoundaryInfoList.size()); i++){
        Double tof = 0.0;
        UInt4 fNo = 0;
        if (_type==uf.BOUNDARYTYPE_TOF){
            tof = boundary;
        }else{
            if (_pixelPositionVect[i]!=NULL){
                std::vector<Double>* pv = _pixelPositionVect[i];  //[mm]
                // Shifts for Sample Position
                pv->at(0) -= _SamplePosition[0]; //[mm]
                pv->at(1) -= _SamplePosition[1]; //[mm]
                pv->at(2) -= _SamplePosition[2]; //[mm]
                Double L1 = _L1/1000.0; //[mm]->[m]
                Double L2 = sqrt( (pv->at(0))*(pv->at(0)) + (pv->at(1))*(pv->at(1)) + (pv->at(2))*(pv->at(2)) )/1000.0; //[mm]->[m]
                if (_type==uf.BOUNDARYTYPE_LAMBDA){
                    //lambda = TLtoLambda( tof, L ) = cVtoLambda/L * tof -> tof = Lambda/cVtoLambda*L;
                    tof = boundary*(L1+L2)/uc.VtoLambda();
                }else if (_type==uf.BOUNDARYTYPE_ENERGY){
                    // TOF = LEtoT( L, ene )
                    tof = uc.LEtoT( (L1+L2), boundary );
                }else if (_type==uf.BOUNDARYTYPE_EI){
                    tof = uc.LEtoT( L1, boundary );
                }else{
                    tof = boundary;
                }
            }else{
                UtsusemiError(_MessageTag+"SetFrameBoundaryInfoList >> Invalid PixelPosition.");
                return false;
            }
        }

        if ((tof>=0.0)&&(tof<MLF_TARGET_FRAME_MICROSEC)){
            if (frameNo==1) fNo = 2; // maybe using 'type'
            else if ((frameNo==2)||(frameNo==3)) fNo=frameNo; // for old format
        }else if ((tof>=MLF_TARGET_FRAME_MICROSEC)&&(tof<=(2.0*MLF_TARGET_FRAME_MICROSEC))){
            fNo = 3;
            tof -= MLF_TARGET_FRAME_MICROSEC;
        }else{
            fNo=0;
            tof = 0.0;
        }
        if (FrameBoundaryInfoList[i]==NULL) FrameBoundaryInfoList[i] = new std::pair<UInt4,Double>;
        FrameBoundaryInfoList[i]->first = fNo;
        FrameBoundaryInfoList[i]->second = tof;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> WiringInfoConversionDictionary::
PutXLabel( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = NULL;
    if (convtype<0) tmp = _Search( _KeyCode );
    else tmp = _Search( convtype );

    std::pair<std::string,std::string> ret;
    if (tmp!=NULL){
        ret.first  = tmp->LabelsOfEC[0].first;
        ret.second = tmp->LabelsOfEC[0].second;
    }else{
        ret.first  = UTSUSEMI_KEY_UNKNOWN;
        ret.second = UTSUSEMI_KEY_UNKNOWN;
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> WiringInfoConversionDictionary::
PutYLabel( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = NULL;
    if (convtype<0) tmp = _Search( _KeyCode );
    else tmp = _Search( convtype );

    std::pair<std::string,std::string> ret;
    if (tmp!=NULL){
        ret.first  = tmp->LabelsOfEC[1].first;
        ret.second = tmp->LabelsOfEC[1].second;
    }else{
        ret.first  = UTSUSEMI_KEY_INTENSITY;
        ret.second = UTSUSEMI_KEY_COUNTS_UNIT;
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> WiringInfoConversionDictionary::
PutELabel( Int4 convtype ){
    WiringInfoConversionTemplate* tmp = NULL;
    if (convtype<0) tmp = _Search( _KeyCode );
    else tmp = _Search( convtype );

    std::pair<std::string,std::string> ret;
    if (tmp!=NULL){
        ret.first  = tmp->LabelsOfEC[2].first;
        ret.second = tmp->LabelsOfEC[2].second;
    }else{
        ret.first  = UTSUSEMI_KEY_ERROR;
        ret.second = UTSUSEMI_KEY_COUNTS_UNIT;
    }
    return ret;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
SetTofShift( UInt4 cType ){
    _UTO = new UtsusemiTofOriginCorrection();
    if (_UTO->SetTofOriginCorrectionType( cType )) return true;
    else{
        delete _UTO;
        _UTO=NULL;
        return false;
    }
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
SetTofShift( UInt4 cType, std::vector<Double> params ){
    _UTO = new UtsusemiTofOriginCorrection();
    if (_UTO->SetTofOriginCorrectionType( cType, params )) return true;
    else{
        delete _UTO;
        _UTO=NULL;
        return false;
    }
}
//[inamura 160809]-->
//////////////////////////////////////////////////////////
void WiringInfoConversionDictionary::
SetTimeDependBackGroundRegion( Double tof0, Double tof1 ){
    if (tof0>tof1){
        Double tmp = tof0;
        tof0 = tof1;
        tof1 = tmp;
    }
    StringTools st;
    UtsusemiMessage("WiringInfoConversionDictionary::SetTimeDependBackGGroundRegion tof0,tof1="+st.DoubleToString(tof0)+","+st.DoubleToString(tof1));
    isSetTimeDependBackGroundRegion = false;
    if ((tof0>=0.0)&&(tof1>0.0)){
        if (TimeDependBackGroundRegion==NULL){
            TimeDependBackGroundRegion = new std::vector< std::vector<Double>* >(1,NULL);
            TimeDependBackGroundRegion->at(0) = new std::vector<Double>(3,0.0);
            TimeDependBackGroundRegion->at(0)->at(1) = tof0;
            TimeDependBackGroundRegion->at(0)->at(2) = tof1;
        }

        if (_pixelPositionVect.empty()){
        }else{
            TimeDependBackGroundRegion->resize( _pixelPositionVect.size(), NULL );
        }
        for (UInt4 i=0; i<TimeDependBackGroundRegion->size(); i++){
            if (TimeDependBackGroundRegion->at(i)==NULL)
                TimeDependBackGroundRegion->at(i)= new std::vector<Double>(3,0.0);
            TimeDependBackGroundRegion->at(i)->at(1) = tof0;
            TimeDependBackGroundRegion->at(i)->at(2) = tof1;
        }
        UtsusemiMessage("WiringInfoConversionDictionary::SetTimeDependBackGGroundRegion size="+st.UInt4ToString(TimeDependBackGroundRegion->size()));
        isSetTimeDependBackGroundRegion = true;
    }else{
        if (TimeDependBackGroundRegion!=NULL){
            for (UInt4 i=0; i<TimeDependBackGroundRegion->size(); i++)
                if (TimeDependBackGroundRegion->at(i)!=NULL)
                    delete TimeDependBackGroundRegion->at(i);
            TimeDependBackGroundRegion->clear();
            TimeDependBackGroundRegion=NULL;
        }
        isSetTimeDependBackGroundRegion = false;
    }
}
//<--[inamura 160809]
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType001( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType001( std::vector<Double> params, Double tof_offset){
    return params;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType001( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* posi_vect, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return *xaxis;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType001( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    std::vector<Double> ret( xaxis->size(), 0.0 );
    if (!(out_params->empty()))
        for (UInt4 i=0;i<xaxis->size(); i++)
            ret[i] = uuc->VtoLambda( (out_params->at(0))/(xaxis->at(i)) );

    return ret;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType002( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double start_ch = params[0];
    Double end_ch = params[1];
    Double delta_ch = params[2];

    if (start_ch<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType002 : invalid param : start_ch<0.0");
        return false;
    }
    if (start_ch>end_ch){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType002 : invalid param : start_ch>end_ch");
        return false;
    }
    if (delta_ch<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType002 : invalid param : delta_ch<0.0");
        return false;
    }
    if ((start_ch+delta_ch)>end_ch){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType002 : invalid param : too large delta_ch");
        return false;
    }

    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType002( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    if (params.size()<3) {
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType003C >> parameter is invalid.");
        return ret;
    }
    Double start_ch = params[0];
    Double end_ch = params[1];
    Double delta_ch = params[2];
    Double current_tof = params[0];
    while( current_tof<= params[1] ){
        ret.push_back( current_tof );
        current_tof += params[2];
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType002( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* posi_vect, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return *xaxis;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType003( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double start_ch = params[0];
    Double end_ch = params[1];
    Double ratio_ch = params[2];

    if (start_ch<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType003 : invalid param : start_ch<0.0");
        return false;
    }
    if (start_ch>end_ch){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType003 : invalid param : start_ch>end_ch");
        return false;
    }
    if (ratio_ch<=0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType003 : invalid param : ratio_ch<=0.0");
        return false;
    }

    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType003( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    if (params.size()<3) {
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType003ConvType003 >> parameter is invalid.");
        return ret;
    }
    Double start_ch = params[0];
    Double end_ch = params[1];
    Double ratio_ch = params[2];
    Double factor_ch = (ratio_ch+2.)/(2.-ratio_ch);
    if (start_ch==0.0){
        start_ch = MLF_NEUNET_CLOCK_MICROSEC/(ratio_ch);// minimum time channle width of NEUNET is 0.025 micro-sec
    }
    Double first_ch =  (2.0/(1+factor_ch) )*start_ch;
    Double current_ch = first_ch;
    Double i = 1.0;
    while ( current_ch<=end_ch ){
        ret.push_back( current_ch );
        current_ch = first_ch * pow( factor_ch, i );
        i += 1.0;
    }

    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType003( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* posi_vect, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return *xaxis;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType012Type013( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    std::vector<Double> ret;
    if (out_params==NULL){
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType012013 >> out_params is empty.");
        return ret;
    }
    Double CC0 = 0.0;
    Double CC1 = 0.0;
    //if (out_params->size()==(2+1)){
    if ((out_params->size()==2)||(out_params->size()==3)){
        CC0 = out_params->at(0);
        CC1 = out_params->at(1);
    }else if (out_params->size()==(3+1)){
        Double L1 = out_params->at(0);
        Double L2_ref = out_params->at(1);
        Double Th_ref = out_params->at(2);
        Double L2 = sqrt( pv->at(0)*pv->at(0) + pv->at(1)*pv->at(1) + pv->at(2)*pv->at(2) );
        Double Tth = acos( pv->at(2)/L2 );
        if (pv->at(0)<0) Tth *= -1.0;

        CC1 = fabs( (L1+L2_ref)*sin((Th_ref/180.0*M_PI)/2.0)/((L1+L2)*sin(Tth/2.0)) );
    }else{
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType012013 >> Parameters are invalid.");
        return ret;
    }

    ret.resize( xaxis->size(), 0.0 );
    for (UInt4 i=0; i<xaxis->size(); i++) ret[i] = ((xaxis->at(i)) - CC0)/CC1;
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType012Type013( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    std::vector<Double> ret( xaxis->size(), 0.0 );
    for (UInt4 i=0;i<xaxis->size(); i++)
        ret[i] = uuc->VtoLambda( (out_params->back())/(xaxis->at(i)) );

    return ret;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType020( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double Ei = params[0];
    Double hw_min = params[1];
    Double hw_max = params[2];
    Double hw_delta = params[3];

    if (Ei<0.0) {
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType020 : invalid param : Ei<0.0");
        return false;
    }
    if (hw_min>hw_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType020 : invalid param : hw_min>hw_max");
        return false;
    }
    if (hw_delta<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType020 : invalid param : hw_delta<0.0");
        return false;
    }
    if ((hw_max-hw_min)<hw_delta){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType020 : invalid param : hw_max-hw_min<hw_delta");
        return false;
    }
    if (hw_max>=Ei){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType020 : invalid param : hw_max>=Ei");
        return false;
    }

    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType020( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    Double X_min;
    Double X_max;
    Double X_delta;
    if ( params.size()==6 ){
        X_min = params[1];
        X_max = params[2];
        X_delta = params[3];
        //L1 = param[4];
        tof_offset = params[5];  // Refered to Histogram.py
    }else if( params.size()==5 ){
        X_min = params[1];
        X_max = params[2];
        X_delta = params[3];
        //L1 = _detInfo->PutInstL1();
        tof_offset = params[4];  // Refered to Histogram.py
    }else if (params.size()==4 ){
        X_min = params[1];
        X_max = params[2];
        X_delta = params[3];
        tof_offset = 0.0;
    }else{
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType020 >> Parameters not enough.");
        return ret;
    }
    if (X_min>X_max){
        Double tmp = X_min;
        X_min = X_max;
        X_max = tmp;
    }

    Double X = -X_delta/2.0;
    while( X >= X_min ){ X -= X_delta; }
    if ((X<X_min)&&((X_min-X)>(X_delta/2.0))){
        while( X<X_min ){ X += X_delta; }
        X -= X_delta;
    }
    while( X < X_max ){
        ret.push_back( X );
        X += X_delta;
    }
    ret.push_back( X );

    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType020( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    std::vector<Double> ret;
    Double L1;
    if (params->size()==6) L1 = params->at(4);
    else if ( (params->size()==5)&&(out_params!=NULL)&&(out_params->size()>0) ) L1 = out_params->at(0);
    else if ( (params->size()==4)&&(out_params!=NULL)&&(out_params->size()>0) ) L1 = out_params->at(0);
    else{
        UtsusemiError("WiringInfoConversionDictionary::PutTofBInConvType020 >> size of params or out_params is invalid.");
        return ret;
    }
    Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
    Double t0_sample = (L1/1000.0)/(uuc->EtoV(params->at(0)));
    ret.resize( xaxis->size(),0.0 );
    for (UInt4 i=0;i<xaxis->size();i++)
        ret[i] = t0_sample + (L2/1000.0)/( uuc->EtoV((params->at(0))-xaxis->at(i)) );
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType020( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    std::vector<Double> ret( xaxis->size(), 0.0 ) ;
    for (UInt4 i=0;i<xaxis->size(); i++)
        ret[i] = uuc->EtoLambda( (params->at(0))-(xaxis->at(i)) );

    return ret;
}

//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType021( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double E_min = params[0];
    Double E_max = params[1];
    Double E_delta = params[2];

    if (E_min<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType021 : invalid param : E_min<0.0");
        return false;
    }
    if (E_min>E_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType021 : invalid param : E_min>E_max");
        return false;
    }
    if (E_delta<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType021 : invalid param : E_delta<0.0");
        return false;
    }
    if ((E_min+E_delta)>E_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType021 : invalid param : too large E_delta");
        return false;
    }

    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType021( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    Double E_min = 0.;
    Double E_max = 0.;
    Double E_stp = 0.;
    if ( params.size()==3 ){
        E_min = params[0];
        E_max = fabs( params[1] );
        E_stp = fabs( params[2] );
    }else{
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType021 >> Parameters not enough.");
        return ret;
    }
    if (E_min>E_max){
        Double tmp = E_min;
        E_min = E_max;
        E_max = tmp;
    }
    if (E_min<0.0) E_min=E_stp/2.0;
    Double E=E_min-0.5*E_stp;

    ret.clear();
    while( E < E_max ){
        ret.push_back( E );
        E += E_stp;
    }
    ret.push_back( E );
    reverse( ret.begin(), ret.end() );

    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType021( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params ,UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutTofBinConvType021 >> out_params is invalid.");
  }else{
      Double L1=out_params->at(0);
      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      ret.resize( xaxis->size(),0.0);
      for (UInt4 i=0;i<xaxis->size();i++)
          ret[i] = uuc->LEtoT( (L1+L2)/1000.0, xaxis->at(i) );
  }
  return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType021( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params ,UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutLambdaConvType021 >> out_params is invalid.");
  }else{
      ret.resize( xaxis->size(),0.0);
      for (UInt4 i=0;i<xaxis->size();i++)
          ret[i] = uuc->EtoLambda( xaxis->at(i) );
  }
  return ret;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType022( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double Q_min = params[0];
    Double Q_max = params[1];
    Double Q_delta = params[2];

    if (Q_min<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : Q_min<0.0");
        return false;
    }
    if (Q_min>Q_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : Q_min>Q_max");
        return false;
    }
    if (Q_delta<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : Q_delta<0.0");
        return false;
    }
    if ((Q_min+Q_delta)>Q_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : too large Q_delta");
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType022( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    Double Q_min;
    Double Q_max;
    Double Q_delta;

    if ( ( params.size()==3 )||( params.size()==6 ) ){
        Q_min = params[0];
        Q_max = params[1];
        Q_delta = params[2];
    }else{
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType022 >> Parameters not enough.");
        return ret;
    }
    if (Q_min>Q_max){
        Double tmp = Q_min;
        Q_min = Q_max;
        Q_max = tmp;
    }

    ret.clear();
    if (Q_delta<0.0) Q_delta=-Q_delta;
    if (Q_min<=0.0) Q_min=Q_delta/2.0;
    Double Q = Q_min-Q_delta/2.0;
    while( Q < Q_max ){
        ret.push_back( Q );
        Q += Q_delta;
    }
    ret.push_back( Q );
    reverse( ret.begin(), ret.end() );

    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType022( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutTofBinConvType022 >> out_params is invalid.");
  }else{
      Double L1=out_params->at(0);

      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      std::vector<Double> *p0v = new std::vector<Double> (3,0.0);
      if (params->size()>5){
          p0v->at(0)=params->at(3);
          p0v->at(1)=params->at(4);
          p0v->at(2)=params->at(5);
      }else{
          p0v->at(2)=1.0;
      }
      Double L2d = sqrt( (p0v->at(0))*(p0v->at(0))+(p0v->at(1))*(p0v->at(1))+(p0v->at(2))*(p0v->at(2)) );
      Double FF = sqrt(   ( (pv->at(0))/L2-(p0v->at(0))/L2d )*( (pv->at(0))/L2-(p0v->at(0))/L2d )
                          + ( (pv->at(1))/L2-(p0v->at(1))/L2d )*( (pv->at(1))/L2-(p0v->at(1))/L2d )
                          + ( (pv->at(2))/L2-(p0v->at(2))/L2d )*( (pv->at(2))/L2-(p0v->at(2))/L2d ) );
      delete p0v;

      ret.resize( xaxis->size(),0.0);
      for (UInt4 i=0;i<xaxis->size();i++)
          ret[i] = uuc->Vmm_msToK()*( (L1+L2)/(xaxis->at(i)) ) * FF;
  }
  return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType022( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutTofBinConvType022 >> out_params is invalid.");
  }else{
      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      std::vector<Double> *p1v = new std::vector<Double> (3,0.0);
      p1v->at(0) = (pv->at(0))/L2;
      p1v->at(1) = (pv->at(1))/L2;
      p1v->at(2) = (pv->at(2))/L2;

      std::vector<Double> *p0v = new std::vector<Double> (3,0.0);
      if (params->size()>5){
          Double L2d = sqrt( (params->at(3))*(params->at(3))+(params->at(4))*(params->at(4))+(params->at(5))*(params->at(5)) );
          p0v->at(0)=(params->at(3))/L2d;
          p0v->at(1)=(params->at(4))/L2d;
          p0v->at(2)=(params->at(5))/L2d;
      }else{
          p0v->at(2)=1.0;
      }

      Double FF = sqrt( ((p1v->at(0))-(p0v->at(0)))*((p1v->at(0))-(p0v->at(0)))
                        + ((p1v->at(1))-(p0v->at(1)))*((p1v->at(1))-(p0v->at(1)))
                        + ((p1v->at(2))-(p0v->at(2)))*((p1v->at(2))-(p0v->at(2))) );

      delete p0v;
      delete p1v;

      ret.resize( xaxis->size(), 0.0 );
      for (UInt4 i=0; i<xaxis->size(); i++)
          ret[i] = uuc->KtoLambda( (xaxis->at(i))/FF );
  }
  return ret;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType023( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double l_min = params[0];
    Double l_max = params[1];
    Double l_delta = params[2];

    if (l_min<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : lambda_min<0.0");
        return false;
    }
    if (l_min>l_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : lamblda_min>Q_max");
        return false;
    }
    if (l_delta<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : lambda_delta<0.0");
        return false;
    }
    if ((l_min+l_delta)>l_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType022 : invalid param : too large lambda_delta");
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType023( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    ret.clear();
    if (params.size()<3){
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType023 >> Parameters not enough.");
        return ret;
    }else{
        Double lambda_min = params[0];
        Double lambda_max = params[1];
        Double del_lambda = params[2];

        Double lambda_tmp = lambda_min-( del_lambda/2.0 );
        if (lambda_tmp<0.0) lambda_tmp = 0.0;
        while(lambda_tmp<lambda_max){
            ret.push_back( lambda_tmp );
            lambda_tmp = lambda_tmp+del_lambda;
        }
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType023( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;

  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutTofBinConvType023 >> out_params is invalid.");
  }else{
      Double L1=out_params->at(0); //L1 [mm]
      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      Double const_lambdaToTof = ((L1+L2)/1000.0)/(uuc->VtoLambda());
      ret.resize( xaxis->size(), 0.0 );
      for (UInt4 i=0;i<ret.size();i++)
          ret[i] = (xaxis->at(i))*const_lambdaToTof;
  }
  return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType023( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return *xaxis;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType024( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double l_min = params[0];
    Double l_max = params[1];
    Double l_ratio = params[2];

    if (l_min<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType024 : invalid param : lambda_min<0.0");
        return false;
    }
    if (l_min>l_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType024 : invalid param : lamblda_min>Q_max");
        return false;
    }
    if (l_ratio<=0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType024 : invalid param : lambda_ratio<=0.0");
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType024( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    if (params.size()<3){
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType024 >> Parameters not enough.");
    }else{
        Double lambda_min = params[0];
        Double lambda_max = params[1];
        Double racio_lambda = params[2];

        Double factor = (2.0+racio_lambda)/(2.0-racio_lambda);
        if ( lambda_min<=0.0 ) lambda_min = 1.0E-10;

        Double first_Lam = 2.0*lambda_min/(1+factor);
        Double currLam = first_Lam;
        Double i = 1.0;
        while( currLam<=lambda_max ){
            ret.push_back( currLam );
            currLam = first_Lam * pow( factor, i );
            i += 1.0;
        }
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType024( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutTofBinConvType024 >> out_params is invalid.");
  }else{
      Double L1=out_params->at(0);
      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      Double const_lambdaToTof = ((L1+L2)/1000.0)/(uuc->VtoLambda());
      ret.resize( xaxis->size(), 0.0 );
      for (UInt4 i=0;i<ret.size();i++)
          ret[i] = (xaxis->at(i))*const_lambdaToTof;
  }
  return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType024( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return *xaxis;
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType025( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    Double d_min = params[0];
    Double d_max = params[1];
    Double d_delta = params[2];

    if (d_min<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType025 : invalid param : d_min<0.0");
        return false;
    }
    if (d_min>d_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType025 : invalid param : d_min>Q_max");
        return false;
    }
    if (d_delta<0.0){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType025 : invalid param : d_delta<0.0");
        return false;
    }
    if ((d_min+d_delta)>d_max){
        UtsusemiError("WiringInfoConversionDictionary::CheckParamsType025 : invalid param : too large d_delta");
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType025( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    ret.clear();
    if (params.size()<3){
        UtsusemiError("WiringInfoConversionDictionary::PutXaxisConvType025 >> Parameters not enough.");
    }else{
        Double d_min = params[0];
        Double d_max = params[1];
        Double delta_d = params[2];

        Double d_tmp = d_min - delta_d/2.0;
        while(d_tmp<d_max){
            ret.push_back( d_tmp );
            d_tmp += delta_d;
        }
    }
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType025( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutBinConvType025 >> out_params is invalid.");
  }else{
      Double L1=out_params->at(0);
      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      Double theta = acos( (pv->at(2))/L2 )/2.0;
      Double const_dToTof = 2.0*sin( theta )*((L1+L2)/1000.0)/(uuc->VtoLambda());
      ret.resize( xaxis->size(), 0.0 );
      for (UInt4 i=0;i<ret.size();i++)
          ret[i] = (xaxis->at(i))*const_dToTof;
  }
  return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType025( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  std::vector<Double> ret;
  if ((out_params==NULL)||(out_params->empty())){
      UtsusemiError("WiringInfoConversionDictionary::PutLambdaConvType025 >> out_params is invalid.");
  }else{
      Double L2 = sqrt( (pv->at(0))*(pv->at(0))+(pv->at(1))*(pv->at(1))+(pv->at(2))*(pv->at(2)) );
      Double theta = acos( (pv->at(2))/L2 )/2.0;
      ret.resize( xaxis->size(), 0.0 );
      for (UInt4 i=0;i<ret.size();i++)
          ret[i] = 2.0*(xaxis->at(i))*sin( theta );
  }
  return ret;
}



//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType027( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType027( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType027( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return (*xaxis);
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType027( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  return (*xaxis);
}
//////////////////////////////////////////////////////////
bool WiringInfoConversionDictionary::
CheckParamsType028( std::vector<Double> params, UtsusemiUnitConverter* uuc ){
    return true;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutXaxisConvType028( std::vector<Double> params, Double tof_offset){
    std::vector<Double> ret;
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutTofBinConvType028( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
    return (*xaxis);
}
//////////////////////////////////////////////////////////
std::vector<Double> WiringInfoConversionDictionary::
PutLambdaConvType028( std::vector<Double>* xaxis, std::vector<Double>* params, std::vector<Double>* pv, std::vector<Double>* out_params, UtsusemiUnitConverter* uuc ){
  return (*xaxis);
}

