#include "UtsusemiNeutronEventDecoderBase.hh"
//////////////////////////////////////////////////////////
UtsusemiNeutronEventDecoderBase::
UtsusemiNeutronEventDecoderBase()
{
    Initialize();
}

//////////////////////////////////////////////////////////
UtsusemiNeutronEventDecoderBase::
~UtsusemiNeutronEventDecoderBase()
{
    delete stools;

}
//////////////////////////////////////////////////////////
const UInt4 UtsusemiNeutronEventDecoderBase::_isNeutronEvent = 1;
const UInt4 UtsusemiNeutronEventDecoderBase::_isT0Event = 2;
const UInt4 UtsusemiNeutronEventDecoderBase::_isClockEvent = 3;
//////////////////////////////////////////////////////////
void UtsusemiNeutronEventDecoderBase::
Initialize()
{
   _MessageTag = "UtsusemiNeutronEventDecoderBase >>";
    stools = new StringTools();

    _version="0.1";
    _INVALID_VALUE = (UInt4)10000000000;
    _EventSize = 8;
    _instCode = "XXX";

    _MicroSec_Par_Frame = MLF_TARGET_FRAME_MICROSEC;
    _LabelsOfEC.clear();
    // make empty
    /**
    std::vector< pair< std::string,std::string > > empty_pair_vec(3);
    empty_pair_vec[0].first  =UTSUSEMI_KEY_UNKNOWN;
    empty_pair_vec[0].second =UTSUSEMI_KEY_UNKNOWN_UNIT;
    empty_pair_vec[1].first  =UTSUSEMI_KEY_INTENSITY;
    empty_pair_vec[1].second =UTSUSEMI_KEY_COUNTS_UNIT;
    empty_pair_vec[2].first  =UTSUSEMI_KEY_ERROR;
    empty_pair_vec[2].second =UTSUSEMI_KEY_COUNTS_UNIT;

    std::vector< std::pair< std::string,std::string > > tmp_tof( 3 );
    tmp_tof[0].first=UTSUSEMI_KEY_TOF;
    tmp_tof[0].second=UTSUSEMI_KEY_TOF_UNIT;
    tmp_tof[1].first=UTSUSEMI_KEY_INTENSITY;
    tmp_tof[1].second=UTSUSEMI_KEY_COUNTS_UNIT;
    tmp_tof[2].first=UTSUSEMI_KEY_ERROR;
    tmp_tof[2].second=UTSUSEMI_KEY_COUNTS_UNIT;
    std::vector< std::pair< std::string,std::string > > tmp_hw( 3 );
    tmp_hw[0].first=UTSUSEMI_KEY_ENERGY;
    tmp_hw[0].second=UTSUSEMI_KEY_ENERGY_UNIT;
    tmp_hw[1].first=UTSUSEMI_KEY_INTENSITY;
    tmp_hw[1].second=UTSUSEMI_KEY_COUNTS_UNIT;
    tmp_hw[2].first=UTSUSEMI_KEY_ERROR;
    tmp_hw[2].second=UTSUSEMI_KEY_COUNTS_UNIT;
    std::vector< std::pair< std::string,std::string > > tmp_q( 3 );
    tmp_q[0].first=UTSUSEMI_KEY_MOMENTTRANSFER;
    tmp_q[0].second=UTSUSEMI_KEY_MOMENTTRANSFER_UNIT;
    tmp_q[1].first=UTSUSEMI_KEY_INTENSITY;
    tmp_q[1].second=UTSUSEMI_KEY_COUNTS_UNIT;
    tmp_q[2].first=UTSUSEMI_KEY_ERROR;
    tmp_q[2].second=UTSUSEMI_KEY_COUNTS_UNIT;
    std::vector< std::pair< std::string,std::string > > tmp_lambda( 3 );
    tmp_lambda[0].first=UTSUSEMI_KEY_LAMBDA;
    tmp_lambda[0].second=UTSUSEMI_KEY_LAMBDA_UNIT;
    tmp_lambda[1].first=UTSUSEMI_KEY_INTENSITY;
    tmp_lambda[1].second=UTSUSEMI_KEY_COUNTS_UNIT;
    tmp_lambda[2].first=UTSUSEMI_KEY_ERROR;
    tmp_lambda[2].second=UTSUSEMI_KEY_COUNTS_UNIT;
    std::vector< std::pair< std::string,std::string > > tmp_d( 3 );
    tmp_d[0].first=UTSUSEMI_KEY_DVALUE;
    tmp_d[1].second="";
    tmp_d[1].first=UTSUSEMI_KEY_INTENSITY;
    tmp_d[1].second=UTSUSEMI_KEY_COUNTS_UNIT;
    tmp_d[2].first=UTSUSEMI_KEY_ERROR;
    tmp_d[2].second=UTSUSEMI_KEY_COUNTS_UNIT;

    _LabelsOfEC.clear();
    _LabelsOfEC.resize(30, empty_pair_vec);

    // TofBinType=0

    // TofBinType=1,2,3,4 TOF
    _LabelsOfEC[1] = tmp_tof;
    _LabelsOfEC[2] = tmp_tof;
    _LabelsOfEC[3] = tmp_tof;
    _LabelsOfEC[4] = tmp_tof;
    // TofBinType=5-11 not defined

    // TofBinType=12,13 TOF in Time Focusing
    _LabelsOfEC[12] = tmp_tof;
    _LabelsOfEC[13] = tmp_tof;
    // TofBinType=14-19 not defined

    // TofBinType=20,21 EnergyTransfer or Energy
    _LabelsOfEC[20] = tmp_hw;
    _LabelsOfEC[21] = tmp_hw;
    // TofBinType=22 Q
    _LabelsOfEC[22] = tmp_q;
    // TofBinType==23,24 Lambda
    _LabelsOfEC[23] = tmp_lambda;
    _LabelsOfEC[24] = tmp_lambda;
    // TofBinType==25 d-value
    _LabelsOfEC[25] = tmp_d;
    // TofBinType=26 not defined

    // TofBinType=27 EnrgyTransfer on indirect geometry
    _LabelsOfEC[27] = tmp_hw;
    **/
}
//////////////////////////////////////////////////////////
Int4 UtsusemiNeutronEventDecoderBase::
SetParametersFromFiles( std::string wiring_file, std::string detector_file )
{
    UtsusemiMessage(_MessageTag+"SetParametersFromFiles executes.");
    return 0;
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeutronEventDecoderBase::
decodeEventDataPy( UInt4 daqId, std::string data_s )
{
    UInt4 pixelid = 0;
    double tof = 0.0;
    UChar *data = new UChar[ data_s.size() ];
    for (UInt4 i=0;i<data_s.size();i++){
        data[i]=(UChar)data_s[i];
    }
    std::vector<Double> clock(3,0.0);

    UInt4 moduleNo=0;
    UInt4 type = DecodeEventData( daqId, moduleNo, data, &pixelid,&tof,&clock );

    std::vector<Double> ret;
    ret.clear();

    if (type == _isNeutronEvent){
        ret.push_back( (double)(pixelid) );
        ret.push_back( tof );
    }
    if (data) delete [] data;
    return ret;

}

/////////////////////////////////////////////////////////////
// Functions required by UtsusemiEventDataConverterTemplate
/////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiNeutronEventDecoderBase::
PutPixelIdList( bool isInner ){
    std::vector<UInt4> ret;
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeutronEventDecoderBase::
PutHistBin( UInt4 outerPixelId ){
    std::vector<Double> ret;
    return ret;
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeutronEventDecoderBase::
PutXaxis(){
    std::vector<Double> ret;
    return ret;
}
//////////////////////////////////////////////////////////
void UtsusemiNeutronEventDecoderBase::
ClearPrevT0Event(UInt4 ThNum)
{
    UtsusemiMessage(_MessageTag+"clearPrevEvent executes.");
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeutronEventDecoderBase::
DecodeEventData( UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector<Double>* Clock, UInt4 ThNum )
{
    return 0;
}
//////////////////////////////////////////////////////////
bool UtsusemiNeutronEventDecoderBase::
IsNeutronEvent( UInt4 type ){
    if (type==_isNeutronEvent) return true;
    return false;
}
//////////////////////////////////////////////////////////
bool UtsusemiNeutronEventDecoderBase::
IsT0Event( UInt4 type ){
    if (type==_isT0Event) return true;
    return false;
}
//////////////////////////////////////////////////////////
bool UtsusemiNeutronEventDecoderBase::
IsInstClockEvent( UInt4 type ){
    if (type==_isClockEvent) return true;
    return false;
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeutronEventDecoderBase::
ConvertPixelIdToInnerId( UInt4 pixel_id )
{
    UtsusemiMessage(_MessageTag+"convPixelIdToInnerId executes.");
    return 0;
}
//////////////////////////////////////////////////////////
Double UtsusemiNeutronEventDecoderBase::
CalcIncrementVal( Double *tof, UInt4 *pixelId ){
    return 1.0;
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeutronEventDecoderBase::
PutPixelPosition( UInt4 outerPixelId ){
    std::vector<Double> ret;
    return ret;
}
//////////////////////////////////////////////////////////
Int4 UtsusemiNeutronEventDecoderBase::
PutTofBinType( UInt4 outerPixelId ){
    return -1;
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> UtsusemiNeutronEventDecoderBase::
PutXLabel( Int4 convtype ){
    std::pair< std::string,std::string > ret( UTSUSEMI_KEY_UNKNOWN,UTSUSEMI_KEY_UNKNOWN_UNIT );
    return ret;
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> UtsusemiNeutronEventDecoderBase::
PutYLabel( Int4 convtype ){
    std::pair< std::string,std::string > ret( UTSUSEMI_KEY_INTENSITY,UTSUSEMI_KEY_COUNTS_UNIT );
    return ret;
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> UtsusemiNeutronEventDecoderBase::
PutELabel( Int4 convtype ){
    std::pair< std::string,std::string > ret( UTSUSEMI_KEY_ERROR,UTSUSEMI_KEY_COUNTS_UNIT );
    return ret;
}
//////////////////////////////////////////////////////////
bool UtsusemiNeutronEventDecoderBase::
isReverseAxis( Int4 convtype ){
    return false;
}
//////////////////////////////////////////////////////////
bool UtsusemiNeutronEventDecoderBase::
isValidConvType( Int4 convtype ){
    return true;
}
//////////////////////////////////////////////////////////
void UtsusemiNeutronEventDecoderBase::
SetMaskOnError( UInt4 _outerPixelId, std::vector<Double> &_bin, std::vector<Double> &_err ){

}
//[inamura 160809]-->
/////////////////////////////////////////////////////////
std::vector<double>* UtsusemiNeutronEventDecoderBase::
PutTimeDependBackGroundInfo( UInt4 _outerPixelId ){
    std::vector<double>* ret = NULL;
    return ret;
}
//<--[inamura 160809]
std::vector<Double> UtsusemiNeutronEventDecoderBase::
PutTypicalPixelSize(UInt4 _detId){
    std::vector<Double> ret;
    return ret;
}
