#include "UtsusemiNeunetEventDecoderBase.hh"
//////////////////////////////////////////////////////////
UtsusemiNeunetEventDecoderBase::
UtsusemiNeunetEventDecoderBase():
UtsusemiNeutronEventDecoderBase()
{
    Initialize();
}
//////////////////////////////////////////////////////////
UtsusemiNeunetEventDecoderBase::
~UtsusemiNeunetEventDecoderBase(){
    Clear();
    delete [] _prevT0Event;
    if (_detInfo!=NULL) delete _detInfo;
    if (_wirInfo!=NULL) delete _wirInfo;
    //if (_tofBinConv!=NULL) delete _tofBinConv;
    //if (_wirDict!=NULL) delete _wirDict;
    delete _st;
}
//////////////////////////////////////////////////////////
void UtsusemiNeunetEventDecoderBase::
Initialize(){
    _detInfo = new DetectorInfoEditorNeunet();
    _wirInfo = new WiringInfoEditorNeunet();
    //_tofBinConv = NULL;
    _wirDict = _wirInfo->PutConversionDictionary();

    _EventSize = (UInt4)8;
    _HeaderT0Event      = (UChar)0x5b;
    _HeaderClockEvent   = (UChar)0x5c;
    _HeaderNeutronEvent = (UChar)0x5a;

    _NumOfMulTh = UtsusemiGetNumOfMulTh();
#ifdef MULTH
    _prevT0Event = new UChar[ _EventSize*_NumOfMulTh ];
    for (UInt4 i=0;i<_EventSize*_NumOfMulTh;i++) *(_prevT0Event+i)=0x00;
#else
    _prevT0Event = new UChar[ _EventSize*2 ];
    for (UInt4 i=0;i<_EventSize*2;i++) *(_prevT0Event+i)=0x00;
#endif

    _MessageTag="UtsusemiNeunetEventDecoderBase >> ";

    _pixelPositionVect.clear();
    _pixelSolidAngleVect.clear();

    _st = new StringTools();

    _isSetFrameBoundary=false;
    _isUsedModuleNoInEvent=true;
}
/////////////////////////////////////////////////////////
void UtsusemiNeunetEventDecoderBase::
Clear(){
    if (!(_pixelPositionVect.empty())){
        for (UInt4 i=0;i<_pixelPositionVect.size();i++)
            if (_pixelPositionVect[i]!=NULL) delete _pixelPositionVect[i];

        _pixelPositionVect.clear();
    }
    _pixelSolidAngleVect.clear();
}
//////////////////////////////////////////////////////////
Int4 UtsusemiNeunetEventDecoderBase::
SetParametersFromFiles( std::string wiring_file, std::string detector_file ){
    if (_detInfo!=NULL) {
        delete _detInfo;
        _detInfo=NULL;
    }
    if (_wirInfo!=NULL) {
        delete _wirInfo;
        _wirInfo=NULL;
    }

    _detInfo = new DetectorInfoEditorNeunet(detector_file);
    _wirInfo = new WiringInfoEditorNeunet(wiring_file);
    //_tofBinConv = new UtsusemiTofBinPatternFor3HePsd();
    //_wirDict = new WiringInfoConversionDictionary();
    _wirDict = _wirInfo->PutConversionDictionary();

    if ((_detInfo->_Status)&&(_wirInfo->_Status)){
        UtsusemiMessage(_MessageTag+"SetParametersFromFilesBase finished successfully. ");
    }else{
        UtsusemiError(_MessageTag+"SetParametersFromFilesBase fails. ");
        delete _detInfo;
        delete _wirInfo;
        _detInfo = NULL;
        _wirInfo = NULL;
        return -1;
    }

    //_tofBinConv->SetDetectorAndWiringInfo( _detInfo, _wirInfo );
    CalcPixelPosition();
    //_tofBinConv->SetPixelPosition( _pixelPositionVect );
    _wirDict->SetPixelPosition( _pixelPositionVect );
    _wirDict->SetTimeFocusingParam( _detInfo->PutTfp() );
    _wirDict->SetL1( _detInfo->PutInstL1() );
    std::vector<Double> p = _detInfo->PutInstSamplePosition();
    _wirDict->SetSamplePosition( p[0],p[1],p[2] );
    _instCode = _wirInfo->InstCode;

    // Set FrameBoundary for each pixel
    if (_wirInfo->FrameBoundaryInfo.frameNo!=0){
        if ( _wirDict->SetFrameBoundaryInfoList(
                 _wirInfo->FrameBoundaryInfo.frameNo,
                 _wirInfo->FrameBoundaryInfo.boundaryValue,
                 _wirInfo->FrameBoundaryInfo.boundaryType
                 ) ){
            _isSetFrameBoundary=true;
        }else{
            UtsusemiError(_MessageTag+"SetParameterFromFilesBase >> SetFrameBounadryInfoList failed" );
            _isSetFrameBoundary=false;
            delete _detInfo;
            delete _wirInfo;
            _detInfo = NULL;
            _wirInfo = NULL;
            return -1;
        }
    }

    return 0;

}

//////////////////////////////////////////////////////////
void UtsusemiNeunetEventDecoderBase::
ClearPrevT0Event(UInt4 ThNum){
    for (UInt4 i=0;i<_EventSize;i++) _prevT0Event[(_EventSize*ThNum)+i]=0x00;
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeunetEventDecoderBase::
DecodeEventData( UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector<Double>* Clock, UInt4 ThNum ){

    UInt4 ret = 0;

    // if given event is neutron event;
    if (*data == _HeaderNeutronEvent){
        if (_prevT0Event[_EventSize*ThNum+0]!=0x00){
            if (_isUsedModuleNoInEvent){
                //moduleNo = (UInt4)(*(_prevT0Event+(_EventSize*ThNum)+2));
                UInt4 modNoInT0Event = (UInt4)(*(_prevT0Event+(_EventSize*ThNum)+2));
                if (moduleNo!=modNoInT0Event){
                    std::string msg = _MessageTag+"T0 Event is broken becase module No "+_st->UInt4ToString(modNoInT0Event)+" in T0Event";
                    msg += " is not same as given moduleNo "+_st->UInt4ToString(moduleNo);
                    UtsusemiWarning(msg);
                 }
                else
                    moduleNo=modNoInT0Event;
            }
            UInt4 det_num = (UInt4)( (*(data+4))&0x7 );
            // decode neutron event of NeuNET
            UInt4 k = (UInt4)( *(data+6) )/16;
            UInt4 ph_l = (UInt4)( *(data+5) ) * 16 +  k ;
            UInt4 ph_r = (UInt4)( *(data+7) )
                + 256 * ( (UInt4( *(data+6) ) )-(k*16) );
            UInt4 tof_clock = (UInt4)( *(data+1) << 16 )
                + (UInt4)( *(data+2) << 8 )
                + (UInt4)( *(data+3) );
            *tof = tof_clock*MLF_NEUNET_CLOCK_MICROSEC; // [micro-sec]

            // frame treatment : minus clock means this frame must be ignored.
            /*
            if ( (_wirInfo->FrameBoundaryInfo.first)>1 ){
                if ( *tof < (_wirInfo->FrameBoundaryInfo.second) ){
                    if (Clock->at( _wirInfo->FrameBoundaryInfo.first -1 )<0) return ret;
                    *tof += Clock->at( _wirInfo->FrameBoundaryInfo.first -1 );
                }else{
                    if (Clock->at( _wirInfo->FrameBoundaryInfo.first -2 )<0) return ret;
                    *tof += Clock->at( _wirInfo->FrameBoundaryInfo.first -2 );
                }
            }
            */

            if (_wirInfo->PixelInfoStore->at(daqId)==NULL){
                UtsusemiWarning(_MessageTag + "Given DaqId is not defined in WiringInfo. ("+_st->UInt4ToString(daqId)+")");
                return 0;
            }
            if (_wirInfo->PixelInfoStore->at(daqId)->at(moduleNo)==NULL){
                UtsusemiWarning(_MessageTag + "Given moduleNo is not defined in WiringInfo. ("+_st->UInt4ToString(moduleNo)+")");
                return 0;
            }
            std::vector<Int4> *pixel_info = NULL;
            try{
                if (det_num>=(_wirInfo->PixelInfoStore->at(daqId)->at(moduleNo)->size())) return 0;
                pixel_info = _wirInfo->PixelInfoStore->at(daqId)->at(moduleNo)->at(det_num);
            }catch(...){
                return 0;
            }
            Int4 det_id = pixel_info->at(1);
            if (det_id>=0){
                std::vector<Double>* abc = _wirInfo->PsdParamsList->at( det_id );
                if (abc!=NULL){
                    if ( ((ph_l+ph_r)>=(UInt4)(abc->at(3))) && ((ph_l+ph_r)<=(UInt4)(abc->at(4))) ){
                        Double pixel_posi = (abc->at(0)) * (Double)ph_r / ( (Double)ph_l + (abc->at(1))*(Double)ph_r ) - (abc->at(2));
                        //std::cout << "pixel_posi=" << pixel_posi << std::endl;
                        if (pixel_posi>=0){
                            std::vector<Double> *bininfo = _wirInfo->PsdBinInfoList[det_id];
                            Int4 pixel = (Int4)pixel_posi;
                            if (bininfo==NULL) UtsusemiWarning(_MessageTag+" bininfo is NULL at det_id="+_st->UInt4ToString(det_id));
                            if ( (bininfo->at(1))!=0.0 )
                                pixel = (Int4)( (pixel_posi - (bininfo->at(2))) / (bininfo->at(1)) );
                            if ((pixel>=0) && (pixel<=((pixel_info->at(3))-1))){
                                *pixel_id = (pixel_info->at(2)) + pixel;
                                if ((*pixel_id)<=_wirInfo->MaxPixelId) {
                                    ret = _isNeutronEvent;
                                    if(_wirInfo->TofBinInfoList[(*pixel_id)]!=NULL)
                                        *tof += _wirInfo->TofBinInfoList[(*pixel_id)]->at(1);
                                    if (_isSetFrameBoundary){
                                        UInt4 fno = _wirDict->FrameBoundaryInfoList[(*pixel_id)]->first;
                                        Double boundary = _wirDict->FrameBoundaryInfoList[(*pixel_id)]->second;
                                        // if no clocks for TOF shifting, return -1 to ignore this frame.
                                        if ( *tof < boundary){
                                            if (Clock->at( fno -1 )<0) return 0;
                                            *tof += Clock->at( fno -1 );
                                        }else if ( *tof < (boundary+_MicroSec_Par_Frame) ){
                                            if (Clock->at( fno -2 )<0) return 0;
                                            *tof += Clock->at( fno -2 );
                                        }
                                    }
                                }else{
                                    //std::cout << "pixel_id="<< (*pixel_id) << ">" << _wirInfo->MaxPixelId << std::endl;
                                }
                            }else{
                                //std::cout << "pixel="<<pixel<<", pixel_info[3]="<< (pixel_info->at(3))-1<<std::endl;
                            }
                        }
                    }
                }
            }
        }
    }else if (*data == _HeaderT0Event){
        for (UInt4 i=0;i<_EventSize;i++) (*(_prevT0Event+(_EventSize*ThNum)+i))=(*(data+i));
        ret = _isT0Event;
    }else if (*data == _HeaderClockEvent){
        ret = _isClockEvent;
    }

    return ret;

}

//////////////////////////////////////////////////////////
UInt4 UtsusemiNeunetEventDecoderBase::
ConvertPixelIdToInnerId( UInt4 pixel_id ){
    //return _wirInfo->PixelConvTable->at(pixel_id)->at(1);
    //return (_wirInfo->PixelConvTable->at(pixel_id)->at(1);
    return _wirInfo->PixelIdToInnerId[pixel_id];
    //return *(_wirInfo->PixelIdToInnerId+pixel_id);
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeunetEventDecoderBase::
ConvertPixelIdToDetId( UInt4 pixel_id ){
    return _wirInfo->PixelConvTable->at(pixel_id)->at(2);
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeunetEventDecoderBase::
PutNumOfInnerPixels(){
    return _wirInfo->NumOfInnerPixel;
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeunetEventDecoderBase::
PutMaxOfPixelId(){
    return _wirInfo->MaxPixelId;
}
//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiNeunetEventDecoderBase::
PutPixelIdList( bool isInner ){
    std::vector<UInt4> ret;
    UInt4 ind = 0;
    if (isInner) ind = 1;

    for (UInt4 i=0; i<(_wirInfo->PixelConvTable->size()); i++){
        if ( _wirInfo->PixelConvTable->at(i)!=NULL ){
            if (_wirInfo->PixelConvTable->at(i)->at(ind)!=-1) ret.push_back(i);
        }
    }
    return ret;
}

//////////////////////////////////////////////////////////
Int4 UtsusemiNeunetEventDecoderBase::
PutTofBinType( UInt4 outerPixelId ){

    if (_wirInfo->TofBinInfoList[outerPixelId]==NULL) return -1;
    std::vector<Double>* tofBinInfo = _wirInfo->TofBinInfoList[outerPixelId];

    UInt4 tof_pat_id = (UInt4)(tofBinInfo->at(0));
    if (_wirInfo->TofBinPtnInfo[ tof_pat_id ]==NULL) return -1;

    return  _wirInfo->TofBinPtnInfo[ tof_pat_id ]->type;

}

//////////////////////////////////////////////////////////
void UtsusemiNeunetEventDecoderBase::
CalcPixelPosition(){
    Clear();
    if (_wirInfo->PixelInfoStore->empty()) {
        UtsusemiError( _MessageTag + " not ready wiring info.");
        return;
    }

    for (UInt4 daq=0; daq<_wirInfo->PixelInfoStore->size();daq++){

        if (_wirInfo->PixelInfoStore->at(daq)==NULL) continue;

        for (UInt4 mod=0; mod<_wirInfo->PixelInfoStore->at(daq)->size(); mod++){
            if (_wirInfo->PixelInfoStore->at(daq)->at(mod)==NULL) continue;

            for (UInt4 psd=0; psd<_wirInfo->PixelInfoStore->at(daq)->at(mod)->size(); psd++){
                if (_wirInfo->PixelInfoStore->at(daq)->at(mod)->at(psd)!=NULL){
                    std::vector<Int4>* pic = _wirInfo->PixelInfoStore->at(daq)->at(mod)->at(psd);
                    UInt4 out_detId = pic->at(1);
                    UInt4 head_px = pic->at(2);
                    UInt4 num_px = pic->at(3);
                    if (_pixelPositionVect.size()<( head_px+num_px )){
                        _pixelPositionVect.resize( (head_px+num_px), NULL );
                        _pixelSolidAngleVect.resize( (head_px+num_px), 0.0 );
                    }
                    for (UInt4 pxId=head_px; pxId<(head_px+num_px); pxId++){
                        std::vector<Double> v = _detInfo->CalcPsdPixelPosition( out_detId, (pxId-head_px), num_px );
                        if (!(v.empty())){
                            if (_pixelPositionVect[pxId]==NULL) _pixelPositionVect[pxId] = new std::vector<Double>;
                            _pixelPositionVect[pxId]->clear();
                            for (UInt4 i=0; i<v.size(); i++){
                                _pixelPositionVect[pxId]->push_back( v[i] );
                            }
                            _pixelSolidAngleVect[pxId]=_detInfo->CalcPsdPixelSolidAngle( out_detId, (pxId-head_px), num_px );
                        }
                    }
                }
            }
        }
    }
}

//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeunetEventDecoderBase::
PutPixelPosition( UInt4 outerPixelId ){
    std::vector<Double>* p_vec = _pixelPositionVect[ outerPixelId ];
    std::vector<Double> ret;
    ret.push_back( p_vec->at(0) );
    ret.push_back( p_vec->at(1) );
    ret.push_back( p_vec->at(2) );
    return ret;

}

//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeunetEventDecoderBase::
PutXaxis(){
    if (_wirDict!=NULL)
        return _wirDict->PutXaxis();
    else{
        UtsusemiError(_MessageTag+"PutXaxis > have not executed SetParametersFromFiles() yet.");
        std::vector<Double> tmp;
        return tmp;
    }

}
//////////////////////////////////////////////////////////
bool UtsusemiNeunetEventDecoderBase::
isReverseAxis( Int4 convtype ){
    if (_wirDict!=NULL)
        return _wirDict->isReverseXaxis( convtype );
    else{
        UtsusemiError(_MessageTag+"isReverseAxis > have not executed SetParametersFromFiles() yet.");
        return false;
    }
}
//////////////////////////////////////////////////////////
bool UtsusemiNeunetEventDecoderBase::
isValidConvType( Int4 convtype ){
    if (_wirDict!=NULL)
        return _wirDict->isValidConvType( convtype );
    else{
        UtsusemiError(_MessageTag+"isValidConvType > have not executed SetParametersFromFiles() yet." );
        return false;
    }
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeunetEventDecoderBase::
PutHistBin( UInt4 outerPixelId ){
    std::vector<Double> ret;
    ret.clear();

    if (_wirInfo->TofBinInfoList[outerPixelId]==NULL) {
        UtsusemiError(_MessageTag+"PutHistBin : TofBinInfo[pixelId]=NULL : pixel_id="+_st->UInt4ToString(outerPixelId));
        return ret;
    }
    std::vector<Double>* tofBinInfo = _wirInfo->TofBinInfoList[outerPixelId];

    UInt4 tof_pat_id = (UInt4)(tofBinInfo->at(0));
    if (_wirInfo->TofBinPtnInfo[ tof_pat_id ]==NULL){
        UtsusemiError(_MessageTag+"PutHistBin : TofBinPtnInfo[ tof_pat_id ]=NULL : pat_id="+_st->UInt4ToString(tof_pat_id));
        return ret;
    }

    Int4 tofBinType = _wirInfo->TofBinPtnInfo[ tof_pat_id ]->type;
    std::vector<Double>* pattern = _wirInfo->TofBinPtnInfo[ tof_pat_id ]->PatternVect;

    //if ( (tofBinType>10)&&( !(_tofBinConv->isSetTimeFocVect)) ){
    //        SetTimeFocParams();
    //}

    //return _tofBinConv->Put( outerPixelId, tofBinType, *pattern );
    return _wirDict->PutTofBin( outerPixelId, tofBinType, pattern );

}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> UtsusemiNeunetEventDecoderBase::
PutXLabel( Int4 convtype ){
    if (_wirDict!=NULL)
        return _wirDict->PutXLabel( convtype );
    else{
        UtsusemiError(_MessageTag+"PutXLabel > have not executed SetParametersFromFiles() yet.");
        std::pair<std::string,std::string> tmp;
        tmp.first="None";
        tmp.second="None";
        return tmp;
    }
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> UtsusemiNeunetEventDecoderBase::
PutYLabel( Int4 convtype ){
    if (_wirDict!=NULL)
        return _wirDict->PutYLabel( convtype );
    else{
        UtsusemiError(_MessageTag+"PutYLabel > have not executed SetParametersFromFiles() yet.");
        std::pair<std::string,std::string> tmp;
        tmp.first="None";
        tmp.second="None";
        return tmp;
    }
}
//////////////////////////////////////////////////////////
std::pair<std::string,std::string> UtsusemiNeunetEventDecoderBase::
PutELabel( Int4 convtype ){
    if (_wirDict!=NULL)
        return _wirDict->PutELabel( convtype );
    else{
        UtsusemiError(_MessageTag+"PutELabel > have not executed SetParametersFromFiles() yet.");
        std::pair<std::string,std::string> tmp;
        tmp.first="None";
        tmp.second="None";
        return tmp;
    }
}
//////////////////////////////////////////////////////////
//void UtsusemiNeunetEventDecoderBase::
//SetTimeFocParams(){
//    _tofBinConv->SetTimeFocusingParam( _detInfo->PutTfp() );
//}

//////////////////////////////////////////////////////////
//void UtsusemiNeunetEventDecoderBase::
//SetEfix( std::vector< Double > efix ){
//    if (_tofBinConv!=NULL){
//        _tofBinConv->SetEfix( efix );
//    }else{
//        std::cout << _MessageTag << " not execute SetParametersFromFiles() yet." << std::endl;
//    }
//}

//////////////////////////////////////////////////////////
//void UtsusemiNeunetEventDecoderBase::
//SetEfix( Double efix ){
//    if (_tofBinConv!=NULL){
//        _tofBinConv->SetEfix( efix );
//    }else{
//        std::cout << _MessageTag << " not execute SetParametersFromFiles() yet." << std::endl;
//    }
//}

//////////////////////////////////////////////////////////
bool UtsusemiNeunetEventDecoderBase::
SetTofOriginShift( UInt4 cType ){
    if (_wirDict!=NULL)
        return _wirDict->SetTofShift( cType );
    else{
        UtsusemiError(_MessageTag + "SetTofOriginShift > have not executed SetParametersFromFiles() yet.");
        return false;
    }
}
//////////////////////////////////////////////////////////
bool UtsusemiNeunetEventDecoderBase::
SetTofOriginShift( UInt4 cType, std::vector<Double> params ){
    if (_wirDict!=NULL)
        return _wirDict->SetTofShift( cType, params );
    else{
        UtsusemiError(_MessageTag+" have not executed SetParametersFromFiles() yet.");
        return false;
    }
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeunetEventDecoderBase::
PutLambda( UInt4 pixel_id ){
    if (_wirDict!=NULL)
        return _wirDict->PutLambda( pixel_id );
    else{
        UtsusemiError(_MessageTag+"PutLambda > have not executed SetParametersFromFiles() yet.");
        std::vector<Double> ret;
        return ret;
    }
}
//////////////////////////////////////////////////////////
void UtsusemiNeunetEventDecoderBase::
SetMaskOnError( UInt4 _outerPixelId, std::vector<Double> &_bin, std::vector<Double> &_err ){
    if (_wirInfo->TofMaskPtnInfo.empty()){
    }else{
        if ((_wirInfo->TofBinInfoList.size()<=_outerPixelId)||(_wirInfo->TofBinInfoList[_outerPixelId]==NULL)) {
            UtsusemiError(_MessageTag+"SetMaskOnError : TofBinInfoList[pixelId]=NULL : pixel_id="+_st->UInt4ToString(_outerPixelId) );
            return;
        }
        std::vector<Double>* tofBinInfo = _wirInfo->TofBinInfoList[_outerPixelId];
        if (tofBinInfo->size()>=3){
            Int4 tof_mask_ptnId = (Int4)(tofBinInfo->at(2));
            if (tof_mask_ptnId<0){
            }else if (_wirInfo->TofMaskPtnInfo[(UInt4)(tof_mask_ptnId)]!=NULL){
                UtsusemiTofMaskPattern *tmp = _wirInfo->TofMaskPtnInfo[(UInt4)(tof_mask_ptnId)];
                if (tmp!=NULL){
                    for (UInt4 i=0; i<(_err.size()); i++){
                        Double bin1 = _bin[i];
                        Double bin2 = _bin[i+1];
                        bool isMask = false;
                        for (UInt4 j=0; j<(tmp->PatternVect.size()); j++){
                            if ( ( ( bin1>=(tmp->PatternVect[j].first) )&&( bin2<=(tmp->PatternVect[j].second) ) )
                                 ||( ( bin1<=(tmp->PatternVect[j].first) )&&( (tmp->PatternVect[j].first)<=bin2 ) )
                                 ||( ( bin1<=(tmp->PatternVect[j].second) )&&( (tmp->PatternVect[j].second)<=bin2 ) ) ) {
                                isMask = true;
                                break;
                            }
                        }
                        if (isMask) {
                            if (_err[i]==0.0) _err[i] = 1e-30;
                            _err[i] = -1.0*_err[i];
                        }
                    }
                }
            }
        }
    }
}
//[inamura 160809]-->
//////////////////////////////////////////////////////////
std::vector<double>* UtsusemiNeunetEventDecoderBase::
PutTimeDependBackGroundInfo( UInt4 _outerPixelId ){
    std::vector<Double>* ret = NULL;
    std::vector< std::vector<Double>* >* BGL = _wirInfo->PutTimeDependBackGroundList();
    if (BGL==NULL){
        //std::cout << "UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo BGL==NULL"<< std::endl;;
        return ret;
    }
    if (BGL->empty()){
        //std::cout << "UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo BGL is empty."<< std::endl;;
        return ret;
    }
    if (_outerPixelId>=BGL->size()){
        //std::cout << "UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo outerPixelId is over"<< std::endl;;
        return ret;
    }
    if (BGL->at(_outerPixelId)!=NULL)
        if (BGL->at(_outerPixelId)->at(0)==0.0) return ret;
        if ((BGL->at(_outerPixelId)->at(1)>=0.0)&&(BGL->at(_outerPixelId)->at(2)>0.0))
            return BGL->at(_outerPixelId);
    //std::cout << "UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo BGL[pixelId]==NULL"<< std::endl;;
    return ret;
}
//<--[inamura 160809]

//////////////////////////////////////////////////////////
bool UtsusemiNeunetEventDecoderBase::
PutDetIdPixNoFromEvent(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *detId, UInt4 *pixNo, UInt4 ThNum ){

    // if given event is neutron event;
    if (*data == _HeaderNeutronEvent){
        if (_prevT0Event[_EventSize*ThNum+0]!=0x00){
            moduleNo = (UInt4)(*(_prevT0Event+(_EventSize*ThNum)+2));
            UInt4 det_num = (UInt4)( (*(data+4))&0x7 );
            // decode neutron event of NeuNET
            UInt4 k = (UInt4)( *(data+6) )/16;
            UInt4 ph_l = (UInt4)( *(data+5) ) * 16 +  k ;
            UInt4 ph_r = (UInt4)( *(data+7) )
                + 256 * ( (UInt4( *(data+6) ) )-(k*16) );

            std::vector<Int4> *pixel_info = NULL;
            try{
                if (det_num>=(_wirInfo->PixelInfoStore->at(daqId)->at(moduleNo)->size())) return false;
                pixel_info = _wirInfo->PixelInfoStore->at(daqId)->at(moduleNo)->at(det_num);
            }catch(...){
                return false;
            }
            Int4 det_id = pixel_info->at(1);
            if (det_id>=0){
                std::vector<Double>* abc = _wirInfo->PsdParamsList->at( det_id );
                if (abc!=NULL){
                    if ( ((ph_l+ph_r)>=(UInt4)(abc->at(3))) && ((ph_l+ph_r)<=(UInt4)(abc->at(4))) ){
                        Double pixel_posi = (abc->at(0)) * (Double)ph_r / ( (Double)ph_l + (abc->at(1))*(Double)ph_r ) - (abc->at(2));
                        if (pixel_posi>=0){
                            std::vector<Double> *bininfo = _wirInfo->PsdBinInfoList[det_id];
                            Int4 pixel = (Int4)pixel_posi;
                            if (bininfo==NULL) UtsusemiWarning(_MessageTag+" bininfo is NULL at det_id="+_st->UInt4ToString(det_id));
                            if ( (bininfo->at(1))!=0.0 )
                                pixel = (Int4)( (pixel_posi - (bininfo->at(2))) / (bininfo->at(1)) );
                            if ((pixel>=0) && (pixel<=((pixel_info->at(3))-1))){
                                *pixNo=(UInt4)pixel;
                                *detId=(UInt4)det_id;
                                return true;
                            }else{
                                //std::cout << "pixel="<<pixel<<", pixel_info[3]="<< (pixel_info->at(3))-1<<std::endl;
                            }
                        }
                    }
                }
            }
        }
    }
    return false;
}
//////////////////////////////////////////////////////////
UInt4 UtsusemiNeunetEventDecoderBase::
PutNumOfPixelForDet(UInt4 _detId){
    return _wirInfo->PutNumOfPixelForDet(_detId);
}
//////////////////////////////////////////////////////////
Double UtsusemiNeunetEventDecoderBase::
PutL1(){
    return _detInfo->PutInstL1();
}
//////////////////////////////////////////////////////////
Double UtsusemiNeunetEventDecoderBase::
PutTypicalL2(){
    return _detInfo->PutInstTypicalL2();
}
//////////////////////////////////////////////////////////
Double UtsusemiNeunetEventDecoderBase::
PutTypicalDS(){
    return _detInfo->PutInstTypicalDS();
}
//////////////////////////////////////////////////////////
std::vector<Double> UtsusemiNeunetEventDecoderBase::
PutTypicalPixelSize(UInt4 _detId){
    std::vector<Double> ret;
    std::vector<Double> pv = _detInfo->PutPositionInfoParams(_detId);
    if ((pv.empty())&&(_detId==0)&&(_detInfo->PosiInfo!=NULL)){
        for (UInt4 i=0; i<_detInfo->PosiInfo->position_list.size(); i++){
            pv = _detInfo->PutPositionInfoParams(i);
            if (!(pv.empty())) break;
        }
    }
    if (pv.empty()) return ret;

    UInt4 numOfPixel = PutNumOfPixelForDet();
    ret.clear();
    ret.resize(3,0.0);
    ret[0] = sqrt( pv[3]*pv[3] + pv[4]*pv[4] + pv[5]*pv[5] )/(Double)numOfPixel;
    ret[1] = pv[7];
    ret[2] = pv[7];
    return ret;
}
//////////////////////////////////////////////////////////
void UtsusemiNeunetEventDecoderBase::
SetSimpleMode( bool _isSimple ){
    _isUsedModuleNoInEvent= (!_isSimple);
    _wirInfo->IgnoredXml( _isSimple );
}
