#ifndef UTSUSEMIGETRPMTHISTOGRAM
#define UTSUSEMIGETRPMTHISTOGRAM

/* Header.hh should be included on the top to avoid environments
 * specific issues (see Header.hh for the detail).
 */
#include "UtsusemiHeader.hh"

#include  <boost/filesystem.hpp>
#include "StringTools.hh"
#include "UtsusemiAnaEnvironReader.hh"
#include "UtsusemiGetHistogramTemplate.hh"
#include "UtsusemiTofOriginCorrection.hh"
#include "UtsusemiWiringInfoEditorBase.hh"
#include "UtsusemiDetectorInfoEditorBase.hh"
#include "UtsusemiEventDataConverterRPMT.hh"

////////////////////////////////////
// UtsusemiGetRPMTHistogram
///////////////////////////////////

//! Creates Histogram from Neunet event data
/*!
 *   - read WiringInfo
 *   - Set runNo and read suitable WiringInfo
 *   - Set Histgram conversion parameter
 *   - Set many parameters for the condition of histogram
 *   - rewrite WiringInfo by given parameters
 *   - create histogram from rewritten WiringInfo and DetectorInfo
 *
 */

class UtsusemiGetRPMTHistogram:
    public UtsusemiGetHistogramTemplate<UtsusemiWiringInfoEditorBase,UtsusemiDetectorInfoEditorBase>
{
private:
    void Initialize();

    std::string _MessageTag;

protected:

public:
    UtsusemiGetRPMTHistogram();
        //!< Constructor
        /*!<
         */
    ~UtsusemiGetRPMTHistogram();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    virtual bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath="/data", std::string t0dataPath="" );
    virtual bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, std::string dataPath="/data", std::string t0dataPath="" );
        //!< sets Histogram into ElementContainerMatrix using saved temporal wiring info file
        /*!<     bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath="/data", std::string t0dataPath="" )
         *       bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, bool withPH=false, std::string dataPath="/data", std::string t0dataPath="" )
         *
         *   @param ecm        (ElementContainerMatrix*) data container for histogram
         *   @param dataPath   (std::string) top path of event data ("/data")
         *   @param t0dataPath (std::string) path of T0Index event data ("")
         *   @retval true    : succeeded
         *   @retval false   : failed
         */

};
#endif
