#include "UtsusemiGetNeunetHistogram.hh"

//////////////////////////////////////////////////////////
UtsusemiGetNeunetHistogram::UtsusemiGetNeunetHistogram(){
    Initialize();
}
//////////////////////////////////////////////////////////
UtsusemiGetNeunetHistogram::~UtsusemiGetNeunetHistogram(){
    if (_EDC!=NULL) delete _EDC;
    if (_EDCPH!=NULL) delete _EDCPH;
}
//////////////////////////////////////////////////////////
void UtsusemiGetNeunetHistogram::Initialize(){
    //    UtsusemiGetHistogramTemplate<UtsusemiWiringInfoEditorNeunet,UtsusemiDetectorInfoEditorBase>::Initialize();

    _MessageTag="UtsusemiGetNeunetHistogram >> ";
    _EDC = NULL;
    _EDCPH = NULL;
    _isCheckPulseId=true;
    _isAddTofBin=false;
}
//////////////////////////////////////////////////////////
/*
bool UtsusemiGetNeunetHistogram::
SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath, std::string t0dataPath ){
    std::vector<std::string> pfiles = MakeTempInfoFiles();
    if ( pfiles[0]=="" ){
        UtsusemiError(_MessageTag+"SetElementContainerMatrix >> Not found file = "+pfiles[0]);
        return false;
    }else if (pfiles[1]==""){
        UtsusemiError(_MessageTag+"SetElementContainerMatrix >> Not found file = "+pfiles[1]);
        return false;
    }else{
        return SetElementContainerMatrix( ecm, _runNos, pfiles[0], pfiles[1], _withPH, dataPath, t0dataPath );
    }
}
*/
//////////////////////////////////////////////////////////
bool UtsusemiGetNeunetHistogram::
SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, bool withPH, std::string dataPath, std::string t0dataPath ){
    if (withPH){
        if (_EDCPH==NULL) _EDCPH = new UtsusemiEventDataConverterNeunetWithPH();
        if (_EDCPH->LoadParamFiles( wfile, dfile )){
            _EDCPH->SetHistAllocation();
            if ( (_TimeRangeSec.first!=-1.0)||(_TimeRangeSec.second!=-1.0) ){
                if (_EDCPH->SetRangeOfSingleTimeSlicing( _TimeRangeSec.first, _TimeRangeSec.second )){
                }else{
                    UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                    delete _EDCPH;
                    _EDCPH=NULL;
                    return false;
                }
            }else if ( (_TimeRangeDateTime.first!="")||(_TimeRangeDateTime.second!="") ){
                if (_EDCPH->SetRangeOfSingleTimeSlicing( _TimeRangeDateTime.first, _TimeRangeDateTime.second )){
                }else{
                    UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                    delete _EDCPH;
                    _EDCPH = NULL;
                    return false;
                }
            }else{
            }
            if (_isLoadFileOfTimeDependBackGround)
                _EDCPH->ReadTimeDependBackGroundListFromFile( _pathFileOfTimeDependBackGround );

            Int4 ret = _EDCPH->SetElementContainerMatrix( ecm, runNos, dataPath, t0dataPath );
            if (ret!=0){
                delete _EDCPH;
                _EDCPH=NULL;
                return false;
            }
            if (_isAddTofBin) _EDCPH->SetHistBin(ecm, UTSUSEMI_KEY_TOF);

            if ((_isLoadFileOfTimeDependBackGround==false)&&(_pathFileOfTimeDependBackGround!=""))
                _EDCPH->SaveTimeDependBackGroundListToFile( _pathFileOfTimeDependBackGround );
        }
    }else{
        if (_EDC==NULL) _EDC = new UtsusemiEventDataConverterNeunet();
        if (_EDC->LoadParamFiles( wfile, dfile )){
            if (_tofOriginShiftByLambda_type != -1){
                if (_tofOriginShiftByLambda_type==0){
                }else{
                    if (_tofOriginShiftByLambda_params.empty())
                        if (_EDC->SetTofOriginShift( _tofOriginShiftByLambda_type )){
                        }else{
                            UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                            delete _EDC;
                            _EDC=NULL;
                            return false;
                        }
                    else
                        if (_EDC->SetTofOriginShift( _tofOriginShiftByLambda_type, _tofOriginShiftByLambda_params )){
                        }else{
                            UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                            delete _EDC;
                            _EDC=NULL;
                            return false;
                        }
                }
            }

            _EDC->SetHistAllocation();

            if ( (_TimeRangeSec.first!=-1.0)||(_TimeRangeSec.second!=-1.0) ){
                if (_EDC->SetRangeOfSingleTimeSlicing( _TimeRangeSec.first, _TimeRangeSec.second )){
                }else{
                    UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                    delete _EDC;
                    _EDC=NULL;
                    return false;
                }
            }else if ( (_TimeRangeDateTime.first!="")||(_TimeRangeDateTime.second!="") ){
                if (_EDC->SetRangeOfSingleTimeSlicing( _TimeRangeDateTime.first, _TimeRangeDateTime.second )){
                }else{
                    UtsusemiError(_MessageTag+"SetElementContainerMatrix >> TimeRange is invalid ");
                    delete _EDC;
                    _EDC=NULL;
                    return false;
                }
            }else{
            }
            if (_isLoadFileOfTimeDependBackGround)
                _EDC->ReadTimeDependBackGroundListFromFile( _pathFileOfTimeDependBackGround );

            Int4 ret = _EDC->SetElementContainerMatrix( ecm, runNos, dataPath, t0dataPath );
            if (ret!=0){
                delete _EDC;
                _EDC=NULL;
                return false;
            }
            if (_isAddTofBin) _EDC->SetHistBin(ecm, UTSUSEMI_KEY_TOF);

            if ((_isLoadFileOfTimeDependBackGround==false)&&(_pathFileOfTimeDependBackGround!=""))
                _EDC->SaveTimeDependBackGroundListToFile( _pathFileOfTimeDependBackGround );
        }
    }

    //[inamura 160830]-->
    if (this->_SetMask( ecm )){
    }else{
        return false;
    };
    //<--[inamura 160830]

    // Calclation of Polar and Azimuth angles
    UtsusemiReductionCommon UR( ecm );
    UR.CalcPhi();

    return true;
}
//////////////////////////////////////////////////////////
bool UtsusemiGetNeunetHistogram::
LoadEventDataFiles( std::string dataPath, std::string t0dataPath ){
    std::vector<std::string> pfiles = MakeTempInfoFiles();
    if ( pfiles[0]=="" ){
        UtsusemiError(_MessageTag+"LoadEventDataFiles >> Not found file = "+pfiles[0]);
        return false;
    }else if (pfiles[1]==""){
        UtsusemiError(_MessageTag+"LoadEventDataFiles >> Not found file = "+pfiles[1]);
        return false;
    }
    std::string wfile = pfiles[0];
    std::string dfile = pfiles[1];

    bool isOk = false;
    if (_withPH){
        if (_EDCPH!=NULL) delete _EDCPH;
        _EDCPH = new UtsusemiEventDataConverterNeunetWithPH();
        if ( (_TimeRangeSec.first!=-1.0)||(_TimeRangeSec.second!=-1.0) ){
            _EDCPH->SetRangeOfSingleTimeSlicing( _TimeRangeSec.first, _TimeRangeSec.second );
        }else if ( (_TimeRangeDateTime.first!="")||(_TimeRangeDateTime.second!="") ){
            _EDCPH->SetRangeOfSingleTimeSlicing( _TimeRangeDateTime.first, _TimeRangeDateTime.second );
        }else if (!_TimeSlicingList.empty()){
            _EDCPH->SetTimeSlicing( _TimeSlicingList );
        }
        if (_EDCPH->LoadParamFiles( wfile, dfile, _CaseInfoFilePath )){
            if (_CaseInfoFilePath!=""){
                _EDCPH->SetFlagOfPulseIdCheck(_isCheckPulseId);
                _EDCPH->LoadTrignetEventFile( _runNos[0], dataPath, t0dataPath );
            }else if (!_TimeSlicingList.empty()){
                _EDCPH->LoadTrignetEventFile( _runNos[0], dataPath, t0dataPath );
            }
            _EDCPH->SetHistAllocation();
            if (_isLoadFileOfTimeDependBackGround)
                _EDCPH->ReadTimeDependBackGroundListFromFile( _pathFileOfTimeDependBackGround );
            if (_EDCPH->LoadEventDataFiles( _runNos, dataPath, t0dataPath)==0) isOk = true;
            else{
                UtsusemiError(_MessageTag+"LoadEventDataFiles >> Failed to load eventdata files ");
            }
        }
        if (!isOk){
            delete _EDCPH;
            _EDCPH = NULL;
        }
    }else{
        if (_EDC!=NULL) delete _EDC;
        _EDC = new UtsusemiEventDataConverterNeunet();
        if ( (_TimeRangeSec.first!=-1.0)||(_TimeRangeSec.second!=-1.0) ){
            _EDC->SetRangeOfSingleTimeSlicing( _TimeRangeSec.first, _TimeRangeSec.second );
        }else if ( (_TimeRangeDateTime.first!="")||(_TimeRangeDateTime.second!="") ){
            _EDC->SetRangeOfSingleTimeSlicing( _TimeRangeDateTime.first, _TimeRangeDateTime.second );
        }else if (!_TimeSlicingList.empty()){
            _EDC->SetTimeSlicing( _TimeSlicingList );
        }
        if (_EDC->LoadParamFiles( wfile, dfile, _CaseInfoFilePath )){

            if (_CaseInfoFilePath!=""){
                _EDC->SetFlagOfPulseIdCheck(_isCheckPulseId);
                _EDC->LoadTrignetEventFile( _runNos[0], dataPath, t0dataPath );
            }else if (!_TimeSlicingList.empty()){
                _EDC->LoadTrignetEventFile( _runNos[0], dataPath, t0dataPath );
            }

            _EDC->SetHistAllocation();
            if (_isLoadFileOfTimeDependBackGround)
                _EDC->ReadTimeDependBackGroundListFromFile( _pathFileOfTimeDependBackGround );
            if (_EDC->LoadEventDataFiles( _runNos, dataPath, t0dataPath)==0) isOk = true;
            else{
                UtsusemiError(_MessageTag+"LoadEventDataFiles >> Failed to load eventdata files ");
            }
        }
        if (!isOk){
            delete _EDC;
            _EDC = NULL;
        }
    }
    return isOk;
}
//////////////////////////////////////////////////////////
bool UtsusemiGetNeunetHistogram::
SetElementContainerMatrix( ElementContainerMatrix *ecm, UInt4 caseId ){
    if (_withPH){
        if (_EDCPH==NULL){
            UtsusemiError(_MessageTag+"SetElementContainerMatrix( ecm, caseId ) >> LoadEventDataFiles is required." );
            return false;
        }else{
            Int4 ret = _EDCPH->SetElementContainerMatrix( ecm, caseId );
            if (_isAddTofBin) _EDCPH->SetHistBin(ecm, UTSUSEMI_KEY_TOF);
            if (ret!=0) return false;
            if ((_isLoadFileOfTimeDependBackGround==false)&&(_pathFileOfTimeDependBackGround!=""))
                _EDCPH->SaveTimeDependBackGroundListToFile( _pathFileOfTimeDependBackGround );
        }
    }else{
        if (_EDC==NULL){
            UtsusemiError(_MessageTag+"SetElementContainerMatrix( ecm, caseId ) >> LoadEventDataFiles is required." );
            return false;
        }else{
            Int4 ret = _EDC->SetElementContainerMatrix( ecm, caseId );
            if (_isAddTofBin) _EDC->SetHistBin(ecm, UTSUSEMI_KEY_TOF);
            if (ret!=0) return false;
            if ((_isLoadFileOfTimeDependBackGround==false)&&(_pathFileOfTimeDependBackGround!=""))
                _EDC->SaveTimeDependBackGroundListToFile( _pathFileOfTimeDependBackGround );
        }
    }

    if (this->_SetMask( ecm )){
    }else{
        return false;
    }

    // Calclation of Polar and Azimuth angles
    UtsusemiReductionCommon UR( ecm );
    UR.CalcPhi();

    return true;
}
//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiGetNeunetHistogram::
PutListOfCases(){
    std::vector<UInt4> ret_error;
    if (_withPH){
        if (_EDCPH==NULL){
            UtsusemiError(_MessageTag+"SetElementContainerMatrix( ecm, caseId ) >> LoadEventDataFiles is required." );
            return ret_error;
        }else{
            return _EDCPH->PutListOfCases();
        }
    }else{
        if (_EDC==NULL){
            UtsusemiError(_MessageTag+"SetElementContainerMatrix( ecm, caseId ) >> LoadEventDataFiles is required." );
            return ret_error;
        }else{
            return _EDC->PutListOfCases();
        }
    }
}
//////////////////////////////////////////////////////////
void UtsusemiGetNeunetHistogram::
SetFlagOfPulseIdCheck( bool flag ){
    _isCheckPulseId=flag;
}
//////////////////////////////////////////////////////////
void UtsusemiGetNeunetHistogram::
SetFlagToAddTofBin( bool flag ){
    _isAddTofBin = flag;
}
