#include "UtsusemiDetectorEfficiencyCorrection.hh"
//////////////////////////////////////////////////////////////////////////
UtsusemiDetectorEfficiencyCorrection::
UtsusemiDetectorEfficiencyCorrection(){
    _MessageTag = "UtsusemiDetectorEfficiencyCorrection::";
}
//////////////////////////////////////////////////////////////////////////
UtsusemiDetectorEfficiencyCorrection::
UtsusemiDetectorEfficiencyCorrection( std::string _detInfo, std::string _detName ){
    _MessageTag = "UtsusemiDetectorEfficiencyCorrection::";
    Initialize( _detInfo, _detName );
}
//////////////////////////////////////////////////////////////////////////
UtsusemiDetectorEfficiencyCorrection::
UtsusemiDetectorEfficiencyCorrection( UInt4 _runNo, std::string _detName, UInt4 _modeNo ){
    _MessageTag = "UtsusemiDetectorEfficiencyCorrection::";
    Initialize( _runNo, _detName, _modeNo );
}
//////////////////////////////////////////////////////////////////////////
UtsusemiDetectorEfficiencyCorrection::
UtsusemiDetectorEfficiencyCorrection( std::string _datFile ){
    _MessageTag = "UtsusemiDetectorEfficiencyCorrection::";
    LoadDataFile( _datFile );
}
//////////////////////////////////////////////////////////////////////////
UtsusemiDetectorEfficiencyCorrection::
~UtsusemiDetectorEfficiencyCorrection(){
}
//////////////////////////////////////////////////////////////////////////
bool UtsusemiDetectorEfficiencyCorrection::
Initialize( std::string _detInfo, std::string _detName ){

    // Make file search paths
    // /opt/mlfsoft/python-utsusemi/ana/xml
    std::string utsusemi_base_path=UtsusemiEnvGetBaseDir();
    std::string utsusemi_user_path=UtsusemiEnvGetInstDir();
    if (utsusemi_user_path=="")
        utsusemi_user_path=UtsusemiEnvGetUserDir();

    if (utsusemi_user_path!=""){
        char utsusemi_usr_xml_path_c[200];
        std::snprintf( utsusemi_usr_xml_path_c, sizeof(utsusemi_usr_xml_path_c),  "%s/%s", utsusemi_user_path.c_str(), UTSUSEMIUSERPRIVXMLFILEPATH.c_str());
        std::string tmp( utsusemi_usr_xml_path_c );
        std::vector<std::string> xml_search_paths;
        xml_search_paths.push_back( tmp );
        if (utsusemi_base_path!="") {
            char tmp1_c[200];
            std::snprintf( tmp1_c, sizeof(tmp1_c), "%s/%s", utsusemi_base_path.c_str(), UTSUSEMIUSERPRIVXMLFILEPATH.c_str());
            std::string tmp1( tmp1_c );
            xml_search_paths.push_back( tmp1 );
        }
        this->SetXmlPath( xml_search_paths );
    }else{
        UtsusemiWarning( _MessageTag+"Initialize > can not get Utsusemi environment variables " );
    }
    return MlfDetectorEfficiencyCorrection::Initialize( _detInfo, _detName );

}
//////////////////////////////////////////////////////////////////////////
bool UtsusemiDetectorEfficiencyCorrection::
Initialize( UInt4 _runNo, std::string _detName, UInt4 _modeNo ){
    std::string msg = _MessageTag+"::Initialize with RunNo : ";
    StringTools st;
    UtsusemiAnaEnvironReader *UAR = new UtsusemiAnaEnvironReader( _runNo, true );
    if (UAR->_Status){
        std::vector<std::string> pfiles = UAR->PutParamFiles( _runNo, _modeNo,true );
        if (!(pfiles.empty())){
            delete UAR;
            return Initialize( pfiles[1], _detName );
        }else{
            msg += "Filed to find param files from runNo="+st.UInt4ToString( _runNo )+" and mode No="+st.UInt4ToString( _modeNo );
        }
    }else{
        msg += "Failed to find environ_ana.xml ";
    }
    UtsusemiError(msg);
    delete UAR;
    return false;
}
//////////////////////////////////////////////////////////////////////////
bool UtsusemiDetectorEfficiencyCorrection::
LoadDataFile( std::string _datFile, std::string additionalPath ){
    std::string full_path = FindParamFilePath( _datFile, additionalPath );
    if (full_path==""){
        return false;
    }
    return MlfDetectorEfficiencyCorrection::LoadApproximateData( full_path );

}
