#ifndef NXSPEFILEIO
#define NXSPEFILEIO

#include "UtsusemiHeader.hh"
#include "WriteNeXusFile.hh"
#include "ReadNeXusFile.hh"

//////////////////////////////////
// NxspeFileIO
/////////////////////////////////

//! Tools for treating T0 event in eventdata
/*!
 *
 *
 *
 *
 */

class NxspeFileIO
{
private:

protected:
    void _Initialize();
    Double _fixed_energy;
    bool _kikf;
    Double _orientationAngle;
    std::string _instCode;
    Double _sampleTemperature;

    std::vector<Double> _param_AzimuthAng_list;
    std::vector<Double> _param_AzimuthAngWidth_list;
    std::vector<Double> _param_PolarAng_list;
    std::vector<Double> _param_PolarAngWidth_list;
    std::vector<Double> _param_L2_list;
    std::vector<Double> _param_Energy_list;
    std::vector< std::vector<Double> > _intensity;
    std::vector< std::vector<Double> > _error;
    ElementContainerMatrix *_ecm;
    bool _ImportData(ElementContainerMatrix* ecm);
    bool _ExportData(ElementContainerMatrix* ecm);
    std::vector<Double> _reducePrec(std::vector<Double>);
    bool _isReduce;
    UInt4 _pixelNo_per_det;
    std::string _MessageTag;
    bool _Status;
public:
    NxspeFileIO(bool isReduce=false);
        //!< Constructor
        /*!<
         *   @param isReduce (bool) true..reduce the precision of intensity/error from 64bit(double) to 32bit(float)
         */
    ~NxspeFileIO();
        //!< Destructor
        /*!<
         */
    bool _Stetus;
    bool SetData( ElementContainerMatrix* ECM, Double angle=0.0, Double temperature=300.0 );
        //!< Sets ElementContainerMatrix to be saved as nxspe.
        /*!<
         *   @param ECM (ElementContainerMatrxi*) The data to be saved.
         *   @param angle (Double) The angle value required by nxspe form.
         *   @param temperature (Double) The temperature value required by nxspe form.
         *   @retval true
         *   @retval false
         */
    void SetSampleInfo( Double angle, Double temperature );
        //!< Sets sample information required by nxspe form.
        /*!<
         *   @param angle (Double) The angle value required by nxspe form.
         *   @param temperature (Double) The temperature value required by nxspe form.
         *   @retval None
         */
    bool Save( std::string filepath, std::string username="MLFuser", UInt4 compMode=1 );
        //!< Save as nxspe.
        /*!<
         *   @param filepath (std::string) File path.
         *   @param username (std::string) The username parameter required by nxspe.
         *   @param compMode (UInt4)  0..no compressed, 1..complessed on WriteNeXusFile
         *   @retval true
         *   @retval false
         */
    bool Read( ElementContainerMatrix* ECM, std::string filepath, UInt4 pixelNo=100 );
        //!< Read nxspe file.
        /*!<
         *   @param ECM (ElementContainerMatrix) Empty container to be imported.
         *   @param filepath (std::string) File path.
         *   @param pixelNo (UInt) The number of pixels in a group as PSD.
         *   @retval true
         *   @retval false
         */
    void Test();

};

#endif
