// File: classAnaEnvironPeriodInfo.xml

%feature("docstring") AnaEnvironPeriodInfo "C++ includes: UtsusemiAnaEnvironReader.hh 

";
%feature("docstring") AnaEnvironPeriodInfo::AnaEnvironPeriodInfo "AnaEnvironPeriodInfo::AnaEnvironPeriodInfo() AnaEnvironPeriodInfo::AnaEnvironPeriodInfo

    
AnaEnvironPeriodInfo::AnaEnvironPeriodInfo(const AnaEnvironPeriodInfo &obj) AnaEnvironPeriodInfo::AnaEnvironPeriodInfo
";
%feature("docstring") AnaEnvironPeriodInfo::~AnaEnvironPeriodInfo "AnaEnvironPeriodInfo::~AnaEnvironPeriodInfo() AnaEnvironPeriodInfo::~AnaEnvironPeriodInfo

";
// File: classCaseInfoReaderBase.xml

%feature("docstring") CaseInfoReaderBase "

    Load CaseInfo.xml.
    This is a base class to make classes to load CaseInfo.xml and store their imformation.
    C++ includes: CaseInfoReaderBase.hh 

";
%feature("docstring") CaseInfoReaderBase::CaseInfoReaderBase "CaseInfoReaderBase::CaseInfoReaderBase() CaseInfoReaderBase::CaseInfoReaderBase Constructor. 

    
CaseInfoReaderBase::CaseInfoReaderBase(std::string filename) CaseInfoReaderBase::CaseInfoReaderBase Constructor.
=================================================================================================================

    Args:
        filename (std::string) the file name of CaseInfo to parse

    Returns:
        None 
";
%feature("docstring") CaseInfoReaderBase::~CaseInfoReaderBase "CaseInfoReaderBase::~CaseInfoReaderBase() CaseInfoReaderBase::~CaseInfoReaderBase Destructor. 

";
%feature("docstring") CaseInfoReaderBase::ReadFile "bool CaseInfoReaderBase::ReadFile(std::string filename) CaseInfoReaderBase::ReadFile Read CaseInfo xml file to parse xml.
==========================================================================================================================

    Args:
        filename (std::string) the file name

    Returns:
        true
        false 

";
%feature("docstring") CaseInfoReaderBase::Clear "void CaseInfoReaderBase::Clear() CaseInfoReaderBase::Clear Clear xml information.
==================================================================================

    Args:
        None

    Returns:
        None
        None 

";
%feature("docstring") CaseInfoReaderBase::ImportCaseInfo "bool CaseInfoReaderBase::ImportCaseInfo(std::string filename=\"\") CaseInfoReaderBase::ImportCaseInfo Analyze CaseInfo.
========================================================================================================================

    Args:
        filename (std::string) The file name to be analyzed. If empty, use the parsed information.

    Returns:
        true
        false 

";
%feature("docstring") CaseInfoReaderBase::SetTimeSlicing "void CaseInfoReaderBase::SetTimeSlicing(std::vector< Double > tmp) CaseInfoReaderBase::SetTimeSlicing Set the time slice information directly.
===============================================================================================================================================
    tmp[(<caseId> - 1) * 2] : lower side of time range @caseId tmp[(<caseId> - 1) * 2 + 1] : upper side of time range @caseId

    Args:
        tmp (std::vector<Double>) CaseId and list of time range

    Returns:
        None 

";
// File: classD4MatGroup.xml

%feature("docstring") D4MatGroup "C++ includes: UtsusemiD4Matrix2.hh 

";
%feature("docstring") D4MatGroup::D4MatGroup "D4MatGroup::D4MatGroup() D4MatGroup::D4MatGroup

    
D4MatGroup::D4MatGroup(HeaderBase *hh) D4MatGroup::D4MatGroup
";
%feature("docstring") D4MatGroup::~D4MatGroup "D4MatGroup::~D4MatGroup() D4MatGroup::~D4MatGroup

";
%feature("docstring") D4MatGroup::PutHeaderPointer "HeaderBase * D4MatGroup::PutHeaderPointer() D4MatGroup::PutHeaderPointer

";
%feature("docstring") D4MatGroup::PutPointer "D4MatOne * D4MatGroup::PutPointer(UInt4 i) D4MatGroup::PutPointer

";
%feature("docstring") D4MatGroup::PutSize "UInt4 D4MatGroup::PutSize() D4MatGroup::PutSize

";
%feature("docstring") D4MatGroup::Save "bool D4MatGroup::Save(std::string filepath, bool withComp=false) D4MatGroup::Save

";
%feature("docstring") D4MatGroup::Load "bool D4MatGroup::Load(std::string filepath) D4MatGroup::Load

";
%feature("docstring") D4MatGroup::DumpSqeAsText "bool D4MatGroup::DumpSqeAsText(std::string filepath) D4MatGroup::DumpSqeAsText

";
// File: classD4MatOne.xml

%feature("docstring") D4MatOne "C++ includes: UtsusemiD4Matrix2.hh 

";
%feature("docstring") D4MatOne::D4MatOne "D4MatOne::D4MatOne() D4MatOne::D4MatOne

    
D4MatOne::D4MatOne(const D4MatOne &p) D4MatOne::D4MatOne
";
%feature("docstring") D4MatOne::~D4MatOne "D4MatOne::~D4MatOne() D4MatOne::~D4MatOne

";
%feature("docstring") D4MatOne::PutHeaderPointer "HeaderBase * D4MatOne::PutHeaderPointer() D4MatOne::PutHeaderPointer

";
%feature("docstring") D4MatOne::Save "bool D4MatOne::Save(std::string filepath) D4MatOne::Save

    
bool D4MatOne::Save(std::ofstream &ofs) D4MatOne::Save
";
%feature("docstring") D4MatOne::Savez "bool D4MatOne::Savez(std::ofstream &ofs) D4MatOne::Savez

";
%feature("docstring") D4MatOne::Load "bool D4MatOne::Load(std::ifstream &ifs) D4MatOne::Load

";
%feature("docstring") D4MatOne::DumpSqeAsText "bool D4MatOne::DumpSqeAsText(std::string filepath) D4MatOne::DumpSqeAsText

    
bool D4MatOne::DumpSqeAsText(FILE *fp) D4MatOne::DumpSqeAsText
";
// File: classD4MatrixCalc.xml

%feature("docstring") D4MatrixCalc "

    Class for calculation between D4Matrix.
    C++ includes: D4MatrixCalc.hh 

";
%feature("docstring") D4MatrixCalc::D4MatrixCalc "D4MatrixCalc::D4MatrixCalc() D4MatrixCalc::D4MatrixCalc Constructor. 

";
%feature("docstring") D4MatrixCalc::~D4MatrixCalc "D4MatrixCalc::~D4MatrixCalc() D4MatrixCalc::~D4MatrixCalc Destructor. 

";
%feature("docstring") D4MatrixCalc::OpenMat1 "void D4MatrixCalc::OpenMat1(std::string datapath, std::string paramfile) D4MatrixCalc::OpenMat1 Opens the first D4Mat data file.
=================================================================================================================================

    Args:
        datapath (std::string) the path to the folder in which D4Mat data files are placed.
        paramfile (std::string) the file name of the parameter xml file of target D4Mat data

    Returns:
        None 

";
%feature("docstring") D4MatrixCalc::OpenMat2 "void D4MatrixCalc::OpenMat2(std::string datapath, std::string paramfile) D4MatrixCalc::OpenMat2 Opens the second D4Mat data file.
==================================================================================================================================

    Args:
        datapath (std::string) the path to the folder in which D4Mat data files are placed.
        paramfile (std::string) the file name of the parameter xml file of target D4Mat data

    Returns:
        None 

";
%feature("docstring") D4MatrixCalc::CalcBetweenTwo "void D4MatrixCalc::CalcBetweenTwo(std::string ope, std::string outpath, std::string outparamfile) D4MatrixCalc::CalcBetweenTwo Calculates between two D4Mat data opened by OpenMat1 and OpenMat2 with given operator.
======================================================================================================================================================================================================================

    Args:
        ope (std::string) the operator for the calculation \"+\", \"-\", \"*\" or \"-\"
        outpath (std::string) the path to the directory to save calculated D4Mat data
        outparamfile (std::string) the file name of the parameter xml file to be saved.

    Returns:
        None 

    
void D4MatrixCalc::CalcBetweenTwo(std::string ope, Double coef1, Double coef2, std::string outpath, std::string outparamfile) D4MatrixCalc::CalcBetweenTwo Calculates between two D4Mat data opened by OpenMat1 and OpenMat2 with given operator and coeficiencies.
====================================================================================================================================================================================================================================================================
    calculate between <coef1> * D4Mat1 and <coef2> * D4Mat2.

    Args:
        ope (std::string) the operator for the calculation \"+\", \"-\", \"*\" or \"-\"
        coef1 (double) the coeficiency to the first D4Mat data
        coef2 (double) the coeficiency to the second D4Mat data
        outpath (std::string) the path to the directory to save calculated D4Mat data
        outparamfile (std::string) the file name of the parameter xml file to be saved.

    Returns:
        None 
";
// File: classDetectorInfoEditorBase.xml

%feature("docstring") DetectorInfoEditorBase "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") DetectorInfoEditorBase::DetectorInfoEditorBase "DetectorInfoEditorBase::DetectorInfoEditorBase() DetectorInfoEditorBase::DetectorInfoEditorBase Constructor. 

    
DetectorInfoEditorBase::DetectorInfoEditorBase(std::string dfile, bool workAsReader=true) DetectorInfoEditorBase::DetectorInfoEditorBase Constructor.
======================================================================================================================================================

    Args:
        dfile (std::string) DetectorInfo file path to be read
        workAsReader (bool) 
";
%feature("docstring") DetectorInfoEditorBase::~DetectorInfoEditorBase "DetectorInfoEditorBase::~DetectorInfoEditorBase() DetectorInfoEditorBase::~DetectorInfoEditorBase Destructor. 

";
%feature("docstring") DetectorInfoEditorBase::Clear "void DetectorInfoEditorBase::Clear(UInt4 index=0) DetectorInfoEditorBase::Clear Clears stored parameters.
==========================================================================================================
    This deletes information by given index. index = 0 : all (default) index = 1 : InstrumentInfo index = 2 : TfpInfo index = 3 : TfpCalcParams index = 4 : PositionInfo index = 5 : BankInfo

    Args:
        index (UInt4)

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::Read "bool DetectorInfoEditorBase::Read(std::string arg) DetectorInfoEditorBase::Read Reads DetectorInfo.xml and import information.
===============================================================================================================================

    Args:
        arg (std::string) path/to/DetectorInfo.xml or DetectorInfo std::string

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::Write "bool DetectorInfoEditorBase::Write(std::string filepath) DetectorInfoEditorBase::Write Writes DetectorInfo.xml.
================================================================================================================

    Args:
        filepath (std::string)

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::OutXml "std::string DetectorInfoEditorBase::OutXml(bool withIndent=false) DetectorInfoEditorBase::OutXml Returns DetectorInfo as std::string.
======================================================================================================================================

    Args:
        withIndent(bool) false : output text without an indent format

    Returns:
        std::string 

";
%feature("docstring") DetectorInfoEditorBase::ImportInstInfo "void DetectorInfoEditorBase::ImportInstInfo() DetectorInfoEditorBase::ImportInstInfo Import \"instrumentInfo\" from DetectorInfo.xml.
======================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::_makeInstInfoXml "void DetectorInfoEditorBase::_makeInstInfoXml() DetectorInfoEditorBase::_makeInstInfoXml make \"instrumentInfo\" xml element
=============================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::ImportTfpInfo "void DetectorInfoEditorBase::ImportTfpInfo() DetectorInfoEditorBase::ImportTfpInfo Import \"tfp\" info from DetectorInfo.xml.
==============================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::_makeTfpInfoXml "void DetectorInfoEditorBase::_makeTfpInfoXml() DetectorInfoEditorBase::_makeTfpInfoXml make \"tfp\" xml element
================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::ImportTfpCalcParams "void DetectorInfoEditorBase::ImportTfpCalcParams() DetectorInfoEditorBase::ImportTfpCalcParams Import \"tfpCalcParams\" from DetectorInfo.xml.
===============================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::_makeTfpCalcParamsXml "void DetectorInfoEditorBase::_makeTfpCalcParamsXml() DetectorInfoEditorBase::_makeTfpCalcParamsXml make \"tfpCalcParams\" xml element
======================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::ImportPosiInfo "void DetectorInfoEditorBase::ImportPosiInfo() DetectorInfoEditorBase::ImportPosiInfo Import \"positionInfo\" from DetectorInfo.xml.
====================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::_makePosiInfoXml "void DetectorInfoEditorBase::_makePosiInfoXml() DetectorInfoEditorBase::_makePosiInfoXml make \"positionInfo\" xml element
===========================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::ImportBankInfo "void DetectorInfoEditorBase::ImportBankInfo() DetectorInfoEditorBase::ImportBankInfo Import \"bankInfo\" from DetectorInfo.xml.
================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::_makeBankInfoXml "void DetectorInfoEditorBase::_makeBankInfoXml() DetectorInfoEditorBase::_makeBankInfoXml make \"bankInfo\" xml element
=======================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::Dump "void DetectorInfoEditorBase::Dump(Int4 index=DUMP_ALL) DetectorInfoEditorBase::Dump Shows imported information.
================================================================================================================

    Args:
        index (Int4)

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::_makeOutputXml "bool DetectorInfoEditorBase::_makeOutputXml() DetectorInfoEditorBase::_makeOutputXml Makes XML format from stored information.
===============================================================================================================================

    Args:
        None

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::SetInstInfoL1 "bool DetectorInfoEditorBase::SetInstInfoL1(Double _L1) DetectorInfoEditorBase::SetInstInfoL1 Set L1 in InstrumentInfo.
=======================================================================================================================

    Args:
        L1 (Double) [mm]

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::SetInstInfoSamplePosition "bool DetectorInfoEditorBase::SetInstInfoSamplePosition(Double _px, Double _py, Double _pz) DetectorInfoEditorBase::SetInstInfoSamplePosition Set SamplePosition in InstrumentInfo.
===================================================================================================================================================================================

    Args:
        _px (Double) [mm]
        _py (Double) [mm]
        _pz (Double) [mm]

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::SetInstInfoTypicalL2 "bool DetectorInfoEditorBase::SetInstInfoTypicalL2(Double _L2) DetectorInfoEditorBase::SetInstInfoTypicalL2 Set the typical L2 in InstrumentInfo.
=================================================================================================================================================
    which is used for the solid-angle correction

    Args:
        _L2 (Double) [mm]

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::SetInstInfoTypicalDS "bool DetectorInfoEditorBase::SetInstInfoTypicalDS(Double _dS) DetectorInfoEditorBase::SetInstInfoTypicalDS Set the typical dS (the area of one pixel) in InstrumentInfo.
=========================================================================================================================================================================
    which is used for the solid-angle correction

    Args:
        _dS (Double) [mm]

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::SetTfpInfo "bool DetectorInfoEditorBase::SetTfpInfo(UInt4 pixId, Double A, Double B) DetectorInfoEditorBase::SetTfpInfo Set Time-focusing parameters (for ENG )
====================================================================================================================================================

    Args:
        pixId (UInt4) pixel-Id
        A (Double) param A
        B (Double) param B

    Returns:
        true succeded
        false failed 

    
bool DetectorInfoEditorBase::SetTfpInfo(std::vector< UInt4 > pixIdList, std::vector< Double > AList, std::vector< Double > BList) DetectorInfoEditorBase::SetTfpInfo Set Time-focusing parameters (for ENG )
=============================================================================================================================================================================================================

    Args:
        pixIdList (std::vector<UInt4>) list of pixId
        AList (std::vector<Double>) list of A
        BList (std::vector<Double>) list of B

    Returns:
        true succeded
        false failed 
";
%feature("docstring") DetectorInfoEditorBase::PutTfpInfo "std::vector< Double > DetectorInfoEditorBase::PutTfpInfo(UInt4 pixId) DetectorInfoEditorBase::PutTfpInfo Put Tfp parameters of given pixId.
============================================================================================================================================

    Args:
        pixId (UInt4) pixel-Id

    Returns:
        std::vector<Double> returned A and B 

";
%feature("docstring") DetectorInfoEditorBase::DeleteTfpInfo "bool DetectorInfoEditorBase::DeleteTfpInfo(UInt4 pixId, bool isForced=false) DetectorInfoEditorBase::DeleteTfpInfo Delete Tfp parameters of given pixId.
=========================================================================================================================================================

    Args:
        pixId (UInt4) pixel-Id
        isForced (bool) execute without warning message

    Returns:
        true succeded
        false failed 

    
bool DetectorInfoEditorBase::DeleteTfpInfo(std::vector< UInt4 > pixIdList, bool isForced=false) DetectorInfoEditorBase::DeleteTfpInfo Delete Tfp parameters of given pixId.
============================================================================================================================================================================

    Args:
        pixIdList (std::vector<UInt4>) list of pixel-Id
        isForced (bool) execute without warning message

    Returns:
        true succeded
        false failed 
";
%feature("docstring") DetectorInfoEditorBase::SetTfpCalcParamsPsdRef "bool DetectorInfoEditorBase::SetTfpCalcParamsPsdRef(Double psd_ref_l2, Double psd_ref_theta) DetectorInfoEditorBase::SetTfpCalcParamsPsdRef Set Time-focusing Calculation Parameters.
======================================================================================================================================================================================

    Args:
        psd_ref_l2 (Double) Reference L2
        psd_ref_theta (Double) Reference Theta

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::SetPositionInfo "bool DetectorInfoEditorBase::SetPositionInfo(UInt4 detId, UInt4 numAxis, std::vector< Double > params) DetectorInfoEditorBase::SetPositionInfo Set Position info parameters.
=============================================================================================================================================================================

    Args:
        detId (UInt4) detector ID
        numAxis (UInt4) the number of axes
        params (std::vector<Double>)

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::DeletePositionInfo "bool DetectorInfoEditorBase::DeletePositionInfo(UInt4 detId, bool isForced=false) DetectorInfoEditorBase::DeletePositionInfo Delete Position info parameters of given detectorId.
==================================================================================================================================================================================

    Args:
        detId (UInt4) detector ID
        isForced (bool) execute without warning message

    Returns:
        true succeded
        false failed 

    
bool DetectorInfoEditorBase::DeletePositionInfo(std::vector< UInt4 > detIdList, bool isForced=false) DetectorInfoEditorBase::DeletePositionInfo Delete Position info parameters of given detectorId.
=====================================================================================================================================================================================================

    Args:
        detIdList (std::vector<UInt4>) list of detId
        isForced (bool) execute without warning message

    Returns:
        true succeded
        false failed 
";
%feature("docstring") DetectorInfoEditorBase::PutPositionInfoNumAxis "UInt4 DetectorInfoEditorBase::PutPositionInfoNumAxis(UInt4 detId) DetectorInfoEditorBase::PutPositionInfoNumAxis Put NumAxis in Position info parameters of given detectorId.
==============================================================================================================================================================================

    Args:
        detId (UInt4) detector ID

    Returns:
        UInt4 NumAxis 

";
%feature("docstring") DetectorInfoEditorBase::PutPositionInfoParams "std::vector< Double > DetectorInfoEditorBase::PutPositionInfoParams(UInt4 detId) DetectorInfoEditorBase::PutPositionInfoParams Put parameters in Position info of given detectorId.
====================================================================================================================================================================================

    Args:
        detId (UInt4) detector ID

    Returns:
        std::vector<Double> parameters 

";
%feature("docstring") DetectorInfoEditorBase::PutPositionInfoDetIdList "std::vector< UInt4 > DetectorInfoEditorBase::PutPositionInfoDetIdList() DetectorInfoEditorBase::PutPositionInfoDetIdList Put list of detId stored as Position Inof.
====================================================================================================================================================================

    Args:
        None

    Returns:
        std::vector<UInt4> list of detId 

";
%feature("docstring") DetectorInfoEditorBase::SetBankInfo "bool DetectorInfoEditorBase::SetBankInfo(UInt4 bankId, std::string bankName, std::string conts) DetectorInfoEditorBase::SetBankInfo Set BankInfo.
==================================================================================================================================================

    Args:
        bankId (UInt4) Bank ID
        bankName (std::string) Bank Name
        conts (std::string)

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::DeleteBankInfo "bool DetectorInfoEditorBase::DeleteBankInfo(UInt4 bankId) DetectorInfoEditorBase::DeleteBankInfo Delete BankInfo of given bankId.
==================================================================================================================================

    Args:
        bankId (UInt4) Bank ID

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::PutBankInfo "std::vector< std::string > DetectorInfoEditorBase::PutBankInfo(UInt4 bankId) DetectorInfoEditorBase::PutBankInfo Put BankInfo of given bankId.
===============================================================================================================================================

    Args:
        bankId (UInt4) Bank ID

    Returns:
        std::vector<std::string> <BankName>,<Conts1,Conts2,...> 

";
%feature("docstring") DetectorInfoEditorBase::SetInfoAsReader "bool DetectorInfoEditorBase::SetInfoAsReader() DetectorInfoEditorBase::SetInfoAsReader Converts WiringInfo into the format to be read from histogram creation methods.
=======================================================================================================================================================================

    Args:
        None

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorBase::ClearReader "void DetectorInfoEditorBase::ClearReader(UInt4 index=0) DetectorInfoEditorBase::ClearReader Clears the WiringInfo data to be read from histogram creation methods.
===================================================================================================================================================================

    Args:
        index (UInt4) index of variables to be cleared.

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorBase::PutInstL1 "Double DetectorInfoEditorBase::PutInstL1() DetectorInfoEditorBase::PutInstL1 Put L1.
=====================================================================================

    Args:
        None

    Returns:
        Double L1[mm] 

";
%feature("docstring") DetectorInfoEditorBase::PutInstSamplePosition "std::vector< Double > DetectorInfoEditorBase::PutInstSamplePosition() DetectorInfoEditorBase::PutInstSamplePosition Put Sample Position.
=========================================================================================================================================

    Args:
        None

    Returns:
        std::vector<Double> [px,py,pz] [mm] 

";
%feature("docstring") DetectorInfoEditorBase::PutInstTypicalL2 "Double DetectorInfoEditorBase::PutInstTypicalL2() DetectorInfoEditorBase::PutInstTypicalL2 Put the typical L2 stored.
======================================================================================================================

    Args:
        None

    Returns:
        Double L2 [mm] 

";
%feature("docstring") DetectorInfoEditorBase::PutInstTypicalDS "Double DetectorInfoEditorBase::PutInstTypicalDS() DetectorInfoEditorBase::PutInstTypicalDS Put the typical dS (the area of one pixel) stored.
==============================================================================================================================================

    Args:
        None

    Returns:
        Double dS [mm*mm] 

";
%feature("docstring") DetectorInfoEditorBase::PutBankIdList "std::vector< Int4 > DetectorInfoEditorBase::PutBankIdList() DetectorInfoEditorBase::PutBankIdList Puts List of Bank ID.
========================================================================================================================

    Args:
        None

    Returns:
        List of BankId (std::vector<Int4>). 

";
%feature("docstring") DetectorInfoEditorBase::PutDetIdInBank "std::vector< Int4 > DetectorInfoEditorBase::PutDetIdInBank(UInt4 bankId) DetectorInfoEditorBase::PutDetIdInBank Puts range of DetId in Bank ID given by an argument.
=====================================================================================================================================================================

    Args:
        bankId(UInt4) bank ID p *

    Returns:
        range of detId (std::vector<Int4>). 

    
std::vector< Int4 > DetectorInfoEditorBase::PutDetIdInBank(std::string bankName) DetectorInfoEditorBase::PutDetIdInBank Puts range of DetId in Bank ID given by an argument.
=============================================================================================================================================================================

    Args:
        bankName (String) bank Name

    Returns:
        range of detId (std::vector<Int4>). 
";
%feature("docstring") DetectorInfoEditorBase::PutBankName "std::vector< std::string > DetectorInfoEditorBase::PutBankName() DetectorInfoEditorBase::PutBankName Puts List of Banks name.
==============================================================================================================================
    attribute \"name\" in bank tag

    Args:
        None

    Returns:
        list of banks name (std::vector<std::string>). 

";
%feature("docstring") DetectorInfoEditorBase::PutTfp "std::vector< std::vector< Double > > * DetectorInfoEditorBase::PutTfp() DetectorInfoEditorBase::PutTfp Put Time focusing parameters loaded from DetectorInfo file.
===================================================================================================================================================================

    Args:
        None

    Returns:
        timeFocParam 

";
// File: classDetectorInfoEditorNeunet.xml

%feature("docstring") DetectorInfoEditorNeunet "C++ includes: DetectorInfoEditorNeunet.hh 

";
%feature("docstring") DetectorInfoEditorNeunet::DetectorInfoEditorNeunet "DetectorInfoEditorNeunet::DetectorInfoEditorNeunet() DetectorInfoEditorNeunet::DetectorInfoEditorNeunet Constructor. 

    
DetectorInfoEditorNeunet::DetectorInfoEditorNeunet(std::string dfile, bool workAsReader=true) DetectorInfoEditorNeunet::DetectorInfoEditorNeunet Constructor.
==============================================================================================================================================================

    Args:
        dfile (std::string) DetectorInfo file path to be read
        workAsReader (bool) 
";
%feature("docstring") DetectorInfoEditorNeunet::~DetectorInfoEditorNeunet "DetectorInfoEditorNeunet::~DetectorInfoEditorNeunet() DetectorInfoEditorNeunet::~DetectorInfoEditorNeunet Destructor. 

";
%feature("docstring") DetectorInfoEditorNeunet::Clear "void DetectorInfoEditorNeunet::Clear(UInt4 index=0) DetectorInfoEditorNeunet::Clear Clears stored parameters.
==============================================================================================================
    This deletes information by given index. index = 0 : all (default) index = 1 : InstrumentInfo index = 2 : TfpInfo index = 3 : TfpCalcParams index = 4 : PositionInfo index = 5 : BankInfo

    Args:
        index (UInt4)

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorNeunet::Read "bool DetectorInfoEditorNeunet::Read(std::string arg) DetectorInfoEditorNeunet::Read Reads DetectorInfo.xml and import information.
===================================================================================================================================

    Args:
        arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") DetectorInfoEditorNeunet::Write "bool DetectorInfoEditorNeunet::Write(std::string filepath) DetectorInfoEditorNeunet::Write Writes DetectorInfo.xml.
====================================================================================================================

    Args:
        filepath (std::string)

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") DetectorInfoEditorNeunet::OutXml "std::string DetectorInfoEditorNeunet::OutXml(bool withIndent=false) DetectorInfoEditorNeunet::OutXml Returns DetectorInfo as std::string.
==========================================================================================================================================

    Args:
        withIndent(bool) false : output text without an indent format

    Returns:
        std::string 

";
%feature("docstring") DetectorInfoEditorNeunet::_makeOutputXmlNeunet "bool DetectorInfoEditorNeunet::_makeOutputXmlNeunet() DetectorInfoEditorNeunet::_makeOutputXmlNeunet Makes XML format from stored information.
===============================================================================================================================================

    Args:
        None

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorNeunet::SetInfoAsReader "bool DetectorInfoEditorNeunet::SetInfoAsReader() DetectorInfoEditorNeunet::SetInfoAsReader Converts WiringInfo into the format to be read from histogram creation methods.
===========================================================================================================================================================================

    Args:
        None

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorNeunet::ClearReader "void DetectorInfoEditorNeunet::ClearReader(UInt4 index=0) DetectorInfoEditorNeunet::ClearReader Clears the WiringInfo data to be read from histogram creation methods.
=======================================================================================================================================================================

    Args:
        index (UInt4) index of variables to be cleared.

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorNeunet::CalcPsdPixelPosition "std::vector< double > DetectorInfoEditorNeunet::CalcPsdPixelPosition(UInt4 det_id, UInt4 pixelNo, UInt4 numOfPixel) DetectorInfoEditorNeunet::CalcPsdPixelPosition Calculate pixel position.
=============================================================================================================================================================================================
    This calculates pixel position by given detector ID, Pixel no and number of pixels

    Args:
        det_id (UInt4) detector ID
        pixelNo (UInt4) pixel NO in a PSD of det_id ( 0 <= pixelNo < numOfPixel )
        numOfPixel (UInt4) the number of pixels in a PSD

    Returns:
        position (std::vector<double>) [px,py,pz] 

";
%feature("docstring") DetectorInfoEditorNeunet::CalcPsdPixelSolidAngle "Double DetectorInfoEditorNeunet::CalcPsdPixelSolidAngle(UInt4 det_id, UInt4 pixelNo, UInt4 numOfPixel) DetectorInfoEditorNeunet::CalcPsdPixelSolidAngle Calculates Solid Angle by given detId and Pixel No.
============================================================================================================================================================================================================

    Args:
        det_id (UInt4)
        pixelNo (UInt4)
        numOfPixel (UInt4)

    Returns:
        None 

";
// File: classDetectorInfoEditorReadout2d.xml

%feature("docstring") DetectorInfoEditorReadout2d "C++ includes: DetectorInfoEditorReadout2d.hh 

";
%feature("docstring") DetectorInfoEditorReadout2d::DetectorInfoEditorReadout2d "DetectorInfoEditorReadout2d::DetectorInfoEditorReadout2d() DetectorInfoEditorReadout2d::DetectorInfoEditorReadout2d Constructor. 

    
DetectorInfoEditorReadout2d::DetectorInfoEditorReadout2d(std::string dfile, bool workAsReader=true) DetectorInfoEditorReadout2d::DetectorInfoEditorReadout2d Constructor.
==========================================================================================================================================================================

    Args:
        dfile (std::string) DetectorInfo file path to be read
        workAsReader (bool) 
";
%feature("docstring") DetectorInfoEditorReadout2d::~DetectorInfoEditorReadout2d "DetectorInfoEditorReadout2d::~DetectorInfoEditorReadout2d() DetectorInfoEditorReadout2d::~DetectorInfoEditorReadout2d Destructor. 

";
%feature("docstring") DetectorInfoEditorReadout2d::Clear "void DetectorInfoEditorReadout2d::Clear(UInt4 index=0) DetectorInfoEditorReadout2d::Clear Clears stored parameters.
====================================================================================================================
    This deletes information by given index. index = 0 : all (default) index = 1 : InstrumentInfo index = 2 : TfpInfo index = 3 : TfpCalcParams index = 4 : PositionInfo index = 5 : BankInfo

    Args:
        index (UInt4)

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorReadout2d::Read "bool DetectorInfoEditorReadout2d::Read(std::string arg) DetectorInfoEditorReadout2d::Read Reads DetectorInfo.xml and import information.
=========================================================================================================================================

    Args:
        arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") DetectorInfoEditorReadout2d::Write "bool DetectorInfoEditorReadout2d::Write(std::string filepath) DetectorInfoEditorReadout2d::Write Writes DetectorInfo.xml.
==========================================================================================================================

    Args:
        filepath (std::string)

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") DetectorInfoEditorReadout2d::OutXml "std::string DetectorInfoEditorReadout2d::OutXml(bool withIndent=false) DetectorInfoEditorReadout2d::OutXml Returns DetectorInfo as std::string.
================================================================================================================================================

    Args:
        withIndent(bool) false : output text without an indent format

    Returns:
        std::string 

";
%feature("docstring") DetectorInfoEditorReadout2d::_makeOutputXmlReadout2d "bool DetectorInfoEditorReadout2d::_makeOutputXmlReadout2d() DetectorInfoEditorReadout2d::_makeOutputXmlReadout2d Makes XML format from stored information.
===========================================================================================================================================================

    Args:
        None

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorReadout2d::SetInfoAsReader "bool DetectorInfoEditorReadout2d::SetInfoAsReader() DetectorInfoEditorReadout2d::SetInfoAsReader Converts WiringInfo into the format to be read from histogram creation methods.
=================================================================================================================================================================================

    Args:
        None

    Returns:
        true succeded
        false failed 

";
%feature("docstring") DetectorInfoEditorReadout2d::ClearReader "void DetectorInfoEditorReadout2d::ClearReader(UInt4 index=0) DetectorInfoEditorReadout2d::ClearReader Clears the WiringInfo data to be read from histogram creation methods.
=============================================================================================================================================================================

    Args:
        index (UInt4) index of variables to be cleared.

    Returns:
        None 

";
%feature("docstring") DetectorInfoEditorReadout2d::CalcReadout2dPixelPosition "bool DetectorInfoEditorReadout2d::CalcReadout2dPixelPosition(UInt4 det_id, UInt4 x_size, UInt4 y_size, std::vector< std::vector< Double > * > *posi_vec) DetectorInfoEditorReadout2d::CalcReadout2dPixelPosition Calculate pixel position.
===========================================================================================================================================================================================================================================
    This calculates pixel position by given detector ID, Pixel size

    Args:
        det_id (UInt4) detector ID
        x_size (UInt4) x-axis size
        y_size (UInt4) y-axis size
        posi_vec (std::vector< std::vector<Double> >) Positions [pixelNo][axes] pixelNo= x_size*py + px

    Returns:
        true No Error
        false Error 

";
%feature("docstring") DetectorInfoEditorReadout2d::CalcReadout2dPixelSolidAngle "std::vector< Double > DetectorInfoEditorReadout2d::CalcReadout2dPixelSolidAngle(UInt4 det_id, UInt4 x_size, UInt4 y_size, std::vector< std::vector< Double > * > *posi_vec) DetectorInfoEditorReadout2d::CalcReadout2dPixelSolidAngle Calculates Solid Angle by given detId and Pixel size.
============================================================================================================================================================================================================================================================================================

    Args:
        det_id (UInt4)
        x_size (UInt4) x-axis size
        y_size (UInt4) y-axis size
        posi_vec (std::vector< std::vector<Double> >) Positions [pixelNo][axes] pixelNo= x_size*py + px

    Returns:
        std::vector of solid angle [pixelNo] 

";
// File: classDetectorInfoTagDefineBase.xml

%feature("docstring") DetectorInfoTagDefineBase "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") DetectorInfoTagDefineBase::DetectorInfoTagDefineBase "DetectorInfoTagDefineBase::DetectorInfoTagDefineBase() DetectorInfoTagDefineBase::DetectorInfoTagDefineBase Constructor. 

";
%feature("docstring") DetectorInfoTagDefineBase::~DetectorInfoTagDefineBase "DetectorInfoTagDefineBase::~DetectorInfoTagDefineBase() DetectorInfoTagDefineBase::~DetectorInfoTagDefineBase Destructor. 

";
// File: classEventDataCreator.xml

%feature("docstring") EventDataCreator "

    Create Event data file from scinario in text.
    tt= EventDataCreator() evt=tt.encodePidClockEvent( 1111, 2000 ) evt.encode().hex() '5b000000000004575c00001f40000000' f=open(\"test.edb\",\"wb\") f.write(v.encode()) 16 f.close()
    C++ includes: UtsusemiEventDataCreator.hh 

";
%feature("docstring") EventDataCreator::EventDataCreator "EventDataCreator::EventDataCreator() EventDataCreator::EventDataCreator Constructor. 

";
%feature("docstring") EventDataCreator::~EventDataCreator "EventDataCreator::~EventDataCreator() EventDataCreator::~EventDataCreator Destructor. 

";
%feature("docstring") EventDataCreator::encodePidClockEvent "std::string EventDataCreator::encodePidClockEvent(int pid, double clock) EventDataCreator::encodePidClockEvent

";
%feature("docstring") EventDataCreator::encodeNeutronEvent "std::string EventDataCreator::encodeNeutronEvent(double tof, int mod, int psd) EventDataCreator::encodeNeutronEvent

";
%feature("docstring") EventDataCreator::encodeTrignetEvent "std::string EventDataCreator::encodeTrignetEvent(double tof, int sid1, int sid2, int val1, int val2=0) EventDataCreator::encodeTrignetEvent

";
%feature("docstring") EventDataCreator::output "bool EventDataCreator::output(std::string path_in, std::string path_n, std::string path_t) EventDataCreator::output

";
// File: classHistogramBinToPoint.xml

%feature("docstring") HistogramBinToPoint "

    Histogram format to points.
    This makes points data, which means that there is one-to-one correspondence between X-values ans Y-values ( not like Histogram ).
    C++ includes: HistogramBinToPoint.hh 

";
%feature("docstring") HistogramBinToPoint::HistogramBinToPoint "HistogramBinToPoint::HistogramBinToPoint() HistogramBinToPoint::HistogramBinToPoint Constructor. 

    
HistogramBinToPoint::HistogramBinToPoint(ElementContainer *ec) HistogramBinToPoint::HistogramBinToPoint Constructor.
=====================================================================================================================

    Args:
        ec target ElementContainer 
";
%feature("docstring") HistogramBinToPoint::~HistogramBinToPoint "HistogramBinToPoint::~HistogramBinToPoint() HistogramBinToPoint::~HistogramBinToPoint Destructor. 

";
%feature("docstring") HistogramBinToPoint::Convert "void HistogramBinToPoint::Convert() HistogramBinToPoint::Convert executes conversion
=====================================================================================

    Returns:
        None 

";
%feature("docstring") HistogramBinToPoint::PutXo "std::vector< Double > HistogramBinToPoint::PutXo() HistogramBinToPoint::PutXo Returns original X data.
=======================================================================================================

    Returns:
        original X data as double std::vector 

";
%feature("docstring") HistogramBinToPoint::PutX "std::vector< Double > HistogramBinToPoint::PutX() HistogramBinToPoint::PutX Returns X data of points.
======================================================================================================

    Returns:
        X data as double std::vector 

";
%feature("docstring") HistogramBinToPoint::PutY "std::vector< Double > HistogramBinToPoint::PutY() HistogramBinToPoint::PutY Returns Y data of points.
======================================================================================================

    Returns:
        X data as double std::vector 

";
%feature("docstring") HistogramBinToPoint::PutE "std::vector< Double > HistogramBinToPoint::PutE() HistogramBinToPoint::PutE Returns E data of points.
======================================================================================================

    Returns:
        E data as double std::vector 

";
%feature("docstring") HistogramBinToPoint::PutXList "PyObject * HistogramBinToPoint::PutXList() HistogramBinToPoint::PutXList Return the Python-List assigned to X-value.
=====================================================================================================================

    Returns:
        X data as list of python object 

";
%feature("docstring") HistogramBinToPoint::PutYList "PyObject * HistogramBinToPoint::PutYList() HistogramBinToPoint::PutYList Return the Python-List assigned to Y-value.
=====================================================================================================================

    Returns:
        Y data as list of python object 

";
%feature("docstring") HistogramBinToPoint::PutEList "PyObject * HistogramBinToPoint::PutEList() HistogramBinToPoint::PutEList Return the Python-List assigned to E-value.
=====================================================================================================================

    Returns:
        E data as list of python object 

";
// File: classNxspeFileIO.xml

%feature("docstring") NxspeFileIO "

    Tools for treating T0 event in eventdata.
    C++ includes: NxspeFileIO.hh 

";
%feature("docstring") NxspeFileIO::NxspeFileIO "NxspeFileIO::NxspeFileIO(bool isReduce=false) NxspeFileIO::NxspeFileIO Constructor.
====================================================================================

    Args:
        isReduce (bool) true..reduce the precision of intensity/error from 64bit(double) to 32bit(float) 

";
%feature("docstring") NxspeFileIO::~NxspeFileIO "NxspeFileIO::~NxspeFileIO() NxspeFileIO::~NxspeFileIO Destructor. 

";
%feature("docstring") NxspeFileIO::SetData "bool NxspeFileIO::SetData(ElementContainerMatrix *ECM, Double angle=0.0, Double temperature=300.0) NxspeFileIO::SetData Sets ElementContainerMatrix to be saved as nxspe.
==========================================================================================================================================================================

    Args:
        ECM (ElementContainerMatrxi*) The data to be saved.
        angle (Double) The angle value required by nxspe form.
        temperature (Double) The temperature value required by nxspe form.

    Returns:
        true
        false 

";
%feature("docstring") NxspeFileIO::SetSampleInfo "void NxspeFileIO::SetSampleInfo(Double angle, Double temperature) NxspeFileIO::SetSampleInfo Sets sample information required by nxspe form.
=============================================================================================================================================

    Args:
        angle (Double) The angle value required by nxspe form.
        temperature (Double) The temperature value required by nxspe form.

    Returns:
        None 

";
%feature("docstring") NxspeFileIO::Save "bool NxspeFileIO::Save(std::string filepath, std::string username=\"MLFuser\", UInt4 compMode=1) NxspeFileIO::Save Save as nxspe.
==================================================================================================================================

    Args:
        filepath (std::string) File path.
        username (std::string) The username parameter required by nxspe.
        compMode (UInt4) 0..no compressed, 1..complessed on WriteNeXusFile

    Returns:
        true
        false 

";
%feature("docstring") NxspeFileIO::Read "bool NxspeFileIO::Read(ElementContainerMatrix *ECM, std::string filepath, UInt4 pixelNo=100) NxspeFileIO::Read Read nxspe file.
================================================================================================================================

    Args:
        ECM (ElementContainerMatrix) Empty container to be imported.
        filepath (std::string) File path.
        pixelNo (UInt) The number of pixels in a group as PSD.

    Returns:
        true
        false 

";
%feature("docstring") NxspeFileIO::Test "void NxspeFileIO::Test() NxspeFileIO::Test

";
// File: classShamotoDymPDF.xml

%feature("docstring") ShamotoDymPDF "C++ includes: ShamotoDymPDF.hh 

";
%feature("docstring") ShamotoDymPDF::ShamotoDymPDF "ShamotoDymPDF::ShamotoDymPDF(bool useMF=true) ShamotoDymPDF::ShamotoDymPDF Constructor. 

";
%feature("docstring") ShamotoDymPDF::~ShamotoDymPDF "ShamotoDymPDF::~ShamotoDymPDF() ShamotoDymPDF::~ShamotoDymPDF Destructor. 

";
%feature("docstring") ShamotoDymPDF::SetModeToDymPDF "void ShamotoDymPDF::SetModeToDymPDF() ShamotoDymPDF::SetModeToDymPDF Set mode to DymPDF.
=========================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetModeToDyPDF "void ShamotoDymPDF::SetModeToDyPDF() ShamotoDymPDF::SetModeToDyPDF Set mode to DyPDF.
======================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetMode "void ShamotoDymPDF::SetMode(bool useMF) ShamotoDymPDF::SetMode Set mode for DymPDF / DyPDF.
============================================================================================

    Args:
        useMF (bool) True : DymPDF mode (with magnetic form factor), False : DyPDF mode

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetData "void ShamotoDymPDF::SetData(ElementContainerMatrix *ecm) ShamotoDymPDF::SetData Set data to be calculated.
===========================================================================================================

    Args:
        ecm (ElementContainerMatrix)

    Returns:
        None 

    
void ShamotoDymPDF::SetData(ElementContainerArray *eca) ShamotoDymPDF::SetData Set data to be calculated.
==========================================================================================================

    Args:
        eca (ElementContainerArray)

    Returns:
        None 
";
%feature("docstring") ShamotoDymPDF::SetSlicedData "void ShamotoDymPDF::SetSlicedData(ElementContainerArray *eca) ShamotoDymPDF::SetSlicedData Set the empty data container to be stored the sliced data by the Execute method.
============================================================================================================================================================================

    Args:
        eca (ElementContainerArray)

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetSliceWidth "void ShamotoDymPDF::SetSliceWidth(Double delta_hw, Double min_hw=0.0, Double max_hw=0.0) ShamotoDymPDF::SetSliceWidth Set parameters used for slicing along to energy axis.
============================================================================================================================================================================
    min_hw == max_hw means the use of all energy reange in data.

    Args:
        delta_hw (Double) Energy bin width
        min_hw (Double) Minimun value of enargy range
        max_hw (Double) Maximun value of enargy range

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetCf "void ShamotoDymPDF::SetCf(Double cf) ShamotoDymPDF::SetCf Set correction factor parameters used for the magnetic form factor calculation.
==========================================================================================================================================

    Args:
        cf (Double)

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetNav "void ShamotoDymPDF::SetNav(UInt4 nav) ShamotoDymPDF::SetNav Set the number of bins used for averaging intensity of S(Q,hw)
===========================================================================================================================

    Args:
        nav (UInt4) the number of bins

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::SetMagFormFact "void ShamotoDymPDF::SetMagFormFact(Double _A1, Double _a2, Double _B1, Double _b2, Double _C1, Double _c2, Double _D) ShamotoDymPDF::SetMagFormFact Set parameters used for the magnetic form factor calculation.
==================================================================================================================================================================================================================
    A1*exp(-a2*s*s) + B1*exp(-b2*s*s) + C1*exp(-c2*s*s) + D where s = Q/(4*PI)

    Args:
        _A1 (Double)
        _a2 (Double)
        _B1 (Double)
        _b2 (Double)
        _C1 (Double)
        _c2 (Double)
        _D (Double)

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::Slice "bool ShamotoDymPDF::Slice(ElementContainerMatrix *ecm, ElementContainerArray *eca, Double delta_hw, Double min_hw=0.0, Double max_hw=0.0) ShamotoDymPDF::Slice Do slice of the original data using the energy range and width given by SetSliceWidth.
======================================================================================================================================================================================================================================================
    min_hw == max_hw means the use of all energy reange in data. G(r, E) is calcualted from this sliced data

    Args:
        ecm (ElementContainerMatrix) original data (S(Q,E))
        eca (ElementContainerArray) sliced data
        delta_hw (Double) Energy bin width
        min_hw (Double) Minimum value of enargy range
        max_hw (Double) Maximum value of enargy range

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::SetRRange "bool ShamotoDymPDF::SetRRange(Double dR, Double maxR) ShamotoDymPDF::SetRRange Set r range of calculated data G(r, E)
======================================================================================================================

    Args:
        dR (Double) bin width of r
        maxR (Double) Maximum value of r range

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::_ExecuteDyPDFBase "bool ShamotoDymPDF::_ExecuteDyPDFBase(std::vector< Double > *r_RHO, std::vector< Double > *g_RHO, std::vector< Double > *e_RHO, std::vector< Double > *q_FQ, std::vector< Double > *s_FQ, std::vector< Double > *e_FQ, UInt4 nav) ShamotoDymPDF::_ExecuteDyPDFBase Execute the DyPDF conversion calculation of G(r, E) from data S(Q,hw), hw is const.
=======================================================================================================================================================================================================================================================================================================================================================

    Args:
        r_RHO (std::vector<Double>) r std::vector of G(r,hw) converted
        g_RHO (std::vector<Double>) Intensity std::vector of G(r,hw) converted
        e_RHO (std::vector<Double>) Error std::vector of G(r,hw) converted
        q_FQ (std::vector<Double>) Q std::vector of S(Q,hw)
        s_FQ (std::vector<Double>) Intensity std::vector of S(Q,hw)
        e_FQ (std::vector<Double>) Error std::vector of S(Q,hw)
        nav (UInt4) the number of bins for averaging

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::_ExecuteDyPDF "bool ShamotoDymPDF::_ExecuteDyPDF(bool doSlice) ShamotoDymPDF::_ExecuteDyPDF

";
%feature("docstring") ShamotoDymPDF::_ExecuteDymPDF "bool ShamotoDymPDF::_ExecuteDymPDF(bool doSlice) ShamotoDymPDF::_ExecuteDymPDF

";
%feature("docstring") ShamotoDymPDF::Execute "bool ShamotoDymPDF::Execute(bool doSlice=true) ShamotoDymPDF::Execute Execute the calculation of G(r, E) from the sliced data.
===============================================================================================================================

    Args:
        doSlice (bool) plot S(Q, E) or not befor G(r, E) calculation.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::_ExecuteWideDymPDFBase "bool ShamotoDymPDF::_ExecuteWideDymPDFBase(std::vector< Double > &r_RHO, std::vector< Double > &g_RHO, std::vector< Double > &e_RHO, std::vector< Double > &q_FQ, std::vector< Double > &s_FQ, std::vector< Double > &e_FQ, const std::vector< Double > &params) ShamotoDymPDF::_ExecuteWideDymPDFBase Execute the Wide-Q magnetic pair density funcation analysis (wideDymPDF) @ hw const.
============================================================================================================================================================================================================================================================================================================================================================================================

    Args:
        r_RHO (std::vector<Double>) r vector of G(r,hw) converted
        g_RHO (std::vector<Double>) Intensity vector of G(r,hw) converted
        e_RHO (std::vector<Double>) Error vector of G(r,hw) converted
        q_FQ (std::vector<Double>) Q vector of S(Q,hw)
        s_FQ (std::vector<Double>) Intensity vector of S(Q,hw)
        e_FQ (std::vector<Double>) Error vector of S(Q,hw)
        params (std::vector<Double>) params[0]:Qmin for phonon background fitting, params[1]:Qmax for dynamic magnetic PDF analysis

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::ExecuteWideDymPDF "bool ShamotoDymPDF::ExecuteWideDymPDF(Double Qmin_phononBG, Double Qmax_DymPDF, bool doSlice=true) ShamotoDymPDF::ExecuteWideDymPDF The Wide-Q dynamic magnetic pair density funcation analysis (wideDymPDF)
=============================================================================================================================================================================================================

    Args:
        Qmin_phononBG (Double) Qmin for phonon background fitting
        Qmax_DymPDF (Double) Qmax for dynamic magnetic PDF analysis
        doSlice (bool) plot S(Q, E) or not befor G(r, E) calculation

    Returns:
        true succeeded
        false failed 

";
%feature("docstring") ShamotoDymPDF::TurnOffMF "void ShamotoDymPDF::TurnOffMF(bool off=true) ShamotoDymPDF::TurnOffMF Change the flag to use the magnetic form factor when G(r, E) calculation.
================================================================================================================================================

    Args:
        off (bool) true means \"Not use the magnetic form factor\"

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::PutResult "ElementContainerArray ShamotoDymPDF::PutResult(bool isXaxisR=true) ShamotoDymPDF::PutResult Put the result G(r, E) or S(Q, E)
==============================================================================================================================

    Args:
        isXaxisR (bool) true means G(r, E) returns, false means S(Q, E)

    Returns:
        ElementContainerArray 

    
void ShamotoDymPDF::PutResult(ElementContainerArray *ret, bool isXaxisR=true) ShamotoDymPDF::PutResult Put the result G(r, E) or S(Q, E) into ElementContainerArray.
=====================================================================================================================================================================

    Args:
        eca (ElementContainerArray) contains the result
        isXaxisR (bool) true means G(r, E) returns, false means S(Q, E)

    Returns:
        None 
";
%feature("docstring") ShamotoDymPDF::PutSlicedMap "ElementContainerArray ShamotoDymPDF::PutSlicedMap() ShamotoDymPDF::PutSlicedMap Put the sliced data S(Q, E)
============================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") ShamotoDymPDF::Test "bool ShamotoDymPDF::Test(std::string _inputfile, std::string _outputfile, ElementContainerArray *_eca) ShamotoDymPDF::Test Test code.
======================================================================================================================================

    Args:
        _inputfile (std::string) test file path of sample 1d (hw, Intensity, Error) data at const hw
        _outputfile (std::string) output file path which is calcutated as G(r, hw)

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::TestDyPDF "bool ShamotoDymPDF::TestDyPDF(std::string _inputfile, UInt4 nav) ShamotoDymPDF::TestDyPDF Test code for DyPDF only.
====================================================================================================================

    Args:
        _inputfile (std::string) test file path of sample 1d (hw, Intensity, Error) data at const hw
        nav

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") ShamotoDymPDF::TestWideDymPDF "bool ShamotoDymPDF::TestWideDymPDF(std::string _inputfile, Double Qmin, Double Qmax) ShamotoDymPDF::TestWideDymPDF Test code for wideDymPDF only.
==================================================================================================================================================

    Args:
        _inputfile (std::string) test file path of sample 1d (hw, Intensity, Error) data at const hw
        Qmin
        Qmax

    Returns:
        true succeeded.
        false failed. 

";
// File: classShamotoMagFormFact.xml

%feature("docstring") ShamotoMagFormFact "DymPDF Magnetic Form factor s = Q/(4*PI) A1*exp(-a2*s*s) + B1*exp(-b2*s*s) + C1*exp(-c2*s*s) + D SetMagFormFact(A1, a2, B1, b2, C1, c2, D) Sample script for DymPDF DPDF = mu.ShamotoDymPDF() DPDF.SetModeToDymPDF() DPDF.SetData(DAT) DPDF.SetSliceWidth(0.2, 1.0, 12.5) DPDF.SetCf(74.84) DPDF.SetMagFormFact(0.4220, 17.684, 0.5948, 6.005, 0.0043, -0.609, -0.0219) DPDF.SetRRange(0.1, 40.0) DPDF.Execute() ECA = DPDF.PutResult(True) DyPDFSample script for DyPDF DPDF = mu.ShamotoDymPDF() DPDF.SetModeToDyPDF() # execute as DyPDF DPDF.SetData(DAT) DPDF.SetSliceWidth(0.2, 1.0, 12.5) DPDF.SetRRange(0.1, 40.0) DPDF.SetNav(5) DPDF.Execute() ECA = DPDF.PutResult(True)
====================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================
    C++ includes: ShamotoDymPDF.hh 

";
%feature("docstring") ShamotoMagFormFact::ShamotoMagFormFact "ShamotoMagFormFact::ShamotoMagFormFact() ShamotoMagFormFact::ShamotoMagFormFact

";
%feature("docstring") ShamotoMagFormFact::~ShamotoMagFormFact "ShamotoMagFormFact::~ShamotoMagFormFact() ShamotoMagFormFact::~ShamotoMagFormFact

";
%feature("docstring") ShamotoMagFormFact::Calc "Double ShamotoMagFormFact::Calc(Double Q) ShamotoMagFormFact::Calc

";
// File: classT0TreatToolsNeunet.xml

%feature("docstring") T0TreatToolsNeunet "

    Tools for treating T0 event in eventdata.
    C++ includes: T0TreatToolsNeunet.hh 

";
%feature("docstring") T0TreatToolsNeunet::T0TreatToolsNeunet "T0TreatToolsNeunet::T0TreatToolsNeunet() T0TreatToolsNeunet::T0TreatToolsNeunet Constructor. 

";
%feature("docstring") T0TreatToolsNeunet::~T0TreatToolsNeunet "T0TreatToolsNeunet::~T0TreatToolsNeunet() T0TreatToolsNeunet::~T0TreatToolsNeunet Destructor. 

";
// File: classT0TreatToolsReadout.xml

%feature("docstring") T0TreatToolsReadout "

    Tools for treating T0 event in eventdata.
    C++ includes: T0TreatToolsReadout.hh 

";
%feature("docstring") T0TreatToolsReadout::T0TreatToolsReadout "T0TreatToolsReadout::T0TreatToolsReadout() T0TreatToolsReadout::T0TreatToolsReadout Constructor. 

";
%feature("docstring") T0TreatToolsReadout::~T0TreatToolsReadout "T0TreatToolsReadout::~T0TreatToolsReadout() T0TreatToolsReadout::~T0TreatToolsReadout Destructor. 

";
// File: classT0TreatToolsReadoutWLSF32.xml

%feature("docstring") T0TreatToolsReadoutWLSF32 "

    Tools for treating T0 event in eventdata.
    C++ includes: T0TreatToolsReadoutWLSF32.hh 

";
%feature("docstring") T0TreatToolsReadoutWLSF32::T0TreatToolsReadoutWLSF32 "T0TreatToolsReadoutWLSF32::T0TreatToolsReadoutWLSF32() T0TreatToolsReadoutWLSF32::T0TreatToolsReadoutWLSF32 Constructor. 

";
%feature("docstring") T0TreatToolsReadoutWLSF32::~T0TreatToolsReadoutWLSF32 "T0TreatToolsReadoutWLSF32::~T0TreatToolsReadoutWLSF32() T0TreatToolsReadoutWLSF32::~T0TreatToolsReadoutWLSF32 Destructor. 

";
// File: classTofToEnergyChoppers.xml

%feature("docstring") TofToEnergyChoppers "

    Function for converting Time-of-flight to Energy.
    This function requires header information as below : ElementContainerMatrix must have incident neutron energy value with \"L1\" key. ElementContainerArray (PSD) must have the type (\"PSD\" or \"MONITOR\") with \"TYPE\" key. ElementContainer (Pixel) must have pixel position information with \"PixelPosition\" key.
    ElementContainer must have Time of flight as Key-X. Units: L1 [mm], PixelPosition [mm], TOF offset [micro-sec]
    C++ includes: TofToEnergyChoppers.hh 

";
%feature("docstring") TofToEnergyChoppers::TofToEnergyChoppers "TofToEnergyChoppers::TofToEnergyChoppers() TofToEnergyChoppers::TofToEnergyChoppers Constructor. 

";
%feature("docstring") TofToEnergyChoppers::~TofToEnergyChoppers "TofToEnergyChoppers::~TofToEnergyChoppers() TofToEnergyChoppers::~TofToEnergyChoppers Destructor. 

";
%feature("docstring") TofToEnergyChoppers::TofToEnergy "void TofToEnergyChoppers::TofToEnergy(double Tof_offset) TofToEnergyChoppers::TofToEnergy Convert TOF to EnergyTransfer.
=========================================================================================================================

    Args:
        Tof_offset Use this to shift the origin of TOF [micro-sec]

    Returns:
        None 

    
void TofToEnergyChoppers::TofToEnergy(double Tof_offset, std::vector< Double > new_bin) TofToEnergyChoppers::TofToEnergy Convert TOF to EnergyTransfer with rebinning.
=======================================================================================================================================================================

    Args:
        Tof_offset use this to shift the origin of TOF [micro-sec]
        new_bin new binning of TOF

    Returns:
        None 
    
void TofToEnergyChoppers::TofToEnergy(double L1, double Tof_offset) TofToEnergyChoppers::TofToEnergy Convert TOF to EnergyTransfer.
====================================================================================================================================

    Args:
        L1 the distanse between neutron source to sample position [mm]
        Tof_offset Use this to shift the origin of TOF [micro-sec]

    Returns:
        None 
    
void TofToEnergyChoppers::TofToEnergy(double L1, double Tof_offset, std::vector< Double > new_bin) TofToEnergyChoppers::TofToEnergy Convert TOF to EnergyTransfer with rebinning.
==================================================================================================================================================================================

    Args:
        L1 the distanse between neutron source to sample position [mm]
        Tof_offset use this to shift the origin of TOF [micro-sec]
        new_bin new binning of TOF

    Returns:
        None 
";
// File: classTofToEnergyTransfer.xml

%feature("docstring") TofToEnergyTransfer "

    Function for converting Time-of-flight to Energy Transfer.
    This function requires header information as below : ElementContainerMatrix must have incident neutron energy value with \"Ei\" key. ElementContainerArray (PSD) must have the type (\"PSD\" or \"MONITOR\") with \"TYPE\" key. ElementContainer (Pixel) must have pixel position information with \"PixelPosition\" key.
    ElementContainer must have Time of flight as Key-X. Units: L1 [mm], PixelPosition [mm], Tof_offset [micro-sec]
    C++ includes: TofToEnergyTransfer.hh 

";
%feature("docstring") TofToEnergyTransfer::TofToEnergyTransfer "TofToEnergyTransfer::TofToEnergyTransfer() TofToEnergyTransfer::TofToEnergyTransfer Constructor. 

";
%feature("docstring") TofToEnergyTransfer::~TofToEnergyTransfer "TofToEnergyTransfer::~TofToEnergyTransfer() TofToEnergyTransfer::~TofToEnergyTransfer Destructor. 

";
%feature("docstring") TofToEnergyTransfer::Tof2EnergyTransfer "void TofToEnergyTransfer::Tof2EnergyTransfer(double Tof_offset) TofToEnergyTransfer::Tof2EnergyTransfer Convert TOF to EnergyTransfer.
=======================================================================================================================================

    Args:
        Tof_offset Use this to shift the origin of TOF

    Returns:
        None 

    
void TofToEnergyTransfer::Tof2EnergyTransfer(double Tof_offset, std::vector< Double > new_bin) TofToEnergyTransfer::Tof2EnergyTransfer Convert TOF to EnergyTransfer with rebinning.
=====================================================================================================================================================================================

    Args:
        Tof_offset use this to shift the origin of TOF
        new_bin new binning of TOF

    Returns:
        None 
    
void TofToEnergyTransfer::Tof2EnergyTransfer(double L1, double Tof_offset) TofToEnergyTransfer::Tof2EnergyTransfer Convert TOF to EnergyTransfer.
==================================================================================================================================================

    Args:
        L1 the distanse between neutron source to sample position [mm]
        Tof_offset Use this to shift the origin of TOF [micro-sec]

    Returns:
        None 
    
void TofToEnergyTransfer::Tof2EnergyTransfer(double L1, double Tof_offset, std::vector< Double > new_bin) TofToEnergyTransfer::Tof2EnergyTransfer Convert TOF to EnergyTransfer with rebinning.
================================================================================================================================================================================================

    Args:
        L1 the distanse between neutron source to sample position [mm]
        Tof_offset use this to shift the origin of TOF [micro-sec]
        new_bin new binning of TOF

    Returns:
        None 
";
// File: classTreatD4Matrix2XmlParams.xml

%feature("docstring") TreatD4Matrix2XmlParams "C++ includes: UtsusemiD4Matrix2.hh 

";
%feature("docstring") TreatD4Matrix2XmlParams::TreatD4Matrix2XmlParams "TreatD4Matrix2XmlParams::TreatD4Matrix2XmlParams() TreatD4Matrix2XmlParams::TreatD4Matrix2XmlParams

    
TreatD4Matrix2XmlParams::TreatD4Matrix2XmlParams(std::string) TreatD4Matrix2XmlParams::TreatD4Matrix2XmlParams
";
%feature("docstring") TreatD4Matrix2XmlParams::~TreatD4Matrix2XmlParams "TreatD4Matrix2XmlParams::~TreatD4Matrix2XmlParams() TreatD4Matrix2XmlParams::~TreatD4Matrix2XmlParams

";
%feature("docstring") TreatD4Matrix2XmlParams::AddRunNo "void TreatD4Matrix2XmlParams::AddRunNo(UInt4 _runNo, Double _startAngle) TreatD4Matrix2XmlParams::AddRunNo

";
%feature("docstring") TreatD4Matrix2XmlParams::ClearRunNo "void TreatD4Matrix2XmlParams::ClearRunNo() TreatD4Matrix2XmlParams::ClearRunNo

";
%feature("docstring") TreatD4Matrix2XmlParams::ImportXmlString "bool TreatD4Matrix2XmlParams::ImportXmlString(std::string xmlstring, bool withDR=false) TreatD4Matrix2XmlParams::ImportXmlString

";
%feature("docstring") TreatD4Matrix2XmlParams::PutXmlString "std::string TreatD4Matrix2XmlParams::PutXmlString() TreatD4Matrix2XmlParams::PutXmlString

";
%feature("docstring") TreatD4Matrix2XmlParams::Clear "void TreatD4Matrix2XmlParams::Clear(bool onlyD4Mat2=true) TreatD4Matrix2XmlParams::Clear

";
%feature("docstring") TreatD4Matrix2XmlParams::PutDeviceEncode "Double TreatD4Matrix2XmlParams::PutDeviceEncode(std::string _devName) TreatD4Matrix2XmlParams::PutDeviceEncode

";
%feature("docstring") TreatD4Matrix2XmlParams::CheckDeviceEncodeName "UInt4 TreatD4Matrix2XmlParams::CheckDeviceEncodeName(std::string _devName) TreatD4Matrix2XmlParams::CheckDeviceEncodeName

";
// File: classUtsusemiAnaEnvironReader.xml

%feature("docstring") UtsusemiAnaEnvironReader "C++ includes: UtsusemiAnaEnvironReader.hh 

";
%feature("docstring") UtsusemiAnaEnvironReader::UtsusemiAnaEnvironReader "UtsusemiAnaEnvironReader::UtsusemiAnaEnvironReader(std::string envFileName, std::string UtsusemiUserXmlPath=\"\") UtsusemiAnaEnvironReader::UtsusemiAnaEnvironReader Constructor.
==================================================================================================================================================================================

    Args:
        envFileName (std::string) Xml file name of the histogram creation environment information. If empty, environ_ana.xml is given.
        UtsusemiUserXmlPath (std::string) The path to the folder storing users xml files 

    
UtsusemiAnaEnvironReader::UtsusemiAnaEnvironReader(UInt4 runNo, bool isQuiet=false) UtsusemiAnaEnvironReader::UtsusemiAnaEnvironReader Constructor.
====================================================================================================================================================

    Args:
        runNo (UInt4) run number which is used to find the environment information xml file stored in the run folder (ex. SIK0123456_20230601/params/Utsusemi/environ_ana.xml).
        isQuiet (bool) If true, some messages including warning are not shown. 
";
%feature("docstring") UtsusemiAnaEnvironReader::~UtsusemiAnaEnvironReader "UtsusemiAnaEnvironReader::~UtsusemiAnaEnvironReader() UtsusemiAnaEnvironReader::~UtsusemiAnaEnvironReader Destructor. 

";
%feature("docstring") UtsusemiAnaEnvironReader::Read "bool UtsusemiAnaEnvironReader::Read(std::string envFileName, std::string UtsusemiUserXmlPath=\"\") UtsusemiAnaEnvironReader::Read Read the xml file of the histogram creation environment information.
=======================================================================================================================================================================================================

    Args:
        envFileName (std::string) Xml file name of the histogram creation environment information. If empty, environ_ana.xml is given.
        UtsusemiUserXmlPath (std::string) The path to the folder storing users xml files

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiAnaEnvironReader::Read(UInt4 runNo, bool isQuiet=false) UtsusemiAnaEnvironReader::Read Read the xml file of the histogram creation environment information.
=========================================================================================================================================================================

    Args:
        runNo (UInt4) run number which is used to find the environment information xml file stored in the run folder (ex. SIK0123456_20230601/params/Utsusemi/environ_ana.xml).
        isQuiet (bool) If true, some messages including warning are not show.

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiAnaEnvironReader::Parse "bool UtsusemiAnaEnvironReader::Parse(std::string evnFilePath) UtsusemiAnaEnvironReader::Parse Parse the xml file of the histogram creation environment information.
====================================================================================================================================================================

    Args:
        envFileName (std::string) Xml file name of the histogram creation environment information. The empty is forbidden.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiAnaEnvironReader::PutParamFiles "std::vector< std::string > UtsusemiAnaEnvironReader::PutParamFiles(UInt4 runNo, UInt4 modeNo=0, bool isFullPath=false) UtsusemiAnaEnvironReader::PutParamFiles Put the parameter xml files (WiringInfo, DetectorInfo and CaseInfo) by given a run number and mode number from the environment information.
===========================================================================================================================================================================================================================================================================================================

    Args:
        runNo (UInt4) the run number required to choose the suitable the parameter xml files (WiringInfo, DetectorInfo and CaseInfo).
        modeNo (UInt4) the mode number to choose the suitable parameter xml files.
        isFullPath (bool) whether the full path to the parameter xml files returns or not.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiAnaEnvironReader::Dump "void UtsusemiAnaEnvironReader::Dump() UtsusemiAnaEnvironReader::Dump Show the contents of the environment information xml file.
================================================================================================================================

    Args:
        None

    Returns:
        None 

";
// File: classUtsusemiCalcContainers.xml

%feature("docstring") UtsusemiCalcContainers "

    Calclation between Manyo Containers.
    C++ includes: UtsusemiCalcContainers.hh 

";
%feature("docstring") UtsusemiCalcContainers::UtsusemiCalcContainers "UtsusemiCalcContainers::UtsusemiCalcContainers() UtsusemiCalcContainers::UtsusemiCalcContainers Constructor. 

";
%feature("docstring") UtsusemiCalcContainers::~UtsusemiCalcContainers "UtsusemiCalcContainers::~UtsusemiCalcContainers() UtsusemiCalcContainers::~UtsusemiCalcContainers Destructor. 

";
%feature("docstring") UtsusemiCalcContainers::CalcContainers "ElementContainer UtsusemiCalcContainers::CalcContainers(Double coef1, ElementContainer *ec1, std::string ope, Double coef2, ElementContainer *ec2) UtsusemiCalcContainers::CalcContainers Calculates between two ElementContainers.
====================================================================================================================================================================================================================================
    Formura : coef1*ec1 [\"+\",\"-\",\"*\",\"/\"] coef2*ec2

    Args:
        coef1 (Double) coefficient for ec1
        ec1 (ElementContainer*) first ElementContainer
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ec2
        ec2 (ElementContainer*) second ElementContainer

    Returns:
        ElementContainer as calculation result 

    
ElementContainerArray UtsusemiCalcContainers::CalcContainers(Double coef1, ElementContainerArray *eca1, std::string ope, Double coef2, ElementContainerArray *eca2) UtsusemiCalcContainers::CalcContainers Calculates between two ElementContainerArrays.
==========================================================================================================================================================================================================================================================
    Formura : coef1*eca1 [\"+\",\"-\",\"*\",\"/\"] coef2*eca2

    Args:
        coef1 (Double) coefficient for ec1
        eca1 (ElementContainerArray*) first ElementContainerArray
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ec2
        eca2 (ElementContainerArray*) second ElementContainerArray

    Returns:
        ElementContainerArray as calculation result 
    
ElementContainerArray UtsusemiCalcContainers::CalcContainers(Double coef1, ElementContainerArray *eca, std::string ope, Double coef2, ElementContainer *ec) UtsusemiCalcContainers::CalcContainers Calculates between ElementContainerArray and ElementContainer.
==================================================================================================================================================================================================================================================================
    Formura : coef1*eca [\"+\",\"-\",\"*\",\"/\"] coef2*ec ec operates to each ElementContainer in given ElementContainerArray

    Args:
        coef1 (Double) coefficient for eca
        eca (ElementContainerArray*) ElementContainerArray
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ec
        ec (ElementContainer*) ElementContainer

    Returns:
        ElementContainerArray as calculation result 
    
ElementContainerMatrix UtsusemiCalcContainers::CalcContainers(Double coef1, ElementContainerMatrix *ecm1, std::string ope, Double coef2, ElementContainerMatrix *ecm2) UtsusemiCalcContainers::CalcContainers Calculates between two ElementContainerMatrixs.
==============================================================================================================================================================================================================================================================
    Formura : coef1*ecm1 [\"+\",\"-\",\"*\",\"/\"] coef2*ecm2

    Args:
        coef1 (Double) coefficient for ecm1
        ecm1 (ElementContainerMatrix*) first ElementContainerMatrix
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ecm2
        ecm2 (ElementContainerMatrix*) second ElementContainerMatrix

    Returns:
        ElementContainerMatrix as calculation result 
    
ElementContainerMatrix UtsusemiCalcContainers::CalcContainers(Double coef1, ElementContainerMatrix *ecm, std::string ope, Double coef2, ElementContainerArray *eca) UtsusemiCalcContainers::CalcContainers Calculates between ElementContainerMatrix and ElementContainerArray.
================================================================================================================================================================================================================================================================================
    Formura : coef1*ecm [\"+\",\"-\",\"*\",\"/\"] coef2*eca eca operates to each ElementContainerArray in given ElementContainerMatrix

    Args:
        coef1 (Double) coefficient for ecm
        ecm (ElementContainerMatrix*) ElementContainerMatrix
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for eca
        eca (ElementContainerArray*) ElementContainerArray

    Returns:
        ElementContainerMatrix as calculation result 
    
ElementContainerMatrix UtsusemiCalcContainers::CalcContainers(Double coef1, ElementContainerMatrix *ecm, std::string ope, Double coef2, ElementContainer *ec) UtsusemiCalcContainers::CalcContainers Calculates between ElementContainerMatrix and ElementContainer.
=====================================================================================================================================================================================================================================================================
    Formura : coef1*ecm [\"+\",\"-\",\"*\",\"/\"] coef2*ec ec operates to each ElementContainer in given ElementContainerMatrix

    Args:
        coef1 (Double) coefficient for ecm
        ecm (ElementContainerMatrix*) ElementContainerMatrix
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ec
        ec (ElementContainer*) ElementContainer

    Returns:
        ElementContainerMatrix as calculation result 
    
bool UtsusemiCalcContainers::CalcContainers(ElementContainerMatrix *ret_ecm, Double coef1, ElementContainerMatrix *ecm1, std::string ope, Double coef2, ElementContainerMatrix *ecm2) UtsusemiCalcContainers::CalcContainers Calculates faster between two ElementContainerMatrixs.
====================================================================================================================================================================================================================================================================================
    Formura : coef1*ecm1 [\"+\",\"-\",\"*\",\"/\"] coef2*ecm2

    Args:
        ret_ecm (ElementContainerMatrix) Empty ElementContainerMatrix which calculated result is set.
        coef1 (Double) coefficient for ecm1
        ecm1 (ElementContainerMatrix*) first ElementContainerMatrix
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ecm2
        ecm2 (ElementContainerMatrix*) second ElementContainerMatrix

    Returns:
        true succeeded
        false failed 
    
bool UtsusemiCalcContainers::CalcContainers(ElementContainerArray *ret_eca, Double coef1, ElementContainerArray *eca1, std::string ope, Double coef2, ElementContainerArray *eca2) UtsusemiCalcContainers::CalcContainers Calculates faster between two ElementContainerArrays.
================================================================================================================================================================================================================================================================================
    Formura : coef1*eca1 [\"+\",\"-\",\"*\",\"/\"] coef2*eca2

    Args:
        ret_eca (ElementContainerArray) Empty ElementContainerArray which calculated result is set.
        coef1 (Double) coefficient for ecm1
        eca1 (ElementContainerArray*) first ElementContainerArray
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for eca2
        eca2 (ElementContainerArray*) second ElementContainerArray

    Returns:
        true succeeded
        false failed 
    
bool UtsusemiCalcContainers::CalcContainers(ElementContainerMatrix *ret_ecm, Double coef1, ElementContainerMatrix *ecm1, Double pow1, std::string ope, Double coef2, ElementContainerMatrix *ecm2, Double pow2) UtsusemiCalcContainers::CalcContainers Calculates faster between two ElementContainerMatrixs.
==============================================================================================================================================================================================================================================================================================================
    Formura : coef1*ecm1^(pow1) [\"+\",\"-\",\"*\",\"/\"] coef2*ecm2^(pow2)

    Args:
        ret_ecm (ElementContainerMatrix) Empty ElementContainerMatrix which calculated result is set.
        coef1 (Double) coefficient for ecm1
        ecm1 (ElementContainerMatrix*) first ElementContainerMatrix
        pow1 (Double) power value for ecm1
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for ecm2
        ecm2 (ElementContainerMatrix*) second ElementContainerMatrix
        pow2 (Double) power value for ecm2

    Returns:
        true succeeded
        false failed 
    
bool UtsusemiCalcContainers::CalcContainers(ElementContainerArray *ret_eca, Double coef1, ElementContainerArray *eca1, Double pow1, std::string ope, Double coef2, ElementContainerArray *eca2, Double pow2) UtsusemiCalcContainers::CalcContainers Calculates faster between two ElementContainerArrays.
==========================================================================================================================================================================================================================================================================================================
    Formura : coef1*eca1^(pow1) [\"+\",\"-\",\"*\",\"/\"] coef2*eca2^(pow2)

    Args:
        ret_eca (ElementContainerArray) Empty ElementContainerArray which calculated result is set.
        coef1 (Double) coefficient for ecm1
        eca1 (ElementContainerArray*) first ElementContainerArray
        pow1 (Double) power value for eca1
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".
        coef2 (Double) coefficient for eca2
        eca2 (ElementContainerArray*) second ElementContainerArray
        pow2 (Double) power value for eca2

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") UtsusemiCalcContainers::CheckOperator "UInt4 UtsusemiCalcContainers::CheckOperator(std::string ope) UtsusemiCalcContainers::CheckOperator Checks whether given operator is valid or not.
==================================================================================================================================================

    Args:
        ope (std::string) operator between ec1 and ec2 must be \"+\",\"-\",\"*\" or \"/\".

    Returns:
        true ope is valid
        false invalid 

";
// File: classUtsusemiCaseInfoReaderTrignet.xml

%feature("docstring") UtsusemiCaseInfoReaderTrignet "

    Read Case info File and store information.
    for Trignet This can import case info File and store information for easy using to make histogram.
    C++ includes: UtsusemiCaseInfoReaderTrignet.hh 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::UtsusemiCaseInfoReaderTrignet "UtsusemiCaseInfoReaderTrignet::UtsusemiCaseInfoReaderTrignet() UtsusemiCaseInfoReaderTrignet::UtsusemiCaseInfoReaderTrignet Constructor. 

    
UtsusemiCaseInfoReaderTrignet::UtsusemiCaseInfoReaderTrignet(std::string filename) UtsusemiCaseInfoReaderTrignet::UtsusemiCaseInfoReaderTrignet Constructor.
=============================================================================================================================================================

    Args:
        filename (std::string) path to CaseInfo.xml 
";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::~UtsusemiCaseInfoReaderTrignet "UtsusemiCaseInfoReaderTrignet::~UtsusemiCaseInfoReaderTrignet() UtsusemiCaseInfoReaderTrignet::~UtsusemiCaseInfoReaderTrignet Destructor. 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::Initialize "void UtsusemiCaseInfoReaderTrignet::Initialize() UtsusemiCaseInfoReaderTrignet::Initialize Initializes some parameters. 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::ImportCaseInfo "Int4 UtsusemiCaseInfoReaderTrignet::ImportCaseInfo(std::string filename=\"\") UtsusemiCaseInfoReaderTrignet::ImportCaseInfo Loads and stores CaseInfo.
=======================================================================================================================================================

    Args:
        filename (std::string) path to CaseInfo.xml 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::PutTrignetInfo "std::vector< std::vector< UtsusemiTrignetCondGroup * > * > * UtsusemiCaseInfoReaderTrignet::PutTrignetInfo() UtsusemiCaseInfoReaderTrignet::PutTrignetInfo Puts whole stored information.
==========================================================================================================================================================================================

    Args:
        None

    Returns:
        Cases including Array for Condition-Group 

    
std::vector< UtsusemiTrignetCondGroup * > * UtsusemiCaseInfoReaderTrignet::PutTrignetInfo(UInt4 caseId) UtsusemiCaseInfoReaderTrignet::PutTrignetInfo Puts stored information by a given caseId.
=================================================================================================================================================================================================

    Args:
        caseId (UInt4) caseId

    Returns:
        Array for Condition-Group 
";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::PutTrignetCounterInfo "std::vector< UtsusemiTrignetCounter * > * UtsusemiCaseInfoReaderTrignet::PutTrignetCounterInfo() UtsusemiCaseInfoReaderTrignet::PutTrignetCounterInfo Puts stored information by a given caseId.
=================================================================================================================================================================================================

    Returns:
        instance of UtsusemiTrignetCounter 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::PutNumOfCases "UInt4 UtsusemiCaseInfoReaderTrignet::PutNumOfCases(bool isOnlyFilter=false) UtsusemiCaseInfoReaderTrignet::PutNumOfCases Puts the number of cases read in ImportCaseInfo.
==========================================================================================================================================================================

    Args:
        None

    Returns:
        the number of stored cases 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::PutNumOfEachCases "std::pair< UInt4, UInt4 > UtsusemiCaseInfoReaderTrignet::PutNumOfEachCases() UtsusemiCaseInfoReaderTrignet::PutNumOfEachCases Puts the number of cases both the filter and the counter in CaseInfo.
====================================================================================================================================================================================================
    returns first: the number of filter conditions, second: that of counter conditions

    Args:
        None

    Returns:
        the number of the filter conditions and the counter conditions 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::DumpCases "void UtsusemiCaseInfoReaderTrignet::DumpCases(UInt4 caseId=0) UtsusemiCaseInfoReaderTrignet::DumpCases Dumps stored Filter information briefly.
================================================================================================================================================

    Args:
        caseId (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::DumpCases2 "void UtsusemiCaseInfoReaderTrignet::DumpCases2(UInt4 caseId=0) UtsusemiCaseInfoReaderTrignet::DumpCases2 Dumps stored Filter information briefly.
==================================================================================================================================================

    Args:
        caseId (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiCaseInfoReaderTrignet::DumpTrignetCounter "void UtsusemiCaseInfoReaderTrignet::DumpTrignetCounter() UtsusemiCaseInfoReaderTrignet::DumpTrignetCounter Dumps stored Counter information briefly.
=====================================================================================================================================================

    Args:
        None

    Returns:
        None 

";
// File: classUtsusemiCheckDataProcess.xml

%feature("docstring") UtsusemiCheckDataProcess "

    Treat the process information of data reduction steps.
    This enables to check the data reduction process of the data container. The header of the data container includes the information that what data reduction steps are done on the data. The data reduction functions can treat the process information by this class to avoid doing same data reduction on the data.
    C++ includes: UtsusemiCheckDataProcess.hh 

";
%feature("docstring") UtsusemiCheckDataProcess::UtsusemiCheckDataProcess "UtsusemiCheckDataProcess::UtsusemiCheckDataProcess() UtsusemiCheckDataProcess::UtsusemiCheckDataProcess Constructor. 

";
%feature("docstring") UtsusemiCheckDataProcess::~UtsusemiCheckDataProcess "UtsusemiCheckDataProcess::~UtsusemiCheckDataProcess() UtsusemiCheckDataProcess::~UtsusemiCheckDataProcess Destructor. 

";
%feature("docstring") UtsusemiCheckDataProcess::CheckProcess "bool UtsusemiCheckDataProcess::CheckProcess(ElementContainerMatrix *ecm, std::string process, bool isExact=true) UtsusemiCheckDataProcess::CheckProcess Checks the process of the data (ElementContainerMatrix)
================================================================================================================================================================================================================

    Args:
        ecm (ElementCotainerMatrix) The target data container.
        process (std::string) The key of the process.
        isExact (bool) If the given process key is required to be exactly correct, this is true. If there si ambiguity of the key, false.

    Returns:
        true The process has already been done on the data
        false The process has not yet 

    
bool UtsusemiCheckDataProcess::CheckProcess(ElementContainerArray *eca, std::string process, bool isExact=true) UtsusemiCheckDataProcess::CheckProcess Checks the process of the data (ElementContainerArray)
==============================================================================================================================================================================================================

    Args:
        ecm (ElementCotainerArray) The target data container.
        process (std::string) The key of the process.
        isExact (bool) If the given process key is required to be exactly correct, this is true. If there si ambiguity of the key, false.

    Returns:
        true The process has already been done on the data
        false The process has not yet 
    
bool UtsusemiCheckDataProcess::CheckProcess(ElementContainer *ec, std::string process, bool isExact=true) UtsusemiCheckDataProcess::CheckProcess Checks the process of the data (ElementContainer)
===================================================================================================================================================================================================

    Args:
        ecm (ElementCotainer) The target data container.
        process (std::string) The key of the process.
        isExact (bool) If the given process key is required to be exactly correct, this is true. If there si ambiguity of the key, false.

    Returns:
        true The process has already been done on the data
        false The process has not yet 
";
%feature("docstring") UtsusemiCheckDataProcess::AddProcess "void UtsusemiCheckDataProcess::AddProcess(ElementContainerMatrix *ecm, std::string process) UtsusemiCheckDataProcess::AddProcess Add the process of the data to the data container (ElementContainerMatrix)
============================================================================================================================================================================================================

    Args:
        ecm (ElementCotainerMatrix) The target data container.
        process (std::string) The key of the process.

    Returns:
        None 

    
void UtsusemiCheckDataProcess::AddProcess(ElementContainerArray *eca, std::string process) UtsusemiCheckDataProcess::AddProcess Add the process of the data to the data container (ElementContainerArray)
==========================================================================================================================================================================================================

    Args:
        ecm (ElementCotainerArray) The target data container.
        process (std::string) The key of the process.

    Returns:
        None 
    
void UtsusemiCheckDataProcess::AddProcess(ElementContainer *ec, std::string process) UtsusemiCheckDataProcess::AddProcess Add the process of the data to the data container (ElementContainer)
===============================================================================================================================================================================================

    Args:
        ecm (ElementCotainer) The target data container.
        process (std::string) The key of the process.

    Returns:
        None 
";
%feature("docstring") UtsusemiCheckDataProcess::RemoveProcess "void UtsusemiCheckDataProcess::RemoveProcess(ElementContainerMatrix *ecm, std::string process, bool isExact=true) UtsusemiCheckDataProcess::RemoveProcess Remove the process of the data from the data container (ElementContainerMatrix)
==========================================================================================================================================================================================================================================

    Args:
        ecm (ElementCotainerMatrix) The target data container.
        process (std::string) The key of the process.
        isExact (bool) If the given process key is required to be exactly correct, this is true. If there si ambiguity of the key, false.

    Returns:
        None 

    
void UtsusemiCheckDataProcess::RemoveProcess(ElementContainerArray *eca, std::string process, bool isExact=true) UtsusemiCheckDataProcess::RemoveProcess Remove the process of the data from the data container (ElementContainerArray)
========================================================================================================================================================================================================================================

    Args:
        ecm (ElementCotainerArray) The target data container.
        process (std::string) The key of the process.
        isExact (bool) If the given process key is required to be exactly correct, this is true. If there si ambiguity of the key, false.

    Returns:
        None 
    
void UtsusemiCheckDataProcess::RemoveProcess(ElementContainer *ec, std::string process, bool isExact=true) UtsusemiCheckDataProcess::RemoveProcess Remove the process of the data from the data container (ElementContainer)
=============================================================================================================================================================================================================================

    Args:
        ecm (ElementCotainer) The target data container.
        process (std::string) The key of the process.
        isExact (bool) If the given process key is required to be exactly correct, this is true. If there si ambiguity of the key, false.

    Returns:
        None 
";
// File: classUtsusemiContainerTextConverter.xml

%feature("docstring") UtsusemiContainerTextConverter "

    Save data in Manyo Containers as text file.
    C++ includes: UtsusemiContainerTextConverter.hh 

";
%feature("docstring") UtsusemiContainerTextConverter::UtsusemiContainerTextConverter "UtsusemiContainerTextConverter::UtsusemiContainerTextConverter() UtsusemiContainerTextConverter::UtsusemiContainerTextConverter Constructor. 

    
UtsusemiContainerTextConverter::UtsusemiContainerTextConverter(ElementContainer *_EC) UtsusemiContainerTextConverter::UtsusemiContainerTextConverter Constructor.
==================================================================================================================================================================

    Args:
        _EC (ElementContainer) Target data container 
    
UtsusemiContainerTextConverter::UtsusemiContainerTextConverter(ElementContainerArray *_ECA) UtsusemiContainerTextConverter::UtsusemiContainerTextConverter Constructor.
========================================================================================================================================================================

    Args:
        _EC (ElementContainerArray) Target data container 
    
UtsusemiContainerTextConverter::UtsusemiContainerTextConverter(ElementContainerMatrix *_ECM) UtsusemiContainerTextConverter::UtsusemiContainerTextConverter Constructor.
=========================================================================================================================================================================

    Args:
        _EC (ElementContainerMatrix) Target data container 
";
%feature("docstring") UtsusemiContainerTextConverter::~UtsusemiContainerTextConverter "UtsusemiContainerTextConverter::~UtsusemiContainerTextConverter() UtsusemiContainerTextConverter::~UtsusemiContainerTextConverter Destructor. 

";
%feature("docstring") UtsusemiContainerTextConverter::SetTarget "void UtsusemiContainerTextConverter::SetTarget(ElementContainer *_EC) UtsusemiContainerTextConverter::SetTarget Set the target data container (ElementContainer)
=================================================================================================================================================================

    Args:
        _EC (ElementCotainer) The target data container.

    Returns:
        None 

    
void UtsusemiContainerTextConverter::SetTarget(ElementContainerArray *_ECA) UtsusemiContainerTextConverter::SetTarget Set the target data container (ElementContainerArray)
============================================================================================================================================================================

    Args:
        _ECA (ElementCotainerArray) The target data container.

    Returns:
        None 
    
void UtsusemiContainerTextConverter::SetTarget(ElementContainerMatrix *_ECM) UtsusemiContainerTextConverter::SetTarget Set the target data container (ElementContainerMatrix)
==============================================================================================================================================================================

    Args:
        _ECM (ElementCotainerMatrix) The target data container.

    Returns:
        None 
";
%feature("docstring") UtsusemiContainerTextConverter::Save "bool UtsusemiContainerTextConverter::Save(std::string filename) UtsusemiContainerTextConverter::Save Save the data set as the target to the file.
==================================================================================================================================================

    Args:
        filename (std::string) The file path of the file to be saved.

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiContainerTextConverter::Save(std::string filename, ElementContainer *_EC) UtsusemiContainerTextConverter::Save Save the given data to the file.
=============================================================================================================================================================

    Args:
        filename (std::string) The file path of the file to be saved.
        _EC (ElementContainer) The target data container

    Returns:
        true succeeded.
        false failed. 
    
bool UtsusemiContainerTextConverter::Save(std::string filename, ElementContainerArray *_ECA) UtsusemiContainerTextConverter::Save Save the given data to the file.
===================================================================================================================================================================

    Args:
        filename (std::string) The file path of the file to be saved.
        _ECA (ElementContainerArray) The target data container

    Returns:
        true succeeded.
        false failed. 
    
bool UtsusemiContainerTextConverter::Save(std::string filename, ElementContainerMatrix *_ECM) UtsusemiContainerTextConverter::Save Save the given data to the file.
====================================================================================================================================================================

    Args:
        filename (std::string) The file path of the file to be saved.
        _ECM (ElementContainerMatrix) The target data container

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiContainerTextConverter::Load "bool UtsusemiContainerTextConverter::Load(std::string filename, ElementContainer *_EC) UtsusemiContainerTextConverter::Load Load the data from the given file.
===============================================================================================================================================================

    Args:
        filename (std::string) The file path of the file saved.
        _EC (ElementContainer) The returned data container (give the empty contaienr)

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiContainerTextConverter::Load(std::string filename, ElementContainerArray *_ECA) UtsusemiContainerTextConverter::Load Load the data from the given file.
=====================================================================================================================================================================

    Args:
        filename (std::string) The file path of the file saved.
        _ECA (ElementContainerArray) The returned data container (give the empty container)

    Returns:
        true succeeded.
        false failed. 
    
bool UtsusemiContainerTextConverter::Load(std::string filename, ElementContainerMatrix *_ECM) UtsusemiContainerTextConverter::Load Load the data from the given file.
======================================================================================================================================================================

    Args:
        filename (std::string) The file path of the file saved.
        _ECM (ElementContainerMatrix) The returned data container (give the empty contaienr)

    Returns:
        true succeeded.
        false failed. 
";
// File: classUtsusemiD4Matrix.xml

%feature("docstring") UtsusemiD4Matrix "

    Class for treating 4-dimensional data.
    This can import and conbine several data of single crystal sample with dirrent conditions produced from VisualCont2.
    C++ includes: UtsusemiD4Matrix.hh 

";
%feature("docstring") UtsusemiD4Matrix::UtsusemiD4Matrix "UtsusemiD4Matrix::UtsusemiD4Matrix() UtsusemiD4Matrix::UtsusemiD4Matrix Constructor. 

    
UtsusemiD4Matrix::UtsusemiD4Matrix(bool isDebugMode) UtsusemiD4Matrix::UtsusemiD4Matrix Constructor.
=====================================================================================================

    Args:
        isDebugMode shows some comments and parameters on executing. 
";
%feature("docstring") UtsusemiD4Matrix::~UtsusemiD4Matrix "UtsusemiD4Matrix::~UtsusemiD4Matrix() UtsusemiD4Matrix::~UtsusemiD4Matrix Destructor. 

";
%feature("docstring") UtsusemiD4Matrix::SetEf "bool UtsusemiD4Matrix::SetEf(double _ef) UtsusemiD4Matrix::SetEf Sets Ef which is used to caculate the energy transfer for the inverted geometry instruments.
==============================================================================================================================================================

    Args:
        _ef (Double) Ef [meV]

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix::PutEf "Double UtsusemiD4Matrix::PutEf() UtsusemiD4Matrix::PutEf Puts Ef which is used to caculate the energy transfer for the inverted geometry instruments.
======================================================================================================================================================

    Args:
        None

    Returns:
        Ef 

";
%feature("docstring") UtsusemiD4Matrix::SetMaxSizeOfBlock "void UtsusemiD4Matrix::SetMaxSizeOfBlock(Double _size) UtsusemiD4Matrix::SetMaxSizeOfBlock Sets maximum file size for one block of allocated D4Matrix binary file.
===================================================================================================================================================================
    All file size can not be exceeded this size

    Args:
        _size (Double) maximum file size

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::AllocateNewMat "void UtsusemiD4Matrix::AllocateNewMat(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > titles, std::vector< std::string > units, std::string data_dir, std::string paramfile) UtsusemiD4Matrix::AllocateNewMat Makes new D4Matrix files on disk.
=======================================================================================================================================================================================================================================================================================================================================================
    Each range consists of three values, start, end and width.

    Args:
        a1range (std::vector<Double>) first axis range
        a2range (std::vector<Double>) second axis range
        a3range (std::vector<Double>) third axis range
        a4range (std::vector<Double>) fourth axis range
        titles (std::vector<std::string>) titles for axes
        units (std::vector<std::string>) units for axes
        data_dir (std::string) path to data dir (including xml file)
        paramfile (std::string) file name of parameter xml file

    Returns:
        None 

    
bool UtsusemiD4Matrix::AllocateNewMat(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *titles, PyObject *units, std::string data_dir, std::string paramfile) UtsusemiD4Matrix::AllocateNewMat Makes new D4Matrix files on disk.
=====================================================================================================================================================================================================================================================================
    Each range consists of three values, start, end and width.

    Args:
        a1range (PyObject float list) first axis range
        a2range (PyObject float list) second axis range
        a3range (PyObject float list) third axis range
        a4range (PyObject float list) fourth axis range
        titles (PyObject str list) titles for axes
        units (PyObject str list) units for axes
        data_dir (std::string) path to data dir (including xml file)
        paramfile (std::string) file name of parameter xml file

    Returns:
        False Failed.
        True Succeeded. 
";
%feature("docstring") UtsusemiD4Matrix::OpenMat "bool UtsusemiD4Matrix::OpenMat(std::string datapath, std::string paramfile) UtsusemiD4Matrix::OpenMat Open D4Matrix files existing on disk.
============================================================================================================================================
    Read parameter file and open file pointers given by parameters.

    Args:
        datapath (std::string) The path to data dir
        paramfile (std::string) The file name of parameter xml file

    Returns:
        False Failed.
        True Succeeded. 

";
%feature("docstring") UtsusemiD4Matrix::CloseMat "void UtsusemiD4Matrix::CloseMat() UtsusemiD4Matrix::CloseMat Closes opened D4Matrix files.
===========================================================================================
    Close all file pointers opened by _OpenDat method.

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::isMatOpened "bool UtsusemiD4Matrix::isMatOpened() UtsusemiD4Matrix::isMatOpened Returns whether D4Matrix files are opened or not.
=====================================================================================================================

    Args:
        None

    Returns:
        true D4Matrix files are opened.
        false Not opened. 

";
%feature("docstring") UtsusemiD4Matrix::isStatusOK "bool UtsusemiD4Matrix::isStatusOK() UtsusemiD4Matrix::isStatusOK Returns status of results to be executed.
===========================================================================================================

    Args:
        None

    Returns:
        true OK.
        false Bad. 

";
%feature("docstring") UtsusemiD4Matrix::AddToMatFromText "void UtsusemiD4Matrix::AddToMatFromText(std::string filename) UtsusemiD4Matrix::AddToMatFromText Adds TEXT data to D4Matrix files.
===================================================================================================================================
    Read TEXT data produced by VisualCont2 and add these values to D4Matrix files

    Args:
        filename (std::string) The full path to the text data file

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::AddToMatFromPyList "Int4 UtsusemiD4Matrix::AddToMatFromPyList(std::string title, PyObject *ax1, PyObject *ax2, PyObject *ax3, PyObject *ax4, PyObject *ii, PyObject *ee) UtsusemiD4Matrix::AddToMatFromPyList Adds python List object data to D4Matrix files.
==========================================================================================================================================================================================================================================
    Adds Sliced data produced by VisualCont2 to D4Matrix files

    Args:
        title (std::string) Title for this data
        ax1 (PyObject float list) AX1
        ax2 (PyObject float list) AX2
        ax3 (PyObject float list) AX3
        ax4 (PyObject float list) AX4
        ii (PyObject float list) Intensity
        ee (PyObject float list) Error

    Returns:
        0 No Error
        -1 Error 

";
%feature("docstring") UtsusemiD4Matrix::SubtractFromMatByText "void UtsusemiD4Matrix::SubtractFromMatByText(std::string filename) UtsusemiD4Matrix::SubtractFromMatByText Subtracts TEXT data from D4Matrix files.
====================================================================================================================================================
    Read TEXT data produced by VisualCont2 and subtract these values from D4Matrix files

    Args:
        filename (std::string) The full path to the text data file

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::AddToMatFromBin "bool UtsusemiD4Matrix::AddToMatFromBin(std::string filename) UtsusemiD4Matrix::AddToMatFromBin Adds BINARY data to D4Matrix files.
===================================================================================================================================
    Read binary data converted by VisualCont2 funcion to add these data into D4Matrix files

    Args:
        filename (std::string) The full path to the binary data file

    Returns:
        False Failed.
        True Succeeded. 

";
%feature("docstring") UtsusemiD4Matrix::AddToMatFromBinFolder "bool UtsusemiD4Matrix::AddToMatFromBinFolder(std::string folderpath, std::string _ext=\".vbin\") UtsusemiD4Matrix::AddToMatFromBinFolder Adds D4Mat vbin files in the given \"folderpath\" folder.
===================================================================================================================================================================================================
    Read binary data converted by VisualCont2 funcion to add these data into D4Matrix files

    Args:
        folderpath (std::string) the full path to the folder
        _ext (std::string) the extention code for the binary files

    Returns:
        true Succeeded.
        false Failed. 

";
%feature("docstring") UtsusemiD4Matrix::SubtractFromMatByBin "void UtsusemiD4Matrix::SubtractFromMatByBin(std::string filename) UtsusemiD4Matrix::SubtractFromMatByBin Subtracts BINARY data from D4Matrix files.
====================================================================================================================================================
    Read binary data converted from TEXT data of VisualCont2 and subtract these values from D4Matrix files

    Args:
        filename (std::string) The full path to the binary data

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::SliceMat "void UtsusemiD4Matrix::SliceMat(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > def_axes, std::vector< Double > foldings) UtsusemiD4Matrix::SliceMat Slices D4Matrix by the given ranges and types of axes as 2D data.
==============================================================================================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\" and \"T\". \"X\" and \"Y\" mean X and Y axis on the visualization. Other two axes, must be indicated by \"T\", are summarized. Each range must consits of two values, begin and end;

    Args:
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<std::string>) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (std::vector<Double>) folding values, [] means [ -1, -1, -1, -1]

    Returns:
        False Failed.
        True Succeeded. 

    
bool UtsusemiD4Matrix::SliceMat(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings) UtsusemiD4Matrix::SliceMat Slices D4Matrix by the given ranges and types of axes as 2D data.
=================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\" and \"T\". \"X\" and \"Y\" mean X and Y axis on visualization. Other two axes, must be indicated by \"T\", are summarized. Each range must consits of two values, begin and end;

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]

    Returns:
        False Failed.
        True Succeeded. 
";
%feature("docstring") UtsusemiD4Matrix::SliceMat1d "void UtsusemiD4Matrix::SliceMat1d(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > def_axes, std::vector< Double > foldings) UtsusemiD4Matrix::SliceMat1d Slices D4Matrix by the given ranges and types of axes as 1D data (along an axis)
=================================================================================================================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\" and \"T\".
    Each range must consits of two values, begin and end;

    Args:
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<Double>) role of each axis, for example [ \"X\", \"T\", \"T\", \"T\" ]
        foldings (std::vector<Double>) folding values, [] means [ -1, -1, -1, -1]

    Returns:
        False Failed.
        True Succeeded. 

";
%feature("docstring") UtsusemiD4Matrix::Slice2d "bool UtsusemiD4Matrix::Slice2d(ElementContainerArray *_eca, PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings) UtsusemiD4Matrix::Slice2d Slices D4Matrix by parameters from Python.
=====================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\" and \"T\". \"X\" and \"Y\" mean X and Y axis on visualization. Two axes indicated by \"T\" are summarized. Each range must consits of two values, begin and end;

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]

    Returns:
        False Failed.
        True Succeeded. 

    
ElementContainerArray UtsusemiD4Matrix::Slice2d(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings) UtsusemiD4Matrix::Slice2d Slices D4Matrix by parameters from Python as 2D and returns the result as ElementContainerArray.
===============================================================================================================================================================================================================================================================================================
    (Not recomended) Slice2d (ElementContainerArray, ...) shoud be used instead of this method. Each range must consits of two values, begin and end;

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]

    Returns:
        False Failed.
        True Succeeded. 
";
%feature("docstring") UtsusemiD4Matrix::PutSliceResults "std::vector< Double > UtsusemiD4Matrix::PutSliceResults(UInt4 type, UInt4 Xindex) UtsusemiD4Matrix::PutSliceResults Put Sliced data as std::vector.
====================================================================================================================================================
    Put std::vector made by SliceMat. This method puts a vector with X index.'type' indicates the type of data.

    Args:
        type (UInt4) This indicates data type 0:Intensity, 1:Error, 2:X array, 3:Y array
        Xindex (UInt4) This indicates index of vectors of Intensity and Error.

    Returns:
        std::string std::vector 

";
%feature("docstring") UtsusemiD4Matrix::PickUpInten "std::vector< Double > UtsusemiD4Matrix::PickUpInten(Double a1, Double a2, Double a3, Double a4) UtsusemiD4Matrix::PickUpInten Picks up data at a point on D4Matrix.
====================================================================================================================================================================
    Picks up data at a point indicated by given parameters and show its intensity and error.

    Args:
        a1 (Double) A1 axis
        a2 (Double) A2 axis
        a3 (Double) A3 axis
        a4 (Double) A4 axis

    Returns:
        std::vector of two values for intensity and error. 

";
%feature("docstring") UtsusemiD4Matrix::ReplaceInten "void UtsusemiD4Matrix::ReplaceInten(Double a1, Double a2, Double a3, Double a4, Double Inten, Double Error, Double Counts) UtsusemiD4Matrix::ReplaceInten Replaces data at a point on D4Matrix.
================================================================================================================================================================================================
    Replaces data at a point indicated by given parameters with given Intensity, Error and Counts.

    Args:
        a1 (Double) A1 axis
        a2 (Double) A2 axis
        a3 (Double) A3 axis
        a4 (Double) A4 axis
        Inten (Double) Value for Intensity to be replaced
        Error (Double) Value for Error to be replaced
        Counts (Double) Value for the number of summarized data

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::PutSlicedECA "ElementContainerArray UtsusemiD4Matrix::PutSlicedECA() UtsusemiD4Matrix::PutSlicedECA Puts Sliced data as ElementContainerArray.
=================================================================================================================================
    Sliced data are stored in list of vectors. This method constructs ElementContainerArray from these vectors. ElementContainerArray can be sent to M2Plot directly.

    Args:
        None

    Returns:
        ElementContainerArray 

";
%feature("docstring") UtsusemiD4Matrix::PutFileComponents "std::vector< std::string > UtsusemiD4Matrix::PutFileComponents() UtsusemiD4Matrix::PutFileComponents Puts list for file component of D4Matrix.
===============================================================================================================================================

    Args:
        None

    Returns:
        file_components 

";
%feature("docstring") UtsusemiD4Matrix::PutAxRange "std::vector< Double > UtsusemiD4Matrix::PutAxRange(UInt4 i_ax) UtsusemiD4Matrix::PutAxRange Puts axis range.
=============================================================================================================
    Puts axis range in range_list by given index i_ax as std::vector

    Args:
        i_ax (UInt4) The index of axis

    Returns:
        range_list[ i_ax ] 

";
%feature("docstring") UtsusemiD4Matrix::PutAxTitle "std::string UtsusemiD4Matrix::PutAxTitle(UInt4 i_ax) UtsusemiD4Matrix::PutAxTitle Puts axis title.
===================================================================================================

    Args:
        i_ax (UInt4) The index of axis title

    Returns:
        ax_titles[ i_ax ] 

";
%feature("docstring") UtsusemiD4Matrix::SetAxTitle "void UtsusemiD4Matrix::SetAxTitle(UInt4 i_ax, std::string title) UtsusemiD4Matrix::SetAxTitle Sets axis title.
===============================================================================================================

    Args:
        i_ax (UInt4) The index of axis title
        title (std::string) The axis title

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::SetAxTitles "void UtsusemiD4Matrix::SetAxTitles(std::vector< std::string > titles, bool isSaved) UtsusemiD4Matrix::SetAxTitles Sets axis titles and save parames xml file.
==============================================================================================================================================================

    Args:
        titles (std::vector<std::string>) The list for axis titles
        isSaved (bool) The flag for save file after set of titles

    Returns:
        None 

    
void UtsusemiD4Matrix::SetAxTitles(PyObject *titles, bool isSaved) UtsusemiD4Matrix::SetAxTitles Sets axis titles and save parames xml file.
=============================================================================================================================================

    Args:
        titles (PyObject str list) The list for axis titles
        isSaved (bool) The flag for save file after set of titles

    Returns:
        None 
";
%feature("docstring") UtsusemiD4Matrix::PutAxUnit "std::string UtsusemiD4Matrix::PutAxUnit(UInt4 i_ax) UtsusemiD4Matrix::PutAxUnit Puts axis unit.
================================================================================================

    Args:
        i_ax (UInt4) The index of axis title

    Returns:
        ax_units[ i_ax ] 

";
%feature("docstring") UtsusemiD4Matrix::SetAxUnit "void UtsusemiD4Matrix::SetAxUnit(UInt4 i_ax, std::string title) UtsusemiD4Matrix::SetAxUnit Sets axis unit.
============================================================================================================

    Args:
        i_ax (UInt4) The index of axis unit
        title axis unit

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::SetAxUnits "void UtsusemiD4Matrix::SetAxUnits(std::vector< std::string > units, bool isSaved) UtsusemiD4Matrix::SetAxUnits Sets axis units and save parames xml file.
==========================================================================================================================================================

    Args:
        units (std::vector<std::string>) The list for axis units
        isSaved (bool) The flag for save file after set of units

    Returns:
        None 

    
void UtsusemiD4Matrix::SetAxUnits(PyObject *units, bool isSaved) UtsusemiD4Matrix::SetAxUnits Sets axis units and save parames xml file.
=========================================================================================================================================

    Args:
        units (PyObject std::string list) The list for axis units
        isSaved (bool) The flag for save file after set of units

    Returns:
        None 
";
%feature("docstring") UtsusemiD4Matrix::SavePyListToBin "void UtsusemiD4Matrix::SavePyListToBin(std::string filepath, PyObject *ax1, PyObject *ax2, PyObject *ax3, PyObject *ax4, PyObject *ii, PyObject *ee) UtsusemiD4Matrix::SavePyListToBin Saves List object on python to binary file.
===================================================================================================================================================================================================================================
    Saves given list object on python to binary file as the format to be loaded by AddToMatFromBin.

    Args:
        filepath (std::string) The file path of save binary file
        ax1 (PyObject float list) AX1
        ax2 (PyObject float list) AX2
        ax3 (PyObject float list) AX3
        ax4 (PyObject float list) AX4
        ii (PyObject float list) Intensity
        ee (PyObject float list) Error

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::AddMatToMat "void UtsusemiD4Matrix::AddMatToMat(std::string dir_from, std::string file_from, std::string dir_to, std::string file_to) UtsusemiD4Matrix::AddMatToMat Adds data of saved Matrix files to other Matrix data files.
===================================================================================================================================================================================================================
    This is mainly used for rebinning of matrix

    Args:
        dir_from (std::string) The directory path to original data
        file_from (std::string) The file name to original data
        dir_to (std::string) The directory path to new data
        file_to (std::string) The file name to new data

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::PutOpenedDataPath "std::vector< std::string > UtsusemiD4Matrix::PutOpenedDataPath() UtsusemiD4Matrix::PutOpenedDataPath Puts opened data path.
============================================================================================================================
    This pushes d4mat_data_dir and d4mat_param_file

    Args:
        None

    Returns:
        std::string std::vector including d4mat_data_dir and d4mat_param_file 

";
%feature("docstring") UtsusemiD4Matrix::GetPartOfD4Mat "Int4 UtsusemiD4Matrix::GetPartOfD4Mat(UInt4 fs_index, float data[], UInt4 top_posi, UInt4 get_size) UtsusemiD4Matrix::GetPartOfD4Mat Picks up the part of the binary data file.
================================================================================================================================================================================

    Args:
        fs_index (UInt4) The index of the opened d4mat bin files

    Returns:
        -1 Error that fs_index is too large
        -2 Error that top_posi is over the size of data
        -3 Error that the file is not opened.
        Int4 the result value of the fread function 

";
%feature("docstring") UtsusemiD4Matrix::SaveParamXml "Int4 UtsusemiD4Matrix::SaveParamXml(std::string datapath, std::string paramfilepath) UtsusemiD4Matrix::SaveParamXml Saves parameters to XML file.
==================================================================================================================================================

    Args:
        paramfilepath (std::string) The path to XML file of parameters

    Returns:
        0 No Error
        -1 Error 

";
%feature("docstring") UtsusemiD4Matrix::SliceMat3D "Int4 UtsusemiD4Matrix::SliceMat3D(ElementContainerMatrix *_ecm, std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > def_axes, std::vector< Double > foldings, std::vector< std::string > key_axes) UtsusemiD4Matrix::SliceMat3D Slices D4Matrix for 3D.
===========================================================================================================================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\", \"Z\" and \"T\". \"X\",\"Y\" and \"Z\" mean X, Y and Z axis on visualization. The other axis indicated by \"T\" are summarized. Each range must consits of two values, begin and end; SliceMat3D( dat, a1range, a2range, a3range, a4range, def_axes, foldings, key_axes );

    Args:
        data (ElementContainerMatrix) The result data
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<std::string>) role of each axis, for example [ \"X\", \"Y\", \"Z\", \"T\" ]
        foldings (std::vector<Double>) folding values, empty means [ -1, -1, -1, -1]
        key_axes (std::vector<std::string>) Key name for each range [ <KeyX>,<KeyY>,<KeyZ> ]

    Returns:
        False Failed.
        True Succeeded. 

    
bool UtsusemiD4Matrix::SliceMat3D(ElementContainerMatrix *_ecm, PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings, PyObject *key_axes) UtsusemiD4Matrix::SliceMat3D Slices D4Matrix for 3D.
=============================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\", \"Z\" and \"T\". \"X\",\"Y\" and \"Z\" mean X, Y and Z axis on visualization. The other axis indicated by \"T\" are summarized. Each range must consits of two values, begin and end; SliceMat3D( dat, a1range, a2range, a3range, a4range, def_axes, foldings, key_axes );

    Args:
        data (ElementContainerMatrix) The result data
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]
        key_axes (PyObject str list) Key name for each range [ <KeyX>,<KeyY>,<KeyZ> ]

    Returns:
        False Failed.
        True Succeeded. 
";
%feature("docstring") UtsusemiD4Matrix::Slice3d "bool UtsusemiD4Matrix::Slice3d(ElementContainerMatrix *_ecm, PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings, PyObject *key_axes) UtsusemiD4Matrix::Slice3d Slices D4Matrix for 3D.
=======================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\", \"Z\" and \"T\". \"X\",\"Y\" and \"Z\" mean X, Y and Z axis on visualization. The other axis indicated by \"T\" are summarized. Each range must consits of two values, begin and end; Slice3D( dat, a1range, a2range, a3range, a4range, def_axes, foldings, key_axes );

    Args:
        data (ElementContainerMatrix) The result data
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]
        key_axes (PyObject str list) Key name for each range [ <KeyX>,<KeyY>,<KeyZ> ]

    Returns:
        False Failed.
        True Succeeded. 

    
ElementContainerMatrix UtsusemiD4Matrix::Slice3d(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings, PyObject *key_axes) UtsusemiD4Matrix::Slice3d Slices D4Matrix for 3D (Not recommended using this. Use SliceMat3D instead.)
================================================================================================================================================================================================================================================================================================
    Picks up the region given by parameters from D4Matrix and make std::vector data for visualization. Users can set 4 axes ranges and the role of each axis by using std::string \"X\", \"Y\", \"Z\" and \"T\". \"X\",\"Y\" and \"Z\" mean X, Y and Z axis on visualization. The other axis indicated by \"T\" are summarized. Each range must consits of two values, begin and end; Slice3D(a1range, a2range, a3range, a4range, def_axes, foldings, key_axes);

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]
        key_axes (PyObject str list) Key name for each range [ <KeyX>,<KeyY>,<KeyZ> ]

    Returns:
        ElementContainerMatrix The sliced data 
";
%feature("docstring") UtsusemiD4Matrix::OutputText3D "Int4 UtsusemiD4Matrix::OutputText3D(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > def_axes, std::vector< Double > foldings, std::string filename, bool isIgnoreMaskVal=false, std::string maskValStr=\"\") UtsusemiD4Matrix::OutputText3D Slices as 3D axes data of D4Matrix to save as text file.
============================================================================================================================================================================================================================================================================================================================================================================================================
    OutputText3D( a1range, a2range, a3range, a4range, def_axes, foldings, filename, isIgnoreMaskVal, maskValStr );

    Args:
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<std::string>) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (std::vector<Double>) folding values, [] means [ -1, -1, -1, -1]
        isIgnoreMaskVal (bool) ignore mask values ( does not save mask value ) or not
        maskValStr (std::string) if isIgnoreMaskVal==False, this std::string is used as the mask value in text file.

    Returns:
        0 No trouble.
        -1 Failed to slice data.
        -2 Failed to calculate the reanges for the axes.
        -3 Failed to open the file to output. 

    
bool UtsusemiD4Matrix::OutputText3D(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings, std::string filename, bool isIgnoreMaskVal=false, std::string maskValStr=\"\") UtsusemiD4Matrix::OutputText3D Slices as 3D axes data of D4Matrix to save as text file.
===============================================================================================================================================================================================================================================================================================================================
    OutputText3D( a1range, a2range, a3range, a4range, def_axes, foldings, filename, isIgnoreMaskVal, maskValStr );

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]
        isIgnoreMaskVal (bool) ignore mask values ( does not save mask value ) or not
        maskValStr (str) if isIgnoreMaskVal==False, this std::string is used as the mask value in text file.

    Returns:
        True Succeeded.
        False Failed. 
";
%feature("docstring") UtsusemiD4Matrix::DumpD4MatToFile "Int4 UtsusemiD4Matrix::DumpD4MatToFile(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > def_axes, std::vector< Double > foldings, std::string filename, bool isText=true, bool isAve=true) UtsusemiD4Matrix::DumpD4MatToFile Saves D4Matrix to text or binary file.
==========================================================================================================================================================================================================================================================================================================================================================================
    DumpD4MatToFile( a1range, a2range, a3range, a4range, def_axes, foldings, filename, isText );

    Args:
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<std::string>) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (std::vector<Double>) folding values, [] means [ -1, -1, -1, -1]
        isText (bool) If True, save data as text file.
        isAve (bool) If False, the intensity of a bin is the summation of the counts.

    Returns:
        0 No trouble.
        -1 Failes to calculate the ranges for the axes. 

    
bool UtsusemiD4Matrix::DumpD4MatToFile(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings, std::string filename, bool isText=true, bool isAve=true) UtsusemiD4Matrix::DumpD4MatToFile Saves D4Matrix to text or binary file.
=============================================================================================================================================================================================================================================================================================
    DumpD4MatToFile( a1range, a2range, a3range, a4range, def_axes, foldings, filename, isText );

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]
        isText (bool) If True, save data as text file.
        isAve (bool) If False, the intensity of a bin is the summation of the counts.

    Returns:
        True Succeeded.
        False Failed. 
";
%feature("docstring") UtsusemiD4Matrix::DumpD4MatIntoVect "Int4 UtsusemiD4Matrix::DumpD4MatIntoVect(std::vector< Double > a1r, std::vector< Double > a2r, std::vector< Double > a3r, std::vector< Double > a4r, std::vector< std::string > def_axes, std::vector< Double > foldings, bool isAve, std::vector< Double > *ax1, std::vector< Double > *ax2, std::vector< Double > *ax3, std::vector< Double > *hws, std::vector< Double > *intensity, std::vector< Double > *error) UtsusemiD4Matrix::DumpD4MatIntoVect Put D4Matrix into given vectors on memory.
=====================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================
    The order of intensity :: for ihw in range(hws.size()): for i1 in range(ax1.size()): for i2 in range(ax2.size()): for i3 in range(ax3.size()): ind = i3 + (ax3.size() * i2) + (ax3.size() * ax2.size() * i1) + (ax3.size() * ax2.size() * ax1.size() * ihw) i1, i2, i3, ihw, intensity[ind], error[ind]
    DumpD4MatToFile( a1r, a2r, a3r, a4r, def_axes, foldings, isAve,                  ax1, ax2, ax3, hws, intensity, error );

    Args:
        a1r (std::vector<Double>) first axis range [min, max]
        a2r (std::vector<Double>) second axis range [min, max]
        a3r (std::vector<Double>) third axis range [min, max]
        a4r (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<std::string>) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (std::vector<Double>) folding values, [] means [ -1, -1, -1, -1]
        isAve (bool) If False, the intensity of a bin is the summation of the counts.
        ax1 (std::vector<Double>*) ax1 std::vector imported from D4Matrix data
        ax2 (std::vector<Double>*) ax2 std::vector imported from D4Matrix data
        ax3 (std::vector<Double>*) ax3 std::vector imported from D4Matrix data
        hws (std::vector<Double>*) hw std::vector imported from D4Matrix data
        intensity (std::vector<Double>*) intensity std::vector imported from D4Matrix data
        error (std::vector<Double>*) error std::vector imported from D4Matrix data

    Returns:
        0 No trouble.
        -1 Failes to calculate the ranges for the axes. 

    
bool UtsusemiD4Matrix::DumpD4MatIntoVect(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *def_axes, PyObject *foldings, bool isAve, std::vector< Double > *ax1, std::vector< Double > *ax2, std::vector< Double > *ax3, std::vector< Double > *ax4, std::vector< Double > *intensity, std::vector< Double > *error) UtsusemiD4Matrix::DumpD4MatIntoVect Put D4Matrix into given vectors on memory.
========================================================================================================================================================================================================================================================================================================================================================================================================================================
    The order of intensity :: for ihw in range(hws.size()): for i1 in range(ax1.size()): for i2 in range(ax2.size()): for i3 in range(ax3.size()): ind = i3 + (ax3.size() * i2) + (ax3.size() * ax2.size() * i1) + (ax3.size() * ax2.size() * ax1.size() * ihw) i1, i2, i3, ihw, intensity[ind], error[ind]
    DumpD4MatToFile( a1range, a2range, a3range, a4range, def_axes, foldings, isAve,                  ax1, ax2, ax3, hws, intensity, error );

    Args:
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        def_axes (PyObject str list) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (PyObject float list) folding values, [] means [ -1, -1, -1, -1]
        isAve (bool) If False, the intensity of a bin is the summation of the counts.
        ax1 (std::vector<Double>*) ax1 std::vector imported from D4Matrix data
        ax2 (std::vector<Double>*) ax2 std::vector imported from D4Matrix data
        ax3 (std::vector<Double>*) ax3 std::vector imported from D4Matrix data
        hws (std::vector<Double>*) hw std::vector imported from D4Matrix data
        intensity (std::vector<Double>*) intensity std::vector imported from D4Matrix data
        error (std::vector<Double>*) error std::vector imported from D4Matrix data

    Returns:
        0 No trouble.
        -1 Failes to calculate the ranges for the axes. 
";
%feature("docstring") UtsusemiD4Matrix::_CalcVirtualAngleInfo "void UtsusemiD4Matrix::_CalcVirtualAngleInfo(std::string wfile, std::string dfile) UtsusemiD4Matrix::_CalcVirtualAngleInfo

    
void UtsusemiD4Matrix::_CalcVirtualAngleInfo(ElementContainerMatrix *_ecm) UtsusemiD4Matrix::_CalcVirtualAngleInfo
";
%feature("docstring") UtsusemiD4Matrix::SetRunNoForVirtualMatrix "bool UtsusemiD4Matrix::SetRunNoForVirtualMatrix(UInt4 runNo, PyObject *hwInfo) UtsusemiD4Matrix::SetRunNoForVirtualMatrix Sets the run number for the virtual matrix.
======================================================================================================================================================================

    Args:
        runNo (UInt4) The run number
        hwInfo (PyObject float list) hw information [Ei, delta_hw, hw_min, hw_max]

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix::AllocateVirtualMat "void UtsusemiD4Matrix::AllocateVirtualMat(std::vector< Double > latticeConst, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > rotateSteps, std::vector< Double > viewAxes, std::vector< Double > hwInfo, std::vector< Double > phiSteps, std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > titles, std::vector< std::string > units) UtsusemiD4Matrix::AllocateVirtualMat Makes Virtual Matrix in memory.
=============================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================
    AllocateVirtualMat( latticeConst, Uvec, Vvec, rotateSteps, viewAxes, phiSteps , a1range, a2range, a3range, a4range, titles )

    Args:
        latticeConst (std::vector<Double>) Lattice Constant [a,b,c,alpha,beta,gamma]
        Uvec (std::vector<Double>) U-vector
        Vvec (std::vector<Double>) V-vector
        rotateSteps (std::vector<Double>) Steps for rotation [ 1, -5 ] means -5 degree rotation aroung Y axis
        viewAxes (std::vector<Double>) List of matrix for axes projection
        hwInfo (std::vector<Double>) hw info [Ei, delta_hw, hw_min, hw_max]
        phiStep (std::vector<Double>) List of angles for sample orientations
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        titles (std::vector<std::string>) Titles
        units (std::vector<std::string>) Units

    Returns:
        None 

    
bool UtsusemiD4Matrix::AllocateVirtualMat(PyObject *latticeConst, PyObject *Uvec, PyObject *Vvec, PyObject *rotateSteps, PyObject *viewAxes, PyObject *phiSteps, PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *titles, PyObject *units) UtsusemiD4Matrix::AllocateVirtualMat Makes Virtual Matrix in memory.
=====================================================================================================================================================================================================================================================================================================================================================
    AllocateVirtualMat( latticeConst, Uvec, Vvec, rotateSteps, viewAxes, phiSteps , a1range, a2range, a3range, a4range, titles )

    Args:
        latticeConst (PyObject float list) Lattice Constant [a,b,c,alpha,beta,gamma]
        Uvec (PyObject float list) U-vector
        Vvec (PyObject float list) V-vector
        rotateSteps (PyObject float list) Steps for rotation [ 1, -5 ] means -5 degree rotation aroung Y axis
        viewAxes (PyObject float list) List of matrix for axes projection
        hwInfo (PyObject float list) hw info [Ei, delta_hw, hw_min, hw_max]
        phiStep (PyObject float list) List of angles for sample orientations
        a1range (PyObject float list) first axis range [min, max]
        a2range (PyObject float list) second axis range [min, max]
        a3range (PyObject float list) third axis range [min, max]
        a4range (PyObject float list) fourth axis range [min, max]
        titles (PyObject str list) Titles
        units (PyObject str list) Units

    Returns:
        True succeeded.
        False failed. 
";
%feature("docstring") UtsusemiD4Matrix::EstimateRangeOfVirtualMat "std::vector< Double > UtsusemiD4Matrix::EstimateRangeOfVirtualMat(std::vector< Double > latticeConst, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > rotateSteps, std::vector< Double > viewAxes, std::vector< Double > hwInfo, std::vector< Double > phiSteps) UtsusemiD4Matrix::EstimateRangeOfVirtualMat Estimates range of Virtual Matrix.
==============================================================================================================================================================================================================================================================================================================================================================================
    EstimateRangeOfVirtualMat( latticeConst, Uvec, Vvec, rotateSteps, viewAxes, phiSteps )

    Args:
        latticeConst (std::vector<Double>) Lattice Constant [a,b,c,alpha,beta,gamma]
        Uvec (std::vector<Double>) U-vector
        Vvec (std::vector<Double>) V-vector
        rotateSteps (std::vector<Double>) Steps for rotation [ 1, -5 ] means -5 degree rotation aroung Y axis
        viewAxes (std::vector<Double>) List of matrix for axes projection
        phiStep (std::vector<Double>) List of angles for sample orientations

    Returns:
        ranges for all axes (std::vector<Double>) 

    
PyObject * UtsusemiD4Matrix::EstimateRangeOfVirtualMat(PyObject *latticeConst, PyObject *Uvec, PyObject *Vvec, PyObject *rotateSteps, PyObject *viewAxes, PyObject *phiSteps) UtsusemiD4Matrix::EstimateRangeOfVirtualMat Estimates range of Virtual Matrix.
=============================================================================================================================================================================================================================================================
    EstimateRangeOfVirtualMat( latticeConst, Uvec, Vvec, rotateSteps, viewAxes, phiSteps )

    Args:
        latticeConst (PyObject float list) Lattice Constant [a,b,c,alpha,beta,gamma]
        Uvec (PyObject float list) U-vector
        Vvec (PyObject float list) V-vector
        rotateSteps (PyObject float list) Steps for rotation [ 1, -5 ] means -5 degree rotation aroung Y axis
        viewAxes (PyObject float list) List of matrix for axes projection
        phiStep (PyObject float list) List of angles for sample orientations

    Returns:
        ranges for all axes (PyObject float list) 
";
%feature("docstring") UtsusemiD4Matrix::SliceVirtualMat "void UtsusemiD4Matrix::SliceVirtualMat(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > def_axes, std::vector< Double > foldings) UtsusemiD4Matrix::SliceVirtualMat Slices the virtual matrix.
=====================================================================================================================================================================================================================================================================================================
    SliceVirtualMat(a1range, a2range, a3range, a4range, def_axes, foldings);

    Args:
        a1range (std::vector<Double>) first axis range [min, max]
        a2range (std::vector<Double>) second axis range [min, max]
        a3range (std::vector<Double>) third axis range [min, max]
        a4range (std::vector<Double>) fourth axis range [min, max]
        def_axes (std::vector<std::string>) role of each axis, for example [ \"X\", \"Y\", \"T\", \"T\" ]
        foldings (std::vector<std::string>) folding values, [] means [ -1, -1, -1, -1]

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix::isVirtualMode "bool UtsusemiD4Matrix::isVirtualMode() UtsusemiD4Matrix::isVirtualMode Checks whether the data is the virtual mode or not.
===========================================================================================================================

    Args:
        None

    Returns:
        true the data is the virtual mode.
        false the data is not virtual mode. 

";
%feature("docstring") UtsusemiD4Matrix::isDirectGeometry "bool UtsusemiD4Matrix::isDirectGeometry() UtsusemiD4Matrix::isDirectGeometry Checks whether the type of the instrument for the data is the direct geometry or not.
===================================================================================================================================================================

    Args:
        None

    Returns:
        true the direct geometry
        false the inverted geometry 

";
// File: classUtsusemiD4Matrix2.xml

%feature("docstring") UtsusemiD4Matrix2 "

    D4Mat on memory.
    C++ includes: UtsusemiD4Matrix2.hh 

";
%feature("docstring") UtsusemiD4Matrix2::UtsusemiD4Matrix2 "UtsusemiD4Matrix2::UtsusemiD4Matrix2() UtsusemiD4Matrix2::UtsusemiD4Matrix2 Constructor.
=========================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::~UtsusemiD4Matrix2 "UtsusemiD4Matrix2::~UtsusemiD4Matrix2() UtsusemiD4Matrix2::~UtsusemiD4Matrix2 Destructor.
==========================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::SetCrystalParametersToHeader "Int4 UtsusemiD4Matrix2::SetCrystalParametersToHeader(HeaderBase *head, std::vector< Double > LatticeConsts, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > Rvec) UtsusemiD4Matrix2::SetCrystalParametersToHeader Sets crystal parameters.
=========================================================================================================================================================================================================================================================================
    This sets crystal parameters to HeaderBase.

    Args:
        head (HeaderBase*) target HeaderBase
        LatticeConsts (std::vector<Double>) Lattice constants <a, b, c, alpha, beta, gamma>
        Uvec (std::vector<Double>) U std::vector (ki parallel std::vector in coordinate system inside sample)
        Vvec (std::vector<Double>) V std::vector (ki perpendicular in coordinate system inside sample)
        Rvec (std::vector<Double>) Rotation Steps

    Returns:
        0 no trouble
        -1 trouble happened. 

";
%feature("docstring") UtsusemiD4Matrix2::SetCrystalParametersFromInnerHead "bool UtsusemiD4Matrix2::SetCrystalParametersFromInnerHead(ElementContainerMatrix *ecm, Double phi=0.0) UtsusemiD4Matrix2::SetCrystalParametersFromInnerHead Sets crystal parameters from the crystal parameters stored in the header of given data container.
==============================================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix) Target data conatainer
        phi (Double) Rotation angle around Y-axis

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatParameters "Int4 UtsusemiD4Matrix2::SetD4MatParameters(Int4 runNo, std::vector< Double > dataRedParam, std::vector< Double > LatticeConsts, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > Rvec) UtsusemiD4Matrix2::SetD4MatParameters Sets D4Mat2 parameters into Header.
==============================================================================================================================================================================================================================================================================================
    This sets D4Mat2 parameters to HeaderBase.

    Args:
        runNo (Int4) runNo
        dataRedParam (std::vector<Double>) time_slice_start, time_slice_end, Ei, dHW, hw_min, hw_max, start_deg, end_deg, step_deg
        LatticeConsts (std::vector<Double>) Lattice constants <a, b, c, alpha, beta, gamma>
        Uvec (std::vector<Double>) U std::vector (ki parallel std::vector in coordinate system inside sample)
        Vvec (std::vector<Double>) V std::vector (ki perpendicular in coordinate system inside sample)
        Rvec (std::vector<Double>) Rotation Steps

    Returns:
        0 no trouble
        -1 trouble happened. 

    
bool UtsusemiD4Matrix2::SetD4MatParameters(Int4 runNo, PyObject *dataRedParam, PyObject *LatticeConsts, PyObject *Uvec, PyObject *Vvec, PyObject *Rvec) UtsusemiD4Matrix2::SetD4MatParameters Sets D4Mat2 parameters into Header.
==================================================================================================================================================================================================================================
    This sets D4Mat2 parameters to HeaderBase.

    Args:
        runNo (Int4) runNo
        dataRedParam (PyObject list) time_slice_start, time_slice_end, Ei, dHW, hw_min, hw_max, start_deg, end_deg, step_deg
        LatticeConsts (PyObject list) Lattice constants <a, b, c, alpha, beta, gamma>
        Uvec (PyObject list) U std::vector (ki parallel std::vector in coordinate system inside sample)
        Vvec (PyObject list) V std::vector (ki perpendicular in coordinate system inside sample)
        Rvec (PyObject list) Rotation Steps

    Returns:
        0 no trouble
        -1 trouble happened. 
";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatMode "bool UtsusemiD4Matrix2::SetD4MatMode(UInt4 mode) UtsusemiD4Matrix2::SetD4MatMode Sets D4Mat2 measurement mode ( Step-by-step mode / Continuous rotation mode )
===============================================================================================================================================================

    Args:
        mode (UInt4) 0:Continuous rotation mode / 1:Step-by-step mode

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatContinousMode "void UtsusemiD4Matrix2::SetD4MatContinousMode() UtsusemiD4Matrix2::SetD4MatContinousMode Sets D4Mat2 measurement mode ( Step-by-step mode / Continuous rotation mode )
=======================================================================================================================================================================

    Args:
        None

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatSampleInfo "bool UtsusemiD4Matrix2::SetD4MatSampleInfo(std::vector< Double > LatticeConsts, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > Rvec) UtsusemiD4Matrix2::SetD4MatSampleInfo Sets Sample information ( Lattice constants, U-vector, V-vector and rotations )
==========================================================================================================================================================================================================================================================================================

    Args:
        None
        LatticeConsts (std::vector<Double>) Lattice constants <a, b, c, alpha, beta, gamma>
        Uvec (std::vector<Double>) U std::vector (ki parallel std::vector in coordinate system inside sample)
        Vvec (std::vector<Double>) V std::vector (ki perpendicular in coordinate system inside sample)
        Rvec (std::vector<Double>) Rotation Steps

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiD4Matrix2::SetD4MatSampleInfo(PyObject *LatticeConsts, PyObject *Uvec, PyObject *Vvec, PyObject *Rvec) UtsusemiD4Matrix2::SetD4MatSampleInfo Sets Sample information ( Lattice constants, U-vector, V-vector and rotations )
==========================================================================================================================================================================================================================================

    Args:
        None
        LatticeConsts (PyObject list) Lattice constants <a, b, c, alpha, beta, gamma>
        Uvec (PyObject list) U std::vector (ki parallel std::vector in coordinate system inside sample)
        Vvec (PyObject list) V std::vector (ki perpendicular in coordinate system inside sample)
        Rvec (PyObject list) Rotation Steps

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionInfo "bool UtsusemiD4Matrix2::SetD4MatDataReductionInfo(std::vector< Double > dataRedParam) UtsusemiD4Matrix2::SetD4MatDataReductionInfo Sets D4Mat2 data reduction information.
===========================================================================================================================================================================

    Args:
        dataRedParam (std::vector<Double>) time_slice_start, time_slice_end, Ei, dHW, hw_min, hw_max, start_deg, end_deg, step_deg

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiD4Matrix2::SetD4MatDataReductionInfo(PyObject *dataRedParam) UtsusemiD4Matrix2::SetD4MatDataReductionInfo Sets D4Mat2 data reduction base information.
====================================================================================================================================================================

    Args:
        dataRedParam (PyObject list) time_slice_start, time_slice_end, Ei, dHW, hw_min, hw_max, start_deg, end_deg, step_deg

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionOptions "bool UtsusemiD4Matrix2::SetD4MatDataReductionOptions(std::string maskInfo, Double normFactor, std::string timeIndepBack=\"\", std::string detEffi=\"\", std::string script=\"\") UtsusemiD4Matrix2::SetD4MatDataReductionOptions Sets D4Mat2 data reduction option parameters.
===============================================================================================================================================================================================================================================================================

    Args:
        maskInfo (std::string) Path to MaskInfo file to be used.
        normFactor (Double) The factor for the nomalization
        timeIndepBack (std::string) The parameter for the time-independed background corrections
        detEffi (std::string) Path to the parameter file used for the detector efficiency correction
        script (std::string) Path to the script file used for the data reduction users want to do

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionContinuosAddRunNo "bool UtsusemiD4Matrix2::SetD4MatDataReductionContinuosAddRunNo(UInt4 runNo, Double startAngle) UtsusemiD4Matrix2::SetD4MatDataReductionContinuosAddRunNo Add run number and the start angle of the continuous rotation measurement to be used on its data reduction.
=====================================================================================================================================================================================================================================================================

    Args:
        runNo (UInt4) the run number of the measurement
        startAngle (Double) the start angle parameter for the measurement

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionContinuosClearRunNo "void UtsusemiD4Matrix2::SetD4MatDataReductionContinuosClearRunNo() UtsusemiD4Matrix2::SetD4MatDataReductionContinuosClearRunNo Delete all run numbers and start angles of the continuous rotation measurement.
===============================================================================================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetDeviceEncode "bool UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetDeviceEncode(std::string device) UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetDeviceEncode Set the device like \"BL01-TL\" of the continuous rotation measurement.
===================================================================================================================================================================================================================================

    Args:
        device (std::string) the name of the device \"BL01-TL\", \"BL14-TL\"

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetAnglePerEncode "bool UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetAnglePerEncode(Double ape) UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetAnglePerEncode Set the parameter used to calculate the angle from the encoded value from the raw data of the continuous rotation measurement.
======================================================================================================================================================================================================================================================================================

    Args:
        ape (Double) the conversion value from the counter value encoded from TrigNET event data to the angle.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetTrigNETDIO "bool UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetTrigNETDIO(UInt4 dio=1) UtsusemiD4Matrix2::SetD4MatDataReductionContinuosSetTrigNETDIO Set the dio signal used to encode from TrigNET event data to the counter value for the continuous rotation measurement.
========================================================================================================================================================================================================================================================================

    Args:
        dio (UInt4) DIO number of TrigNET to encode to the counter value.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionStepByStepGonioAtZero "bool UtsusemiD4Matrix2::SetD4MatDataReductionStepByStepGonioAtZero(Double gaz) UtsusemiD4Matrix2::SetD4MatDataReductionStepByStepGonioAtZero Set the parameter of the gonio-at-zero used to calculate the sample orientation for the step-by-step measurement.
===============================================================================================================================================================================================================================================================

    Args:
        gaz (Double) The gonio-at-zero value.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatDataReductionStepByStepAddRunAngles "void UtsusemiD4Matrix2::SetD4MatDataReductionStepByStepAddRunAngles(std::string runNos, double ang, double norm, double normFactor) UtsusemiD4Matrix2::SetD4MatDataReductionStepByStepAddRunAngles Add the measurement data information each angle for the step-by-step measurement.
=====================================================================================================================================================================================================================================================================================

    Args:
        runNos (std::string) Run numbers for an angle
        ang (Double) An angle
        norm (Double) The value for normalization (ex. the number of protons)
        normFactor (Double) The factor of the normalization correction

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo "bool UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo(std::vector< Double > PA) UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo Set the parameters for the projection.
==================================================================================================================================================================

    Args:
        PA (std::vector<Double>) The size of std::vector must be 16 |4x4|.

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo(PyObject *PA) UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo Set the parameters for the projection.
======================================================================================================================================================

    Args:
        PA (PyObject list) The size of list must be 16 |4x4|.

    Returns:
        true succeeded.
        false failed. 
    
bool UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo(std::vector< Double > PA, std::vector< std::string > titles, std::vector< std::string > units) UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo Set the parameters for the projection with the titles and the units.
=====================================================================================================================================================================================================================================================================

    Args:
        PA (std::vector<Double>) The size of list must be 16 |4x4|.
        titles (std::vector<std::string>) [Ax1, Ax2, Ax3, Energy]
        units (std::vector<std::string>) units of Ax1, Ax2, Ax3 and Energy

    Returns:
        true succeeded.
        false failed. 
    
bool UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo(PyObject *PA, PyObject *titles, PyObject *units) UtsusemiD4Matrix2::SetD4MatProjectionAxesInfo Set the parameters for the projection with the titles and the units.
=======================================================================================================================================================================================================================

    Args:
        PA (PyObject list of float) The size of list must be 16 |4x4|.
        titles (PyObject list of std::string) [Ax1, Ax2, Ax3, Energy]
        units (PyObject list of std::string) units of Ax1, Ax2, Ax3 and Energy

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatSliceAxis "bool UtsusemiD4Matrix2::SetD4MatSliceAxis(std::string _id, std::string _type, double _min, double _max, double _width, double _folding) UtsusemiD4Matrix2::SetD4MatSliceAxis Set the parameters for the slicing.
=================================================================================================================================================================================================================
    These parameters are used directly for calling UtsusemiSqeCalcXtalParams::SetSliceAxis.

    Args:
        _id (std::string) The index of axis
        _type (std::string) Type of axis, \"X\", \"Y\", \"Z\" and \"T\"
        _min (Double) The minimum value of the slicing range
        _max (Double) The maximum value of the slicing range
        _width (Double) The width of bin
        _folding (Double) The folding value

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SetD4MatRunNo "bool UtsusemiD4Matrix2::SetD4MatRunNo(Int4 runNo) UtsusemiD4Matrix2::SetD4MatRunNo Set the run number.
=======================================================================================================

    Args:
        runNo (Int4) the run number

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::PutD4MatRunNo "Int4 UtsusemiD4Matrix2::PutD4MatRunNo() UtsusemiD4Matrix2::PutD4MatRunNo Puts RunNo from D4Mat2 parameters in Header.
======================================================================================================================
    This return run number from D4Mat2 parameters in HeaderBase.

    Args:
        None

    Returns:
        runNo (Int4) 

";
%feature("docstring") UtsusemiD4Matrix2::PutD4MatDataRedParams "std::vector< Double > UtsusemiD4Matrix2::PutD4MatDataRedParams(bool fromData=false) UtsusemiD4Matrix2::PutD4MatDataRedParams Puts Data Reduction Parameters from Header.
=========================================================================================================================================================================
    This return data reduction parameters of D4Mat2 from HeaderBase.

    Args:
        fromDATA where is DR params obtained. True:From DATA False: from _HH

    Returns:
        std::vector<Double> 

";
%feature("docstring") UtsusemiD4Matrix2::PutD4MatLatticeConsts "std::vector< Double > UtsusemiD4Matrix2::PutD4MatLatticeConsts() UtsusemiD4Matrix2::PutD4MatLatticeConsts Puts Lattice Constants parameters from Header.
=========================================================================================================================================================
    This return lattice constants parameters of D4Mat2 from HeaderBase.

    Args:
        None

    Returns:
        std::vector<Double> 

";
%feature("docstring") UtsusemiD4Matrix2::PutD4MatUVvects "std::vector< Double > UtsusemiD4Matrix2::PutD4MatUVvects() UtsusemiD4Matrix2::PutD4MatUVvects Puts U-vector and V-vector parameters from Header.
=================================================================================================================================================
    This return U and V vectors of D4Mat2 from HeaderBase.

    Args:
        None

    Returns:
        std::vector<Double> 

";
%feature("docstring") UtsusemiD4Matrix2::ImportEcmsContRot "Int4 UtsusemiD4Matrix2::ImportEcmsContRot(UtsusemiEventDataConverterNeunet *EDC, const std::vector< UInt4 > CaseId, const std::vector< Double > Phi, const std::vector< Double > Kickers, const std::string maskfile, const Double dOmega, const Double normFactor, const std::string detEffi, const UInt4 reductCase=15) UtsusemiD4Matrix2::ImportEcmsContRot Import data after data reduction into D4Matrix on the continuous rotation method.
=================================================================================================================================================================================================================================================================================================================================================================================================================================================

    Args:
        EDC ( UtsusemiEventDataConverterNeunet) Instanse of UtsusemiEventDataConverterNeunet after loading event data with caseinfo.
        CaseId (std::vector<UInt4>) CaseID list used to pick a series of data at an angle
        Phi (std::vector<Double>) Angle list (the number of vector is same as that of CaseId)
        Kickers (std::vector<Double>) Kicker list used for normalization between data of angles
        maskfile (std::string) The path of maskinfo file
        dOmega (Double) The standard solid angle used for the solid angle correction
        normFactor (Double) The factor used to correct the normalization
        detEffi (std::string) The path to the data file used for the detector efficiency corrections
        reductCase (UInt4) The pattern of the data reduction proceedure

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiD4Matrix2::ImportEcmsContRot(UtsusemiEventDataConverterNeunet *EDC, PyObject *CaseId, PyObject *Phi, PyObject *Kickers, const std::string maskfile, const Double dOmega, const Double normFactor, const std::string detEffi, const UInt4 reductCase=15) UtsusemiD4Matrix2::ImportEcmsContRot Import data after data reduction into D4Matrix on the continuous rotation method on the Python codes.
================================================================================================================================================================================================================================================================================================================================================================================================================

    Args:
        EDC ( UtsusemiEventDataConverterNeunet) Instanse of UtsusemiEventDataConverterNeunet after loading event data with caseinfo.
        CaseId (PyObject int list) CaseID list used to pick a series of data at an angle
        Phi (PyObject float list) Angle list (the number of vector is same as that of CaseId)
        Kickers (PyObject float list) Kicker list used for normalization between data of angles.
        maskfile (std::string) The path of maskinfo file.
        dOmega (Double) The standard solid angle used for the solid angle correction.
        normFactor (Double) The factor used to correct the normalization
        detEffi (std::string) The path to the data file used for the detector efficiency corrections
        reductCase (UInt4) The pattern of the data reduction proceedure

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiD4Matrix2::ImportEcmsContRotPseudoOnLine "Int4 UtsusemiD4Matrix2::ImportEcmsContRotPseudoOnLine(UtsusemiEventDataMonitorNeunet *EDC, const std::vector< UInt4 > CaseId, const std::vector< Double > Phi, const std::string maskfile, const Double dOmega, const Double normFactor, const std::string detEffi, const bool isRefresh=false, const UInt4 reductCase=15) UtsusemiD4Matrix2::ImportEcmsContRotPseudoOnLine Import data after data reduction into D4Matrix on the continuous rotation method with on-line mode.
================================================================================================================================================================================================================================================================================================================================================================================================================================================================================

    Args:
        EDC ( UtsusemiEventDataMonitorNeunet) Instanse ofUtsusemiEventDataMonitorNeunet
        CaseId (std::vector<UInt4>) CaseID list used to pick a series of data at an angle
        Phi (std::vector<Double>) Angle list (the number of vector is same as that of CaseId)
        maskfile (std::string) The path of maskinfo file
        dOmega (Double) The standard solid angle used for the solid angle correction
        normFactor (Double) The factor used to correct the normalization
        detEffi (std::string) The path to the data file used for the detector efficiency corrections
        isRefresh (bool) The refresh mode of the on-line treatment.
        reductCase (UInt4) The pattern of the data reduction proceedure

    Returns:
        0 succeeded.
        -1 failed. 

";
%feature("docstring") UtsusemiD4Matrix2::ImportEcmContRot "bool UtsusemiD4Matrix2::ImportEcmContRot(ElementContainerMatrix *ecm, const UInt4 caseId, const double ang, const UInt4 reductCase=15) UtsusemiD4Matrix2::ImportEcmContRot Import data after data reduction into D4Matrix on the continuous rotation method (now used in on-line mode only)
============================================================================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix) The data to be imported
        CaseId (UInt4) CaseID of the given data
        ang (double) The angle of the given data
        reductCase (UInt4) The pattern of the data reduction proceedure

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::PutNumOfAngles "UInt4 UtsusemiD4Matrix2::PutNumOfAngles() UtsusemiD4Matrix2::PutNumOfAngles Put the number of angles.
======================================================================================================

    Args:
        None

    Returns:
        the number of angles 

";
%feature("docstring") UtsusemiD4Matrix2::ExportDataAsEcm "bool UtsusemiD4Matrix2::ExportDataAsEcm(ElementContainerMatrix *ecm, UInt4 index) UtsusemiD4Matrix2::ExportDataAsEcm Export the data of a single angle as ElementContainerMatrix from the imported data set.
=============================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix) The data to be imported
        index (UInt4) the index of the imported data set, maximum is PutNumOfAngles() - 1

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::ReplaceIntensityWithEcm "bool UtsusemiD4Matrix2::ReplaceIntensityWithEcm(ElementContainerMatrix *ecm, UInt4 index) UtsusemiD4Matrix2::ReplaceIntensityWithEcm Replace the intensity of the inside data set with the given ElementContainerMatrix with its index.
========================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix) The data to be imported
        index (UInt4) the index of a data set to be replaced, maximum is PutNumOfAngles() - 1

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::AllocateD4MatPseudoOnLine "void UtsusemiD4Matrix2::AllocateD4MatPseudoOnLine(UInt4 num_of_cases) UtsusemiD4Matrix2::AllocateD4MatPseudoOnLine Allocate D4Mat data for on-line mode.
=========================================================================================================================================================

    Args:
        num_of_cases (UInt4) The number of CaseIds

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::RemoveEcm "Int4 UtsusemiD4Matrix2::RemoveEcm(UInt4 runNo) UtsusemiD4Matrix2::RemoveEcm Removes ElementContainer.
======================================================================================================
    This removes one ElementContainer by given runNo RemoveEcm( UInt4 runNo );

    Args:
        runNo (UInt4) the run number to be removed from D4Mat2 data

    Returns:
        0 no trouble 

    
Int4 UtsusemiD4Matrix2::RemoveEcm(std::string label) UtsusemiD4Matrix2::RemoveEcm Removes ElementContainer.
============================================================================================================
    This removes one ElementContainer by given label RemoveEcm( std::string label );

    Args:
        label (std::string) The label of the data to be removed.

    Returns:
        0 no trouble 
";
%feature("docstring") UtsusemiD4Matrix2::ClearAll "void UtsusemiD4Matrix2::ClearAll() UtsusemiD4Matrix2::ClearAll Clears D4Mat.
=============================================================================
    This resets D4Mat

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::_putQvectorsFromData "void UtsusemiD4Matrix2::_putQvectorsFromData(D4MatOne *ec, std::vector< float > *Vx, std::vector< float > *Vy, std::vector< float > *Vz, std::vector< float > *Vw) UtsusemiD4Matrix2::_putQvectorsFromData

";
%feature("docstring") UtsusemiD4Matrix2::_Slice2D "bool UtsusemiD4Matrix2::_Slice2D(ElementContainerArray *eca, std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< std::string > type, std::vector< Double > folding, std::vector< std::string > axunits) UtsusemiD4Matrix2::_Slice2D

";
%feature("docstring") UtsusemiD4Matrix2::Slice2d "bool UtsusemiD4Matrix2::Slice2d(ElementContainerArray *eca, PyObject *Ax1, PyObject *Ax2, PyObject *Ax3, PyObject *Ax4, PyObject *DiagFolding, PyObject *AxUnits) UtsusemiD4Matrix2::Slice2d Slices D4Mat by given parameters.
===============================================================================================================================================================================================================================
    This slices D4Mat by given parametes to make ElementContainerArray as result

    Args:
        eca (ElementContainerArray) The sliced data to be returned (The given data must be empty.)
        Ax1 (PyObject list) slice info of axis 1 [ \"type\", min, max, width[, folding] ] where \"type\" is \"x\",\"y\",\"z\" or \"t\",
        Ax2 (PyObject list) slice info of axis 2
        Ax3 (PyObject list) slice info of axis 3
        Ax4 (PyObject list) slice info of axis 4
        DiagFolding (PyObject list) list of diag folding value for each axis
        AxUnits (PyObject list) the list of units for axes

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiD4Matrix2::Slice2d(ElementContainerArray *eca, std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< std::string > axType, std::vector< Double > folding, std::vector< std::string > axunits) UtsusemiD4Matrix2::Slice2d Slices D4Mat by given parameters.
===============================================================================================================================================================================================================================================================================================================================================================
    This slices D4Mat by given parametes to make ElementContainerArray as result

    Args:
        eca (ElementContainerArray) The sliced data to be returned (The given data must be empty.)
        ax1range (std::vector<Double>) range for axis 1
        ax2range (std::vector<Double>) range for axis 2
        ax3range (std::vector<Double>) range for axis 3
        ax4range (std::vector<Double>) range for axis 4
        axType (std::vector<std::string>) types for each axis \"X\",\"Y\",\"T\"
        folding (std::vector<Double>) folding information
        axunits (std::vector<std::string>) the list of units for axes

    Returns:
        true succeeded.
        false failed. 
    
ElementContainerArray UtsusemiD4Matrix2::Slice2d(std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< std::string > type, std::vector< Double > folding, std::vector< std::string > axunits) UtsusemiD4Matrix2::Slice2d Slices D4Mat by given parameters (not use recommended)
=======================================================================================================================================================================================================================================================================================================================================================================
    This slices D4Mat by given parametes and makes ElementContainerArray as result

    Args:
        ax1range (std::vector<Double>) range for axis 1
        ax2range (std::vector<Double>) range for axis 2
        ax3range (std::vector<Double>) range for axis 3
        ax4range (std::vector<Double>) range for axis 4
        type (std::vector<std::string>) types for each axis \"X\",\"Y\",\"T\"
        folding (std::vector<Double>) folding information
        axunits (std::vector<std::string>) the list of units for axes

    Returns:
        ElementContainerArray results of sliced data 
    
ElementContainerArray UtsusemiD4Matrix2::Slice2d(PyObject *ax1range, PyObject *ax2range, PyObject *ax3range, PyObject *ax4range, PyObject *type, PyObject *folding, PyObject *AxUnits) UtsusemiD4Matrix2::Slice2d Slices D4Mat by given parameters (not use recommended)
=========================================================================================================================================================================================================================================================================
    This slices D4Mat by given parametes and makes ElementContainerArray as result

    Args:
        ax1range (PyObject float list) range for axis 1
        ax2range (PyObject float list) range for axis 2
        ax3range (PyObject float list) range for axis 3
        ax4range (PyObject float list) range for axis 4
        type (PyObject str list) types for each axis \"X\",\"Y\",\"T\"
        folding (PyObject float list) folding information
        AxUnits (PyObject str list) the list of units for axes

    Returns:
        ElementContainerArray results of sliced data 
";
%feature("docstring") UtsusemiD4Matrix2::_Slice3D "bool UtsusemiD4Matrix2::_Slice3D(ElementContainerMatrix *ecm, std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< std::string > type, std::vector< Double > folding) UtsusemiD4Matrix2::_Slice3D

";
%feature("docstring") UtsusemiD4Matrix2::Slice3d "bool UtsusemiD4Matrix2::Slice3d(ElementContainerMatrix *ecm, PyObject *Ax1, PyObject *Ax2, PyObject *Ax3, PyObject *Ax4, PyObject *DiagFolding) UtsusemiD4Matrix2::Slice3d Slices D4Mat by given parameters.
=============================================================================================================================================================================================================
    This slices D4Mat by given parametes and makes ElementContainerArray as result

    Args:
        ecm (ElementContainerMatrix) The sliced data to be returned (The given data must be empty.)
        Ax1 (PyObject list) slice info of axis 1 [ \"type\", min, max, width[, folding] ] where \"type\" is \"x\",\"y\",\"z\" or \"t\",
        Ax2 (PyObject list) slice info of axis 2
        Ax3 (PyObject list) slice info of axis 3
        Ax4 (PyObject list) slice info of axis 4
        DiagFolding (PyObject list) list of diag folding value for each axis

    Returns:
        true succeeded.
        false failed. 

    
ElementContainerMatrix UtsusemiD4Matrix2::Slice3d(std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< std::string > type, std::vector< Double > folding) UtsusemiD4Matrix2::Slice3d Slices D4Mat by given parameters.
===============================================================================================================================================================================================================================================================================================================
    This slices D4Mat by given parametes and makes ElementContainerArray as result

    Args:
        ax1range (std::vector<Double>) range for axis 1
        ax2range (std::vector<Double>) range for axis 2
        ax3range (std::vector<Double>) range for axis 3
        ax4range (std::vector<Double>) range for axis 4
        type (std::vector<std::string>) types for each axis \"X\",\"Y\",\"Z\",\"T\"
        folding (std::vector<Double>) folding information

    Returns:
        ElementContainerMatrix results of sliced data 
    
ElementContainerMatrix UtsusemiD4Matrix2::Slice3d(PyObject *ax1range, PyObject *ax2range, PyObject *ax3range, PyObject *ax4range, PyObject *axistype, PyObject *folding) UtsusemiD4Matrix2::Slice3d Slices D4Mat by given parameters.
======================================================================================================================================================================================================================================
    This slices D4Mat by given parametes and makes ElementContainerArray as result

    Args:
        ax1range (PyObject float list) range for axis 1
        ax2range (PyObject float list) range for axis 2
        ax3range (PyObject float list) range for axis 3
        ax4range (PyObject float list) range for axis 4
        axistype (PyObject str list) types for each axis \"X\",\"Y\",\"Z\",\"T\"
        folding (PyObject float list) folding information

    Returns:
        ElementContainerMatrix results of sliced data 
";
%feature("docstring") UtsusemiD4Matrix2::WriteData "Int4 UtsusemiD4Matrix2::WriteData(std::string filename) UtsusemiD4Matrix2::WriteData Saves D4Mat data using Boost Serialization.
=================================================================================================================================

    Args:
        filename (std::string)

    Returns:
        0 no trouble
        -1 trouble happened. 

";
%feature("docstring") UtsusemiD4Matrix2::ReadData "Int4 UtsusemiD4Matrix2::ReadData(std::string filename) UtsusemiD4Matrix2::ReadData Loads D4Mat data using Boost Serialization.
===============================================================================================================================

    Args:
        filename (std::string)

    Returns:
        0 no trouble
        -1 trouble happened. 

";
%feature("docstring") UtsusemiD4Matrix2::PutD4matPointer "D4MatGroup * UtsusemiD4Matrix2::PutD4matPointer() UtsusemiD4Matrix2::PutD4matPointer Puts D4Mat data pointer.
==============================================================================================================

    Args:
        None

    Returns:
        ElementContainerArray*) 

";
%feature("docstring") UtsusemiD4Matrix2::ResetD4mat "void UtsusemiD4Matrix2::ResetD4mat() UtsusemiD4Matrix2::ResetD4mat Clear D4Mat data.
=====================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::GetAxLimit "std::vector< Double > UtsusemiD4Matrix2::GetAxLimit() UtsusemiD4Matrix2::GetAxLimit

";
%feature("docstring") UtsusemiD4Matrix2::GetAxLimit2 "std::vector< Double > UtsusemiD4Matrix2::GetAxLimit2() UtsusemiD4Matrix2::GetAxLimit2 Puts axes ranges of D4Mat.
=================================================================================================================

    Args:
        None

    Returns:
        std::vector<Double> 

";
%feature("docstring") UtsusemiD4Matrix2::PutQRange "PyObject * UtsusemiD4Matrix2::PutQRange() UtsusemiD4Matrix2::PutQRange Puts axes ranges of D4Mat.
==================================================================================================

    Args:
        None

    Returns:
        python list object [ax1_min, ax1_max, ax2_min, ... , ax4_max] 

";
%feature("docstring") UtsusemiD4Matrix2::AllocateD4MatOnDisk "bool UtsusemiD4Matrix2::AllocateD4MatOnDisk(std::vector< Double > a1range, std::vector< Double > a2range, std::vector< Double > a3range, std::vector< Double > a4range, std::vector< std::string > titles, std::vector< std::string > units, std::string data_dir, std::string paramfile) UtsusemiD4Matrix2::AllocateD4MatOnDisk

    
bool UtsusemiD4Matrix2::AllocateD4MatOnDisk(PyObject *a1range, PyObject *a2range, PyObject *a3range, PyObject *a4range, PyObject *titles, PyObject *units, std::string data_dir, std::string paramfile) UtsusemiD4Matrix2::AllocateD4MatOnDisk Makes new D4Matrix files on disk.
=================================================================================================================================================================================================================================================================================
    Each range consists of three values, start, end and width.

    Args:
        a1range first axis range
        a2range second axis range
        a3range third axis range
        a4range fourth axis range
        titles titles for axes
        units units for axes
        data_dir path to data dir (including xml file)
        paramfile file name of parameter xml file

    Returns:
        None 
";
%feature("docstring") UtsusemiD4Matrix2::SaveParamXmlD4MatOnDisk "Int4 UtsusemiD4Matrix2::SaveParamXmlD4MatOnDisk(std::string d4mat_datadir, std::string d4mat_param_file, std::vector< std::string > name_of_blocks, std::vector< UInt4 > index_of_blocks, std::vector< std::vector< Double > > ranges, std::vector< std::string > axtitles, std::vector< std::string > units, std::vector< std::string > pathbinfiles) UtsusemiD4Matrix2::SaveParamXmlD4MatOnDisk Saves D4Mat xml to output data as D4Mat.
===========================================================================================================================================================================================================================================================================================================================================================================================================================================
    This method is called in AllocateD4MatOnDisk.

    Args:
        d4mat_datadir (std::string) The path to the folder to store D4Mat data files
        d4mat_param_file (std::string) The file name of xml file for D4Mat
        name_of_blocks (std::vector<std::string>) File names of bin files
        index_of_blocks (std::vector<UInt4>) The index list of blocks in D4Mat data
        ranges (std::vector< std::vector<Double> >) The range for the axes in D4Mat data
        axtitles (std::vector<std::string>) The list of axes titles
        units (std::vector<std::string>) The list of units for axes
        pathbinfiles (std::vector<std::string>) The file list of vbin files (basically not use)

    Returns:
        -1 Failed xml creation.
        0 Succeeded. 

    
Int4 UtsusemiD4Matrix2::SaveParamXmlD4MatOnDisk(std::string d4mat_datadir, std::string d4mat_param_file, std::vector< std::string > name_of_blocks, std::vector< UInt4 > index_of_blocks, std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< std::string > axtitles, std::vector< std::string > axunits, std::vector< std::string > pathbinfiles) UtsusemiD4Matrix2::SaveParamXmlD4MatOnDisk Saves D4Mat xml to output data as D4Mat.
================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================
    This method is called in AllocateD4MatOnDisk.

    Args:
        d4mat_datadir (std::string) The path to the folder to store D4Mat data files
        d4mat_param_file (std::string) The file name of xml file for D4Mat
        name_of_blocks (std::vector<std::string>) File names of bin files
        index_of_blocks (std::vector<UInt4>) The index list of blocks in D4Mat data
        ax1range (std::vector<Double>) The range of the AX1 axis in D4Mat data
        ax2range (std::vector<Double>) The range of the AX2 axis in D4Mat data
        ax3range (std::vector<Double>) The range of the AX3 axis in D4Mat data
        ax4range (std::vector<Double>) The range of the AX4 axis in D4Mat data
        axtitles (std::vector<std::string>) The list of axes titles
        units (std::vector<std::string>) The list of units for axes
        pathbinfiles (std::vector<std::string>) The file list of vbin files (basically empty)

    Returns:
        -1 Failed xml creation.
        0 Succeeded. 
";
%feature("docstring") UtsusemiD4Matrix2::ImportEcmStepByStep "Int4 UtsusemiD4Matrix2::ImportEcmStepByStep(ElementContainerMatrix *ecm, double ang, double norm, double normFactor) UtsusemiD4Matrix2::ImportEcmStepByStep Import ECM data into D4Mat2 (currently not use)
============================================================================================================================================================================================================
    where ECM is the histogram data after the data reductions at an angle.

    Args:
        ecm (ElementContainerMatrix) The data to be imported.
        ang (Double) Angle (around Y axis).
        norm (Double) The normalizing factor, like the proton current or the number of kickers.
        normFactor (Double) The correction value for normalization.

    Returns:
        0 Succeeded. 

    
Int4 UtsusemiD4Matrix2::ImportEcmStepByStep(ElementContainerMatrix *ecm, double ang, std::string label, bool isStepByStep=true) UtsusemiD4Matrix2::ImportEcmStepByStep Import ECM data into D4Mat2.
====================================================================================================================================================================================================
    where ECM is the histogram data after the data reductions at an angle.

    Args:
        ecm (ElementContainerMatrix) The data to be imported.
        ang (Double) Angle (around Y axis).
        label (std::string) The label for the data
        isStepByStep (bool) Whether the mesurement method of the data is Step-by-Step method or not (continuous rotation)

    Returns:
        0 Succeeded. 
";
%feature("docstring") UtsusemiD4Matrix2::Projection "bool UtsusemiD4Matrix2::Projection(std::vector< Double > viewAxis) UtsusemiD4Matrix2::Projection Do the projection treatment of the data.
==========================================================================================================================================
    This function do the projection over all angles data.

    Args:
        vewAxis (std::vector<Double>) The view axes list [ax1_a*, ax1_b*, ax1_c*, ax1_enrgy, ax2_a*, ... , ax4_enrgy ]

    Returns:
        true succeeded.
        false failed. 

    
bool UtsusemiD4Matrix2::Projection(UInt4 ind, std::vector< Double > viewAxis) UtsusemiD4Matrix2::Projection Do the projection treatment of the data.
=====================================================================================================================================================
    This function do the projection of the data at an angle given by argument of ind.

    Args:
        ind (UInt4) The index of the inner D4Mat data set which stores data for each angle.
        vewAxis (std::vector<Double>) The view axes list [ax1_a*, ax1_b*, ax1_c*, ax1_enrgy, ax2_a*, ... , ax4_enrgy ]

    Returns:
        true succeeded.
        false failed. 
    
bool UtsusemiD4Matrix2::Projection(PyObject *viewAxis) UtsusemiD4Matrix2::Projection Do the projection treatment of the data.
==============================================================================================================================
    This function do the projection over all angles data.

    Args:
        vewAxis (PyObject float list) The view axes list [ax1_a*, ax1_b*, ax1_c*, ax1_enrgy, ax2_a*, ... , ax4_enrgy ]

    Returns:
        true succeeded.
        false failed. 
";
%feature("docstring") UtsusemiD4Matrix2::ProjectionStepByStep "bool UtsusemiD4Matrix2::ProjectionStepByStep(PyObject *viewAxis) UtsusemiD4Matrix2::ProjectionStepByStep Do the projection treatment of the data (obsolete)
============================================================================================================================================================
    This function do the projection over all angles data.

    Args:
        vewAxis (PyObject float list) The view axes list [ax1_a*, ax1_b*, ax1_c*, ax1_enrgy, ax2_a*, ... , ax4_enrgy ]

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::ExportEcmFromStepByStep "bool UtsusemiD4Matrix2::ExportEcmFromStepByStep(ElementContainerMatrix *ecm, UInt4 index) UtsusemiD4Matrix2::ExportEcmFromStepByStep Exports an angle data given by the index to ecm.
======================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix) The empty data container to be filled with the data.
        index (UInt4) The index of the inner D4Mat data set which stores data for each angle.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::PutLabelsOfImportedEcm "std::vector< std::string > UtsusemiD4Matrix2::PutLabelsOfImportedEcm() UtsusemiD4Matrix2::PutLabelsOfImportedEcm Put the labels for the imported data.
=======================================================================================================================================================

    Args:
        None

    Returns:
        std::vector<std::string> The list of labels for the imported data 

";
%feature("docstring") UtsusemiD4Matrix2::SetAveragingOnSlice "void UtsusemiD4Matrix2::SetAveragingOnSlice(bool useAve=true) UtsusemiD4Matrix2::SetAveragingOnSlice Set intensity caluculation mode (average or summation) in _Slice2D and _Slice3D.
======================================================================================================================================================================================

    Args:
        useAve (bool) true : Average, false : summation

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::SetXtalParam "void UtsusemiD4Matrix2::SetXtalParam(std::string xtalparam) UtsusemiD4Matrix2::SetXtalParam Set the xml contents of XtalParam as the inner XtalParam information.
==================================================================================================================================================================

    Args:
        xtalparam (std::string) XtalParam text

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::PutXtalParam "std::string UtsusemiD4Matrix2::PutXtalParam() UtsusemiD4Matrix2::PutXtalParam Get the xml contents of the inner XtalParam.
===========================================================================================================================

    Args:
        None

    Returns:
        std::string XtalParam 

";
%feature("docstring") UtsusemiD4Matrix2::SaveXtalParam "bool UtsusemiD4Matrix2::SaveXtalParam(std::string filepath) UtsusemiD4Matrix2::SaveXtalParam Save the xml contents as the filepath.
====================================================================================================================================
    This make xml text from the innder header information (_HH)

    Args:
        filepath (std::string) The path to the xml file.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::SaveData "bool UtsusemiD4Matrix2::SaveData(std::string filepath, bool withComp=false) UtsusemiD4Matrix2::SaveData Save the binary D4Mat2 data.
=====================================================================================================================================

    Args:
        filepath (std::string) The path to the saved data file
        withComp (bool) Whether doing compression on the binary data or not on file saving.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::LoadData "bool UtsusemiD4Matrix2::LoadData(std::string filepath) UtsusemiD4Matrix2::LoadData Load the binary D4Mat2 data.
================================================================================================================

    Args:
        filepath (std::string) The path of the file to be loaded.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::DumpAllDataPoints "bool UtsusemiD4Matrix2::DumpAllDataPoints(std::string filepath) UtsusemiD4Matrix2::DumpAllDataPoints Dump all data points into the text file.
==============================================================================================================================================

    Args:
        filepath (std::string) The path of the file.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::PutSlicedD4MatrixToText "bool UtsusemiD4Matrix2::PutSlicedD4MatrixToText(std::string filepath, std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< Double > folding, bool isAve=true) UtsusemiD4Matrix2::PutSlicedD4MatrixToText Put sliced (matrix) data points into the text file.
=====================================================================================================================================================================================================================================================================================================================================================

    Args:
        filepath (std::string) The path of the file.
        ax1range (std::vector<Double>) Ax1 range [<min>, <max>, <bin>]
        ax2range (std::vector<Double>) Ax2 range
        ax3range (std::vector<Double>) Ax3 range
        ax4range (std::vector<Double>) Ax4(hw) range
        folding (std::vector<Double>) Folding information [<ax1_fold>, <ax2_fold>,...]
        isAve (bool) true means that the calculated intensity is normalized by the number of data.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::PutSlicedD4MatrixToVectors "bool UtsusemiD4Matrix2::PutSlicedD4MatrixToVectors(std::vector< Double > *ax1, std::vector< Double > *ax2, std::vector< Double > *ax3, std::vector< Double > *ax4, std::vector< Double > *intensity, std::vector< Double > *error, bool isAve=true) UtsusemiD4Matrix2::PutSlicedD4MatrixToVectors Put inner arrays for sliced (matrix) data points as vectors.
===============================================================================================================================================================================================================================================================================================================================================================

    Args:
        ax1range (std::vector<Double>*) Ax1 bin std::vector
        ax2range (std::vector<Double>*) Ax2 bin std::vector
        ax3range (std::vector<Double>*) Ax3 bin std::vector
        ax4range (std::vector<Double>*) Ax4(hw) bin std::vector
        intansity (std::vector<Double>*) intensity std::vector
        error (std::vector<Double>*) error std::vector
        isAve (bool) true means that the calculated intensity is normalized by the number of data.

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::MakeSlicedD4MatrixInner "bool UtsusemiD4Matrix2::MakeSlicedD4MatrixInner(std::vector< Double > ax1range, std::vector< Double > ax2range, std::vector< Double > ax3range, std::vector< Double > ax4range, std::vector< Double > folding) UtsusemiD4Matrix2::MakeSlicedD4MatrixInner Make inner arrays for sliced (matrix) data points.
=============================================================================================================================================================================================================================================================================================================

    Args:
        ax1range (std::vector<Double>) Ax1 range [<min>, <max>, <bin>]
        ax2range (std::vector<Double>) Ax2 range
        ax3range (std::vector<Double>) Ax3 range
        ax4range (std::vector<Double>) Ax4(hw) range
        folding (std::vector<Double>) Folding information [<ax1_fold>, <ax2_fold>,...]

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::ClearSlicedD4MatrixInner "void UtsusemiD4Matrix2::ClearSlicedD4MatrixInner() UtsusemiD4Matrix2::ClearSlicedD4MatrixInner Clear inner arrays for sliced (matrix) data points.
===================================================================================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiD4Matrix2::Empty "bool UtsusemiD4Matrix2::Empty() UtsusemiD4Matrix2::Empty Check whether the D4Mat2 data is empty.
=================================================================================================

    Returns:
        true The data is empty.
        false The data is filled. 

";
%feature("docstring") UtsusemiD4Matrix2::MakeVirtualD4Mat2 "bool UtsusemiD4Matrix2::MakeVirtualD4Mat2(ElementContainerMatrix *ecm, std::vector< Double > angles, std::vector< std::string > labels) UtsusemiD4Matrix2::MakeVirtualD4Mat2 Make dummy D4Mat2 data.
=====================================================================================================================================================================================================
    This makes the virtual measurement data to be used for the check the measurement area and so on. @apram ecm (ElementContainerMatrix) The dummy data (all intensities are \"1.0\")

    Args:
        angles (std::vector<Double>) The angles list used as the dummy data
        labels (std::vector<std::string>) The labels list used ad the dummy data

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiD4Matrix2::PutSize "UInt4 UtsusemiD4Matrix2::PutSize() UtsusemiD4Matrix2::PutSize Put the size of D4Mat data (the number of measurements angles)
=============================================================================================================================

    Args:
        None

    Returns:
        UInt4 the size 

";
%feature("docstring") UtsusemiD4Matrix2::MakeXmlStringFromHeader "std::string UtsusemiD4Matrix2::MakeXmlStringFromHeader(HeaderBase *hh) UtsusemiD4Matrix2::MakeXmlStringFromHeader Put Xtalparam.xml information converted from the given header information.
=============================================================================================================================================================================================

    Args:
        hh (HeaderBase) the given header information

    Returns:
        std::string The xml text made from the header 

";
%feature("docstring") UtsusemiD4Matrix2::PutTreatD4Mat2XmlParams "TreatD4Matrix2XmlParams * UtsusemiD4Matrix2::PutTreatD4Mat2XmlParams() UtsusemiD4Matrix2::PutTreatD4Mat2XmlParams Put the instanse of TreatD4Matrix2XmlParams.
===============================================================================================================================================================

    Args:
        None

    Returns:
        the instanse of TreatD4Matrix2XmlParams 

";
%feature("docstring") UtsusemiD4Matrix2::SetMemorySaving "void UtsusemiD4Matrix2::SetMemorySaving(bool memSave=true) UtsusemiD4Matrix2::SetMemorySaving

";
// File: classUtsusemiDaqInfo.xml

%feature("docstring") UtsusemiDaqInfo "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiDaqInfo::UtsusemiDaqInfo "UtsusemiDaqInfo::UtsusemiDaqInfo() UtsusemiDaqInfo::UtsusemiDaqInfo Constructor. 

    
UtsusemiDaqInfo::UtsusemiDaqInfo(const UtsusemiDaqInfo &obj) UtsusemiDaqInfo::UtsusemiDaqInfo Copy Constructor. 
";
%feature("docstring") UtsusemiDaqInfo::~UtsusemiDaqInfo "UtsusemiDaqInfo::~UtsusemiDaqInfo() UtsusemiDaqInfo::~UtsusemiDaqInfo Destructor. 

";
%feature("docstring") UtsusemiDaqInfo::ClearList "void UtsusemiDaqInfo::ClearList() UtsusemiDaqInfo::ClearList

";
%feature("docstring") UtsusemiDaqInfo::PutAliveList "std::vector< UInt4 > UtsusemiDaqInfo::PutAliveList() UtsusemiDaqInfo::PutAliveList Puts list of ModList index alived.
======================================================================================================================

    Args:
        None

    Returns:
        std::vector of index 

";
// File: classUtsusemiDetAxisInfo.xml

%feature("docstring") UtsusemiDetAxisInfo "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiDetAxisInfo::UtsusemiDetAxisInfo "UtsusemiDetAxisInfo::UtsusemiDetAxisInfo() UtsusemiDetAxisInfo::UtsusemiDetAxisInfo Constructor. 

    
UtsusemiDetAxisInfo::UtsusemiDetAxisInfo(const UtsusemiDetAxisInfo &obj) UtsusemiDetAxisInfo::UtsusemiDetAxisInfo Copy Constructor. 
";
%feature("docstring") UtsusemiDetAxisInfo::~UtsusemiDetAxisInfo "UtsusemiDetAxisInfo::~UtsusemiDetAxisInfo() UtsusemiDetAxisInfo::~UtsusemiDetAxisInfo Destructor. 

";
// File: classUtsusemiDetInfo.xml

%feature("docstring") UtsusemiDetInfo "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiDetInfo::UtsusemiDetInfo "UtsusemiDetInfo::UtsusemiDetInfo() UtsusemiDetInfo::UtsusemiDetInfo Constructor. 

    
UtsusemiDetInfo::UtsusemiDetInfo(const UtsusemiDetInfo &obj) UtsusemiDetInfo::UtsusemiDetInfo Copy Constructor. 
";
%feature("docstring") UtsusemiDetInfo::~UtsusemiDetInfo "UtsusemiDetInfo::~UtsusemiDetInfo() UtsusemiDetInfo::~UtsusemiDetInfo Destructor. 

";
// File: classUtsusemiDetectorEfficiencyCorrection.xml

%feature("docstring") UtsusemiDetectorEfficiencyCorrection "

    Detector Efficiency correction.
    Usage: correction using approximate values stored in DetEffi.dat DF = UtsusemiDetectorEfficiencyCorrection() if DF.LoadDataFile( \"path/to/DetEffi.dat\" ): DF.Execute( dat )
    Usage: Make DetEffi.dat DF = UtsusemiDetectorEfficiencyCorrection() if DF.Initialize( \"path/to/DetectorInfo.xml\", \"SIK-SUS304-3He-PSD\" ): DF.MakeApproximateData( \"path/to/DetEffi.dat\", <Ef_min>, <Ef_max>, <Ef_num>, <th_min>, <th_max>, <th_num> )
    This class is based on MlfDetectorEfficiencyCorrection at rev301 or later
    C++ includes: UtsusemiDetectorEfficiencyCorrection.hh 

";
%feature("docstring") UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection "UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection() UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection Constructor.
=====================================================================================================================================================================
    UtsusemiDetectorEfficiencyCorrection()

    Args:
        None

    Returns:
        None 

    
UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection(std::string _detInfo, std::string _detName) UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection Constructor.
===============================================================================================================================================================================================================
    UtsusemiDetectorEfficiencyCorrection( std::string _detInfo, std::string _detName=\"\" )

    Args:
        _detInfo (std::string) path to DetectorInfo.xml which must include <detectorStructure>.
        _detName (std::string) Detector Name like \"SUS304-3He-PSD\". This name must be included <detectorStructure>.

    Returns:
        None 
    
UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection(UInt4 _runNo, std::string _detName, UInt4 _modeNo=0) UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection Constructor.
========================================================================================================================================================================================================================
    UtsusemiDetectorEfficiencyCorrection( UInt4 _runNo, std::string _detName, UInt4 _modeNo=0 );

    Args:
        _runNo (UInt4) runNo to find the suitable DetectorInfo.xml
        _detName (std::string) Detector Name like \"SUS304-3He-PSD\". This name must be included <detectorStructure>.
        _modNo (UInt4) mode number to choose DetectorInfo.xml

    Returns:
        None 
    
UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection(std::string _datFile) UtsusemiDetectorEfficiencyCorrection::UtsusemiDetectorEfficiencyCorrection Constructor.
=========================================================================================================================================================================================
    UtsusemiDetectorEfficiencyCorrection( std::string _datFile )

    Args:
        _datFile (std::string) path to file storing approxmate correction values as matrix format.

    Returns:
        None 
";
%feature("docstring") UtsusemiDetectorEfficiencyCorrection::~UtsusemiDetectorEfficiencyCorrection "UtsusemiDetectorEfficiencyCorrection::~UtsusemiDetectorEfficiencyCorrection() UtsusemiDetectorEfficiencyCorrection::~UtsusemiDetectorEfficiencyCorrection Destructor. 

";
%feature("docstring") UtsusemiDetectorEfficiencyCorrection::Initialize "bool UtsusemiDetectorEfficiencyCorrection::Initialize(std::string _detInfo, std::string _detName) UtsusemiDetectorEfficiencyCorrection::Initialize Sets DetectorInfo and detNmae.
==================================================================================================================================================================================
    Sets DetectorInfo (including <detectorStructure>) and detName to set parameters for calculations of detector efficiency.

    Args:
        _detInfo (std::string) path to DetectorInfo.xml which must include <detectorStructure>.
        _detName (std::string) Detector Name like \"SUS304-3He-PSD\". This name must be included <detectorStructure>.

    Returns:
        true suceeded.
        false failed. 

    
bool UtsusemiDetectorEfficiencyCorrection::Initialize(UInt4 _runNo, std::string _detName, UInt4 _modeNo=0) UtsusemiDetectorEfficiencyCorrection::Initialize Sets DetectorInfo and detNmae.
===========================================================================================================================================================================================
    Sets DetectorInfo (including <detectorStructure>) and detName to set parameters for calculations of detector efficiency.

    Args:
        _runNo (UInt4) runNo to find the suitable DetectorInfo.xml
        _detName (std::string) Detector Name like \"SUS304-3He-PSD\". This name must be included <detectorStructure>.
        _modNo (UInt4) mode number to choose DetectorInfo.xml

    Returns:
        true suceeded.
        false failed. 
";
%feature("docstring") UtsusemiDetectorEfficiencyCorrection::LoadDataFile "bool UtsusemiDetectorEfficiencyCorrection::LoadDataFile(std::string _datFile, std::string additionalPath=\"\") UtsusemiDetectorEfficiencyCorrection::LoadDataFile Loads data from file storing approximate values of detector efficiency.
==========================================================================================================================================================================================================================================

    Args:
        _datFile (std::string) path of data file to be saved
        additionalPath (std::string) path of folder to be search _datFile

    Returns:
        true : succeeded.
        false : failed. 

";
// File: classUtsusemiDetectorInfoBankInfo.xml

%feature("docstring") UtsusemiDetectorInfoBankInfo "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") UtsusemiDetectorInfoBankInfo::UtsusemiDetectorInfoBankInfo "UtsusemiDetectorInfoBankInfo::UtsusemiDetectorInfoBankInfo() UtsusemiDetectorInfoBankInfo::UtsusemiDetectorInfoBankInfo Constructor. 

    
UtsusemiDetectorInfoBankInfo::UtsusemiDetectorInfoBankInfo(const UtsusemiDetectorInfoBankInfo &obj) UtsusemiDetectorInfoBankInfo::UtsusemiDetectorInfoBankInfo Copy Constructor. 
";
%feature("docstring") UtsusemiDetectorInfoBankInfo::~UtsusemiDetectorInfoBankInfo "UtsusemiDetectorInfoBankInfo::~UtsusemiDetectorInfoBankInfo() UtsusemiDetectorInfoBankInfo::~UtsusemiDetectorInfoBankInfo Destructor. 

";
%feature("docstring") UtsusemiDetectorInfoBankInfo::AddBank "void UtsusemiDetectorInfoBankInfo::AddBank(UInt4 bankId, std::string name, std::string conts) UtsusemiDetectorInfoBankInfo::AddBank

";
%feature("docstring") UtsusemiDetectorInfoBankInfo::DelBank "bool UtsusemiDetectorInfoBankInfo::DelBank(UInt4 bankId) UtsusemiDetectorInfoBankInfo::DelBank

";
%feature("docstring") UtsusemiDetectorInfoBankInfo::PutBank "std::vector< std::string > UtsusemiDetectorInfoBankInfo::PutBank(UInt4 bankId) UtsusemiDetectorInfoBankInfo::PutBank

";
// File: classUtsusemiDetectorInfoEditorBase.xml

%feature("docstring") UtsusemiDetectorInfoEditorBase "C++ includes: UtsusemiDetectorInfoEditorBase.hh 

";
%feature("docstring") UtsusemiDetectorInfoEditorBase::UtsusemiDetectorInfoEditorBase "UtsusemiDetectorInfoEditorBase::UtsusemiDetectorInfoEditorBase() UtsusemiDetectorInfoEditorBase::UtsusemiDetectorInfoEditorBase Constructor. 

    
UtsusemiDetectorInfoEditorBase::UtsusemiDetectorInfoEditorBase(std::string dfile, bool workAsReader) UtsusemiDetectorInfoEditorBase::UtsusemiDetectorInfoEditorBase Constructor with arguments.
================================================================================================================================================================================================

    Args:
        dfile (std::string) path/to/DetectorInfo.xml to be loaded
        workAsReader (bool) swich the mode to work as a reader 
";
%feature("docstring") UtsusemiDetectorInfoEditorBase::~UtsusemiDetectorInfoEditorBase "UtsusemiDetectorInfoEditorBase::~UtsusemiDetectorInfoEditorBase() UtsusemiDetectorInfoEditorBase::~UtsusemiDetectorInfoEditorBase Destructor. 

";
// File: classUtsusemiDetectorInfoEditorNeunet.xml

%feature("docstring") UtsusemiDetectorInfoEditorNeunet "C++ includes: UtsusemiDetectorInfoEditorNeunet.hh 

";
%feature("docstring") UtsusemiDetectorInfoEditorNeunet::UtsusemiDetectorInfoEditorNeunet "UtsusemiDetectorInfoEditorNeunet::UtsusemiDetectorInfoEditorNeunet() UtsusemiDetectorInfoEditorNeunet::UtsusemiDetectorInfoEditorNeunet Constructor. 

    
UtsusemiDetectorInfoEditorNeunet::UtsusemiDetectorInfoEditorNeunet(std::string dfile, bool workAsReader) UtsusemiDetectorInfoEditorNeunet::UtsusemiDetectorInfoEditorNeunet Constructor with arguments.
========================================================================================================================================================================================================

    Args:
        dfile (std::string) path/to/DetectorInfo.xml to be loaded
        workAsReader (bool) swich the mode to work as a reader 
";
%feature("docstring") UtsusemiDetectorInfoEditorNeunet::~UtsusemiDetectorInfoEditorNeunet "UtsusemiDetectorInfoEditorNeunet::~UtsusemiDetectorInfoEditorNeunet() UtsusemiDetectorInfoEditorNeunet::~UtsusemiDetectorInfoEditorNeunet Destructor. 

";
// File: classUtsusemiDetectorInfoEditorTemplate.xml

%feature("docstring") UtsusemiDetectorInfoEditorTemplate "C++ includes: UtsusemiDetectorInfoEditorTemplate.hh 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::UtsusemiDetectorInfoEditorTemplate "UtsusemiDetectorInfoEditorTemplate< T1 >::UtsusemiDetectorInfoEditorTemplate() UtsusemiDetectorInfoEditorTemplate::UtsusemiDetectorInfoEditorTemplate

    
UtsusemiDetectorInfoEditorTemplate< T1 >::UtsusemiDetectorInfoEditorTemplate(std::string dfile, bool workAsReader) UtsusemiDetectorInfoEditorTemplate::UtsusemiDetectorInfoEditorTemplate
";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::~UtsusemiDetectorInfoEditorTemplate "UtsusemiDetectorInfoEditorTemplate< T1 >::~UtsusemiDetectorInfoEditorTemplate() UtsusemiDetectorInfoEditorTemplate::~UtsusemiDetectorInfoEditorTemplate

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::SetRunNo "bool UtsusemiDetectorInfoEditorTemplate< T1 >::SetRunNo(UInt4 runNo, UInt4 mode_no=0, std::string env_file=\"\") UtsusemiDetectorInfoEditorTemplate::SetRunNo sets run No, mode number and environ_ana.xml
===========================================================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo sutable for the run number. If evn_file is empty(), this uses python-utsusemi/XXX/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath.

    Args:
        runNo (UInt4) run number
        mode_no (UInt4) mode number
        env_file (std::string) environ_ana.xml which includes several WiringInfo and DetectorInfo for each run number.

    Returns:
        true : succeeded
        false : failed 

    
bool UtsusemiDetectorInfoEditorTemplate< T1 >::SetRunNo(std::string runNos, std::string mode_no=\"0\", std::string env_file=\"\") UtsusemiDetectorInfoEditorTemplate::SetRunNo sets run No, mode number and environ_ana.xml
============================================================================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo sutable for the run number. If evn_file is empty(), this uses python-utsusemi/XXX/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath. bool SetRunNo( std::string runNos, std::string env_file=\"\" )

    Args:
        runNos (std::string) run numbers. format : \"1234,1235\"
        mode_no (std::string) mode number
        env_file (std::string) environ_ana.xml which includes several WiringInfo and DetectorInfo for each run number.

    Returns:
        true : succeeded
        false : failed 
    
bool UtsusemiDetectorInfoEditorTemplate< T1 >::SetRunNo(UInt4 runNo, std::string dfile) UtsusemiDetectorInfoEditorTemplate::SetRunNo sets run No and environ_ana.xml
=====================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo sutable for the run number.

    Args:
        runNo (UInt4) run number
        dfile (std::string) set directly DetectorInfo file

    Returns:
        true : succeeded
        false : failed 
";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::SetRunNoWithDetectorInfo "bool UtsusemiDetectorInfoEditorTemplate< T1 >::SetRunNoWithDetectorInfo(std::string runNos, std::string dfile) UtsusemiDetectorInfoEditorTemplate::SetRunNoWithDetectorInfo sets run No and DetectorInfo
=========================================================================================================================================================================================================
    This set run number to select WiringInfo sutable for the run number.        @param runNos   (std::string) run numbers \"1234,5678\"         @param dfile    (std::string) set directly DetectorInfo file         @retval true     : succeeded         @retval false    : failed 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::MakeTempDetectorInfo "std::string UtsusemiDetectorInfoEditorTemplate< T1 >::MakeTempDetectorInfo(std::string _path=\"\") UtsusemiDetectorInfoEditorTemplate::MakeTempDetectorInfo make and save the temporal detector info to create histogram
=========================================================================================================================================================================================================================
    this returns a path of the saved temporal detector info file std::string MakeTempDetectorInfo()

    Args:
        None

    Returns:
        (std::string) : the path of output detector info file 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::PutDE "T1 * UtsusemiDetectorInfoEditorTemplate< T1 >::PutDE() UtsusemiDetectorInfoEditorTemplate::PutDE Put DetectorInfoEditorXXX.
============================================================================================================================

    Args:
        None

    Returns:
        DetectorInfoXXX 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::PutBankIdList "std::vector< Int4 > UtsusemiDetectorInfoEditorTemplate< T1 >::PutBankIdList() UtsusemiDetectorInfoEditorTemplate::PutBankIdList Put Bank ID list described in the detector info.
=================================================================================================================================================================================

    Args:
        None

    Returns:
        std::vector<Int4> 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::PutBankInfo "std::vector< std::string > UtsusemiDetectorInfoEditorTemplate< T1 >::PutBankInfo(UInt4 bankId) UtsusemiDetectorInfoEditorTemplate::PutBankInfo Put bank information described in the detector info.
====================================================================================================================================================================================================

    Args:
        bankId (UInt4) The id of the bank.

    Returns:
        std::vector<std::string> 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::PutInstL1 "Double UtsusemiDetectorInfoEditorTemplate< T1 >::PutInstL1() UtsusemiDetectorInfoEditorTemplate::PutInstL1 Put L1 [mm] described in the detector info.
=======================================================================================================================================================

    Args:
        None

    Returns:
        double L1 [mm] 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::PutInstTypicalL2 "Double UtsusemiDetectorInfoEditorTemplate< T1 >::PutInstTypicalL2() UtsusemiDetectorInfoEditorTemplate::PutInstTypicalL2 Put the typical L2 [mm] described in the detector info.
=================================================================================================================================================================================

    Args:
        None

    Returns:
        double L2 [mm] 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::PutInstTypicalDS "Double UtsusemiDetectorInfoEditorTemplate< T1 >::PutInstTypicalDS() UtsusemiDetectorInfoEditorTemplate::PutInstTypicalDS Put the typical area of one pixel described in the detector info.
===========================================================================================================================================================================================

    Args:
        None

    Returns:
        double the typical area [mm*mm] 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::SetInstInfoL1 "bool UtsusemiDetectorInfoEditorTemplate< T1 >::SetInstInfoL1(Double _L1) UtsusemiDetectorInfoEditorTemplate::SetInstInfoL1 Set L1 [mm] to be described in the detector info.
=============================================================================================================================================================================

    Args:
        _L1 (Double) L1

    Returns:
        true succeeded.
        false failed. 

";
%feature("docstring") UtsusemiDetectorInfoEditorTemplate::SetInstInfoSamplePosition "bool UtsusemiDetectorInfoEditorTemplate< T1 >::SetInstInfoSamplePosition(Double _px, Double _py, Double _pz) UtsusemiDetectorInfoEditorTemplate::SetInstInfoSamplePosition Set the sample position [mm] to be described in the detector info.
==============================================================================================================================================================================================================================================

    Args:
        _px (Double) X position [mm]
        _py (Double) Y position [mm]
        _pz (Double) Z position [mm]

    Returns:
        true succeeded.
        false failed. 

";
// File: classUtsusemiDetectorInfoInstInfo.xml

%feature("docstring") UtsusemiDetectorInfoInstInfo "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") UtsusemiDetectorInfoInstInfo::UtsusemiDetectorInfoInstInfo "UtsusemiDetectorInfoInstInfo::UtsusemiDetectorInfoInstInfo() UtsusemiDetectorInfoInstInfo::UtsusemiDetectorInfoInstInfo Constructor. 

    
UtsusemiDetectorInfoInstInfo::UtsusemiDetectorInfoInstInfo(const UtsusemiDetectorInfoInstInfo &obj) UtsusemiDetectorInfoInstInfo::UtsusemiDetectorInfoInstInfo Copy Constructor. 
";
%feature("docstring") UtsusemiDetectorInfoInstInfo::~UtsusemiDetectorInfoInstInfo "UtsusemiDetectorInfoInstInfo::~UtsusemiDetectorInfoInstInfo() UtsusemiDetectorInfoInstInfo::~UtsusemiDetectorInfoInstInfo Destructor. 

";
// File: classUtsusemiDetectorInfoPosiInfo.xml

%feature("docstring") UtsusemiDetectorInfoPosiInfo "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::UtsusemiDetectorInfoPosiInfo "UtsusemiDetectorInfoPosiInfo::UtsusemiDetectorInfoPosiInfo() UtsusemiDetectorInfoPosiInfo::UtsusemiDetectorInfoPosiInfo Constructor. 

    
UtsusemiDetectorInfoPosiInfo::UtsusemiDetectorInfoPosiInfo(const UtsusemiDetectorInfoPosiInfo &obj) UtsusemiDetectorInfoPosiInfo::UtsusemiDetectorInfoPosiInfo Copy Constructor. 
";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::~UtsusemiDetectorInfoPosiInfo "UtsusemiDetectorInfoPosiInfo::~UtsusemiDetectorInfoPosiInfo() UtsusemiDetectorInfoPosiInfo::~UtsusemiDetectorInfoPosiInfo Destructor. 

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::Clear "void UtsusemiDetectorInfoPosiInfo::Clear() UtsusemiDetectorInfoPosiInfo::Clear

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::AddPosi "void UtsusemiDetectorInfoPosiInfo::AddPosi(UInt4 detId, UInt4 numAxis, std::vector< Double > posi) UtsusemiDetectorInfoPosiInfo::AddPosi

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::DelPosi "bool UtsusemiDetectorInfoPosiInfo::DelPosi(UInt4 detId, bool isForced) UtsusemiDetectorInfoPosiInfo::DelPosi

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::PutPosiNumAxis "UInt4 UtsusemiDetectorInfoPosiInfo::PutPosiNumAxis(UInt4 detId) UtsusemiDetectorInfoPosiInfo::PutPosiNumAxis

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::PutPosi "std::vector< Double > UtsusemiDetectorInfoPosiInfo::PutPosi(UInt4 detId) UtsusemiDetectorInfoPosiInfo::PutPosi

";
%feature("docstring") UtsusemiDetectorInfoPosiInfo::PutDetIdList "std::vector< UInt4 > UtsusemiDetectorInfoPosiInfo::PutDetIdList() UtsusemiDetectorInfoPosiInfo::PutDetIdList

";
// File: classUtsusemiDetectorInfoTfp.xml

%feature("docstring") UtsusemiDetectorInfoTfp "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") UtsusemiDetectorInfoTfp::UtsusemiDetectorInfoTfp "UtsusemiDetectorInfoTfp::UtsusemiDetectorInfoTfp() UtsusemiDetectorInfoTfp::UtsusemiDetectorInfoTfp Constructor. 

    
UtsusemiDetectorInfoTfp::UtsusemiDetectorInfoTfp(const UtsusemiDetectorInfoTfp &obj) UtsusemiDetectorInfoTfp::UtsusemiDetectorInfoTfp Copy Constructor. 
";
%feature("docstring") UtsusemiDetectorInfoTfp::~UtsusemiDetectorInfoTfp "UtsusemiDetectorInfoTfp::~UtsusemiDetectorInfoTfp() UtsusemiDetectorInfoTfp::~UtsusemiDetectorInfoTfp Destructor. 

";
%feature("docstring") UtsusemiDetectorInfoTfp::ClearList "void UtsusemiDetectorInfoTfp::ClearList() UtsusemiDetectorInfoTfp::ClearList

";
%feature("docstring") UtsusemiDetectorInfoTfp::AddTfp "void UtsusemiDetectorInfoTfp::AddTfp(UInt4 pixelId, Double A, Double B) UtsusemiDetectorInfoTfp::AddTfp

";
// File: classUtsusemiDetectorInfoTfpCalcParams.xml

%feature("docstring") UtsusemiDetectorInfoTfpCalcParams "C++ includes: DetectorInfoEditorBase.hh 

";
%feature("docstring") UtsusemiDetectorInfoTfpCalcParams::UtsusemiDetectorInfoTfpCalcParams "UtsusemiDetectorInfoTfpCalcParams::UtsusemiDetectorInfoTfpCalcParams() UtsusemiDetectorInfoTfpCalcParams::UtsusemiDetectorInfoTfpCalcParams Constructor. 

    
UtsusemiDetectorInfoTfpCalcParams::UtsusemiDetectorInfoTfpCalcParams(const UtsusemiDetectorInfoTfpCalcParams &obj) UtsusemiDetectorInfoTfpCalcParams::UtsusemiDetectorInfoTfpCalcParams Copy Constructor. 
";
%feature("docstring") UtsusemiDetectorInfoTfpCalcParams::~UtsusemiDetectorInfoTfpCalcParams "UtsusemiDetectorInfoTfpCalcParams::~UtsusemiDetectorInfoTfpCalcParams() UtsusemiDetectorInfoTfpCalcParams::~UtsusemiDetectorInfoTfpCalcParams Destructor. 

";
// File: classUtsusemiEventCasesDecoderBase.xml

%feature("docstring") UtsusemiEventCasesDecoderBase "

    Decode Cases by Event Data.
    C++ includes: UtsusemiEventCasesDecoderBase.hh 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::UtsusemiEventCasesDecoderBase "UtsusemiEventCasesDecoderBase::UtsusemiEventCasesDecoderBase() UtsusemiEventCasesDecoderBase::UtsusemiEventCasesDecoderBase

";
%feature("docstring") UtsusemiEventCasesDecoderBase::~UtsusemiEventCasesDecoderBase "UtsusemiEventCasesDecoderBase::~UtsusemiEventCasesDecoderBase() UtsusemiEventCasesDecoderBase::~UtsusemiEventCasesDecoderBase

";
%feature("docstring") UtsusemiEventCasesDecoderBase::ReadCaseInfoFile "void UtsusemiEventCasesDecoderBase::ReadCaseInfoFile(std::string filepath) UtsusemiEventCasesDecoderBase::ReadCaseInfoFile Imports Case Info file.
===================================================================================================================================================

    Args:
        filepath (std::string) path to CaseInfo file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::ReadCaseEvent "void UtsusemiEventCasesDecoderBase::ReadCaseEvent(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiEventCasesDecoderBase::ReadCaseEvent

";
%feature("docstring") UtsusemiEventCasesDecoderBase::ReadCaseEventFiles "void UtsusemiEventCasesDecoderBase::ReadCaseEventFiles(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiEventCasesDecoderBase::ReadCaseEventFiles Reads event data files for cases.
====================================================================================================================================================================================================================================

    Args:
        files (std::vector<std::string>) pathes to event data file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::CalcIncrementPosi "Double UtsusemiEventCasesDecoderBase::CalcIncrementPosi(Double *tof, UInt4 *pixelId, UInt4 *caseId) UtsusemiEventCasesDecoderBase::CalcIncrementPosi Calculation increment position (tof shift)
================================================================================================================================================================================================
    If bin position(tof) shifts by case id and pixelId, use this function. This is used in original Increment function.

    Args:
        tof (Double*) tof
        pixelId (UInt4*) given pixel id
        caseNo (UInt4*) given case number

    Returns:
        tof (Double) shifted tof 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::GetCaseFromTof "UInt4 UtsusemiEventCasesDecoderBase::GetCaseFromTof(const UInt4 pixelId, Double *tof, std::vector< UInt4 > *caseVec) UtsusemiEventCasesDecoderBase::GetCaseFromTof Returns CaseId from given pixel id and tof.
===============================================================================================================================================================================================================
    This is used in original Increment function.

    Args:
        pixelId (UInt4*) given pixel id
        tof (Double*) tof
        caseVec (vecotr<UInt4>*) given std::vector of cases

    Returns:
        caseId (UInt4) if 0, this tof will not be incremented to histogram. 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::PutT0Index "std::vector< UInt4 > UtsusemiEventCasesDecoderBase::PutT0Index() UtsusemiEventCasesDecoderBase::PutT0Index Puts T0Index.
=========================================================================================================================

    Args:
        None

    Returns:
        T0Index std::vector 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::PutT0ClockDiff "std::vector< Double > UtsusemiEventCasesDecoderBase::PutT0ClockDiff() UtsusemiEventCasesDecoderBase::PutT0ClockDiff Puts differencies clocks between frames.
=============================================================================================================================================================

    Args:
        None

    Returns:
        diffencies clocks std::vector 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::PutCaseTable "std::vector< std::vector< UInt4 > * > * UtsusemiEventCasesDecoderBase::PutCaseTable() UtsusemiEventCasesDecoderBase::PutCaseTable Puts CaseTable.
==================================================================================================================================================

    Args:
        None

    Returns:
        CaseTable 

";
%feature("docstring") UtsusemiEventCasesDecoderBase::CheckCaseTableWithT0Index "void UtsusemiEventCasesDecoderBase::CheckCaseTableWithT0Index() UtsusemiEventCasesDecoderBase::CheckCaseTableWithT0Index

";
// File: classUtsusemiEventCasesDecoderTemplate.xml

%feature("docstring") UtsusemiEventCasesDecoderTemplate "

    Decode Cases by Event Data.
    C++ includes: UtsusemiEventCasesDecoderTemplate.hh 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::UtsusemiEventCasesDecoderTemplate "UtsusemiEventCasesDecoderTemplate< T1, T2 >::UtsusemiEventCasesDecoderTemplate() UtsusemiEventCasesDecoderTemplate::UtsusemiEventCasesDecoderTemplate Constructor. 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::~UtsusemiEventCasesDecoderTemplate "UtsusemiEventCasesDecoderTemplate< T1, T2 >::~UtsusemiEventCasesDecoderTemplate() UtsusemiEventCasesDecoderTemplate::~UtsusemiEventCasesDecoderTemplate Destructor. 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::CalcIncrementPosi "Double UtsusemiEventCasesDecoderTemplate< T1, T2 >::CalcIncrementPosi(Double *tof, UInt4 *pixelId, UInt4 *caseId) UtsusemiEventCasesDecoderTemplate::CalcIncrementPosi Calculation increment position (tof shift)
==================================================================================================================================================================================================================
    If bin position(tof) shifts by case id and pixelId, use this function. This is used in original Increment function.

    Args:
        tof (Double*) tof
        pixelId (UInt4*) given pixel id
        caseNo (UInt4*) given case number

    Returns:
        tof (Double) shifted tof 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::GetCaseFromTof "UInt4 UtsusemiEventCasesDecoderTemplate< T1, T2 >::GetCaseFromTof(const UInt4 pixelId, Double *tof, std::vector< UInt4 > *caseVec) UtsusemiEventCasesDecoderTemplate::GetCaseFromTof Returns CaseId from given pixel id and tof.
=================================================================================================================================================================================================================================
    This is used in original Increment function.

    Args:
        pixelId (UInt4*) given pixel id
        tof (Double*) tof
        caseVec (vecotr<UInt4>*) given std::vector of cases

    Returns:
        caseId (UInt4) if 0, this tof will not be incremented to histogram. 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutT0Index "std::vector< UInt8 > UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutT0Index() UtsusemiEventCasesDecoderTemplate::PutT0Index Puts T0Index.
===========================================================================================================================================

    Args:
        None

    Returns:
        T0Index std::vector 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutPulseId "std::vector< UInt8 > UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutPulseId() UtsusemiEventCasesDecoderTemplate::PutPulseId Puts PulseId list.
================================================================================================================================================

    Args:
        None

    Returns:
        PulseId std::vector 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutT0ClockDiff "std::vector< Double > UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutT0ClockDiff() UtsusemiEventCasesDecoderTemplate::PutT0ClockDiff Puts differencies clocks between frames.
===============================================================================================================================================================================

    Args:
        None

    Returns:
        diffencies clocks std::vector 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutCaseTable "std::vector< std::vector< UInt4 > * > * UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutCaseTable() UtsusemiEventCasesDecoderTemplate::PutCaseTable Puts CaseTable.
====================================================================================================================================================================

    Args:
        None

    Returns:
        CaseTable 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutT0TreatTools "T1 * UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutT0TreatTools() UtsusemiEventCasesDecoderTemplate::PutT0TreatTools Puts T0TreatToolsXXX pointer.
=====================================================================================================================================================

    Args:
        _tt (T1*) instance of T0TreatToolsXXX

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutFilter "T2 * UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutFilter() UtsusemiEventCasesDecoderTemplate::PutFilter Puts Filger function pointer.
=========================================================================================================================================

    Args:
        _ff (T2*) instance of Filter function

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::ReadCaseInfoFile "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::ReadCaseInfoFile(std::string filepath) UtsusemiEventCasesDecoderTemplate::ReadCaseInfoFile Imports Case Info file.
=====================================================================================================================================================================

    Args:
        filepath (std::string) path to CaseInfo file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::ReadCaseEvent "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::ReadCaseEvent(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiEventCasesDecoderTemplate::ReadCaseEvent Reads event data files for cases.
============================================================================================================================================================================================================================================

    Args:
        index (UInt4) The index of TrigNET
        evt_files (std::vector<std::string>) pathes to event data file
        t0b_files (std::vector<std::string>) pathes to t0b event data file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::ReadCaseEventFiles "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::ReadCaseEventFiles(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiEventCasesDecoderTemplate::ReadCaseEventFiles Reads event data files for cases (obsolete)
================================================================================================================================================================================================================================================================

    Args:
        index (UInt4) The index of TrigNET
        evt_files (std::vector<std::string>) pathes to event data file
        t0b_files (std::vector<std::string>) pathes to t0b event data file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutListOfCases "std::vector< UInt4 > UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutListOfCases() UtsusemiEventCasesDecoderTemplate::PutListOfCases Puts list of cases.
=========================================================================================================================================================

    Args:
        None

    Returns:
        list of cases 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::CheckCaseTableWithT0Index "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::CheckCaseTableWithT0Index() UtsusemiEventCasesDecoderTemplate::CheckCaseTableWithT0Index Checks and rewrite Case table using T0Index.
========================================================================================================================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutNumOfT0ListInCases "std::vector< UInt4 > UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutNumOfT0ListInCases(Double tof=1.0) UtsusemiEventCasesDecoderTemplate::PutNumOfT0ListInCases Returns the number of T0 for each case.
=========================================================================================================================================================================================================
    retVal[caseId] = T0 counts at caseId

    Args:
        tof (Double) Time-of-flight point in each frame to be determined caseId

    Returns:
        std::vector of the number of T0 : index is caseId : ret[caseId] included caseId=0 <- ret.size() = num_of_cases + 1 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::_CopyCaseTable "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::_CopyCaseTable(std::vector< UInt4 > *target, std::vector< UInt4 > *orig) UtsusemiEventCasesDecoderTemplate::_CopyCaseTable Copies function between std::vector pointers.
===========================================================================================================================================================================================================================

    Args:
        target (std::vector<UInt4>*) copy to
        orig (std::vector<UInt4>*) copy from

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::SetParamsForShiftTof "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::SetParamsForShiftTof(std::vector< std::vector< Double > * > *pixelPositionVect, std::vector< Double > *L1Vect, std::vector< Double > *T0ShiftVect) UtsusemiEventCasesDecoderTemplate::SetParamsForShiftTof Sets some parameters for TOF shift.
=================================================================================================================================================================================================================================================================================================
    TOF detected at detectors may be shifted that at the sample position.

    Args:
        pixelPositionVect pixel position <pixelId><axis>
        LiVect L2 for each pixel <pixelId>
        T0ShiftVect T0 shift for each pixel <pixelId>

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::ShiftTofAtSample "Double UtsusemiEventCasesDecoderTemplate< T1, T2 >::ShiftTofAtSample(Double tof, UInt4 pixelId) UtsusemiEventCasesDecoderTemplate::ShiftTofAtSample Calculates tof at the sample position.
===========================================================================================================================================================================================

    Args:
        tof (Double) TOF at a detector
        pixelId (UInt4) pixelID

    Returns:
        shifted tof 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::ReadT0IndexEventFile "Int4 UtsusemiEventCasesDecoderTemplate< T1, T2 >::ReadT0IndexEventFile(std::string t0Data, UInt4 num_of_clocks=0) UtsusemiEventCasesDecoderTemplate::ReadT0IndexEventFile Reads T0Index Event data file.
=========================================================================================================================================================================================================
    This calls _TT->reatT0IndexEvent()

    Args:
        t0Data (std::string) path to T0 event data file
        num_clocks (UInt4) number of clocks before first T0

    Returns:
        0 successful 

    
Int4 UtsusemiEventCasesDecoderTemplate< T1, T2 >::ReadT0IndexEventFile(std::vector< std::string > t0DataSet, UInt4 num_of_clocks=0) UtsusemiEventCasesDecoderTemplate::ReadT0IndexEventFile Reads T0Index Event data file.
===========================================================================================================================================================================================================================
    This calls _TT->reatT0IndexEvent()

    Args:
        t0DataSet (std::vector<std::string>) list of path to T0 event data files
        num_clocks (UInt4) number of clocks before first T0

    Returns:
        0 successful 
";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::PutMeasPeriodFromT0 "std::vector< Double > UtsusemiEventCasesDecoderTemplate< T1, T2 >::PutMeasPeriodFromT0() UtsusemiEventCasesDecoderTemplate::PutMeasPeriodFromT0 Puts the period to be measured.
================================================================================================================================================================================

    Args:
        None

    Returns:
        date and time of the period 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::SetRangeOfSingleTimeSlicing "bool UtsusemiEventCasesDecoderTemplate< T1, T2 >::SetRangeOfSingleTimeSlicing(double startSec, double endSec) UtsusemiEventCasesDecoderTemplate::SetRangeOfSingleTimeSlicing Sets time range for time slice of event data.
===========================================================================================================================================================================================================================
    Values for time are indicated the passed time [sec] from head of event data

    Args:
        startSec start time [sec]
        endSec end time [sec]

    Returns:
        true succeeded
        false failed 

    
bool UtsusemiEventCasesDecoderTemplate< T1, T2 >::SetRangeOfSingleTimeSlicing(std::string startDate, std::string endDate) UtsusemiEventCasesDecoderTemplate::SetRangeOfSingleTimeSlicing Sets time range for time slice of event data.
=======================================================================================================================================================================================================================================
    Values for time are indicated the passed time [sec] from head of event data std::string format : \"YYYY,MM,DD,hh,mm,ss,s.ss\", \"2011,1,22,13,54,22,0.54\"

    Args:
        startDate start date std::string
        endDate end date std::string

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::MakeTimeSlicingCases "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::MakeTimeSlicingCases(std::vector< std::string > _t0b_files) UtsusemiEventCasesDecoderTemplate::MakeTimeSlicingCases Makes the case list for the time slicing.
================================================================================================================================================================================================================
    This calls UtsusemiFilterBase::MakeTimeSlicingCases

    Args:
        _t0b_files (std::vector<std::string>) T0b files

    Returns:
        None 

";
%feature("docstring") UtsusemiEventCasesDecoderTemplate::SetTimeSlicing "void UtsusemiEventCasesDecoderTemplate< T1, T2 >::SetTimeSlicing(std::vector< Double > tmp) UtsusemiEventCasesDecoderTemplate::SetTimeSlicing Sets the list for the time slicing.
==================================================================================================================================================================================
    This calls UtsusemiFilterBase::SetTimeSlicing

    Args:
        tmp (std::vector<Double>) Time range [t0_start,t0_end, t1_start, t1_end, ..., tn_end]

    Returns:
        None 

";
// File: classUtsusemiEventDataConverterMWPC.xml

%feature("docstring") UtsusemiEventDataConverterMWPC "

    Load Event Data and convert to Histogram from 2d-scintillation counter PCMT.
    LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )
    C++ includes: UtsusemiEventDataConverterMWPC.hh 

";
%feature("docstring") UtsusemiEventDataConverterMWPC::UtsusemiEventDataConverterMWPC "UtsusemiEventDataConverterMWPC::UtsusemiEventDataConverterMWPC() UtsusemiEventDataConverterMWPC::UtsusemiEventDataConverterMWPC Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterMWPC::~UtsusemiEventDataConverterMWPC "UtsusemiEventDataConverterMWPC::~UtsusemiEventDataConverterMWPC() UtsusemiEventDataConverterMWPC::~UtsusemiEventDataConverterMWPC Destructor. 

";
// File: classUtsusemiEventDataConverterNeunet.xml

%feature("docstring") UtsusemiEventDataConverterNeunet "

    Load Event Data and convert to Histogram for Inelastic scattering.
    LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )
    C++ includes: UtsusemiEventDataConverterNeunet.hh 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::UtsusemiEventDataConverterNeunet "UtsusemiEventDataConverterNeunet::UtsusemiEventDataConverterNeunet() UtsusemiEventDataConverterNeunet::UtsusemiEventDataConverterNeunet Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::~UtsusemiEventDataConverterNeunet "UtsusemiEventDataConverterNeunet::~UtsusemiEventDataConverterNeunet() UtsusemiEventDataConverterNeunet::~UtsusemiEventDataConverterNeunet Destructor. 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::LoadParamFiles "bool UtsusemiEventDataConverterNeunet::LoadParamFiles(std::string w_file, std::string d_file, std::string c_file=\"\") UtsusemiEventDataConverterNeunet::LoadParamFiles Loads parameter files.
===============================================================================================================================================================================================
    This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.

    Args:
        w_file (std::string) Wiring Info file path
        d_file (std::string) Detector Info file path
        c_file (std::string) Case Info file path

    Returns:
        true : succeeded.
        false : failed. 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::SetElementContainerNeunet "void UtsusemiEventDataConverterNeunet::SetElementContainerNeunet(UInt4 outer_pixel_id, ElementContainer *ec, UInt4 caseId=1) UtsusemiEventDataConverterNeunet::SetElementContainerNeunet Sets Histogram into ElementContainer.
===============================================================================================================================================================================================================================

    Args:
        outer_pixel_id (UInt4) pixel_id
        ec (ElementContainer*)
        caseId (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::LoadEventDataFiles "Int4 UtsusemiEventDataConverterNeunet::LoadEventDataFiles(UInt4 runNumber, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunet::LoadEventDataFiles Loads event data files.
====================================================================================================================================================================================================================

    Args:
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 

    
Int4 UtsusemiEventDataConverterNeunet::LoadEventDataFiles(std::vector< UInt4 > runNumbers, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunet::LoadEventDataFiles Loads event data files.
====================================================================================================================================================================================================================================

    Args:
        runNumbers (<std::vector<UInt4>) a seriese of run numbers
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 
";
%feature("docstring") UtsusemiEventDataConverterNeunet::SetElementContainerMatrix "Int4 UtsusemiEventDataConverterNeunet::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1) UtsusemiEventDataConverterNeunet::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
======================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

    
Int4 UtsusemiEventDataConverterNeunet::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunet::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
=============================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
    
Int4 UtsusemiEventDataConverterNeunet::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunet::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
============================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, std::string instCode, UInt4 runNuber, std::string pathToData=\"\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (std::vector<UInt4>) The list of run numbers
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
";
%feature("docstring") UtsusemiEventDataConverterNeunet::MakeCaseTable "void UtsusemiEventDataConverterNeunet::MakeCaseTable(UInt4 runno, std::string pathToData=\"\", std::string pathToT0data=\"\", std::string trigModKey=\"\") UtsusemiEventDataConverterNeunet::MakeCaseTable Reads Trignet Event data file to make case table.
=============================================================================================================================================================================================================================================================

    Args:
        runno (UInt4) the run number
        pathToTrigData (std::string) path to TrigNET event data files
        pathToT0data (std::string) path to directory to store T0Index event data files
        trigModKey (std::string) The key of TrigNET event file (if you want use the special trignet event file)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::LoadTrignetEventFile "void UtsusemiEventDataConverterNeunet::LoadTrignetEventFile(UInt4 runno, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunet::LoadTrignetEventFile Reads Trignet Event data file for cases.
=====================================================================================================================================================================================================================================
    This call MakeCaseTable with the given parameters

    Args:
        runno (UInt4) the run number
        pathToTrigData (std::string) path to TrigNET event data files
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::ReadTrignetEventFile "void UtsusemiEventDataConverterNeunet::ReadTrignetEventFile(std::string pathToTrigData, UInt4 index=0) UtsusemiEventDataConverterNeunet::ReadTrignetEventFile Reads Trignet Event data file for cases (obsolete)
=================================================================================================================================================================================================================

    Args:
        pathToTrigData (std::string) path to TrigNET event data files
        index (UInt4) event file index

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::DumpCaseTable "std::vector< UInt4 > UtsusemiEventDataConverterNeunet::DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size) UtsusemiEventDataConverterNeunet::DumpCaseTable Dumps table of cases.
=============================================================================================================================================================================================

    Args:
        i1 (UInt4)
        i2 (UInt4)
        isI1Size (bool)
        isI2Size (bool)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::SetElementContainerMatrixForPseudOnLineMon "Int4 UtsusemiEventDataConverterNeunet::SetElementContainerMatrixForPseudOnLineMon(ElementContainerMatrix *ecm, UInt4 caseId=1, UInt4 runNo=999999) UtsusemiEventDataConverterNeunet::SetElementContainerMatrixForPseudOnLineMon Sets histograms to ElementContainermatrix as pseud on-line monitor.
====================================================================================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID
        runNo (UInt4) run number
        isI2Size (bool)

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::SetDataPathTest "Int4 UtsusemiEventDataConverterNeunet::SetDataPathTest(std::string dataPath, std::string t0Path, UInt4 runNo) UtsusemiEventDataConverterNeunet::SetDataPathTest Checks the function of SetDataPath.
====================================================================================================================================================================================================

    Args:
        dataPath (std::string) Tha path to data folder
        t0Path (std::string) Tha path to t0 data folder
        runNo (UInt4) run number

    Returns:
        0 : succeed
        -1 : failed 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::PutListOfCounterConditions "std::vector< Double > UtsusemiEventDataConverterNeunet::PutListOfCounterConditions() UtsusemiEventDataConverterNeunet::PutListOfCounterConditions Puts the list of the counter conditions for trignet.
=======================================================================================================================================================================================================
    This calls UtsusemiFilterTrignet::PutListOfCounterConditions

    Args:
        None

    Returns:
        std::vector<Double> [CaseId_0_start, CaseId_0_end, CaseId_1_start, ... , CaseId_n_end] 

";
%feature("docstring") UtsusemiEventDataConverterNeunet::SetTofOriginShift "bool UtsusemiEventDataConverterNeunet::SetTofOriginShift(UInt4 cType) UtsusemiEventDataConverterNeunet::SetTofOriginShift Sets type and calculation parameter for Tof origin shift.
====================================================================================================================================================================================
    This shift is defined by the lamda-depend function given in codes

    Args:
        cType (UInt4) pattern Id for function

    Returns:
        true succeeded
        false failed 

    
bool UtsusemiEventDataConverterNeunet::SetTofOriginShift(UInt4 cType, std::vector< Double > params) UtsusemiEventDataConverterNeunet::SetTofOriginShift Sets type and calculation parameter for Tof origin shift.
==================================================================================================================================================================================================================
    This shift is defined by the lamda-depend function given in codes

    Args:
        cType (UInt4) pattern Id for function
        params (std::vector<Double>) parameters of cType function

    Returns:
        true succeeded
        false failed 
";
// File: classUtsusemiEventDataConverterNeunetWithPH.xml

%feature("docstring") UtsusemiEventDataConverterNeunetWithPH "

    Load Event Data and convert to Histogram for Inelastic scattering.
    LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )
    C++ includes: UtsusemiEventDataConverterNeunetWithPH.hh 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::UtsusemiEventDataConverterNeunetWithPH "UtsusemiEventDataConverterNeunetWithPH::UtsusemiEventDataConverterNeunetWithPH() UtsusemiEventDataConverterNeunetWithPH::UtsusemiEventDataConverterNeunetWithPH Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::~UtsusemiEventDataConverterNeunetWithPH "UtsusemiEventDataConverterNeunetWithPH::~UtsusemiEventDataConverterNeunetWithPH() UtsusemiEventDataConverterNeunetWithPH::~UtsusemiEventDataConverterNeunetWithPH Destructor. 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::LoadParamFiles "bool UtsusemiEventDataConverterNeunetWithPH::LoadParamFiles(std::string w_file, std::string d_file, std::string c_file=\"\") UtsusemiEventDataConverterNeunetWithPH::LoadParamFiles Loads parameter files.
===========================================================================================================================================================================================================
    This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.

    Args:
        w_file (std::string) Wiring Info file path
        d_file (std::string) Detector Info file path
        c_file (std::string) Case Info file path

    Returns:
        true : succeeded.
        false : failed. 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::SetElementContainerNeunet "void UtsusemiEventDataConverterNeunetWithPH::SetElementContainerNeunet(UInt4 outer_pixel_id, ElementContainer *ec, UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPH::SetElementContainerNeunet Sets Histogram into ElementContainer.
===========================================================================================================================================================================================================================================

    Args:
        outer_pixel_id (UInt4) pixel_id
        ec (ElementContainer*)
        caseId (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::LoadEventDataFiles "Int4 UtsusemiEventDataConverterNeunetWithPH::LoadEventDataFiles(UInt4 runNumber, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunetWithPH::LoadEventDataFiles Loads event data files.
================================================================================================================================================================================================================================

    Args:
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 

    
Int4 UtsusemiEventDataConverterNeunetWithPH::LoadEventDataFiles(std::vector< UInt4 > runNumbers, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunetWithPH::LoadEventDataFiles Loads event data files.
================================================================================================================================================================================================================================================

    Args:
        runNumbers (<std::vector<UInt4>) a seriese of run numbers
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 
";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix "Int4 UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
==================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

    
Int4 UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
=========================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, std::string pathToData=\"\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
    
Int4 UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
========================================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, std::vector<UInt4> runNuber, std::string pathToData=\"\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (std::vector<UInt4>) the list of run numbers
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::LoadTrignetEventFile "void UtsusemiEventDataConverterNeunetWithPH::LoadTrignetEventFile(UInt4 runno, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunetWithPH::LoadTrignetEventFile Reads Trignet Event data file for cases.
=================================================================================================================================================================================================================================================

    Args:
        runno (UInt4) The run number
        pathData (std::string) path to the event data files
        pathToT0data (std::string) path to the t0 event data files

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::ReadTrignetEventFile "void UtsusemiEventDataConverterNeunetWithPH::ReadTrignetEventFile(std::string pathToTrigData, UInt4 index=0) UtsusemiEventDataConverterNeunetWithPH::ReadTrignetEventFile Reads Trignet Event data file for cases.
===================================================================================================================================================================================================================

    Args:
        pathToTrigData (std::string) path to TrigNET event data file
        index (UInt4) event file index

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::DumpCaseTable "std::vector< UInt4 > UtsusemiEventDataConverterNeunetWithPH::DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size) UtsusemiEventDataConverterNeunetWithPH::DumpCaseTable Dumps table of cases.
=========================================================================================================================================================================================================

    Args:
        i1 (UInt4)
        i2 (UInt4)
        isI1Size (bool)
        isI2Size (bool)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrixForPseudOnLineMon "Int4 UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrixForPseudOnLineMon(ElementContainerMatrix *ecm, UInt4 caseId=1, UInt4 runNo=999999) UtsusemiEventDataConverterNeunetWithPH::SetElementContainerMatrixForPseudOnLineMon Sets histograms to ElementContainermatrix as pseud on-line monitor.
================================================================================================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID
        runNo (UInt4) run number
        isI2Size (bool)

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::SetDataPathTest "Int4 UtsusemiEventDataConverterNeunetWithPH::SetDataPathTest(std::string dataPath, std::string t0Path, UInt4 runNo) UtsusemiEventDataConverterNeunetWithPH::SetDataPathTest Checks the function of SetDataPath.
================================================================================================================================================================================================================

    Args:
        dataPath (std::string) Tha path to data folder
        t0Path (std::string) Tha path to t0 data folder
        runNo (UInt4) run number

    Returns:
        0 : succeed
        -1 : failed 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::PutListOfCounterConditions "std::vector< Double > UtsusemiEventDataConverterNeunetWithPH::PutListOfCounterConditions() UtsusemiEventDataConverterNeunetWithPH::PutListOfCounterConditions Puts the list of the counter conditions for trignet.
===================================================================================================================================================================================================================
    This calls UtsusemiFilterTrignet::PutListOfCounterConditions

    Args:
        None

    Returns:
        std::vector<Double> [CaseId_0_start, CaseId_0_end, CaseId_1_start, ... , CaseId_n_end] 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightOfDet "ElementContainer UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightOfDet(ElementContainerMatrix *ecm, UInt4 OuterDetId, UInt4 binSize=1) UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightOfDet Makes Histogram of Pulse Height for each detector from its HeaderBase in ElementContainer.
====================================================================================================================================================================================================================================================================================================
    ElementContainer PutPulseHeightOfDet( ElementContainerMatrix* ecm, UInt4 OuterDetId, UInt4 binSize=1 );

    Args:
        ecm (ElementContainerMatrix*) target data
        OuterDetId (UInt4) target Det-Id
        binSize (UInt4) binning size of axis

    Returns:
        ElementContainer 

    
ElementContainer UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightOfDet(ElementContainerArray *eca, UInt4 binSize=1) UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightOfDet Makes Histogram of Pulse Height for each detector from its HeaderBase in ElementContainer.
=================================================================================================================================================================================================================================================================================
    ElementContainer PutPulseHeightOfDet( ElementContainerArray* eca, UInt4 binSize=1 );

    Args:
        eca (ElementContainerArray*) target data
        binSize (UInt4) binning size of axis

    Returns:
        ElementContainer 
";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightAll "ElementContainerArray UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightAll(ElementContainerMatrix *ecm, UInt4 binSize=1) UtsusemiEventDataConverterNeunetWithPH::PutPulseHeightAll Makes Histogram of Pulse Height for all detectors from HeaderBase in ElementContainer.
===============================================================================================================================================================================================================================================================================
    ElementContainerArray PutPulseHeightAll( ElementContainerMatrix* ecm, UInt4 binSize=1 );

    Args:
        ecm (ElementContainerMatrix*) target data
        binSize (UInt4) binning size of axis

    Returns:
        ElementContainerArray 

";
// File: classUtsusemiEventDataConverterNeunetWithPHDep.xml

%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep "

    Load Event Data and convert to Histogram for Inelastic scattering.
    LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )
    C++ includes: UtsusemiEventDataConverterNeunetWithPHDep.hh 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::UtsusemiEventDataConverterNeunetWithPHDep "UtsusemiEventDataConverterNeunetWithPHDep::UtsusemiEventDataConverterNeunetWithPHDep() UtsusemiEventDataConverterNeunetWithPHDep::UtsusemiEventDataConverterNeunetWithPHDep Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::~UtsusemiEventDataConverterNeunetWithPHDep "UtsusemiEventDataConverterNeunetWithPHDep::~UtsusemiEventDataConverterNeunetWithPHDep() UtsusemiEventDataConverterNeunetWithPHDep::~UtsusemiEventDataConverterNeunetWithPHDep Destructor. 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::LoadParamFiles "bool UtsusemiEventDataConverterNeunetWithPHDep::LoadParamFiles(std::string w_file, std::string d_file, std::string c_file=\"\") UtsusemiEventDataConverterNeunetWithPHDep::LoadParamFiles Loads parameter files.
=================================================================================================================================================================================================================
    This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.

    Args:
        w_file (std::string) Wiring Info file path
        d_file (std::string) Detector Info file path
        c_file (std::string) Case Info file path

    Returns:
        true : succeeded.
        false : failed. 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerNeunetWithPHDep "void UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerNeunetWithPHDep(UInt4 outer_pixel_id, ElementContainer *ec, UInt4 ph_i, UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerNeunetWithPHDep Sets Histogram into ElementContainer.
===============================================================================================================================================================================================================================================================================

    Args:
        outer_pixel_id (UInt4) pixel_id
        ec (ElementContainer*)
        ph_i (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::LoadEventDataFiles "Int4 UtsusemiEventDataConverterNeunetWithPHDep::LoadEventDataFiles(UInt4 runNumber, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunetWithPHDep::LoadEventDataFiles Loads event data files.
======================================================================================================================================================================================================================================

    Args:
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 

    
Int4 UtsusemiEventDataConverterNeunetWithPHDep::LoadEventDataFiles(std::vector< UInt4 > runNumbers, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunetWithPHDep::LoadEventDataFiles Loads event data files.
======================================================================================================================================================================================================================================================

    Args:
        runNumbers (<std::vector<UInt4>) a seriese of run numbers
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 
";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix "Int4 UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
========================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

    
Int4 UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
===============================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, std::string pathToData=\"\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
    
Int4 UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
==============================================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, std::vector<UInt4> runNuber, std::string pathToData=\"\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (std::vector<UInt4>) the list of run numbers
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
    
void UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 runNumber, UInt4 det_min, UInt4 det_max, UInt4 num_of_pixel, UInt4 ph_min, UInt4 ph_max, UInt4 ph_bin, std::string histparam=\"tof,0,40000,100\", std::string pathToData=\"/data\", std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
=================================================================================================================================================================================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, UInt4 det_min, UInt4 det_max, UInt4 num_of_pixel, UInt4 ph_min, UInt4 ph_max, UInt4 ph_bin, std::string histparam=\"tof,0,40000,100\", std::string pathToData=\"/data\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        runNumber (UInt4) run number
        det_min (UInt4) the minumum of the detector id range
        det_max (UInt4) the maximum of the detector id range
        num_of_pixel (UInt4) the number of pixels of one PSD
        ph_min (UInt4) the minimum of the pulse height range
        ph_max (UInt4) the maximum of the pulse height range
        ph_bin (UInt4) the bin width of the pulse height data
        histparam (std::string) the paramters of the histogram creations
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::LoadTrignetEventFile "void UtsusemiEventDataConverterNeunetWithPHDep::LoadTrignetEventFile(UInt4 runno, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterNeunetWithPHDep::LoadTrignetEventFile Reads Trignet Event data file for cases.
=======================================================================================================================================================================================================================================================

    Args:
        runno (UInt4) The run number
        pathData (std::string) path to the event data files
        pathToT0data (std::string) path to the t0 event data files

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::ReadTrignetEventFile "void UtsusemiEventDataConverterNeunetWithPHDep::ReadTrignetEventFile(std::string pathToTrigData, UInt4 index=0) UtsusemiEventDataConverterNeunetWithPHDep::ReadTrignetEventFile Reads Trignet Event data file for cases.
=========================================================================================================================================================================================================================

    Args:
        pathToTrigData (std::string) path to TrigNET event data files
        index (UInt4) event file index

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::DumpCaseTable "std::vector< UInt4 > UtsusemiEventDataConverterNeunetWithPHDep::DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size) UtsusemiEventDataConverterNeunetWithPHDep::DumpCaseTable Dumps table of cases.
===============================================================================================================================================================================================================

    Args:
        i1 (UInt4)
        i2 (UInt4)
        isI1Size (bool)
        isI2Size (bool)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrixForPseudOnLineMon "Int4 UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrixForPseudOnLineMon(ElementContainerMatrix *ecm, UInt4 caseId=1, UInt4 runNo=999999) UtsusemiEventDataConverterNeunetWithPHDep::SetElementContainerMatrixForPseudOnLineMon Sets histograms to ElementContainermatrix as pseud on-line monitor.
======================================================================================================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID
        runNo (UInt4) run number
        isI2Size (bool)

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::SetDataPathTest "Int4 UtsusemiEventDataConverterNeunetWithPHDep::SetDataPathTest(std::string dataPath, std::string t0Path, UInt4 runNo) UtsusemiEventDataConverterNeunetWithPHDep::SetDataPathTest Checks the function of SetDataPath.
======================================================================================================================================================================================================================

    Args:
        dataPath (std::string) Tha path to data folder
        t0Path (std::string) Tha path to t0 data folder
        runNo (UInt4) run number

    Returns:
        0 : succeed
        -1 : failed 

";
%feature("docstring") UtsusemiEventDataConverterNeunetWithPHDep::PutListOfCounterConditions "std::vector< Double > UtsusemiEventDataConverterNeunetWithPHDep::PutListOfCounterConditions() UtsusemiEventDataConverterNeunetWithPHDep::PutListOfCounterConditions Puts the list of the counter conditions for trignet.
=========================================================================================================================================================================================================================
    This calls UtsusemiFilterTrignet::PutListOfCounterConditions

    Args:
        None

    Returns:
        std::vector<Double> [CaseId_0_start, CaseId_0_end, CaseId_1_start, ... , CaseId_n_end] 

";
// File: classUtsusemiEventDataConverterRPMT.xml

%feature("docstring") UtsusemiEventDataConverterRPMT "

    Load Event Data and convert to Histogram from 2d-scintillation counter PCMT.
    LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )
    C++ includes: UtsusemiEventDataConverterRPMT.hh 

";
%feature("docstring") UtsusemiEventDataConverterRPMT::UtsusemiEventDataConverterRPMT "UtsusemiEventDataConverterRPMT::UtsusemiEventDataConverterRPMT() UtsusemiEventDataConverterRPMT::UtsusemiEventDataConverterRPMT Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterRPMT::~UtsusemiEventDataConverterRPMT "UtsusemiEventDataConverterRPMT::~UtsusemiEventDataConverterRPMT() UtsusemiEventDataConverterRPMT::~UtsusemiEventDataConverterRPMT Destructor. 

";
// File: classUtsusemiEventDataConverterReadoutTemplate.xml

%feature("docstring") UtsusemiEventDataConverterReadoutTemplate "

    Expansion of Template class for Convesion of event data from Readout module.
    read EvnetDataFile
    Decode Event data using Decode module
    C++ includes: UtsusemiEventDataConverterReadoutTemplate.hh 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::UtsusemiEventDataConverterReadoutTemplate "UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::UtsusemiEventDataConverterReadoutTemplate() UtsusemiEventDataConverterReadoutTemplate::UtsusemiEventDataConverterReadoutTemplate Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::~UtsusemiEventDataConverterReadoutTemplate "UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::~UtsusemiEventDataConverterReadoutTemplate() UtsusemiEventDataConverterReadoutTemplate::~UtsusemiEventDataConverterReadoutTemplate Destructor. 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::ReadEventData "void UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::ReadEventData(UInt4 daqId, UInt4 modNo) UtsusemiEventDataConverterReadoutTemplate::ReadEventData Reads Event data file to make histograms.
=====================================================================================================================================================================================================

    Args:
        daqId (UInt4) DAQ id
        modNo (UInt4) module No

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::CheckPulseIdTables "void UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::CheckPulseIdTables() UtsusemiEventDataConverterReadoutTemplate::CheckPulseIdTables Compares PulseId between ReadoutGate and Readout.
===============================================================================================================================================================================================
    to make unified T0Index

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::LoadEventDataFiles "Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::LoadEventDataFiles(UInt4 runNumber, std::string pathToData, std::string pathToT0data) UtsusemiEventDataConverterReadoutTemplate::LoadEventDataFiles

    
Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::LoadEventDataFiles(std::vector< UInt4 > runNumbers, std::string pathToData, std::string pathToT0data) UtsusemiEventDataConverterReadoutTemplate::LoadEventDataFiles Reads Event data file to make histograms.
========================================================================================================================================================================================================================================================================

    Args:
        runNumber (UInt4) Run number
        runNumbers (std::vector<UInt4>) Run numbers
        pathToData (std::string) path to data folder like /data
        pathToT0Data (std::string) path to t0 index event data folder like /data

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo 
";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::SetElementContainerReadout "void UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetElementContainerReadout(UInt4 outer_pixel_id, ElementContainer *ec, UInt4 caseId) UtsusemiEventDataConverterReadoutTemplate::SetElementContainerReadout Sets ElementContaienr from stored gsl_histogram.
======================================================================================================================================================================================================================================================================

    Args:
        outer_pixel_id (UInt4) Pixel ID
        ec (ElementContainer) target ElementContainer
        caseId (UInt4) Case ID

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::LoadParamFiles "bool UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::LoadParamFiles(std::string w_file, std::string d_file, std::string c_file=\"\") UtsusemiEventDataConverterReadoutTemplate::LoadParamFiles Loads parameter files.
===========================================================================================================================================================================================================================
    This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.

    Args:
        w_file (std::string) Wiring Info file path
        d_file (std::string) Detector Info file path
        c_file (std::string) Case Info file path

    Returns:
        true : succeeded.
        false : failed. 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::SetElementContainerMatrix "Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1) UtsusemiEventDataConverterReadoutTemplate::SetElementContainerMatrix

    
Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterReadoutTemplate::SetElementContainerMatrix
    
Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > runNuber, std::string pathToData, std::string pathToT0data=\"\", UInt4 caseId=1) UtsusemiEventDataConverterReadoutTemplate::SetElementContainerMatrix Sets Histogram into ElementContainerMatrix.
========================================================================================================================================================================================================================================================================================================================================
    SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 ) SetElementContainerMatrix( ElementContainerMatrix* ecm, std::string instCode, UInt4 runNuber, std::string pathToData=\"\", std::string pathToT0data=\"\", UInt4 caseId=1 )

    Args:
        ecm (ElementContainerMatrix*)
        instCode (std::string) Instrument code
        runNumber (UInt4) run number
        pathToData (std::string) path to root directory of instruments event data folders (\"/data\")
        pathToT0data (std::string) path to directory to store T0Index event data files
        caseId (UInt4) case ID

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 
";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::LoadTrignetEventFile "void UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::LoadTrignetEventFile(UInt4 runno, std::string pathToData=\"\", std::string pathToT0data=\"\") UtsusemiEventDataConverterReadoutTemplate::LoadTrignetEventFile

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::ReadTrignetEventFile "void UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::ReadTrignetEventFile(std::string pathToTrigData, UInt4 index=0) UtsusemiEventDataConverterReadoutTemplate::ReadTrignetEventFile Reads Trignet Event data file for cases.
===================================================================================================================================================================================================================================

    Args:
        pathToTrigData (std::string) path to TrigNET event data files
        index (UInt4) event file index

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::DumpCaseTable "std::vector< UInt4 > UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size) UtsusemiEventDataConverterReadoutTemplate::DumpCaseTable Dumps table of cases.
=========================================================================================================================================================================================================================

    Args:
        i1 (UInt4)
        i2 (UInt4)
        isI1Size (bool)
        isI2Size (bool)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::SetElementContainerMatrixForPseudOnLineMon "Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetElementContainerMatrixForPseudOnLineMon(ElementContainerMatrix *ecm, UInt4 caseId=1, UInt4 runNo=999999) UtsusemiEventDataConverterReadoutTemplate::SetElementContainerMatrixForPseudOnLineMon Sets histograms to ElementContainermatrix as pseud on-line monitor.
================================================================================================================================================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*)
        caseId (UInt4) case ID
        runNo (UInt4) run number
        isI2Size (bool)

    Returns:
        0 : succeed
        -1 : Not found data folder with given run numbers
        -2 : Never loaded WiringInfo
        -3 : Wrong defined TOF binning info ( failed to load WiringInfo ) 

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::SetDataPathTest "Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetDataPathTest(std::string dataPath, std::string t0Path, UInt4 runNo) UtsusemiEventDataConverterReadoutTemplate::SetDataPathTest

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::PutListOfCounterConditions "std::vector< Double > UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::PutListOfCounterConditions() UtsusemiEventDataConverterReadoutTemplate::PutListOfCounterConditions

";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::SetTofOriginShift "bool UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetTofOriginShift(UInt4 cType) UtsusemiEventDataConverterReadoutTemplate::SetTofOriginShift

    
bool UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::SetTofOriginShift(UInt4 cType, std::vector< Double > params) UtsusemiEventDataConverterReadoutTemplate::SetTofOriginShift
";
%feature("docstring") UtsusemiEventDataConverterReadoutTemplate::_SetElementContainerMatrix "virtual Int4 UtsusemiEventDataConverterReadoutTemplate< T1, T2 >::_SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1)=0 UtsusemiEventDataConverterReadoutTemplate::_SetElementContainerMatrix

";
// File: classUtsusemiEventDataConverterReadoutWLSF32Template.xml

%feature("docstring") UtsusemiEventDataConverterReadoutWLSF32Template "

    Expansion of Template class for Convesion with Pulse Height.
    from EventData to Histogram on offline. read EvnetDataFile
    Decode Event data using Decode module
    Increment to gls histogram and make Pulse Height
    Put Pulse Height into HeaderBase for each ElementContainer This template requires the instanse successing UtsusemiNeutronEventDecorder.
    C++ includes: UtsusemiEventDataConverterReadoutWLSF32Template.hh 

";
%feature("docstring") UtsusemiEventDataConverterReadoutWLSF32Template::UtsusemiEventDataConverterReadoutWLSF32Template "UtsusemiEventDataConverterReadoutWLSF32Template< T1, T2 >::UtsusemiEventDataConverterReadoutWLSF32Template() UtsusemiEventDataConverterReadoutWLSF32Template::UtsusemiEventDataConverterReadoutWLSF32Template

";
%feature("docstring") UtsusemiEventDataConverterReadoutWLSF32Template::~UtsusemiEventDataConverterReadoutWLSF32Template "UtsusemiEventDataConverterReadoutWLSF32Template< T1, T2 >::~UtsusemiEventDataConverterReadoutWLSF32Template() UtsusemiEventDataConverterReadoutWLSF32Template::~UtsusemiEventDataConverterReadoutWLSF32Template

";
%feature("docstring") UtsusemiEventDataConverterReadoutWLSF32Template::Increment "void UtsusemiEventDataConverterReadoutWLSF32Template< T1, T2 >::Increment(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 size, UInt4 ThNum, std::vector< Double > *Offset, std::vector< UInt4 > *Case) UtsusemiEventDataConverterReadoutWLSF32Template::Increment Increment intensity.
==============================================================================================================================================================================================================================================================================================
    Increment intensity of histogram by using information from decoded event

    Args:
        daqId (UInt4) DAQ id
        moduleNo (UInt4) Module No
        data (UChar*) event data
        size (UInt4) size of event data
        ThNum (UInt4) thread number
        Offset (Double) offset value

    Returns:
        None
        < This is Increment function
        < Why this needs ? Because DecodeEventData require different argument moduleNo. 

";
// File: classUtsusemiEventDataConverterSample.xml

%feature("docstring") UtsusemiEventDataConverterSample "

    Load Event Data and convert to Histogram for Inelastic scattering.
    C++ includes: UtsusemiEventDataConverterSample.hh 

";
%feature("docstring") UtsusemiEventDataConverterSample::UtsusemiEventDataConverterSample "UtsusemiEventDataConverterSample::UtsusemiEventDataConverterSample() UtsusemiEventDataConverterSample::UtsusemiEventDataConverterSample Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterSample::~UtsusemiEventDataConverterSample "UtsusemiEventDataConverterSample::~UtsusemiEventDataConverterSample() UtsusemiEventDataConverterSample::~UtsusemiEventDataConverterSample Destructor. 

";
// File: classUtsusemiEventDataConverterSimpleNeunet.xml

%feature("docstring") UtsusemiEventDataConverterSimpleNeunet "

    Load single event data file to convert to histogram briefly.
    tt= UtsusemiEventDataConverterSimpleNeunet() Set the number of pixels in a PSD tt.SetNumOfPixel(100) Set ABC parameters for each PSD A, B, C = ( 1100.000, 1.0, 65.00 ) tt.SetPsdParam( A, B, C ) Set min LLD and max LLD tt.SetPsdPH( 512, 4096 ) Set parameters for histogram conversion tt.SetHistParams( \"tof,0,40000,100\" ) Read event data file(s) to create histogram modNo = 0 tt.ReadEventData( modNo, \"SIK000373_00_000_000.edb\" ) Set histogram to ElementContainerMatrix ecm = ElementContainerMatrix() tt.SetElementContainerMatrix( ecm )
    C++ includes: UtsusemiEventDataConverterSimpleNeunet.hh 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::UtsusemiEventDataConverterSimpleNeunet "UtsusemiEventDataConverterSimpleNeunet::UtsusemiEventDataConverterSimpleNeunet() UtsusemiEventDataConverterSimpleNeunet::UtsusemiEventDataConverterSimpleNeunet Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::~UtsusemiEventDataConverterSimpleNeunet "UtsusemiEventDataConverterSimpleNeunet::~UtsusemiEventDataConverterSimpleNeunet() UtsusemiEventDataConverterSimpleNeunet::~UtsusemiEventDataConverterSimpleNeunet Destructor. 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetL1 "void UtsusemiEventDataConverterSimpleNeunet::SetL1(Double L1) UtsusemiEventDataConverterSimpleNeunet::SetL1

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetNumOfMod "void UtsusemiEventDataConverterSimpleNeunet::SetNumOfMod(UInt4 n) UtsusemiEventDataConverterSimpleNeunet::SetNumOfMod Sets the number of NEUNET modules.
=========================================================================================================================================================
    This number is used to calculate detId (= n * 8)

    Args:
        n (UInt4) the number of NEUNET modules

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetNumOfPixel "void UtsusemiEventDataConverterSimpleNeunet::SetNumOfPixel(UInt4 _numPix) UtsusemiEventDataConverterSimpleNeunet::SetNumOfPixel Sets the number of pixels in a PSD.
====================================================================================================================================================================

    Args:
        _numPix (UInt4) the number of pixels in a PSD

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetPsdParam "void UtsusemiEventDataConverterSimpleNeunet::SetPsdParam(Double _A, Double _B, Double _C) UtsusemiEventDataConverterSimpleNeunet::SetPsdParam Sets A B C parameters to all PSD.
================================================================================================================================================================================

    Args:
        _A (Double) parameter A
        _B (Double) parameter B
        _C (Double) parameter C

    Returns:
        None 

    
bool UtsusemiEventDataConverterSimpleNeunet::SetPsdParam(UInt4 detId, Double _A, Double _B, Double _C) UtsusemiEventDataConverterSimpleNeunet::SetPsdParam Sets A B C parameters to a PSD of given detId.
==========================================================================================================================================================================================================

    Args:
        detId (UInt4) target detector ID
        _A (Double) parameter A
        _B (Double) parameter B
        _C (Double) parameter C

    Returns:
        true setting is succeeded
        false failed setting 
";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetPsdPosition "bool UtsusemiEventDataConverterSimpleNeunet::SetPsdPosition(UInt4 detId, std::vector< Double > det_info) UtsusemiEventDataConverterSimpleNeunet::SetPsdPosition Sets psd position information for each PSD of given detId.
===========================================================================================================================================================================================================================
    ( Under construction ) 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetPsdPH "void UtsusemiEventDataConverterSimpleNeunet::SetPsdPH(Double _minPH, Double _maxPH=4096) UtsusemiEventDataConverterSimpleNeunet::SetPsdPH Sets the limitation for the pulse height.
====================================================================================================================================================================================

    Args:
        _minPH (Double) lower limit of pulse height
        _maxPH (Double) upper limit of pulse height

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetPsdInfo "void UtsusemiEventDataConverterSimpleNeunet::SetPsdInfo(Double deltaX, Double offsetX) UtsusemiEventDataConverterSimpleNeunet::SetPsdInfo Sets PSD information for all PSD.
============================================================================================================================================================================

    Args:
        _minPH (Double) lower limit of pulse height
        _maxPH (Double) upper limit of pulse height

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetHistParams "bool UtsusemiEventDataConverterSimpleNeunet::SetHistParams(std::string _params) UtsusemiEventDataConverterSimpleNeunet::SetHistParams Sets parameters to create histogram.
===========================================================================================================================================================================

    Args:
        _params (String) histogram parameters

    Returns:
        true setting is succeeded
        false failed setting 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::ReadEventData "bool UtsusemiEventDataConverterSimpleNeunet::ReadEventData(UInt4 modNo, std::string _file) UtsusemiEventDataConverterSimpleNeunet::ReadEventData Load event data file.
=======================================================================================================================================================================

    Args:
        modNo (UInt4) NEUNET module No
        _file (String) the path to event data file

    Returns:
        true setting is succeeded
        false failed setting 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::SetElementContainerMatrix "bool UtsusemiEventDataConverterSimpleNeunet::SetElementContainerMatrix(ElementContainerMatrix *_ecm) UtsusemiEventDataConverterSimpleNeunet::SetElementContainerMatrix Sets created histogram data into given ElementContainerMatrix.
======================================================================================================================================================================================================================================

    Args:
        _ecm (ElementContainerMatrix) container

    Returns:
        true setting is succeeded
        false failed setting 

";
%feature("docstring") UtsusemiEventDataConverterSimpleNeunet::Test "void UtsusemiEventDataConverterSimpleNeunet::Test(ElementContainerMatrix *_ecm, UInt4 modNo, std::string _filePath) UtsusemiEventDataConverterSimpleNeunet::Test

";
// File: classUtsusemiEventDataConverterTemplate.xml

%feature("docstring") UtsusemiEventDataConverterTemplate "

    Template class for Convesion.
    from EventData to Histogram on offline. read EvnetDataFile
    Decode Event data using Decode module
    Increment to gls histogram This template requires the instanse successing UtsusemiNeutronEventDecorder.
    C++ includes: UtsusemiEventDataConverterTemplate.hh 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::UtsusemiEventDataConverterTemplate "UtsusemiEventDataConverterTemplate< T1, T2 >::UtsusemiEventDataConverterTemplate() UtsusemiEventDataConverterTemplate::UtsusemiEventDataConverterTemplate Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::~UtsusemiEventDataConverterTemplate "UtsusemiEventDataConverterTemplate< T1, T2 >::~UtsusemiEventDataConverterTemplate() UtsusemiEventDataConverterTemplate::~UtsusemiEventDataConverterTemplate Destructor. 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutEventDecoder "T1 * UtsusemiEventDataConverterTemplate< T1, T2 >::PutEventDecoder() UtsusemiEventDataConverterTemplate::PutEventDecoder Puts instanse of event decoder class.
===============================================================================================================================================================

    Returns:
        instanse of event decoder class 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutCaseDecoder "T2 * UtsusemiEventDataConverterTemplate< T1, T2 >::PutCaseDecoder() UtsusemiEventDataConverterTemplate::PutCaseDecoder Puts instanse of case decoder class.
============================================================================================================================================================

    Returns:
        instanse of case decoder class 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetEventParams "bool UtsusemiEventDataConverterTemplate< T1, T2 >::SetEventParams(std::string wiring_file, std::string detector_file) UtsusemiEventDataConverterTemplate::SetEventParams Sets Wiring Info and Detector Info files.
===================================================================================================================================================================================================================

    Args:
        wiring_file (std::string) path to Wiring Info file
        detector_file (std::string) path to Detector Info file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetCaseInfoParams "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetCaseInfoParams(std::string pathToCaseInfo) UtsusemiEventDataConverterTemplate::SetCaseInfoParams Sets CaseInfo file.
===========================================================================================================================================================================

    Args:
        pathToCaseInfo (std::string) path to caseInfo file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::AllocateGslHist "void UtsusemiEventDataConverterTemplate< T1, T2 >::AllocateGslHist(UInt4 numOfPixel=0, UInt4 numOfCases=0) UtsusemiEventDataConverterTemplate::AllocateGslHist Allocate memory for GSL Histogram.
==================================================================================================================================================================================================
    This makes gslhistogram with the number of numOfPixel * numOfCases

    Args:
        numOfPixel (UInt4) the number of pixels
        numOfPixel (UInt4) the number of cases

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetHistBin "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetHistBin(UInt4 innerPixelId, Double *tof, UInt4 Size) UtsusemiEventDataConverterTemplate::SetHistBin Set binning of histogram with array.
===============================================================================================================================================================================================

    Args:
        innerPixelId (UInt4) inner pixel id
        tof (Double*) array of tof
        Size (UInt4) the number of array

    Returns:
        None 

    
void UtsusemiEventDataConverterTemplate< T1, T2 >::SetHistBin(UInt4 innerPixelId, std::vector< Double > xaxis) UtsusemiEventDataConverterTemplate::SetHistBin Set binning of histogram with std::vector.
=========================================================================================================================================================================================================
    This calls SetHistBin.

    Args:
        innerPixelId (UInt4) inner pixel id
        xaxis (std::vector<Double>) std::vector of tof

    Returns:
        None 
    
void UtsusemiEventDataConverterTemplate< T1, T2 >::SetHistBin() UtsusemiEventDataConverterTemplate::SetHistBin Set binning of histogram.
=========================================================================================================================================
    This calls SetHistBin using information loaded from wiring info and detector info
    return None 
    
void UtsusemiEventDataConverterTemplate< T1, T2 >::SetHistBin(ElementContainerMatrix *ecm, std::string _key=\"\") UtsusemiEventDataConverterTemplate::SetHistBin
";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetHistAllocation "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetHistAllocation(UInt4 num_of_multh=0) UtsusemiEventDataConverterTemplate::SetHistAllocation Allocation of GSL-Histogram and SetHistBin.
=============================================================================================================================================================================================
    This executes simple allocation as AllocateGslHist(); SethistBin();

    Args:
        num_of_multh (UInt4) set _NumOfMulTh if num_of_multh!=0

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::Increment "void UtsusemiEventDataConverterTemplate< T1, T2 >::Increment(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 size, UInt4 ThNum, std::vector< Double > *Offset, std::vector< UInt4 > *Case) UtsusemiEventDataConverterTemplate::Increment Increment intensity.
====================================================================================================================================================================================================================================================================
    Increment intensity of histogram by using information from decoded event

    Args:
        daqId (UInt4) DAQ id
        moduleNo (UInt4) Module No
        data (UChar*) event data
        size (UInt4) size of event data
        ThNum (UInt4) thread number
        Offset (Double) offset value

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PreIncrement "void UtsusemiEventDataConverterTemplate< T1, T2 >::PreIncrement(UInt4 daqId, UInt4 moduleNo, const UChar *data, std::vector< UInt8 > T0Table, std::vector< Double > ClockTable, std::vector< std::vector< UInt4 > * > *CaseTable) UtsusemiEventDataConverterTemplate::PreIncrement

    
void UtsusemiEventDataConverterTemplate< T1, T2 >::PreIncrement(UInt4 daqId, UInt4 moduleNo, const UChar *data, std::vector< UInt8 > T0Table) UtsusemiEventDataConverterTemplate::PreIncrement Pre-process to convert event data to histogam.
==============================================================================================================================================================================================================================================
    Pre-process to convert event data to histogam with multh-threading.

    Args:
        daqId (UInt4) DAQ id
        moduleNo (UInt4) module No
        data (UChar*) event data
        T0Table (vecrot<UInt4>) T0 index
        ClockTable (std::vector<Double>) Differences between instrument clocks
        CaseTable (std::vector<std::vector<UInt4>>) Table of cases pattern

    Returns:
        None 
";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetDataPathOld "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetDataPathOld(std::string dataPath, std::string t0Path, std::vector< UInt4 > runNumbers, bool isReset=false) UtsusemiEventDataConverterTemplate::SetDataPathOld

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetDataPath "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetDataPath(std::string dataPath, std::string t0Path, UInt4 runNo, bool isReset=false, std::vector< std::vector< std::vector< std::vector< Int4 > * > * > * > *_PixelInfoStore=NULL, std::vector< std::pair< UInt4, UInt4 > > *maskModules=NULL, bool makeT0b=true) UtsusemiEventDataConverterTemplate::SetDataPath

    
void UtsusemiEventDataConverterTemplate< T1, T2 >::SetDataPath(std::string dataPath, std::string t0Path, std::vector< UInt4 > runNumbers, bool isReset=false, std::vector< std::vector< std::vector< std::vector< Int4 > * > * > * > *_PixelInfoStore=NULL, std::vector< std::pair< UInt4, UInt4 > > *maskModules=NULL, bool makeT0b=true) UtsusemiEventDataConverterTemplate::SetDataPath Sets path to Event data files.
==========================================================================================================================================================================================================================================================================================================================================================================================================================
    This makes list of Event data files and T0 event data files to be read. This finds data directories like /data/XXX, /data/XXX01, /data/XXX02, ... /data/XXX99, then search run_folder and data files in found data directoris from beggning as XXX -> XXX01 -> XXX02 -> ... If data files (edb) are founds, searching in directories stops.

    Args:
        dataPath (std::string) Path to Event data folder ( \"/data\" )
        t0Path (std::string) Path to T0Event data folder
        runNo (UInt4) RunNo
        runNumbers (std::vector<UInt4> list of RunNo to be combined
        isReset (bool) Resets previous file list or not
        _PixelInfoStore
        maskModules
        makeT0b (bool) true: try to create t0b

    Returns:
        None 
";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutDataFiles "std::vector< std::string > UtsusemiEventDataConverterTemplate< T1, T2 >::PutDataFiles(UInt4 daqId, UInt4 modNo, bool isEdb=true) UtsusemiEventDataConverterTemplate::PutDataFiles Puts data file list.
=======================================================================================================================================================================================================
    This puts data files with given daqId, modNo from made list of data files

    Args:
        daqId (UInt4) DAQ id
        modNo (UInt4) module No
        isEdb (bool) event data file (true) or t0b file (false)

    Returns:
        file list (std::vector<stirng>) 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutFilesSize "std::vector< UInt8 > UtsusemiEventDataConverterTemplate< T1, T2 >::PutFilesSize(std::vector< std::string > files) UtsusemiEventDataConverterTemplate::PutFilesSize Puts file sizes of given pathes.
====================================================================================================================================================================================================

    Args:
        files (std::vector<std::string>) path list

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::ReadEventData "void UtsusemiEventDataConverterTemplate< T1, T2 >::ReadEventData(UInt4 daqId, UInt4 modNo) UtsusemiEventDataConverterTemplate::ReadEventData Read Event data file to make histograms.
======================================================================================================================================================================================

    Args:
        daqId (UInt4) DAQ id
        modNo (UInt4) module No

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutHistId "UInt4 UtsusemiEventDataConverterTemplate< T1, T2 >::PutHistId(UInt4 PixelId, UInt4 CaseId=1) UtsusemiEventDataConverterTemplate::PutHistId Puts Histogram ID from outer PixelId and CaseId.
============================================================================================================================================================================================
    Histogram ID is used for allocated GSL-Histograms.

    Args:
        PixelId (UInt4) outer pixel ID
        CaseId (UInt4) case id

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutHist "std::vector< Double > UtsusemiEventDataConverterTemplate< T1, T2 >::PutHist(UInt4 PixelId, UInt4 CaseId=1) UtsusemiEventDataConverterTemplate::PutHist Puts intensity of histogram by outer PixelId and CaseId.
================================================================================================================================================================================================================

    Args:
        PixelId (UInt4) outer pixel ID
        CaseId (UInt4) case id

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutErr "std::vector< Double > UtsusemiEventDataConverterTemplate< T1, T2 >::PutErr(UInt4 PixelId, UInt4 CaseId=1) UtsusemiEventDataConverterTemplate::PutErr Puts error of histogram by outer PixelId and CaseId.
==========================================================================================================================================================================================================

    Args:
        PixelId (UInt4) outer pixel ID
        CaseId (UInt4) case id

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::TimeDependBackGroundCorrection "Double UtsusemiEventDataConverterTemplate< T1, T2 >::TimeDependBackGroundCorrection(bool isIntensity, std::vector< Double > *tof_vec, std::vector< Double > *hist_vec, std::vector< Double > *bg_info, std::vector< Double > *ret) UtsusemiEventDataConverterTemplate::TimeDependBackGroundCorrection Executes time-depend background correction.
==================================================================================================================================================================================================================================================================================================================================================

    Args:
        isIntensity (bool) hist_vec is the intensity (true) or errors (false).
        tof_vec (std::vector<Double>) TOF std::vector including backgrond region.
        hist_vec (std::vector<Double>) The intensity or error values
        bg_info (std::vector<Double>) Background Info [0]:patern, [1]:first tof val, [2]:last tof val
        ret (std::vector<Double>) corrected hist_vec.

    Returns:
        background intensity per unit (Double) 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::InitTimeDependBackGroundList "void UtsusemiEventDataConverterTemplate< T1, T2 >::InitTimeDependBackGroundList() UtsusemiEventDataConverterTemplate::InitTimeDependBackGroundList

";
%feature("docstring") UtsusemiEventDataConverterTemplate::TimeDependBackGroundCorrectionByList "bool UtsusemiEventDataConverterTemplate< T1, T2 >::TimeDependBackGroundCorrectionByList(bool isIntensity, std::vector< Double > *tof_vec, std::vector< Double > *hist_vec, UInt4 pixelId, UInt4 multh, std::vector< Double > *ret, UInt4 caseId=1) UtsusemiEventDataConverterTemplate::TimeDependBackGroundCorrectionByList

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SaveTimeDependBackGroundListToFile "bool UtsusemiEventDataConverterTemplate< T1, T2 >::SaveTimeDependBackGroundListToFile(std::string filePath, UInt4 caseId=1) UtsusemiEventDataConverterTemplate::SaveTimeDependBackGroundListToFile

";
%feature("docstring") UtsusemiEventDataConverterTemplate::ReadTimeDependBackGroundListFromFile "bool UtsusemiEventDataConverterTemplate< T1, T2 >::ReadTimeDependBackGroundListFromFile(std::string filePath) UtsusemiEventDataConverterTemplate::ReadTimeDependBackGroundListFromFile

";
%feature("docstring") UtsusemiEventDataConverterTemplate::ClearTimeDependBackGroundList "void UtsusemiEventDataConverterTemplate< T1, T2 >::ClearTimeDependBackGroundList() UtsusemiEventDataConverterTemplate::ClearTimeDependBackGroundList

";
%feature("docstring") UtsusemiEventDataConverterTemplate::ReadCaseEvent "void UtsusemiEventDataConverterTemplate< T1, T2 >::ReadCaseEvent(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiEventDataConverterTemplate::ReadCaseEvent

";
%feature("docstring") UtsusemiEventDataConverterTemplate::ReadCaseEventFiles "void UtsusemiEventDataConverterTemplate< T1, T2 >::ReadCaseEventFiles(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiEventDataConverterTemplate::ReadCaseEventFiles Reads event data files for cases.
========================================================================================================================================================================================================================================================

    Args:
        index (UInt4) index for files ( XXX001000_00_000_000.edb, _001.edb ... has same index )
        evt_files (std::vector<std::string>) pathes to neutron event data file
        t0b_files (std::vector<std::string>) pathes to t0b event data file

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetFlagOfPulseIdCheck "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetFlagOfPulseIdCheck(bool flag=true) UtsusemiEventDataConverterTemplate::SetFlagOfPulseIdCheck Sets flag of Pulse iD check.
================================================================================================================================================================================
    This flag is used to compare pulse id between neutrons event data and case (trignet) event data

    Args:
        flag (bool) true : do check on reading case event data

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetElementContainer "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetElementContainer(UInt4 PixelId, ElementContainer *ec, UInt4 caseId=0) UtsusemiEventDataConverterTemplate::SetElementContainer Put histogram data into ElementContainer with Case.
========================================================================================================================================================================================================================================
    Before using this method, target ElementContainer must be created.

    Args:
        PixelId (UInt4) pixel Id
        ec (ElementContainer) target ElementContainer
        caseId (UInt4) case Id

    Returns:
        None
        }else if (tof_bin_type<5){ ec->Add(xlabel.first,_gslHist->at(innerId)->PutBin(),xlabel.second); if (_runNumber>0){ ec->Add(ylabel.first,PutHist( outerPixelId, caseId ),ylabel.second); ec->Add(elabel.first,PutErr( outerPixelId, caseId ),elabel.second ); }else{ std::vector<Double> dummy( (ec->Put(xlabel.first).size()-1),1 ); ec->Add(ylabel.first,dummy,ylabel.second); ec->Add(elabel.first,dummy,elabel.second ); } ec->SetKeys(xlabel.first,ylabel.first,elabel.first); }else if ((tof_bin_type==12)||(tof_bin_type==13)||(tof_bin_type==20)||(tof_bin_type==23)||(tof_bin_type==24)||(tof_bin_type==25)){ ec->Add(xlabel.first,_EventDecoder->PutXaxis(),xlabel.second); if (_runNumber>0){ ec->Add(ylabel.first,PutHist( outerPixelId, caseId ),ylabel.second); ec->Add(elabel.first,PutErr( outerPixelId, caseId ),elabel.second ); }else{ std::vector<Double> dummy( (ec->Put(xlabel.first).size()-1),1 ); ec->Add(ylabel.first,dummy,ylabel.second); ec->Add(elabel.first,dummy,elabel.second ); }
        ec->SetKeys(xlabel.first,ylabel.first,elabel.first); }else if ((tof_bin_type==21)||(tof_bin_type==22)||(tof_bin_type==27)){ std::vector<Double> xxv = _EventDecoder->PutXaxis(); std::vector<Double> yyv = PutHist( outerPixelId, caseId ); std::vector<Double> eev = PutErr( outerPixelId, caseId ); reverse( xxv.begin(),xxv.end() ); reverse( yyv.begin(),yyv.end() ); reverse( eev.begin(),eev.end() ); ec->Add(xlabel.first,xxv,xlabel.second); ec->Add(ylabel.first,yyv,ylabel.second); ec->Add(elabel.first,eev,elabel.second ); ec->SetKeys(xlabel.first,ylabel.first,elabel.first); 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::ResetHistogram "void UtsusemiEventDataConverterTemplate< T1, T2 >::ResetHistogram() UtsusemiEventDataConverterTemplate::ResetHistogram Reset Histogram.
========================================================================================================================================
    Clear all values in bins of GslHistogram ( binning is kept )

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutNumOfCases "UInt4 UtsusemiEventDataConverterTemplate< T1, T2 >::PutNumOfCases() UtsusemiEventDataConverterTemplate::PutNumOfCases Return number of cases.
==============================================================================================================================================

    Returns:
        UInt4 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutMeasTimeList "std::vector< Double > UtsusemiEventDataConverterTemplate< T1, T2 >::PutMeasTimeList() UtsusemiEventDataConverterTemplate::PutMeasTimeList

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutListOfCases "std::vector< UInt4 > UtsusemiEventDataConverterTemplate< T1, T2 >::PutListOfCases() UtsusemiEventDataConverterTemplate::PutListOfCases Puts list of cases.
===========================================================================================================================================================

    Args:
        None

    Returns:
        list of cases 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutNumOfT0ListInCases "std::vector< UInt4 > UtsusemiEventDataConverterTemplate< T1, T2 >::PutNumOfT0ListInCases() UtsusemiEventDataConverterTemplate::PutNumOfT0ListInCases

";
%feature("docstring") UtsusemiEventDataConverterTemplate::PutMeasTime "std::vector< Double > UtsusemiEventDataConverterTemplate< T1, T2 >::PutMeasTime() UtsusemiEventDataConverterTemplate::PutMeasTime put measuring period from instrument clock event
===================================================================================================================================================================================
    This returns std::vector with 12 params. If conversion is failed, size of returned vector is one.

    Args:
        None

    Returns:
        std::vector<Double> std::vector with 12 params for begin time and end time (year,month,day,hour,minute,second,sub-second) x 2 

";
%feature("docstring") UtsusemiEventDataConverterTemplate::AddRunInfoToHeader "bool UtsusemiEventDataConverterTemplate< T1, T2 >::AddRunInfoToHeader(HeaderBase *_hh, UInt4 caseId=1) UtsusemiEventDataConverterTemplate::AddRunInfoToHeader

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetRangeOfSingleTimeSlicing "bool UtsusemiEventDataConverterTemplate< T1, T2 >::SetRangeOfSingleTimeSlicing(double startSec, double endSec) UtsusemiEventDataConverterTemplate::SetRangeOfSingleTimeSlicing Sets time range for time slice of event data.
=============================================================================================================================================================================================================================
    Values for time are indicated the passed time [sec] from head of event data

    Args:
        startSec start time [sec]
        endSec end time [sec]

    Returns:
        true succeeded
        false failed 

    
bool UtsusemiEventDataConverterTemplate< T1, T2 >::SetRangeOfSingleTimeSlicing(std::string startDate, std::string endDate) UtsusemiEventDataConverterTemplate::SetRangeOfSingleTimeSlicing Sets time range for time slice of event data.
=========================================================================================================================================================================================================================================
    Values for time are indicated the passed time [sec] from head of event data std::string format : \"YYYY,MM,DD,hh,mm,ss,s.ss\", \"2011,1,22,13,54,22,0.54\"

    Args:
        startDate start date std::string
        endDate end date std::string

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetTimeSlicing "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetTimeSlicing(std::vector< Double > tmp) UtsusemiEventDataConverterTemplate::SetTimeSlicing

";
%feature("docstring") UtsusemiEventDataConverterTemplate::SetFramePeriod "void UtsusemiEventDataConverterTemplate< T1, T2 >::SetFramePeriod(Double _time) UtsusemiEventDataConverterTemplate::SetFramePeriod

";
// File: classUtsusemiEventDataConverterTemplateWithPH.xml

%feature("docstring") UtsusemiEventDataConverterTemplateWithPH "

    Expansion of Template class for Convesion with Pulse Height.
    from EventData to Histogram on offline. read EvnetDataFile
    Decode Event data using Decode module
    Increment to gls histogram and make Pulse Height
    Put Pulse Height into HeaderBase for each ElementContainer This template requires the instanse successing UtsusemiNeutronEventDecorder.
    C++ includes: UtsusemiEventDataConverterTemplateWithPH.hh 

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::UtsusemiEventDataConverterTemplateWithPH "UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::UtsusemiEventDataConverterTemplateWithPH() UtsusemiEventDataConverterTemplateWithPH::UtsusemiEventDataConverterTemplateWithPH

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::~UtsusemiEventDataConverterTemplateWithPH "UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::~UtsusemiEventDataConverterTemplateWithPH() UtsusemiEventDataConverterTemplateWithPH::~UtsusemiEventDataConverterTemplateWithPH

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::SetHistAllocation "void UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::SetHistAllocation() UtsusemiEventDataConverterTemplateWithPH::SetHistAllocation

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::Increment "void UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::Increment(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 size, UInt4 ThNum, std::vector< Double > *Offset, std::vector< UInt4 > *Case) UtsusemiEventDataConverterTemplateWithPH::Increment Increment intensity.
================================================================================================================================================================================================================================================================================
    Increment intensity of histogram by using information from decoded event

    Args:
        daqId (UInt4) DAQ id
        moduleNo (UInt4) Module No
        data (UChar*) event data
        size (UInt4) size of event data
        ThNum (UInt4) thread number
        Offset (Double) offset value

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::PutPulseHeight "std::vector< Int4 > UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::PutPulseHeight(UInt4 det_id) UtsusemiEventDataConverterTemplateWithPH::PutPulseHeight

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::SetMaxOfChannels "void UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::SetMaxOfChannels(UInt4 max_channel=4096) UtsusemiEventDataConverterTemplateWithPH::SetMaxOfChannels Sets maximum number of channels for Pulse Height.
===============================================================================================================================================================================================================

    Args:
        max_channels (UInt4) maximum number of channels

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPH::SetIsGateNet "void UtsusemiEventDataConverterTemplateWithPH< T1, T2 >::SetIsGateNet(bool isGateNet=false) UtsusemiEventDataConverterTemplateWithPH::SetIsGateNet Sets maximum number of channels for Pulse Height.
=====================================================================================================================================================================================================

    Args:
        isGateNet (bool) whether this data comes from GateNET or not.

    Returns:
        None 

";
// File: classUtsusemiEventDataConverterTemplateWithPHDep.xml

%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep "

    Expansion of Template class for Convesion with Pulse Height Dependency.
    from EventData to Histogram on offline. read EvnetDataFile
    Decode Event data using Decode module
    Increment to gls histogram and make Pulse Height
    Put Pulse Height into HeaderBase for each ElementContainer This template requires the instanse successing UtsusemiNeutronEventDecorder.
    C++ includes: UtsusemiEventDataConverterTemplateWithPHDep.hh 

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep::UtsusemiEventDataConverterTemplateWithPHDep "UtsusemiEventDataConverterTemplateWithPHDep< T1, T2 >::UtsusemiEventDataConverterTemplateWithPHDep() UtsusemiEventDataConverterTemplateWithPHDep::UtsusemiEventDataConverterTemplateWithPHDep

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep::~UtsusemiEventDataConverterTemplateWithPHDep "UtsusemiEventDataConverterTemplateWithPHDep< T1, T2 >::~UtsusemiEventDataConverterTemplateWithPHDep() UtsusemiEventDataConverterTemplateWithPHDep::~UtsusemiEventDataConverterTemplateWithPHDep

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep::SetPulseHeightRange "void UtsusemiEventDataConverterTemplateWithPHDep< T1, T2 >::SetPulseHeightRange(UInt4 ph_min, UInt4 ph_max, UInt4 ph_bin) UtsusemiEventDataConverterTemplateWithPHDep::SetPulseHeightRange

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep::SetHistAllocation "void UtsusemiEventDataConverterTemplateWithPHDep< T1, T2 >::SetHistAllocation() UtsusemiEventDataConverterTemplateWithPHDep::SetHistAllocation

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep::Increment "void UtsusemiEventDataConverterTemplateWithPHDep< T1, T2 >::Increment(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 size, UInt4 ThNum, std::vector< Double > *Offset, std::vector< UInt4 > *Case) UtsusemiEventDataConverterTemplateWithPHDep::Increment Increment intensity.
======================================================================================================================================================================================================================================================================================
    Increment intensity of histogram by using information from decoded event

    Args:
        daqId (UInt4) DAQ id
        moduleNo (UInt4) Module No
        data (UChar*) event data
        size (UInt4) size of event data
        ThNum (UInt4) thread number
        Offset (Double) offset value

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataConverterTemplateWithPHDep::SetIsGateNet "void UtsusemiEventDataConverterTemplateWithPHDep< T1, T2 >::SetIsGateNet(bool isGateNet=false) UtsusemiEventDataConverterTemplateWithPHDep::SetIsGateNet Sets maximum number of channels for Pulse Height.
===========================================================================================================================================================================================================

    Args:
        isGateNet (bool) whether this data comes from GateNET or not.

    Returns:
        None 

";
// File: classUtsusemiEventDataConverterWLSF32.xml

%feature("docstring") UtsusemiEventDataConverterWLSF32 "

    Load Event Data and convert to Histogram from 2d-scintillation counter WLSF 32bit mode.
    LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )
    C++ includes: UtsusemiEventDataConverterWLSF32.hh 

";
%feature("docstring") UtsusemiEventDataConverterWLSF32::UtsusemiEventDataConverterWLSF32 "UtsusemiEventDataConverterWLSF32::UtsusemiEventDataConverterWLSF32() UtsusemiEventDataConverterWLSF32::UtsusemiEventDataConverterWLSF32 Constructor. 

";
%feature("docstring") UtsusemiEventDataConverterWLSF32::~UtsusemiEventDataConverterWLSF32 "UtsusemiEventDataConverterWLSF32::~UtsusemiEventDataConverterWLSF32() UtsusemiEventDataConverterWLSF32::~UtsusemiEventDataConverterWLSF32 Destructor. 

";
// File: classUtsusemiEventDataMonitorContainer.xml

%feature("docstring") UtsusemiEventDataMonitorContainer "

    Event Data Monitor ( Differential Data Reduction )
    tt = UtsusemiEventDataMonitorXXXX() tt.SetDataFolder( \"/data\" ) tt.ParameterSet( wfile, dfile, cfile ) tt.AddAllDataModules() // repeat below tt.Update() dat = ElementContainerMatrix() tt.Output( dat ) tt.Clear() // if needed
    or tt.UpdataDataModules() tt.IncrementCases() tt.Increment(1,1) // give the only daqId and modNo required dat = ElementContainerMatrix() tt.Output( dat ) tt.Clear() // if needed
    C++ includes: UtsusemiEventDataMonitorTemplate.hh 

";
%feature("docstring") UtsusemiEventDataMonitorContainer::UtsusemiEventDataMonitorContainer "UtsusemiEventDataMonitorContainer::UtsusemiEventDataMonitorContainer() UtsusemiEventDataMonitorContainer::UtsusemiEventDataMonitorContainer < <filename, file size>
====================================================================================================================================================================
    < <filename, file size> 

    
UtsusemiEventDataMonitorContainer::UtsusemiEventDataMonitorContainer(const UtsusemiEventDataMonitorContainer &obj) UtsusemiEventDataMonitorContainer::UtsusemiEventDataMonitorContainer
";
%feature("docstring") UtsusemiEventDataMonitorContainer::~UtsusemiEventDataMonitorContainer "UtsusemiEventDataMonitorContainer::~UtsusemiEventDataMonitorContainer() UtsusemiEventDataMonitorContainer::~UtsusemiEventDataMonitorContainer

";
// File: classUtsusemiEventDataMonitorMWPC.xml

%feature("docstring") UtsusemiEventDataMonitorMWPC "C++ includes: UtsusemiEventDataMonitorMWPC.hh 

";
%feature("docstring") UtsusemiEventDataMonitorMWPC::UtsusemiEventDataMonitorMWPC "UtsusemiEventDataMonitorMWPC::UtsusemiEventDataMonitorMWPC() UtsusemiEventDataMonitorMWPC::UtsusemiEventDataMonitorMWPC Constructor. 

";
%feature("docstring") UtsusemiEventDataMonitorMWPC::~UtsusemiEventDataMonitorMWPC "UtsusemiEventDataMonitorMWPC::~UtsusemiEventDataMonitorMWPC() UtsusemiEventDataMonitorMWPC::~UtsusemiEventDataMonitorMWPC Destructor. 

";
// File: classUtsusemiEventDataMonitorNeunet.xml

%feature("docstring") UtsusemiEventDataMonitorNeunet "C++ includes: UtsusemiEventDataMonitorNeunet.hh 

";
%feature("docstring") UtsusemiEventDataMonitorNeunet::UtsusemiEventDataMonitorNeunet "UtsusemiEventDataMonitorNeunet::UtsusemiEventDataMonitorNeunet() UtsusemiEventDataMonitorNeunet::UtsusemiEventDataMonitorNeunet Constructor. 

";
%feature("docstring") UtsusemiEventDataMonitorNeunet::~UtsusemiEventDataMonitorNeunet "UtsusemiEventDataMonitorNeunet::~UtsusemiEventDataMonitorNeunet() UtsusemiEventDataMonitorNeunet::~UtsusemiEventDataMonitorNeunet Destructor. 

";
%feature("docstring") UtsusemiEventDataMonitorNeunet::OutputEC "void UtsusemiEventDataMonitorNeunet::OutputEC(ElementContainer *ec, UInt4 pixelId, UInt4 caseId=1) UtsusemiEventDataMonitorNeunet::OutputEC

";
%feature("docstring") UtsusemiEventDataMonitorNeunet::PutUtsusemiEventDataConverterNeunet "UtsusemiEventDataConverterNeunet * UtsusemiEventDataMonitorNeunet::PutUtsusemiEventDataConverterNeunet() UtsusemiEventDataMonitorNeunet::PutUtsusemiEventDataConverterNeunet

";
// File: classUtsusemiEventDataMonitorRPMT.xml

%feature("docstring") UtsusemiEventDataMonitorRPMT "C++ includes: UtsusemiEventDataMonitorRPMT.hh 

";
%feature("docstring") UtsusemiEventDataMonitorRPMT::UtsusemiEventDataMonitorRPMT "UtsusemiEventDataMonitorRPMT::UtsusemiEventDataMonitorRPMT() UtsusemiEventDataMonitorRPMT::UtsusemiEventDataMonitorRPMT Constructor. 

";
%feature("docstring") UtsusemiEventDataMonitorRPMT::~UtsusemiEventDataMonitorRPMT "UtsusemiEventDataMonitorRPMT::~UtsusemiEventDataMonitorRPMT() UtsusemiEventDataMonitorRPMT::~UtsusemiEventDataMonitorRPMT Destructor. 

";
// File: classUtsusemiEventDataMonitorTemplate.xml

%feature("docstring") UtsusemiEventDataMonitorTemplate "C++ includes: UtsusemiEventDataMonitorTemplate.hh 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::UtsusemiEventDataMonitorTemplate "UtsusemiEventDataMonitorTemplate< T1 >::UtsusemiEventDataMonitorTemplate(UInt4 ByteOfNeutronEvent=8) UtsusemiEventDataMonitorTemplate::UtsusemiEventDataMonitorTemplate < Constructor
======================================================================================================================================================================================
    < 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::~UtsusemiEventDataMonitorTemplate "UtsusemiEventDataMonitorTemplate< T1 >::~UtsusemiEventDataMonitorTemplate() UtsusemiEventDataMonitorTemplate::~UtsusemiEventDataMonitorTemplate < Destructor
=============================================================================================================================================================
    < 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::PutEventDataConverter "T1 * UtsusemiEventDataMonitorTemplate< T1 >::PutEventDataConverter() UtsusemiEventDataMonitorTemplate::PutEventDataConverter

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::ParameterSet "void UtsusemiEventDataMonitorTemplate< T1 >::ParameterSet(std::string _WireingFile, std::string _DetectorInfoFile, std::string _CaseInfoFile, UInt4 _MulTh=0, Int4 tofShiftPtnId=-1) UtsusemiEventDataMonitorTemplate::ParameterSet < ParameterSet sets Event parameters
=========================================================================================================================================================================================================================================================================
    <

    Args:
        _WireingFile (std::string) Wiring Info file path
        _DetectorInfoFile (std::string) Detector Info file path
        _CaseInfoFile (std::string)
        tofShiftPtnId (Int4) : this will be included in WiringInfo or DetectorInfo

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::AddDataFiles "void UtsusemiEventDataMonitorTemplate< T1 >::AddDataFiles(std::string TargetT0EventFilePath, std::string TargetEventDataFilePath, UInt4 DaqID) UtsusemiEventDataMonitorTemplate::AddDataFiles < AddDataFiles adds Event data file(s) and T0Index event data file(s) pathes
===========================================================================================================================================================================================================================================================================
    <

    Args:
        TargetT0EventFilePath (std::string or std::vector<std::string>) T0Index event data file path
        TargetEventDataFilePath (std::string or std::vector<std::string>) Event Data file path
        DaqID (UInt4 or std::vector<UInt4>)

    Returns:
        None 

    
void UtsusemiEventDataMonitorTemplate< T1 >::AddDataFiles(std::vector< std::string > TargetT0EventFilePath, std::vector< std::string > TargetEventDataFilePath, std::vector< UInt4 > DaqID) UtsusemiEventDataMonitorTemplate::AddDataFiles
";
%feature("docstring") UtsusemiEventDataMonitorTemplate::Increment "void UtsusemiEventDataMonitorTemplate< T1 >::Increment(UInt4 index) UtsusemiEventDataMonitorTemplate::Increment < Increment increments data
============================================================================================================================================
    < This reads difference of data by index and add to histograms note : This is OBSOLETED! first version of differential data reduction

    Args:
        index (UInt4) Index of data

    Returns:
        None 

    
void UtsusemiEventDataMonitorTemplate< T1 >::Increment(bool doRead=true) UtsusemiEventDataMonitorTemplate::Increment < Increment
=================================================================================================================================
    < This update all data for the differential data reduction

    Args:
        daqId (UInt4)
        modNo (UInt4)

    Returns:
        None 
    
void UtsusemiEventDataMonitorTemplate< T1 >::Increment(UInt4 daqId, UInt4 modNo, bool doRead=true) UtsusemiEventDataMonitorTemplate::Increment
";
%feature("docstring") UtsusemiEventDataMonitorTemplate::SetDataFolder "void UtsusemiEventDataMonitorTemplate< T1 >::SetDataFolder(std::string dfolder) UtsusemiEventDataMonitorTemplate::SetDataFolder < SetDataFolder
================================================================================================================================================
    < This sets data folder

    Args:
        dfolder (std::string) path to data folder same as UTSUSEMI_DATA_DIR

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::ClearDataModules "void UtsusemiEventDataMonitorTemplate< T1 >::ClearDataModules() UtsusemiEventDataMonitorTemplate::ClearDataModules < ClearDataModules
======================================================================================================================================
    < This cleans the list of all modules given by WiringInfo or users

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::SetRunNumber "void UtsusemiEventDataMonitorTemplate< T1 >::SetRunNumber(UInt4 runNo) UtsusemiEventDataMonitorTemplate::SetRunNumber < SetRunNumber
=====================================================================================================================================
    < This sets run number of target for differential data reduction

    Args:
        runNo (UInt4) run number

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::AddAllDataModules "void UtsusemiEventDataMonitorTemplate< T1 >::AddAllDataModules() UtsusemiEventDataMonitorTemplate::AddAllDataModules < AddAllDataModules
=========================================================================================================================================
    < This adds all modules described in WiringInfo to the list to be used for differential data reduction

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::AddDataModule "void UtsusemiEventDataMonitorTemplate< T1 >::AddDataModule(UInt4 daqId, UInt4 modNo) UtsusemiEventDataMonitorTemplate::AddDataModule < AddDataModule
=====================================================================================================================================================
    < This adds given modules to the list to be used for differential data reduction

    Args:
        daqId (UInt4)
        modNo (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::UpdateDataModules "void UtsusemiEventDataMonitorTemplate< T1 >::UpdateDataModules() UtsusemiEventDataMonitorTemplate::UpdateDataModules < UpdateDataModules
=========================================================================================================================================
    < This updates all modules for the differential data reduction

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::UpdateDataModule "bool UtsusemiEventDataMonitorTemplate< T1 >::UpdateDataModule(UInt4 daqId, UInt4 modNo) UtsusemiEventDataMonitorTemplate::UpdateDataModule < UpdateDataModule
==============================================================================================================================================================
    < This updates given modules for the differential data reduction

    Args:
        daqId (UInt4)
        modNo (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::FindTargetFile "std::pair< std::string, UInt4 > UtsusemiEventDataMonitorTemplate< T1 >::FindTargetFile(UInt4 runNo, UInt4 daqId, UInt4 modNo, UInt4 num, std::string ext_code, bool useOnlyOneDir=true) UtsusemiEventDataMonitorTemplate::FindTargetFile < FindTargetFile
==========================================================================================================================================================================================================================================================
    < This gets the full path and file size of the data file of the given modules for the differential data reduction

    Args:
        runNO (UInt4)
        daqId (UInt4)
        modNo (UInt4)
        num (UInt4) the count number for same daqId and modNo
        ext_code (std::string) \".edb\" or \"t0b\"
        useOnlyOneDir (bool) whether using only \"XXX\" data folder or using also \"XXX01\", \"XXX02\"...

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::PutNumOfCases "UInt4 UtsusemiEventDataMonitorTemplate< T1 >::PutNumOfCases() UtsusemiEventDataMonitorTemplate::PutNumOfCases

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::PutListOfCounterConditions "std::vector< Double > UtsusemiEventDataMonitorTemplate< T1 >::PutListOfCounterConditions() UtsusemiEventDataMonitorTemplate::PutListOfCounterConditions < PutListOfCounterConditions()
=======================================================================================================================================================================================
    < This shows ListOfCounterConditions

    Args:
        None

    Returns:
        std::vector<Double> 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::Dump "void UtsusemiEventDataMonitorTemplate< T1 >::Dump(UInt4 ind=0) UtsusemiEventDataMonitorTemplate::Dump < Dump
=============================================================================================================
    < This shows modules information ( file name, file size )

    Args:
        ind (UInt4) unknown

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::IncrementCases "bool UtsusemiEventDataMonitorTemplate< T1 >::IncrementCases() UtsusemiEventDataMonitorTemplate::IncrementCases < IncrementCases
================================================================================================================================
    < This update TrigNET data to make caseID list

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::Update "bool UtsusemiEventDataMonitorTemplate< T1 >::Update(bool doRead=true) UtsusemiEventDataMonitorTemplate::Update < Updated data
==============================================================================================================================
    < This function executes commands below : UpdataDataModules() IncrementCases() Increment()
    bool Update()

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::Output "void UtsusemiEventDataMonitorTemplate< T1 >::Output(std::string OutputFileName) UtsusemiEventDataMonitorTemplate::Output < Output stored data
==============================================================================================================================================
    < Output( std::string OutputFileName ); Output( ElementContainerMatrix* ecm ); Output( ElementContainer* ec, UInt4 pixelId );

    Args:
        OutputFileName (std::string) saves ElementContainer as files
        ecm (ElementContainerMatrix) gives ElementContainerMatrix
        pixelId (UInt4) pixel Id of ElementContainer to get

    Returns:
        None 

    
void UtsusemiEventDataMonitorTemplate< T1 >::Output(ElementContainerMatrix *ecm, UInt4 caseId=1) UtsusemiEventDataMonitorTemplate::Output
";
%feature("docstring") UtsusemiEventDataMonitorTemplate::Clear "void UtsusemiEventDataMonitorTemplate< T1 >::Clear() UtsusemiEventDataMonitorTemplate::Clear < Clear makes stored data empty
=============================================================================================================================
    < This makes intensities for each pixels to zero.

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::SetMeasTimeSliced "void UtsusemiEventDataMonitorTemplate< T1 >::SetMeasTimeSliced(HeaderBase *hh) UtsusemiEventDataMonitorTemplate::SetMeasTimeSliced < SetMeasTimeSliced
=======================================================================================================================================================
    < This adds the information of the measurement period for sliced data

    Args:
        hh (HeaderBase*)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::SetKickers "void UtsusemiEventDataMonitorTemplate< T1 >::SetKickers(HeaderBase *hh, UInt4 caseId=0) UtsusemiEventDataMonitorTemplate::SetKickers < SetKickers
==================================================================================================================================================
    < This adds the number of kickers into HeaderBase

    Args:
        hh (HeaderBase*)
        caseId (UInt4)

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::ClearDataFileSets "void UtsusemiEventDataMonitorTemplate< T1 >::ClearDataFileSets() UtsusemiEventDataMonitorTemplate::ClearDataFileSets < ClearDataFileSets clears data files
===========================================================================================================================================================
    <

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::PutUpdatedCases "std::vector< UInt4 > UtsusemiEventDataMonitorTemplate< T1 >::PutUpdatedCases() UtsusemiEventDataMonitorTemplate::PutUpdatedCases < PutUpdatedCases
===================================================================================================================================================
    < This returns the list of cases that update happened on updating modules

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::ClearUpdatedCases "void UtsusemiEventDataMonitorTemplate< T1 >::ClearUpdatedCases() UtsusemiEventDataMonitorTemplate::ClearUpdatedCases < ClearUpdatedCases
=========================================================================================================================================
    < This clears the list of cases that update happened on updating modules

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiEventDataMonitorTemplate::AddRunInfoToHeader "bool UtsusemiEventDataMonitorTemplate< T1 >::AddRunInfoToHeader(HeaderBase *_hh, UInt4 caseId=1) UtsusemiEventDataMonitorTemplate::AddRunInfoToHeader

";
// File: classUtsusemiFilterBase.xml

%feature("docstring") UtsusemiFilterBase "

    Filter used by UtsusemiEventCaseTemplate.
    C++ includes: UtsusemiFilterBase.hh 

";
%feature("docstring") UtsusemiFilterBase::UtsusemiFilterBase "UtsusemiFilterBase::UtsusemiFilterBase() UtsusemiFilterBase::UtsusemiFilterBase Constructor. 

";
%feature("docstring") UtsusemiFilterBase::~UtsusemiFilterBase "UtsusemiFilterBase::~UtsusemiFilterBase() UtsusemiFilterBase::~UtsusemiFilterBase Destructor. 

";
%feature("docstring") UtsusemiFilterBase::PutNumOfCases "UInt4 UtsusemiFilterBase::PutNumOfCases() UtsusemiFilterBase::PutNumOfCases Puts numOfCases.
=============================================================================================

    Args:
        None

    Returns:
        the number of cases 

";
%feature("docstring") UtsusemiFilterBase::PutListOfCases "std::vector< UInt4 > UtsusemiFilterBase::PutListOfCases() UtsusemiFilterBase::PutListOfCases Puts list of cases.
=================================================================================================================

    Args:
        None

    Returns:
        list of cases 

";
%feature("docstring") UtsusemiFilterBase::DumpCaseTable "void UtsusemiFilterBase::DumpCaseTable() UtsusemiFilterBase::DumpCaseTable Dumps filterCaseTable on screen.
============================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterBase::Clear "void UtsusemiFilterBase::Clear() UtsusemiFilterBase::Clear Clears filterCaseTable and filterPulseIdList.
=========================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterBase::ReadCaseEvent "Int4 UtsusemiFilterBase::ReadCaseEvent(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiFilterBase::ReadCaseEvent Reads Case Event file(s).
============================================================================================================================================================================================
    This method is called from UtsusemiEventCasesDecoderTemplate class and has a role of the interface to this->ReadTrigEvent method.

    Args:
        index (UInt4) index of TrigNET event file
        evt_files (std::vector<std::string>) path to TrigNET event file(s). Given files are must be belong to same runnumber.
        t0b_files (std::vector<std::string>) T0 index table for the TrigNET event file

    Returns:
        0 : Succeeded to make filters
        -1 : Failed to make filters 

";
%feature("docstring") UtsusemiFilterBase::MakeFilterTables "void UtsusemiFilterBase::MakeFilterTables() UtsusemiFilterBase::MakeFilterTables Makes filterCaseTable and filterPulseIdList.
==============================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterBase::CheckAmbiguousFrame "void UtsusemiFilterBase::CheckAmbiguousFrame() UtsusemiFilterBase::CheckAmbiguousFrame Checks and changes ambiguous frames.
============================================================================================================================
    When a frame includes several 'cases', this function changes frame to include a case in a frame.

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterBase::GetCaseFromTof "UInt4 UtsusemiFilterBase::GetCaseFromTof(const UInt4 pixelId, Double *tof, std::vector< UInt4 > *caseVec) UtsusemiFilterBase::GetCaseFromTof Returns CaseId from given pixel id and tof.
=========================================================================================================================================================================================
    This is used in original Increment function.

    Args:
        pixelId (UInt4*) given pixel id
        tof (Double*) tof
        caseVec (vecotr<UInt4>*) given std::vector of cases

    Returns:
        caseId (UInt4) if 0, this tof will not be incremented to histogram. 

";
%feature("docstring") UtsusemiFilterBase::isTimeSlicing "virtual bool UtsusemiFilterBase::isTimeSlicing() UtsusemiFilterBase::isTimeSlicing

";
%feature("docstring") UtsusemiFilterBase::MakeTimeSlicingCases "virtual void UtsusemiFilterBase::MakeTimeSlicingCases(std::vector< UInt8 > _pulseId, std::vector< double > _clocks) UtsusemiFilterBase::MakeTimeSlicingCases

";
%feature("docstring") UtsusemiFilterBase::SetTimeSlicing "virtual void UtsusemiFilterBase::SetTimeSlicing(std::vector< Double > tmp) UtsusemiFilterBase::SetTimeSlicing

";
%feature("docstring") UtsusemiFilterBase::ReadCaseInfoFile "Int4 UtsusemiFilterBase::ReadCaseInfoFile(std::string caseInfoFile) UtsusemiFilterBase::ReadCaseInfoFile Reads Case Info file.
===============================================================================================================================

    Args:
        caseInfoFile (std::string) path to Case Info file

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterBase::ReadCaseEventFiles "Int4 UtsusemiFilterBase::ReadCaseEventFiles(UInt4 index, std::vector< std::string > evt_files, std::vector< std::vector< UInt8 > > t0b_index_list) UtsusemiFilterBase::ReadCaseEventFiles Reads Case Event Files.
==================================================================================================================================================================================================================

    Args:
        list_dataFile (std::vector<std::string>) list of path to Case Event files

    Returns:
        None 

";
// File: classUtsusemiFilterTrignet.xml

%feature("docstring") UtsusemiFilterTrignet "

    Filter used by UtsusemiEventCaseTemplate.
    C++ includes: UtsusemiFilterTrignet.hh 

";
%feature("docstring") UtsusemiFilterTrignet::UtsusemiFilterTrignet "UtsusemiFilterTrignet::UtsusemiFilterTrignet() UtsusemiFilterTrignet::UtsusemiFilterTrignet Constructor. 

";
%feature("docstring") UtsusemiFilterTrignet::~UtsusemiFilterTrignet "UtsusemiFilterTrignet::~UtsusemiFilterTrignet() UtsusemiFilterTrignet::~UtsusemiFilterTrignet Destructor. 

";
%feature("docstring") UtsusemiFilterTrignet::PutListOfCases "std::vector< UInt4 > UtsusemiFilterTrignet::PutListOfCases() UtsusemiFilterTrignet::PutListOfCases Puts list of cases.
=======================================================================================================================

    Args:
        None

    Returns:
        list of cases 

";
%feature("docstring") UtsusemiFilterTrignet::ReadCaseEvent "Int4 UtsusemiFilterTrignet::ReadCaseEvent(UInt4 index, std::vector< std::string > evt_files, std::vector< std::string > t0b_files) UtsusemiFilterTrignet::ReadCaseEvent Reads Case Event file(s).
==================================================================================================================================================================================================
    This method is called from UtsusemiEventCasesDecoderTemplate class and has a role of the interface to this->ReadTrigEvent method.

    Args:
        index (UInt4) index of TrigNET event file
        evt_files (std::vector<std::string>) path to TrigNET event file(s). Given files are must be belong to same runnumber.
        t0b_files (std::vector<std::string>) T0 index table for the TrigNET event file

    Returns:
        0 : Succeeded to make filters
        -1 : Failed to make filters 

";
%feature("docstring") UtsusemiFilterTrignet::MakeFilterTables "void UtsusemiFilterTrignet::MakeFilterTables() UtsusemiFilterTrignet::MakeFilterTables Makes filterCaseTable and filterPulseIdList.
====================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterTrignet::GetCaseFromTof "UInt4 UtsusemiFilterTrignet::GetCaseFromTof(const UInt4 pixelId, Double *tof, std::vector< UInt4 > *caseVec) UtsusemiFilterTrignet::GetCaseFromTof Returns CaseId from given pixel id and tof.
===============================================================================================================================================================================================
    This is used in original Increment function.

    Args:
        pixelId (UInt4*) given pixel id
        tof (Double*) tof
        caseVec (vecotr<UInt4>*) given std::vector of cases

    Returns:
        caseId (UInt4) if 0, this tof will not be incremented to histogram. 

";
%feature("docstring") UtsusemiFilterTrignet::Initialize "void UtsusemiFilterTrignet::Initialize() UtsusemiFilterTrignet::Initialize

";
%feature("docstring") UtsusemiFilterTrignet::ClearAllTables "void UtsusemiFilterTrignet::ClearAllTables(UInt4 index, bool makeNew=false) UtsusemiFilterTrignet::ClearAllTables

";
%feature("docstring") UtsusemiFilterTrignet::CaseSorting "void UtsusemiFilterTrignet::CaseSorting(const UChar *data, UInt8 size, UInt4 index, UInt4 ThNum) UtsusemiFilterTrignet::CaseSorting Sorts TrigNET evetns into each case.
=========================================================================================================================================================================

    Args:
        data (UChar*) events
        size (UInt8) size of events (bytes)
        index (UInt4) index of TrigNET event file
        ThNum (UInt4) Thread number

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterTrignet::PreCaseSorting "void UtsusemiFilterTrignet::PreCaseSorting(const UChar *data, std::vector< UInt8 > T0Table, UInt4 index) UtsusemiFilterTrignet::PreCaseSorting Preprocess to CaseSorting.
==========================================================================================================================================================================

    Args:
        data (UChar*) events
        T0Table (UInt8) T0 index table
        index (UInt4) index of TrigNET event file

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterTrignet::ReadTrigEvent "void UtsusemiFilterTrignet::ReadTrigEvent(std::string trig_event_file, std::string trig_t0_file, UInt4 index=0) UtsusemiFilterTrignet::ReadTrigEvent

    
void UtsusemiFilterTrignet::ReadTrigEvent(std::vector< std::string > trig_event_files, std::vector< std::string > trig_t0_files, UInt4 index=0) UtsusemiFilterTrignet::ReadTrigEvent Reads TrigNET Event file as Case Event data file.
=======================================================================================================================================================================================================================================

    Args:
        trig_event_file (std::string) path to TrigNET event file
        T0Table (std::vector<UInt4>) T0 index table for the TrigNET event file
        index (UInt4) index of TrigNET event file

    Returns:
        None 
";
%feature("docstring") UtsusemiFilterTrignet::ReadCaseInfoFile "Int4 UtsusemiFilterTrignet::ReadCaseInfoFile(std::string caseInfo_file) UtsusemiFilterTrignet::ReadCaseInfoFile Reads Case Info file.
======================================================================================================================================

    Args:
        caseInfo_file (std::string) path to Case Info file

    Returns:
        0 : Succeeded. 

";
%feature("docstring") UtsusemiFilterTrignet::MakeCaseTable "void UtsusemiFilterTrignet::MakeCaseTable(bool isAppend=false) UtsusemiFilterTrignet::MakeCaseTable Makes filterCaseTable by analysis TrigNET event data file(s)
=================================================================================================================================================================

    Args:
        isAppend (bool) if you need not clear previous CaseTables.

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterTrignet::PutListOfCounterConditions "std::vector< std::pair< Double, Double > > UtsusemiFilterTrignet::PutListOfCounterConditions() UtsusemiFilterTrignet::PutListOfCounterConditions Puts list of Counter-cases Conditions.
========================================================================================================================================================================================

    Args:
        None

    Returns:
        list of conditions : index is CaseId 

";
%feature("docstring") UtsusemiFilterTrignet::DumpTrigEventFile "bool UtsusemiFilterTrignet::DumpTrigEventFile(std::string trig_file, std::string out_file, bool isDecorated=true, bool withT0=false) UtsusemiFilterTrignet::DumpTrigEventFile Reads TrigNET event file and writes dump as text file.
=====================================================================================================================================================================================================================================

    Args:
        trig_file (std::string) Path to Event File of TrigNET
        out_file (std::string) Path to output file
        isDecorated (bool) Output text decorated for easy-to-understand
        withT0 (bool) Add T0 events

    Returns:
        true : Succeeded
        false : Failed 

";
%feature("docstring") UtsusemiFilterTrignet::DumpCaseTable "void UtsusemiFilterTrignet::DumpCaseTable(std::string file=\"\") UtsusemiFilterTrignet::DumpCaseTable

";
%feature("docstring") UtsusemiFilterTrignet::MakeTimeSlicingCases "void UtsusemiFilterTrignet::MakeTimeSlicingCases(std::vector< UInt8 > _pulseId, std::vector< double > _seconds) UtsusemiFilterTrignet::MakeTimeSlicingCases

";
%feature("docstring") UtsusemiFilterTrignet::SetTimeSlicing "void UtsusemiFilterTrignet::SetTimeSlicing(std::vector< Double > tmp) UtsusemiFilterTrignet::SetTimeSlicing

";
%feature("docstring") UtsusemiFilterTrignet::ReadTrigEventFile "void UtsusemiFilterTrignet::ReadTrigEventFile(std::string trig_event_file, UInt4 index=0) UtsusemiFilterTrignet::ReadTrigEventFile

    
void UtsusemiFilterTrignet::ReadTrigEventFile(std::string trig_event_file, std::vector< UInt8 > T0Table, UInt4 index=0) UtsusemiFilterTrignet::ReadTrigEventFile Reads TrigNET Event file as Case Event data file (obsoleted)
==============================================================================================================================================================================================================================

    Args:
        trig_event_file (std::string) path to TrigNET event file
        T0Table (std::vector<UInt4>) T0 index table for the TrigNET event file
        index (UInt4) index of TrigNET event file

    Returns:
        None 
";
%feature("docstring") UtsusemiFilterTrignet::ReadCaseEventFiles "Int4 UtsusemiFilterTrignet::ReadCaseEventFiles(UInt4 index, std::vector< std::string > evt_files, std::vector< std::vector< UInt8 > > t0b_index_list) UtsusemiFilterTrignet::ReadCaseEventFiles Reads TrigNET Event file as Case Event data files (obsoleted)
==============================================================================================================================================================================================================================================================

    Args:
        evt_files (vecto<std::string>) pathes to TrigNET event files
        t0b_files (vecto<std::string>) pathes to t0b event for TrigNET event files

    Returns:
        None 

";
%feature("docstring") UtsusemiFilterTrignet::isTimeSlicing "bool UtsusemiFilterTrignet::isTimeSlicing() UtsusemiFilterTrignet::isTimeSlicing

";
// File: classUtsusemiFrameBoundaryInfo.xml

%feature("docstring") UtsusemiFrameBoundaryInfo "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiFrameBoundaryInfo::UtsusemiFrameBoundaryInfo "UtsusemiFrameBoundaryInfo::UtsusemiFrameBoundaryInfo() UtsusemiFrameBoundaryInfo::UtsusemiFrameBoundaryInfo

    
UtsusemiFrameBoundaryInfo::UtsusemiFrameBoundaryInfo(const UtsusemiFrameBoundaryInfo &obj) UtsusemiFrameBoundaryInfo::UtsusemiFrameBoundaryInfo
";
%feature("docstring") UtsusemiFrameBoundaryInfo::~UtsusemiFrameBoundaryInfo "UtsusemiFrameBoundaryInfo::~UtsusemiFrameBoundaryInfo() UtsusemiFrameBoundaryInfo::~UtsusemiFrameBoundaryInfo

";
%feature("docstring") UtsusemiFrameBoundaryInfo::SetParams "bool UtsusemiFrameBoundaryInfo::SetParams(UInt4 fn, Double bv=0.0, std::string bt=\"\") UtsusemiFrameBoundaryInfo::SetParams

";
// File: classUtsusemiGetHistogramTemplate.xml

%feature("docstring") UtsusemiGetHistogramTemplate "

    Creates Histogram from event data.
    read WiringInfo
    Set runNo and read suitable WiringInfo
    Set Histgram conversion parameter
    Set many parameters for the condition of histogram
    rewrite WiringInfo by given parameters
    create histogram from rewritten WiringInfo and DetectorInfo
    T1 : UtsusemiWiringInfoEditorXXX T2 : UtsusemiDetectorInfoEditorXXX
    Neuunet : T1= UtsusemiWiringInfoEditorNeunet T2=UtsusemiDetectorInfoEditorBbase
    RPMT : T1= UtsusemiWiringInfoEditorBase T2=UtsusemiDetectorInfoEditorBbase
    C++ includes: UtsusemiGetHistogramTemplate.hh 

";
%feature("docstring") UtsusemiGetHistogramTemplate::UtsusemiGetHistogramTemplate "UtsusemiGetHistogramTemplate< T1, T2 >::UtsusemiGetHistogramTemplate() UtsusemiGetHistogramTemplate::UtsusemiGetHistogramTemplate Constructor. 

";
%feature("docstring") UtsusemiGetHistogramTemplate::~UtsusemiGetHistogramTemplate "UtsusemiGetHistogramTemplate< T1, T2 >::~UtsusemiGetHistogramTemplate() UtsusemiGetHistogramTemplate::~UtsusemiGetHistogramTemplate Destructor. 

";
%feature("docstring") UtsusemiGetHistogramTemplate::Initialize "void UtsusemiGetHistogramTemplate< T1, T2 >::Initialize() UtsusemiGetHistogramTemplate::Initialize

";
%feature("docstring") UtsusemiGetHistogramTemplate::GetStatus "bool UtsusemiGetHistogramTemplate< T1, T2 >::GetStatus() UtsusemiGetHistogramTemplate::GetStatus Puts Status.
==============================================================================================================
    bool GetStatus()

    Args:
        None

    Returns:
        true command execution succeeded
        false command execution failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetRunNo "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetRunNo(UInt4 runNo, UInt4 mode_no=0, std::string env_file=\"\") UtsusemiGetHistogramTemplate::SetRunNo sets run No and environ_ana.xml
======================================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo suitable for the run number. If evn_file is empty(), this uses UTSUSEMI_USR_DIR/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath. bool SetRunNo( UInt4 runNo, std::string env_file=\"\" ) bool SetRunNo( std::string runNos, std::string env_file=\"\" )

    Args:
        runNo (UInt4) run number
        mode_no (UInt4) Mode number defined in environ_ana.xml
        env_file (std::string) environ_ana.xml which includes several WiringInfo and DetectorInfo for each run number.

    Returns:
        true : succeeded
        false : failed 

    
bool UtsusemiGetHistogramTemplate< T1, T2 >::SetRunNo(std::string runNos, std::string mode_no=\"0\", std::string env_file=\"\") UtsusemiGetHistogramTemplate::SetRunNo sets run No and environ_ana.xml
=======================================================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo suitable for the run number. If evn_file is empty(), this uses UTSUSEMI_USR_DIR/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath. bool SetRunNo( UInt4 runNo, std::string env_file=\"\" ) bool SetRunNo( std::string runNos, std::string env_file=\"\" )

    Args:
        runNos (std::string) run numbers. format : \"1234,1235\"
        mode_no (UInt4) Mode number defined in environ_ana.xml
        env_file (std::string) environ_ana.xml which includes several WiringInfo and DetectorInfo for each run number.

    Returns:
        true : succeeded
        false : failed 
    
bool UtsusemiGetHistogramTemplate< T1, T2 >::SetRunNo(std::string runNos, std::string wfile, std::string dfile, std::string mode_no) UtsusemiGetHistogramTemplate::SetRunNo sets run No and environ_ana.xml
============================================================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo suitable for the run number. If evn_file is empty(), this uses UTSUSEMI_USR_DIR/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath. bool SetRunNo( UInt4 runNo, std::string env_file=\"\" ) bool SetRunNo( std::string runNos, std::string env_file=\"\" )

    Args:
        runNos (std::string) run numbers. format : \"1234,1235\"
        wfile (std::string) WiringInfo.xml if required to indicate directly
        dfile (std::string) DetectorInfo.xml if required to indicate directly
        mode_no (UInt4) Mode number defined in environ_ana.xml

    Returns:
        true : succeeded
        false : failed 
    
bool UtsusemiGetHistogramTemplate< T1, T2 >::SetRunNo(UInt4 runNo, std::string wfile, std::string dfile, std::string mode_no) UtsusemiGetHistogramTemplate::SetRunNo sets run No and environ_ana.xml
=====================================================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo suitable for the run number. If evn_file is empty(), this uses UTSUSEMI_USR_DIR/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath. bool SetRunNo( UInt4 runNo, std::string env_file=\"\" ) bool SetRunNo( std::string runNos, std::string env_file=\"\" )

    Args:
        runNo (UInt4) run number
        wfile (std::string) WiringInfo.xml if required to indicate directly
        dfile (std::string) DetectorInfo.xml if required to indicate directly
        mode_no (UInt4) Mode number defined in environ_ana.xml

    Returns:
        true : succeeded
        false : failed 
";
%feature("docstring") UtsusemiGetHistogramTemplate::SetConversionParameter "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetConversionParameter(std::string params, UInt4 _ptnId=0) UtsusemiGetHistogramTemplate::SetConversionParameter sets conversion parameter for histogram creations
===============================================================================================================================================================================================================
    bool SetConversionParameter( std::string params, UInt4 _ptnId=0 ) Format of params TOF delta-TOF const : tof,<min_tof>,<max_tof>,<delta_tof> d-TOF/TOF const : rtof,<min_tof>,<max_tof>,<racio>
    TOF with time forcusing delta-TOF const : tf-tof,<min_tof>,<max_tof>,<delta_tof> d-TOF/TOF const : tf-rtof,<min_tof>,<max_tof>,<racio>
    Lambda delta-lambda const : lambda,<min_lambda>,<max_lambda>,<delta_lambda> delta-lambda/lambda const : rlambda,<min_lambda>,<max_lambda>,<racio>
    Energy energy,<min_energy>,<max_energy>,<delta_energy>
    Momentum Transfer q,<min_Q>,<max_Q>,<delta_Q>[,<ki_x>,<ki_y>,<ki_z>]
    Energy Transfer hw,<Ei>,<min_hw>,<max_hw>,<delta_hw>[,<t0_shift>]
    d-value d,<min_d-val>,<max_d-val>,<delta_d-val>

    Args:
        params (std::string) parameters for histogram ceration
        _ptnId (UInt4) ID of this parameters in WiringInfo

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetDetRange "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetDetRange(std::string params=\"All\") UtsusemiGetHistogramTemplate::SetDetRange sets detector range for histogram creations
===========================================================================================================================================================================
    bool SetDetRange( std::string params=\"All\" ) Format of params \"All[:<number_of_pixels>]\" : use all detectors \"<startDetId>-<endDetId>[:<number_of_pixels>]\" : use detectors from <startDetId> to <endDetId> ( \"X-Y:Z,A-B:C,D-E:F...\" can be used for more settings in my plan ) \"<BankName>[:<number_of_pixels>[,<BankName>...]]\": use detectors in the bank(s) described in DetectorInfo.xml

    Args:
        params (std::string) parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetFrameInfo "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetFrameInfo(std::string params=\"None\") UtsusemiGetHistogramTemplate::SetFrameInfo sets Frame Info for histogram creations
==========================================================================================================================================================================
    bool SetFrameInfo( std::string params ) Format of params \"<detType>[,<LLD_min> [,<LLD_max>] ]\" detType in {\"psd\",\"n2mon\",\"psd-ph\",\"n2mon-ph\"}
    \"-PH\" means that Pulse Height is calculated at the same time

    Args:
        params (std::string) parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetDetParam "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetDetParam(std::string params=\"psd\") UtsusemiGetHistogramTemplate::SetDetParam sets detector parameter to use for histogram creations
======================================================================================================================================================================================
    bool SetDetParam( std::string params=\"psd\" ) Format of params \"<detType>[,<LLD_min> [-<LLD_max>] ]\" detType in {\"psd\",\"n2mon\",\"psd-ph\",\"n2mon-ph\"}
    \"-PH\" means that Pulse Height is calculated at the same time
    default values for LLD are min=0, max=10000

    Args:
        params (std::string) detector parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetMaskInfo "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetMaskInfo(std::string params=\"NoFile\", UInt4 _ptnId=0) UtsusemiGetHistogramTemplate::SetMaskInfo sets MASK for histogram creations
====================================================================================================================================================================================
    bool SetMaskInfo( std::string params=\"NoFile\", UInt4 _ptnId=0 ) Format of params \"<Mask.xml>[,<TOF-Mask from>-< to > [,<TOF-Mask from>-<to>] ]\" Mask.xml = \"NoFile\" if no mask.

    Args:
        params (std::string) detector parameters for histogram ceration
        _ptnId (UInt4) ID of this parameters in WiringInfo

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetTimeDependBackGroundInfo "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetTimeDependBackGroundInfo(std::string params=\"None\") UtsusemiGetHistogramTemplate::SetTimeDependBackGroundInfo sets Tof region to be used for TimeDependBackground correction
===============================================================================================================================================================================================================================
    bool SetTimeDependBackGroundRegionInfo( std::string params=\"None\" ) Format of params \"None\" : not used this background correction \"tof0-tof1\" : tof0 is start tof of region, tof1 is last of region

    Args:
        params (std::string) TimeDepend BackGroundRegion

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetSaveFileOfTimeDependBackGround "void UtsusemiGetHistogramTemplate< T1, T2 >::SetSaveFileOfTimeDependBackGround(std::string path) UtsusemiGetHistogramTemplate::SetSaveFileOfTimeDependBackGround sets the file name to store the time-depend background information
====================================================================================================================================================================================================================================
    bool SetSaveFileOfTimeDependBackGround( std::string path )@param path (std::string) the full path of file @retval None 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetFileOfTimeDependBackGround "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetFileOfTimeDependBackGround(std::string path) UtsusemiGetHistogramTemplate::SetFileOfTimeDependBackGround sets the file name which store the time-depend background information
===============================================================================================================================================================================================================================
    bool SetFileOfTimeDependBackGround( std::string path ) Format of params \"None\" : not used this background correction \"tof0-tof1\" : tof0 is start tof of region, tof1 is last of region

    Args:
        params (std::string) the name of the file (fullpath or only name)

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetTimeRange "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetTimeRange(std::string params=\"All\") UtsusemiGetHistogramTemplate::SetTimeRange sets Time range for histogram creations
=========================================================================================================================================================================
    bool SetTimeRange( std::string params=\"All\" ) Format of params \"All\" : use all detectors \"<startSec>,<endSec>\" : use events in measurement from <startSec> to <endSec> [sec] which Time format is the passed time from measurement start. \"<startDate>,<startTime>,<endDate>,<endTime>\" : use events in period of these params \"YYYY/MM/DD\",\"hh:mm:ss\",\"YYYY/MM/DD\",\"hh:mm:ss\"

    Args:
        params (std::string) parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetCaseInfo "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetCaseInfo(std::string params=\"None\") UtsusemiGetHistogramTemplate::SetCaseInfo sets case info for histogram creations
=======================================================================================================================================================================
    bool SetCaseInfo( std::string params=\"None\" ) Format of params (not defined)

    Args:
        params (std::string) parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetTofShiftInfo "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetTofShiftInfo(std::string params) UtsusemiGetHistogramTemplate::SetTofShiftInfo sets Tof shift info for histogram creations
===========================================================================================================================================================================
    bool SetTofShiftInfo( UInt4 ptnId ) bool SetTofShiftInfo( std::string params ) bool SetTofShiftInfo( std::string ptnId, std::string xparams=\"\", std::string lambdas=\"\" )
    params format : <ptnId>[,p1,p2,p3,...]

    Args:
        params (std::string) Pattern ID and its parameters as std::string
        ptnId (UInt4) Pattern ID for a method to calculate TOF shift.
        xparams (std::string) parameters for this Pattern ID method ( if need )
        lambdas (std::string) if scattered data in lambda axis, use this.

    Returns:
        true : succeeded
        false : failed 

    
bool UtsusemiGetHistogramTemplate< T1, T2 >::SetTofShiftInfo(UInt4 ptnId, std::string xparams=\"\", std::string lambdas=\"\") UtsusemiGetHistogramTemplate::SetTofShiftInfo
";
%feature("docstring") UtsusemiGetHistogramTemplate::MakeTempWiringInfo "std::string UtsusemiGetHistogramTemplate< T1, T2 >::MakeTempWiringInfo(std::string priv_path=\"\") UtsusemiGetHistogramTemplate::MakeTempWiringInfo make and save the temporal wiring info to create histogram
===============================================================================================================================================================================================================
    this returns a path of the saved temporal wiring info file std::string MakeTempWiringInfo()

    Args:
        None

    Returns:
        (std::string) : the path of output wiring info file 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetL1 "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetL1(Double l1) UtsusemiGetHistogramTemplate::SetL1 sets L1 on DetectorInfo
==========================================================================================================================
    L1 means the distance between neutron source (moderator) and a sample bool SetL1( Double l1 )

    Args:
        l1 (Double)

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::SetSamplePosition "bool UtsusemiGetHistogramTemplate< T1, T2 >::SetSamplePosition(Double px, Double py, Double pz) UtsusemiGetHistogramTemplate::SetSamplePosition sets SamplePosition on DetectorInfo
====================================================================================================================================================================================
    Sample Positions are set the absolute position of Sample bool SetSamplePosition( Double px, Double py, Double pz )

    Args:
        px (Double)
        py (Double)
        pz (Double)

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiGetHistogramTemplate::PutNumOfPixelForDet "UInt4 UtsusemiGetHistogramTemplate< T1, T2 >::PutNumOfPixelForDet(UInt4 _detId=0) UtsusemiGetHistogramTemplate::PutNumOfPixelForDet

";
%feature("docstring") UtsusemiGetHistogramTemplate::PutL1 "Double UtsusemiGetHistogramTemplate< T1, T2 >::PutL1() UtsusemiGetHistogramTemplate::PutL1

";
%feature("docstring") UtsusemiGetHistogramTemplate::PutTypicalL2 "Double UtsusemiGetHistogramTemplate< T1, T2 >::PutTypicalL2() UtsusemiGetHistogramTemplate::PutTypicalL2

";
%feature("docstring") UtsusemiGetHistogramTemplate::PutTypicalDS "Double UtsusemiGetHistogramTemplate< T1, T2 >::PutTypicalDS() UtsusemiGetHistogramTemplate::PutTypicalDS

";
%feature("docstring") UtsusemiGetHistogramTemplate::MakeTempDetectorInfo "std::string UtsusemiGetHistogramTemplate< T1, T2 >::MakeTempDetectorInfo() UtsusemiGetHistogramTemplate::MakeTempDetectorInfo make and save the temporal detector info to create histogram
===========================================================================================================================================================================================
    this returns a path of the saved temporal detector info file std::string MakeTempDetectorInfo()

    Args:
        None

    Returns:
        (std::string) : the path of output detector info file 

";
%feature("docstring") UtsusemiGetHistogramTemplate::MakeTempInfoFiles "virtual std::vector< std::string > UtsusemiGetHistogramTemplate< T1, T2 >::MakeTempInfoFiles() UtsusemiGetHistogramTemplate::MakeTempInfoFiles make the temporal all info files to create histogram
====================================================================================================================================================================================================
    this returns a path of the info files ex. WiringInfo,DetectorInfo and CaseInfo std::vector<std::string> MakeTempInfoFiles()

    Args:
        None

    Returns:
        (std::vector<std::string>) : pathes for info files [0]=WiringInfo, [1]=DetectorInfo, [2]=CaseInfo 

";
// File: classUtsusemiGetNeunetHistogram.xml

%feature("docstring") UtsusemiGetNeunetHistogram "

    Creates Histogram from Neunet event data.
    read WiringInfo
    Set runNo and read suitable WiringInfo
    Set Histgram conversion parameter
    Set many parameters for the condition of histogram
    rewrite WiringInfo by given parameters
    create histogram from rewritten WiringInfo and DetectorInfo
    C++ includes: UtsusemiGetNeunetHistogram.hh 

";
%feature("docstring") UtsusemiGetNeunetHistogram::UtsusemiGetNeunetHistogram "UtsusemiGetNeunetHistogram::UtsusemiGetNeunetHistogram() UtsusemiGetNeunetHistogram::UtsusemiGetNeunetHistogram Constructor. 

";
%feature("docstring") UtsusemiGetNeunetHistogram::~UtsusemiGetNeunetHistogram "UtsusemiGetNeunetHistogram::~UtsusemiGetNeunetHistogram() UtsusemiGetNeunetHistogram::~UtsusemiGetNeunetHistogram Destructor. 

";
%feature("docstring") UtsusemiGetNeunetHistogram::SetElementContainerMatrix "bool UtsusemiGetNeunetHistogram::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > runNos, std::string wfile, std::string dfile, bool withPH=false, std::string dataPath=\"/data\", std::string t0dataPath=\"\") UtsusemiGetNeunetHistogram::SetElementContainerMatrix sets Histogram into ElementContainerMatrix using saved temporal wiring info file
==================================================================================================================================================================================================================================================================================================================================================================================
    bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath=\"/data\", std::string t0dataPath=\"\" ) bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, bool withPH=false, std::string dataPath=\"/data\", std::string t0dataPath=\"\" )

    Args:
        ecm (ElementContainerMatrix*) data container for histogram
        dataPath (std::string) top path of event data (\"/data\")
        t0dataPath (std::string) path of T0Index event data (\"\")
        runNos (std::vector<UInt4>) run numbers list
        wfile (std::string) wiring info file name
        dfile (std::string) detector info file name
        withPH (bool) adding of pulse height info

    Returns:
        true : succeeded
        false : failed 

    
bool UtsusemiGetNeunetHistogram::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1) UtsusemiGetNeunetHistogram::SetElementContainerMatrix
";
%feature("docstring") UtsusemiGetNeunetHistogram::LoadEventDataFiles "bool UtsusemiGetNeunetHistogram::LoadEventDataFiles(std::string dataPath=\"/data\", std::string t0dataPath=\"\") UtsusemiGetNeunetHistogram::LoadEventDataFiles

";
%feature("docstring") UtsusemiGetNeunetHistogram::PutListOfCases "std::vector< UInt4 > UtsusemiGetNeunetHistogram::PutListOfCases() UtsusemiGetNeunetHistogram::PutListOfCases

";
%feature("docstring") UtsusemiGetNeunetHistogram::SetFlagOfPulseIdCheck "void UtsusemiGetNeunetHistogram::SetFlagOfPulseIdCheck(bool flag) UtsusemiGetNeunetHistogram::SetFlagOfPulseIdCheck

";
%feature("docstring") UtsusemiGetNeunetHistogram::SetFlagToAddTofBin "void UtsusemiGetNeunetHistogram::SetFlagToAddTofBin(bool flag) UtsusemiGetNeunetHistogram::SetFlagToAddTofBin

";
%feature("docstring") UtsusemiGetNeunetHistogram::PutEventDataConverterNeunet "UtsusemiEventDataConverterNeunet * UtsusemiGetNeunetHistogram::PutEventDataConverterNeunet() UtsusemiGetNeunetHistogram::PutEventDataConverterNeunet

";
%feature("docstring") UtsusemiGetNeunetHistogram::PutEventDataConverterNeunetWithPH "UtsusemiEventDataConverterNeunetWithPH * UtsusemiGetNeunetHistogram::PutEventDataConverterNeunetWithPH() UtsusemiGetNeunetHistogram::PutEventDataConverterNeunetWithPH

";
// File: classUtsusemiGetRPMTHistogram.xml

%feature("docstring") UtsusemiGetRPMTHistogram "

    Creates Histogram from Neunet event data.
    read WiringInfo
    Set runNo and read suitable WiringInfo
    Set Histgram conversion parameter
    Set many parameters for the condition of histogram
    rewrite WiringInfo by given parameters
    create histogram from rewritten WiringInfo and DetectorInfo
    C++ includes: UtsusemiGetRPMTHistogram.hh 

";
%feature("docstring") UtsusemiGetRPMTHistogram::UtsusemiGetRPMTHistogram "UtsusemiGetRPMTHistogram::UtsusemiGetRPMTHistogram() UtsusemiGetRPMTHistogram::UtsusemiGetRPMTHistogram Constructor. 

";
%feature("docstring") UtsusemiGetRPMTHistogram::~UtsusemiGetRPMTHistogram "UtsusemiGetRPMTHistogram::~UtsusemiGetRPMTHistogram() UtsusemiGetRPMTHistogram::~UtsusemiGetRPMTHistogram Destructor. 

";
%feature("docstring") UtsusemiGetRPMTHistogram::SetElementContainerMatrix "bool UtsusemiGetRPMTHistogram::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::string dataPath=\"/data\", std::string t0dataPath=\"\") UtsusemiGetRPMTHistogram::SetElementContainerMatrix

    
bool UtsusemiGetRPMTHistogram::SetElementContainerMatrix(ElementContainerMatrix *ecm, std::vector< UInt4 > runNos, std::string wfile, std::string dfile, std::string dataPath=\"/data\", std::string t0dataPath=\"\") UtsusemiGetRPMTHistogram::SetElementContainerMatrix sets Histogram into ElementContainerMatrix using saved temporal wiring info file
===========================================================================================================================================================================================================================================================================================================================================================
    bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::string dataPath=\"/data\", std::string t0dataPath=\"\" ) bool SetElementContainerMatrix( ElementContainerMatrix *ecm, std::vector<UInt4> runNos, std::string wfile, std::string dfile, bool withPH=false, std::string dataPath=\"/data\", std::string t0dataPath=\"\" )

    Args:
        ecm (ElementContainerMatrix*) data container for histogram
        dataPath (std::string) top path of event data (\"/data\")
        t0dataPath (std::string) path of T0Index event data (\"\")

    Returns:
        true : succeeded
        false : failed 
";
// File: classUtsusemiLogger.xml

%feature("docstring") UtsusemiLogger "

    Logger of Ustusemi.
    stores any messages This executes as Singlton.
    C++ includes: UtsusemiHeader.hh 

";
%feature("docstring") UtsusemiLogger::_convT "std::string UtsusemiLogger::_convT(const time_t *timer) UtsusemiLogger::_convT

";
%feature("docstring") UtsusemiLogger::Add "void UtsusemiLogger::Add(const Int4 level, const std::string msg, const bool isForce=false) UtsusemiLogger::Add Adds message.
==============================================================================================================================

    Args:
        level (Int4) 0:normal message, 1:worning message, 2:error message
        msg (std::string) message
        isForce (bool) shows message in spite of _isQuiet flag

    Returns:
        None 

    
void UtsusemiLogger::Add(const std::vector< Int4 > levels, const std::vector< std::string > msgs) UtsusemiLogger::Add Adds many messages in a time.
====================================================================================================================================================

    Args:
        levels (std::vector<Int4>) 0:normal message, 1:warning message, 2:error message
        msgs (std::vector<std::string>) messages

    Returns:
        None 
    
void UtsusemiLogger::Add(const std::vector< Int4 > levels, const std::vector< std::string > msgs, const std::vector< std::string > timer) UtsusemiLogger::Add Adds many messages in a time.
============================================================================================================================================================================================

    Args:
        levels (std::vector<Int4>) 0:normal message, 1:warning message, 2:error message
        msgs (std::vector<std::string>) messages
        timer (std::vector<std::string>) timers std::string

    Returns:
        None 
";
%feature("docstring") UtsusemiLogger::Clear "void UtsusemiLogger::Clear() UtsusemiLogger::Clear Clear stored messages.
==========================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiLogger::CheckLogQuiet "void UtsusemiLogger::CheckLogQuiet() UtsusemiLogger::CheckLogQuiet Update the flag from the current UTSUSEMI_LOG_QUIET environment value.
==========================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiLogger::SetLoggingOn "void UtsusemiLogger::SetLoggingOn() UtsusemiLogger::SetLoggingOn Set the logging on.
=====================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiLogger::SetLoggingOff "void UtsusemiLogger::SetLoggingOff() UtsusemiLogger::SetLoggingOff Set the logging off.
========================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiLogger::LoggingStatus "bool UtsusemiLogger::LoggingStatus() UtsusemiLogger::LoggingStatus Return the logging status.
==============================================================================================

    Args:
        None

    Returns:
        true
        false 

";
%feature("docstring") UtsusemiLogger::PutLevels "std::vector< Int4 > UtsusemiLogger::PutLevels() UtsusemiLogger::PutLevels Puts Levels.
=======================================================================================

    Returns:
        _Levels (std::vector<Int4>) 

";
%feature("docstring") UtsusemiLogger::PutMessages "std::vector< std::string > UtsusemiLogger::PutMessages(const Int4 level=-1) UtsusemiLogger::PutMessages Puts Messages.
=======================================================================================================================

    Args:
        level (Int4) -1: all messages, 0:normal, 1:warning, 2:error

    Returns:
        _Messages (std::vector<std::string>) 

";
%feature("docstring") UtsusemiLogger::Dump "void UtsusemiLogger::Dump(const std::string filename=\"\") UtsusemiLogger::Dump Dumps to file.
===============================================================================================

    Args:
        filename (std::string) filename including path

    Returns:
        None 

";
// File: classUtsusemiModInfo.xml

%feature("docstring") UtsusemiModInfo "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiModInfo::UtsusemiModInfo "UtsusemiModInfo::UtsusemiModInfo() UtsusemiModInfo::UtsusemiModInfo Constructor. 

    
UtsusemiModInfo::UtsusemiModInfo(const UtsusemiModInfo &obj) UtsusemiModInfo::UtsusemiModInfo Copy Constructor. 
";
%feature("docstring") UtsusemiModInfo::~UtsusemiModInfo "UtsusemiModInfo::~UtsusemiModInfo() UtsusemiModInfo::~UtsusemiModInfo Destructor. 

";
%feature("docstring") UtsusemiModInfo::ClearList "void UtsusemiModInfo::ClearList() UtsusemiModInfo::ClearList

";
%feature("docstring") UtsusemiModInfo::PutAliveList "std::vector< UInt4 > UtsusemiModInfo::PutAliveList() UtsusemiModInfo::PutAliveList Puts list of DetList index alived.
======================================================================================================================

    Args:
        None

    Returns:
        std::vector of index 

";
// File: classUtsusemiNeunetEventDecoderBase.xml

%feature("docstring") UtsusemiNeunetEventDecoderBase "

    Decode Event Data of NEUNET for Utsusemi.
    C++ includes: UtsusemiNeunetEventDecoderBase.hh 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::UtsusemiNeunetEventDecoderBase "UtsusemiNeunetEventDecoderBase::UtsusemiNeunetEventDecoderBase() UtsusemiNeunetEventDecoderBase::UtsusemiNeunetEventDecoderBase Constructor. 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::~UtsusemiNeunetEventDecoderBase "UtsusemiNeunetEventDecoderBase::~UtsusemiNeunetEventDecoderBase() UtsusemiNeunetEventDecoderBase::~UtsusemiNeunetEventDecoderBase Destructor. 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::SetParametersFromFiles "Int4 UtsusemiNeunetEventDecoderBase::SetParametersFromFiles(std::string wiring_file, std::string detector_file) UtsusemiNeunetEventDecoderBase::SetParametersFromFiles set parameters from files
=================================================================================================================================================================================================

    Args:
        wiring_file (std::string) Wiring Info xml file
        detector_file (std::string) DetectorInfo xml file

    Returns:
        0 no error
        -1 Troubles happened 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::ClearPrevT0Event "void UtsusemiNeunetEventDecoderBase::ClearPrevT0Event(UInt4 ThNum) UtsusemiNeunetEventDecoderBase::ClearPrevT0Event Clear Previous T0 Event.
=============================================================================================================================================

    Args:
        ThNum (UInt4) Thread number

    Returns:
        None 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::DecodeEventData "UInt4 UtsusemiNeunetEventDecoderBase::DecodeEventData(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector< Double > *Clock, UInt4 ThNum) UtsusemiNeunetEventDecoderBase::DecodeEventData decode Event data
=================================================================================================================================================================================================================================================
    This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

    Args:
        daqId (UInt4) daq ID
        moduleNo (UInt4) module number
        data (UChar) one event data
        pixel_id (UInt4) Pixel ID calculated by given event
        tof (double) TOF calculated by given event
        Clock (std::vector<Double>)
        ThNum (UInt4) Thread number

    Returns:
        _isNeutronEvent if neutron event
        _isT0Event if T0 event
        _isClockEvent if clock event
        0 if any other event 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::ConvertPixelIdToInnerId "UInt4 UtsusemiNeunetEventDecoderBase::ConvertPixelIdToInnerId(UInt4 pixel_id) UtsusemiNeunetEventDecoderBase::ConvertPixelIdToInnerId convert outer PixelID to inner( memory allocated ) ID
============================================================================================================================================================================================
    This is used for conversion from outer PixelID to inner id for allocated vectors

    Args:
        pixel_id (UInt4) pixel ID

    Returns:
        inner ID (UInt4) 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::ConvertPixelIdToDetId "UInt4 UtsusemiNeunetEventDecoderBase::ConvertPixelIdToDetId(UInt4 pixel_id) UtsusemiNeunetEventDecoderBase::ConvertPixelIdToDetId convert outer PixelID to outer DetID
=======================================================================================================================================================================
    This is used to get det Id from outer PixelID to

    Args:
        pixel_id (UInt4) pixel ID

    Returns:
        detID (UInt4) 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutPixelIdList "std::vector< UInt4 > UtsusemiNeunetEventDecoderBase::PutPixelIdList(bool isInner) UtsusemiNeunetEventDecoderBase::PutPixelIdList return std::vector of existed id from conversion table
========================================================================================================================================================================================
    Conversion table( PixelID <-> inner ID ) is made by WiringFile. If isInner is true, this puts list of existed inner ID if false, list of existed pixel ID

    Args:
        isInner (bool) parameter to toggle type of return values.

    Returns:
        list of Id (std::vector<UInt4>) 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutHistBin "std::vector< Double > UtsusemiNeunetEventDecoderBase::PutHistBin(UInt4 outerPixelId) UtsusemiNeunetEventDecoderBase::PutHistBin put binning calculated by Efix
===============================================================================================================================================================
    For direct convertion from tof to phisical values, calculated binning(tof) is required to construct histograms.

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        binning std::vector 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutNumOfInnerPixels "UInt4 UtsusemiNeunetEventDecoderBase::PutNumOfInnerPixels() UtsusemiNeunetEventDecoderBase::PutNumOfInnerPixels put the number of inner pixels
===============================================================================================================================================

    Returns:
        the number of pixels (UInt4) 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutPixelPosition "std::vector< Double > UtsusemiNeunetEventDecoderBase::PutPixelPosition(UInt4 outerPixelId) UtsusemiNeunetEventDecoderBase::PutPixelPosition put pixel position from given outerPixelId
=======================================================================================================================================================================================

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        std::vector of pixel position 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutXLabel "std::pair< std::string, std::string > UtsusemiNeunetEventDecoderBase::PutXLabel(Int4 convtype) UtsusemiNeunetEventDecoderBase::PutXLabel

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutYLabel "std::pair< std::string, std::string > UtsusemiNeunetEventDecoderBase::PutYLabel(Int4 convtype) UtsusemiNeunetEventDecoderBase::PutYLabel

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutELabel "std::pair< std::string, std::string > UtsusemiNeunetEventDecoderBase::PutELabel(Int4 convtype) UtsusemiNeunetEventDecoderBase::PutELabel

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::SetMaskOnError "void UtsusemiNeunetEventDecoderBase::SetMaskOnError(UInt4 _outerPixelId, std::vector< Double > &_bin, std::vector< Double > &_err) UtsusemiNeunetEventDecoderBase::SetMaskOnError

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutMaxOfPixelId "UInt4 UtsusemiNeunetEventDecoderBase::PutMaxOfPixelId() UtsusemiNeunetEventDecoderBase::PutMaxOfPixelId put maximum number of pixel id
=======================================================================================================================================

    Returns:
        maximum number (UInt4) 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::CalcPixelPosition "void UtsusemiNeunetEventDecoderBase::CalcPixelPosition() UtsusemiNeunetEventDecoderBase::CalcPixelPosition calculate the position of each pixel
================================================================================================================================================
    This calculates the position of pixel from stored information. Potisions are stored to _pixelPositionVect.

    Returns:
        None 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutTofBinType "Int4 UtsusemiNeunetEventDecoderBase::PutTofBinType(UInt4 outerPixelId) UtsusemiNeunetEventDecoderBase::PutTofBinType put Tof Bin Type of given outerPixelId
============================================================================================================================================================
    Tof Bin Type comes from Wiring File

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        tof bin type 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutXaxis "std::vector< Double > UtsusemiNeunetEventDecoderBase::PutXaxis() UtsusemiNeunetEventDecoderBase::PutXaxis put x axis values
============================================================================================================================
    When TofBinType is for direct conversion from event data to energy, this returns calculated x-axis values.

    Args:
        None

    Returns:
        std::vector for values on calculated x-axis 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::isReverseAxis "bool UtsusemiNeunetEventDecoderBase::isReverseAxis(Int4 convtype) UtsusemiNeunetEventDecoderBase::isReverseAxis

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::isValidConvType "bool UtsusemiNeunetEventDecoderBase::isValidConvType(Int4 convtype) UtsusemiNeunetEventDecoderBase::isValidConvType

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::SetTofOriginShift "bool UtsusemiNeunetEventDecoderBase::SetTofOriginShift(UInt4 cType) UtsusemiNeunetEventDecoderBase::SetTofOriginShift < set fixed Energy value for direct or indirect geometry
===============================================================================================================================================================================
    < fixed Energy values are required to calculate tof array for direct unit convertion from tof If single Double efix is given, this value is used to calculate unit conversion for direct geometry analysis. The std::vector<Double> efix is used for inverted one.

    Args:
        efix (std::vector<Double> or Double) each fixed Energy ( index of vector is PixelId )

    Returns:
        None < imports Time focusing parameters to TofBinPattern from DetInfo  <

    Args:
        None

    Returns:
        None 

    
bool UtsusemiNeunetEventDecoderBase::SetTofOriginShift(UInt4 cType, std::vector< Double > params) UtsusemiNeunetEventDecoderBase::SetTofOriginShift Sets type and calculation parameter for Tof origin shift.
==============================================================================================================================================================================================================
    This shift is defined by the lamda-depend function given in codes

    Args:
        cType (UInt4) pattern Id for function
        params (std::vector<Double>) parameters of cType function

    Returns:
        true succeeded
        false failed 
";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutLambda "std::vector< Double > UtsusemiNeunetEventDecoderBase::PutLambda(UInt4 pixel_id) UtsusemiNeunetEventDecoderBase::PutLambda Puts lambda axis from data container of pixel_id.
============================================================================================================================================================================

    Args:
        pixel_id (UInt4) pixel id

    Returns:
        std::vector<Double> lambda axis 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo "std::vector< double > * UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo(UInt4 _outerPixelId) UtsusemiNeunetEventDecoderBase::PutTimeDependBackGroundInfo

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutDetIdPixNoFromEvent "bool UtsusemiNeunetEventDecoderBase::PutDetIdPixNoFromEvent(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *detId, UInt4 *pixNo, UInt4 ThNum) UtsusemiNeunetEventDecoderBase::PutDetIdPixNoFromEvent < Puts tof range of time depend background for each pixel_id
=========================================================================================================================================================================================================================================================================
    <

    Args:
        pixel_id (UInt4) pixel id

    Returns:
        std::vector<Double>* Tof range of Time Depend Back Ground 

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutNumOfPixelForDet "UInt4 UtsusemiNeunetEventDecoderBase::PutNumOfPixelForDet(UInt4 _detId=0) UtsusemiNeunetEventDecoderBase::PutNumOfPixelForDet

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutL1 "Double UtsusemiNeunetEventDecoderBase::PutL1() UtsusemiNeunetEventDecoderBase::PutL1

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutTypicalL2 "Double UtsusemiNeunetEventDecoderBase::PutTypicalL2() UtsusemiNeunetEventDecoderBase::PutTypicalL2

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutTypicalDS "Double UtsusemiNeunetEventDecoderBase::PutTypicalDS() UtsusemiNeunetEventDecoderBase::PutTypicalDS

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::PutTypicalPixelSize "std::vector< Double > UtsusemiNeunetEventDecoderBase::PutTypicalPixelSize(UInt4 _detId=0) UtsusemiNeunetEventDecoderBase::PutTypicalPixelSize

";
%feature("docstring") UtsusemiNeunetEventDecoderBase::SetSimpleMode "void UtsusemiNeunetEventDecoderBase::SetSimpleMode(bool _isSimple=false) UtsusemiNeunetEventDecoderBase::SetSimpleMode

";
// File: classUtsusemiNeutronEventDecoderBase.xml

%feature("docstring") UtsusemiNeutronEventDecoderBase "

    Base class Decode Event Data.
    with UtsusemiEventDataConverterTemplate
    C++ includes: UtsusemiNeutronEventDecoderBase.hh 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::UtsusemiNeutronEventDecoderBase "UtsusemiNeutronEventDecoderBase::UtsusemiNeutronEventDecoderBase() UtsusemiNeutronEventDecoderBase::UtsusemiNeutronEventDecoderBase Constructor. 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::~UtsusemiNeutronEventDecoderBase "UtsusemiNeutronEventDecoderBase::~UtsusemiNeutronEventDecoderBase() UtsusemiNeutronEventDecoderBase::~UtsusemiNeutronEventDecoderBase Destructor. 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::SetParametersFromFiles "Int4 UtsusemiNeutronEventDecoderBase::SetParametersFromFiles(std::string wiring_file, std::string detector_file) UtsusemiNeutronEventDecoderBase::SetParametersFromFiles set parameters from files
===================================================================================================================================================================================================

    Args:
        wiring_file (std::string) Wiring Info xml file
        detector_file (std::string) DetectorInfo xml file

    Returns:
        0 no error
        -1 Troubles happened 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::decodeEventDataPy "std::vector< Double > UtsusemiNeutronEventDecoderBase::decodeEventDataPy(UInt4 daqId, std::string data) UtsusemiNeutronEventDecoderBase::decodeEventDataPy call decodeEventData from python
============================================================================================================================================================================================
    This call decodeEventData and return pixel_id and tof.

    Args:
        daqId (UInt4) daq ID
        data (std::string) a event data

    Returns:
        std::vector<Double> [0]=pixel ID [1]=tof 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::SetFramePeriod "void UtsusemiNeutronEventDecoderBase::SetFramePeriod(Double _time) UtsusemiNeutronEventDecoderBase::SetFramePeriod

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::ClearPrevT0Event "void UtsusemiNeutronEventDecoderBase::ClearPrevT0Event(UInt4 ThNum) UtsusemiNeutronEventDecoderBase::ClearPrevT0Event Clear Previous T0 Event.
===============================================================================================================================================

    Args:
        ThNum (UInt4) Thread number

    Returns:
        None 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::DecodeEventData "UInt4 UtsusemiNeutronEventDecoderBase::DecodeEventData(UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector< Double > *Clock, UInt4 ThNum=1) UtsusemiNeutronEventDecoderBase::DecodeEventData decode Event data
=====================================================================================================================================================================================================================================================
    This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

    Args:
        daqId (UInt4) daq ID
        moduleNo (UInt4) module number
        data (UChar) one event data
        pixel_id (UInt4) Pixel ID calculated by given event
        tof (double) TOF calculated by given event
        Clock (std::vector<Double>)
        ThNum (UInt4) Thread number

    Returns:
        _isNeutronEvent if neutron event
        _isT0Event if T0 event
        _isClockEvent if clock event
        0 if any other event 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::ConvertPixelIdToInnerId "UInt4 UtsusemiNeutronEventDecoderBase::ConvertPixelIdToInnerId(UInt4 pixel_id) UtsusemiNeutronEventDecoderBase::ConvertPixelIdToInnerId convert outer PixelID to inner( memory allocated ) ID
==============================================================================================================================================================================================
    This is used for conversion from outer PixelID to inner id for allocated vectors

    Args:
        pixel_id (UInt4) pixel ID

    Returns:
        inner ID (UInt4) 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutPixelIdList "std::vector< UInt4 > UtsusemiNeutronEventDecoderBase::PutPixelIdList(bool isInner) UtsusemiNeutronEventDecoderBase::PutPixelIdList return std::vector of existed id from conversion table
==========================================================================================================================================================================================
    Conversion table( PixelID <-> inner ID ) is made by WiringFile. If isInner is true, this puts list of existed inner ID if false, list of existed pixel ID

    Args:
        isInner (bool) parameter to toggle type of return values.

    Returns:
        list of Id (std::vector<UInt4>) 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutHistBin "std::vector< Double > UtsusemiNeutronEventDecoderBase::PutHistBin(UInt4 outerPixelId) UtsusemiNeutronEventDecoderBase::PutHistBin put binning calculated by Efix
=================================================================================================================================================================
    For direct convertion from tof to phisical values, calculated binning(tof) is required to construct histograms.

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        binning std::vector 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutXaxis "std::vector< Double > UtsusemiNeutronEventDecoderBase::PutXaxis() UtsusemiNeutronEventDecoderBase::PutXaxis put X axis binning calculated from Tof bin type
============================================================================================================================================================
    For direct convertion from tof to phisical values, calculated X-axis is required to construct histograms.

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        X-axis std::vector 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::IsNeutronEvent "bool UtsusemiNeutronEventDecoderBase::IsNeutronEvent(UInt4 type) UtsusemiNeutronEventDecoderBase::IsNeutronEvent return true when type is neutron
==================================================================================================================================================
    type is return value from _EventDecoder->DecodeEventData

    Args:
        data (UInt) type

    Returns:
        bool 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::IsT0Event "bool UtsusemiNeutronEventDecoderBase::IsT0Event(UInt4 type) UtsusemiNeutronEventDecoderBase::IsT0Event return true when type is t0 event
=========================================================================================================================================
    type is return value from _EventDecoder->DecodeEventData

    Args:
        data (UInt) type

    Returns:
        bool 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::IsInstClockEvent "bool UtsusemiNeutronEventDecoderBase::IsInstClockEvent(UInt4 type) UtsusemiNeutronEventDecoderBase::IsInstClockEvent return true when type is inst clock
=========================================================================================================================================================
    type is return value from _EventDecoder->DecodeEventData

    Args:
        data (UInt) type

    Returns:
        bool 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::CalcIncrementVal "Double UtsusemiNeutronEventDecoderBase::CalcIncrementVal(Double *tof, UInt4 *pixelId) UtsusemiNeutronEventDecoderBase::CalcIncrementVal Calculation increment value (intensity shift)
======================================================================================================================================================================================
    If incremented value (default=1) shifts by case id and tof, use this function. This is used in original Increment function.

    Args:
        tof (Double*) given tof
        pixelId (UInt4*) given pixel id

    Returns:
        value (Double) 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutNumOfInnerPixels "virtual UInt4 UtsusemiNeutronEventDecoderBase::PutNumOfInnerPixels() UtsusemiNeutronEventDecoderBase::PutNumOfInnerPixels put the number of inner pixels
=========================================================================================================================================================

    Returns:
        the number of pixels (UInt4) 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutPixelPosition "std::vector< Double > UtsusemiNeutronEventDecoderBase::PutPixelPosition(UInt4 outerPixelId) UtsusemiNeutronEventDecoderBase::PutPixelPosition put pixel position from given outerPixelId
=========================================================================================================================================================================================

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        std::vector of pixel position 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutTofBinType "Int4 UtsusemiNeutronEventDecoderBase::PutTofBinType(UInt4 outerPixelId) UtsusemiNeutronEventDecoderBase::PutTofBinType put type of tof binning
===============================================================================================================================================

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        binning type 

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutXLabel "std::pair< std::string, std::string > UtsusemiNeutronEventDecoderBase::PutXLabel(Int4 convtype) UtsusemiNeutronEventDecoderBase::PutXLabel

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutYLabel "std::pair< std::string, std::string > UtsusemiNeutronEventDecoderBase::PutYLabel(Int4 convtype) UtsusemiNeutronEventDecoderBase::PutYLabel

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutELabel "std::pair< std::string, std::string > UtsusemiNeutronEventDecoderBase::PutELabel(Int4 convtype) UtsusemiNeutronEventDecoderBase::PutELabel

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::isReverseAxis "bool UtsusemiNeutronEventDecoderBase::isReverseAxis(Int4 convtype) UtsusemiNeutronEventDecoderBase::isReverseAxis

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::isValidConvType "bool UtsusemiNeutronEventDecoderBase::isValidConvType(Int4 convtype) UtsusemiNeutronEventDecoderBase::isValidConvType

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::SetMaskOnError "void UtsusemiNeutronEventDecoderBase::SetMaskOnError(UInt4 _outerPixelId, std::vector< Double > &_bin, std::vector< Double > &_err) UtsusemiNeutronEventDecoderBase::SetMaskOnError

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutTimeDependBackGroundInfo "std::vector< double > * UtsusemiNeutronEventDecoderBase::PutTimeDependBackGroundInfo(UInt4 _outerPixelId) UtsusemiNeutronEventDecoderBase::PutTimeDependBackGroundInfo

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutNumOfPixelForDet "virtual UInt4 UtsusemiNeutronEventDecoderBase::PutNumOfPixelForDet(UInt4 _detId=0) UtsusemiNeutronEventDecoderBase::PutNumOfPixelForDet

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutL1 "virtual Double UtsusemiNeutronEventDecoderBase::PutL1() UtsusemiNeutronEventDecoderBase::PutL1

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutTypicalL2 "virtual Double UtsusemiNeutronEventDecoderBase::PutTypicalL2() UtsusemiNeutronEventDecoderBase::PutTypicalL2

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutTypicalDS "virtual Double UtsusemiNeutronEventDecoderBase::PutTypicalDS() UtsusemiNeutronEventDecoderBase::PutTypicalDS

";
%feature("docstring") UtsusemiNeutronEventDecoderBase::PutTypicalPixelSize "std::vector< Double > UtsusemiNeutronEventDecoderBase::PutTypicalPixelSize(UInt4 _detId=0) UtsusemiNeutronEventDecoderBase::PutTypicalPixelSize

";
// File: classUtsusemiOneCase.xml

%feature("docstring") UtsusemiOneCase "C++ includes: UtsusemiOneTrignetStorage.hh 

";
%feature("docstring") UtsusemiOneCase::UtsusemiOneCase "UtsusemiOneCase::UtsusemiOneCase() UtsusemiOneCase::UtsusemiOneCase

    
UtsusemiOneCase::UtsusemiOneCase(UInt4 _tof, std::vector< UInt4 > *_cases) UtsusemiOneCase::UtsusemiOneCase
    
UtsusemiOneCase::UtsusemiOneCase(const UtsusemiOneCase &obj) UtsusemiOneCase::UtsusemiOneCase
";
%feature("docstring") UtsusemiOneCase::~UtsusemiOneCase "UtsusemiOneCase::~UtsusemiOneCase() UtsusemiOneCase::~UtsusemiOneCase

";
%feature("docstring") UtsusemiOneCase::SetCases "void UtsusemiOneCase::SetCases(std::vector< UInt4 > _cases) UtsusemiOneCase::SetCases

";
// File: classUtsusemiOneTrignetStorage.xml

%feature("docstring") UtsusemiOneTrignetStorage "

    Class to storage the case table for TrigNET.
    C++ includes: UtsusemiOneTrignetStorage.hh 

";
%feature("docstring") UtsusemiOneTrignetStorage::UtsusemiOneTrignetStorage "UtsusemiOneTrignetStorage::UtsusemiOneTrignetStorage(UInt4 _num_of_multh=2, UInt4 _dio=0, UInt4 _adc1=0, UInt4 _adc2=0, UInt4 _count=0) UtsusemiOneTrignetStorage::UtsusemiOneTrignetStorage Constructor. 

";
%feature("docstring") UtsusemiOneTrignetStorage::~UtsusemiOneTrignetStorage "UtsusemiOneTrignetStorage::~UtsusemiOneTrignetStorage() UtsusemiOneTrignetStorage::~UtsusemiOneTrignetStorage Destructor. 

";
%feature("docstring") UtsusemiOneTrignetStorage::SetDebugMode "void UtsusemiOneTrignetStorage::SetDebugMode(bool isDebug=false) UtsusemiOneTrignetStorage::SetDebugMode Sets Debug mode on.
=============================================================================================================================

    Args:
        isDebug (bool)

    Returns:
        None 

";
%feature("docstring") UtsusemiOneTrignetStorage::StartFrame "void UtsusemiOneTrignetStorage::StartFrame() UtsusemiOneTrignetStorage::StartFrame Reset all inner tables for the beginning of analysis trignet data.
======================================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiOneTrignetStorage::StartAFrame "void UtsusemiOneTrignetStorage::StartAFrame(UInt4 _multh) UtsusemiOneTrignetStorage::StartAFrame Reset all inner tables for one frame to analysis trignet data.
================================================================================================================================================================

    Args:
        _multh (UInt4) the openMP thread number

    Returns:
        None 

";
%feature("docstring") UtsusemiOneTrignetStorage::AddFilterCaseSort "bool UtsusemiOneTrignetStorage::AddFilterCaseSort(UInt4 _multh, UInt4 _sid2, UInt4 _tof, std::vector< UInt4 > _cases) UtsusemiOneTrignetStorage::AddFilterCaseSort Adds caseID calclated from analysis trignet filter data.
============================================================================================================================================================================================================================

    Args:
        _multh (UInt4) the openMP thread number
        _sid2 (UInt4) SID2 of an analyzed TrigNET event
        _tof (UInt4) TOF of an analyzed TrigNET event
        _cases (std::vector<UInt4>) cases of an analyzed TrigNET event

    Returns:
        true : succeeded

    Returns:
        false : failed 

";
%feature("docstring") UtsusemiOneTrignetStorage::AddCounterCaseSort "bool UtsusemiOneTrignetStorage::AddCounterCaseSort(UInt4 _multh, UInt4 _tof, UInt4 _case) UtsusemiOneTrignetStorage::AddCounterCaseSort Adds caseID calclated from analysis trignet counter data.
==================================================================================================================================================================================================

    Args:
        _multh (UInt4) the openMP thread number
        _tof (UInt4) TOF of an analyzed TrigNET event
        _case (UInt4) case of an analyzed TrigNET event

    Returns:
        true : succeeded

    Returns:
        false : failed 

";
%feature("docstring") UtsusemiOneTrignetStorage::AddPulseId "bool UtsusemiOneTrignetStorage::AddPulseId(UInt4 _multh, UInt4 _pulseId, Double _instClock=0.) UtsusemiOneTrignetStorage::AddPulseId Adds Pulse ID encoded from trignet event data.
====================================================================================================================================================================================

    Args:
        _multh (UInt4) the openMP thread number
        _pulseId (UInt4) Pulse ID of TrigNET event
        _instClock (Double) Instrument Clock of TrigNET event

    Returns:
        true : succeeded

    Returns:
        false : failed 

";
%feature("docstring") UtsusemiOneTrignetStorage::MergeOnMulTh "bool UtsusemiOneTrignetStorage::MergeOnMulTh() UtsusemiOneTrignetStorage::MergeOnMulTh Merges inner case tables for each thread into one table.
================================================================================================================================================

    Args:
        None

    Returns:
        true : succeeded

    Returns:
        false : failed 

";
%feature("docstring") UtsusemiOneTrignetStorage::Merge "bool UtsusemiOneTrignetStorage::Merge(std::vector< std::vector< UInt4 > * > *_mergedTable, std::vector< bool > isAndFilter, UInt4 _numOfCounterCase, UInt4 _preCase=0) UtsusemiOneTrignetStorage::Merge Merges three Filter cases tables and one Counter cases table into one tables.
======================================================================================================================================================================================================================================================================================

    Args:
        _mergedTable (std::vector<std::vector<UInt4>*>*) results of this merge
        isAndFilter (std::vector<bool>) And/Or condition between trignet cases in a filter
        _numOfCounterCase (UInt4) total number of counter case

    Returns:
        true : succeeded

    Returns:
        false : failed 

";
%feature("docstring") UtsusemiOneTrignetStorage::PutMergedTable "std::vector< UInt4 > UtsusemiOneTrignetStorage::PutMergedTable(UInt4 frm, std::vector< bool > isAndFilter, UInt4 _numOfCounterCase) UtsusemiOneTrignetStorage::PutMergedTable Puts the result of Merge method.
===============================================================================================================================================================================================================

    Args:
        frm (UInt4) frame NO
        isAndFilter (std::vector<bool>) And/Or condition between trignet cases in a filter
        _numOfCounterCase (UInt4) total number of counter case

    Returns:
        std::vector<UInt4> 

";
// File: classUtsusemiPsdBinInfo.xml

%feature("docstring") UtsusemiPsdBinInfo "C++ includes: WiringInfoEditorNeunet.hh 

";
%feature("docstring") UtsusemiPsdBinInfo::UtsusemiPsdBinInfo "UtsusemiPsdBinInfo::UtsusemiPsdBinInfo() UtsusemiPsdBinInfo::UtsusemiPsdBinInfo Constructor. 

    
UtsusemiPsdBinInfo::UtsusemiPsdBinInfo(const UtsusemiPsdBinInfo &obj) UtsusemiPsdBinInfo::UtsusemiPsdBinInfo Copy Constructor. 
";
%feature("docstring") UtsusemiPsdBinInfo::~UtsusemiPsdBinInfo "UtsusemiPsdBinInfo::~UtsusemiPsdBinInfo() UtsusemiPsdBinInfo::~UtsusemiPsdBinInfo Destructor. 

";
%feature("docstring") UtsusemiPsdBinInfo::SetConts "bool UtsusemiPsdBinInfo::SetConts(std::string conts) UtsusemiPsdBinInfo::SetConts Destructor. 

";
%feature("docstring") UtsusemiPsdBinInfo::SetNewNumOfPixel "bool UtsusemiPsdBinInfo::SetNewNumOfPixel(UInt4 num_of_pixel) UtsusemiPsdBinInfo::SetNewNumOfPixel

";
%feature("docstring") UtsusemiPsdBinInfo::PutContsAsString "std::string UtsusemiPsdBinInfo::PutContsAsString() UtsusemiPsdBinInfo::PutContsAsString

";
// File: classUtsusemiPsdParam.xml

%feature("docstring") UtsusemiPsdParam "C++ includes: WiringInfoEditorNeunet.hh 

";
%feature("docstring") UtsusemiPsdParam::UtsusemiPsdParam "UtsusemiPsdParam::UtsusemiPsdParam() UtsusemiPsdParam::UtsusemiPsdParam

    
UtsusemiPsdParam::UtsusemiPsdParam(const UtsusemiPsdParam &obj) UtsusemiPsdParam::UtsusemiPsdParam
";
%feature("docstring") UtsusemiPsdParam::~UtsusemiPsdParam "UtsusemiPsdParam::~UtsusemiPsdParam() UtsusemiPsdParam::~UtsusemiPsdParam

";
// File: classUtsusemiReadoutEventDecoderTemplate.xml

%feature("docstring") UtsusemiReadoutEventDecoderTemplate "

    Decode Event Data of Readout (2D) for Utsusemi.
    C++ includes: UtsusemiReadoutEventDecoderTemplate.hh 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::UtsusemiReadoutEventDecoderTemplate "UtsusemiReadoutEventDecoderTemplate< T1, T2 >::UtsusemiReadoutEventDecoderTemplate() UtsusemiReadoutEventDecoderTemplate::UtsusemiReadoutEventDecoderTemplate Constructor. 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::~UtsusemiReadoutEventDecoderTemplate "UtsusemiReadoutEventDecoderTemplate< T1, T2 >::~UtsusemiReadoutEventDecoderTemplate() UtsusemiReadoutEventDecoderTemplate::~UtsusemiReadoutEventDecoderTemplate Destructor. 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::SetParametersFromFiles "Int4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::SetParametersFromFiles(std::string wiring_file, std::string detector_file) UtsusemiReadoutEventDecoderTemplate::SetParametersFromFiles set parameters from files
=====================================================================================================================================================================================================================

    Args:
        wiring_file (std::string) Wiring Info xml file
        detector_file (std::string) DetectorInfo xml file

    Returns:
        0 no error
        -1 Troubles happened 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::ClearPrevT0Event "void UtsusemiReadoutEventDecoderTemplate< T1, T2 >::ClearPrevT0Event(UInt4 ThNum) UtsusemiReadoutEventDecoderTemplate::ClearPrevT0Event Clear Previous T0 Event.
=================================================================================================================================================================

    Args:
        ThNum (UInt4) Thread number

    Returns:
        None 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::DecodeEventData "virtual UInt4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::DecodeEventData(UInt4 daqId, UInt4 modNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector< Double > *Clock, UInt4 ThNum)=0 UtsusemiReadoutEventDecoderTemplate::DecodeEventData decode Event data
============================================================================================================================================================================================================================================================================
    This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

    Args:
        daqId (UInt4) daq ID
        modNo (UInt4) module No
        data (UChar) one event data
        pixel_id (UInt4) Pixel ID calculated by given event
        tof (double) TOF calculated by given event
        Clock (std::vector<Double>)
        ThNum (UInt4) Thread number

    Returns:
        _isNeutronEvent if neutron event
        _isT0Event if T0 event
        _isClockEvent if clock event
        0 if any other event 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::ConvertPixelIdToInnerId "UInt4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::ConvertPixelIdToInnerId(UInt4 pixel_id) UtsusemiReadoutEventDecoderTemplate::ConvertPixelIdToInnerId convert outer PixelID to inner( memory allocated ) ID
================================================================================================================================================================================================================
    This is used for conversion from outer PixelID to inner id for allocated vectors

    Args:
        pixel_id (UInt4) pixel ID

    Returns:
        inner ID (UInt4) 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::ConvertPixelIdToDetId "UInt4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::ConvertPixelIdToDetId(UInt4 pixel_id) UtsusemiReadoutEventDecoderTemplate::ConvertPixelIdToDetId convert outer PixelID to outer DetID
===========================================================================================================================================================================================
    This is used to get det Id from outer PixelID to

    Args:
        pixel_id (UInt4) pixel ID

    Returns:
        detID (UInt4) 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutPixelIdList "std::vector< UInt4 > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutPixelIdList(bool isInner) UtsusemiReadoutEventDecoderTemplate::PutPixelIdList return std::vector of existed id from conversion table
============================================================================================================================================================================================================
    Conversion table( PixelID <-> inner ID ) is made by WiringFile. If isInner is true, this puts list of existed inner ID if false, list of existed pixel ID

    Args:
        isInner (bool) parameter to toggle type of return values.

    Returns:
        list of Id (std::vector<UInt4>) 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutHistBin "std::vector< Double > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutHistBin(UInt4 outerPixelId) UtsusemiReadoutEventDecoderTemplate::PutHistBin put binning calculated by Efix
===================================================================================================================================================================================
    For direct convertion from tof to phisical values, calculated binning(tof) is required to construct histograms.

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        binning std::vector 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutNumOfInnerPixels "UInt4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutNumOfInnerPixels() UtsusemiReadoutEventDecoderTemplate::PutNumOfInnerPixels put the number of inner pixels
===================================================================================================================================================================

    Returns:
        the number of pixels (UInt4) 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutPixelPosition "std::vector< Double > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutPixelPosition(UInt4 outerPixelId) UtsusemiReadoutEventDecoderTemplate::PutPixelPosition put pixel position from given outerPixelId
===========================================================================================================================================================================================================

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        std::vector of pixel position 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutXLabel "std::pair< std::string, std::string > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutXLabel(Int4 convtype) UtsusemiReadoutEventDecoderTemplate::PutXLabel

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutYLabel "std::pair< std::string, std::string > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutYLabel(Int4 convtype) UtsusemiReadoutEventDecoderTemplate::PutYLabel

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutELabel "std::pair< std::string, std::string > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutELabel(Int4 convtype) UtsusemiReadoutEventDecoderTemplate::PutELabel

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::SetMaskOnError "void UtsusemiReadoutEventDecoderTemplate< T1, T2 >::SetMaskOnError(UInt4 _outerPixelId, std::vector< Double > &_bin, std::vector< Double > &_err) UtsusemiReadoutEventDecoderTemplate::SetMaskOnError

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::CalcPixelPosition "virtual void UtsusemiReadoutEventDecoderTemplate< T1, T2 >::CalcPixelPosition() UtsusemiReadoutEventDecoderTemplate::CalcPixelPosition calculate the position of each pixel
============================================================================================================================================================================
    This calculates the position of pixel from stored information. Potisions are stored to _pixelPositionVect.

    Returns:
        None 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutMaxOfPixelId "UInt4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutMaxOfPixelId() UtsusemiReadoutEventDecoderTemplate::PutMaxOfPixelId put maximum number of pixel id
===========================================================================================================================================================

    Returns:
        maximum number (UInt4) 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutTofBinType "Int4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutTofBinType(UInt4 outerPixelId) UtsusemiReadoutEventDecoderTemplate::PutTofBinType put Tof Bin Type of given outerPixelId
================================================================================================================================================================================
    Tof Bin Type comes from Wiring File

    Args:
        outerPixelId (UInt4) pixel id

    Returns:
        tof bin type 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutXaxis "std::vector< Double > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutXaxis() UtsusemiReadoutEventDecoderTemplate::PutXaxis put x axis values
================================================================================================================================================
    When TofBinType is for direct conversion from event data to energy, this returns calculated x-axis values.

    Args:
        None

    Returns:
        std::vector for values on calculated x-axis 

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::isReverseAxis "bool UtsusemiReadoutEventDecoderTemplate< T1, T2 >::isReverseAxis(Int4 convtype) UtsusemiReadoutEventDecoderTemplate::isReverseAxis

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::isValidConvType "bool UtsusemiReadoutEventDecoderTemplate< T1, T2 >::isValidConvType(Int4 convtype) UtsusemiReadoutEventDecoderTemplate::isValidConvType

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::SetTofOriginShift "bool UtsusemiReadoutEventDecoderTemplate< T1, T2 >::SetTofOriginShift(UInt4 cType) UtsusemiReadoutEventDecoderTemplate::SetTofOriginShift

    
bool UtsusemiReadoutEventDecoderTemplate< T1, T2 >::SetTofOriginShift(UInt4 cType, std::vector< Double > params) UtsusemiReadoutEventDecoderTemplate::SetTofOriginShift
";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutLambda "std::vector< Double > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutLambda(UInt4 pixel_id) UtsusemiReadoutEventDecoderTemplate::PutLambda

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutNumOfPixelForDet "UInt4 UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutNumOfPixelForDet(UInt4 _detId=0) UtsusemiReadoutEventDecoderTemplate::PutNumOfPixelForDet

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutL1 "Double UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutL1() UtsusemiReadoutEventDecoderTemplate::PutL1

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutTypicalL2 "Double UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutTypicalL2() UtsusemiReadoutEventDecoderTemplate::PutTypicalL2

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutTypicalDS "Double UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutTypicalDS() UtsusemiReadoutEventDecoderTemplate::PutTypicalDS

";
%feature("docstring") UtsusemiReadoutEventDecoderTemplate::PutTypicalPixelSize "std::vector< Double > UtsusemiReadoutEventDecoderTemplate< T1, T2 >::PutTypicalPixelSize(UInt4 _detId=0) UtsusemiReadoutEventDecoderTemplate::PutTypicalPixelSize

";
// File: classUtsusemiReadoutGateInfo.xml

%feature("docstring") UtsusemiReadoutGateInfo "C++ includes: WiringInfoEditorReadout.hh 

";
%feature("docstring") UtsusemiReadoutGateInfo::UtsusemiReadoutGateInfo "UtsusemiReadoutGateInfo::UtsusemiReadoutGateInfo() UtsusemiReadoutGateInfo::UtsusemiReadoutGateInfo

    
UtsusemiReadoutGateInfo::UtsusemiReadoutGateInfo(const UtsusemiReadoutGateInfo &obj) UtsusemiReadoutGateInfo::UtsusemiReadoutGateInfo
";
%feature("docstring") UtsusemiReadoutGateInfo::~UtsusemiReadoutGateInfo "UtsusemiReadoutGateInfo::~UtsusemiReadoutGateInfo() UtsusemiReadoutGateInfo::~UtsusemiReadoutGateInfo

";
// File: classUtsusemiReadoutMWPCEventDecoder.xml

%feature("docstring") UtsusemiReadoutMWPCEventDecoder "

    Decode Event Data of Readout for Utsusemi.
    C++ includes: UtsusemiReadoutMWPCEventDecoder.hh 

";
%feature("docstring") UtsusemiReadoutMWPCEventDecoder::UtsusemiReadoutMWPCEventDecoder "UtsusemiReadoutMWPCEventDecoder::UtsusemiReadoutMWPCEventDecoder() UtsusemiReadoutMWPCEventDecoder::UtsusemiReadoutMWPCEventDecoder Constructor. 

";
%feature("docstring") UtsusemiReadoutMWPCEventDecoder::~UtsusemiReadoutMWPCEventDecoder "UtsusemiReadoutMWPCEventDecoder::~UtsusemiReadoutMWPCEventDecoder() UtsusemiReadoutMWPCEventDecoder::~UtsusemiReadoutMWPCEventDecoder Destructor. 

";
%feature("docstring") UtsusemiReadoutMWPCEventDecoder::DecodeEventData "UInt4 UtsusemiReadoutMWPCEventDecoder::DecodeEventData(UInt4 daqId, UInt4 modNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector< Double > *Clock, UInt4 ThNum) UtsusemiReadoutMWPCEventDecoder::DecodeEventData decode Event data
================================================================================================================================================================================================================================================
    This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

    Args:
        daqId (UInt4) daq ID
        modNo (UInt4) module No
        data (UChar) one event data
        pixel_id (UInt4) Pixel ID calculated by given event
        tof (double) TOF calculated by given event
        Clock (std::vector<Double>)
        ThNum (UInt4) Thread number

    Returns:
        _isNeutronEvent if neutron event
        _isT0Event if T0 event
        _isClockEvent if clock event
        0 if any other event 

";
%feature("docstring") UtsusemiReadoutMWPCEventDecoder::CalcPixelPosition "void UtsusemiReadoutMWPCEventDecoder::CalcPixelPosition() UtsusemiReadoutMWPCEventDecoder::CalcPixelPosition calculate the position of each pixel
==================================================================================================================================================
    This calculates the position of pixel from stored information. Potisions are stored to _pixelPositionVect.

    Returns:
        None 

";
// File: classUtsusemiReadoutRPMTEventDecoder.xml

%feature("docstring") UtsusemiReadoutRPMTEventDecoder "

    Decode Event Data of Readout for Utsusemi.
    C++ includes: UtsusemiReadoutRPMTEventDecoder.hh 

";
%feature("docstring") UtsusemiReadoutRPMTEventDecoder::UtsusemiReadoutRPMTEventDecoder "UtsusemiReadoutRPMTEventDecoder::UtsusemiReadoutRPMTEventDecoder() UtsusemiReadoutRPMTEventDecoder::UtsusemiReadoutRPMTEventDecoder Constructor. 

";
%feature("docstring") UtsusemiReadoutRPMTEventDecoder::~UtsusemiReadoutRPMTEventDecoder "UtsusemiReadoutRPMTEventDecoder::~UtsusemiReadoutRPMTEventDecoder() UtsusemiReadoutRPMTEventDecoder::~UtsusemiReadoutRPMTEventDecoder Destructor. 

";
%feature("docstring") UtsusemiReadoutRPMTEventDecoder::DecodeEventData "UInt4 UtsusemiReadoutRPMTEventDecoder::DecodeEventData(UInt4 daqId, UInt4 modNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector< Double > *Clock, UInt4 ThNum) UtsusemiReadoutRPMTEventDecoder::DecodeEventData decode Event data
================================================================================================================================================================================================================================================
    This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

    Args:
        daqId (UInt4) daq ID
        modNo (UInt4) module No
        data (UChar) one event data
        pixel_id (UInt4) Pixel ID calculated by given event
        tof (double) TOF calculated by given event
        Clock (std::vector<Double>)
        ThNum (UInt4) Thread number

    Returns:
        _isNeutronEvent if neutron event
        _isT0Event if T0 event
        _isClockEvent if clock event
        0 if any other event 

";
%feature("docstring") UtsusemiReadoutRPMTEventDecoder::CalcPixelPosition "void UtsusemiReadoutRPMTEventDecoder::CalcPixelPosition() UtsusemiReadoutRPMTEventDecoder::CalcPixelPosition calculate the position of each pixel
==================================================================================================================================================
    This calculates the position of pixel from stored information. Potisions are stored to _pixelPositionVect.

    Returns:
        None 

";
// File: classUtsusemiReadoutWLSF32EventDecoder.xml

%feature("docstring") UtsusemiReadoutWLSF32EventDecoder "

    Decode Event Data of Readout 32bit for Utsusemi.
    C++ includes: UtsusemiReadoutWLSF32EventDecoder.hh 

";
%feature("docstring") UtsusemiReadoutWLSF32EventDecoder::UtsusemiReadoutWLSF32EventDecoder "UtsusemiReadoutWLSF32EventDecoder::UtsusemiReadoutWLSF32EventDecoder() UtsusemiReadoutWLSF32EventDecoder::UtsusemiReadoutWLSF32EventDecoder Constructor. 

";
%feature("docstring") UtsusemiReadoutWLSF32EventDecoder::~UtsusemiReadoutWLSF32EventDecoder "UtsusemiReadoutWLSF32EventDecoder::~UtsusemiReadoutWLSF32EventDecoder() UtsusemiReadoutWLSF32EventDecoder::~UtsusemiReadoutWLSF32EventDecoder Destructor. 

";
%feature("docstring") UtsusemiReadoutWLSF32EventDecoder::DecodeEventData "UInt4 UtsusemiReadoutWLSF32EventDecoder::DecodeEventData(UInt4 daqId, UInt4 modNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector< Double > *Clock, UInt4 ThNum) UtsusemiReadoutWLSF32EventDecoder::DecodeEventData decode Event data
====================================================================================================================================================================================================================================================
    This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

    Args:
        daqId (UInt4) daq ID
        modNo (UInt4) module No
        data (UChar) one event data
        pixel_id (UInt4) Pixel ID calculated by given event
        tof (double) TOF calculated by given event
        Clock (std::vector<Double>)
        ThNum (UInt4) Thread number

    Returns:
        _isNeutronEvent if neutron event
        _isT0Event if T0 event
        _isClockEvent if clock event
        0 if any other event 

";
%feature("docstring") UtsusemiReadoutWLSF32EventDecoder::CalcPixelPosition "void UtsusemiReadoutWLSF32EventDecoder::CalcPixelPosition() UtsusemiReadoutWLSF32EventDecoder::CalcPixelPosition calculate the position of each pixel
======================================================================================================================================================
    This calculates the position of pixel from stored information. Potisions are stored to _pixelPositionVect.

    Returns:
        None 

";
%feature("docstring") UtsusemiReadoutWLSF32EventDecoder::SetAnaModeReadout32 "bool UtsusemiReadoutWLSF32EventDecoder::SetAnaModeReadout32(Int4 anamode=-1) UtsusemiReadoutWLSF32EventDecoder::SetAnaModeReadout32

";
// File: classUtsusemiReductionCommon.xml

%feature("docstring") UtsusemiReductionCommon "

    Functions to do data correction.
    calculate Phi from Pixel position
    normalized by bin width
    C++ includes: UtsusemiReductionCommon.hh 

";
%feature("docstring") UtsusemiReductionCommon::UtsusemiReductionCommon "UtsusemiReductionCommon::UtsusemiReductionCommon() UtsusemiReductionCommon::UtsusemiReductionCommon Constructor. 

    
UtsusemiReductionCommon::UtsusemiReductionCommon(ElementContainerMatrix *ecm) UtsusemiReductionCommon::UtsusemiReductionCommon Constructor.
============================================================================================================================================

    Args:
        ecm ElementContainerMatrix for the target 
";
%feature("docstring") UtsusemiReductionCommon::~UtsusemiReductionCommon "UtsusemiReductionCommon::~UtsusemiReductionCommon() UtsusemiReductionCommon::~UtsusemiReductionCommon Destructor. 

";
%feature("docstring") UtsusemiReductionCommon::CalcPhi "bool UtsusemiReductionCommon::CalcPhi(ElementContainerMatrix *ecm, double d_px=0, double d_py=0, double d_pz=0) UtsusemiReductionCommon::CalcPhi executes calclulation of Phi to store in header
=================================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*) Target data
        d_px (Double) delta-x of volume of a pixel
        d_py (Double) delta-y of volume of a pixel
        d_pz (Double) delta-z of volume of a pixel

    Returns:
        true suceeded
        false failed 

    
bool UtsusemiReductionCommon::CalcPhi(double d_px=0, double d_py=0, double d_pz=0) UtsusemiReductionCommon::CalcPhi executes calclulation of Phi
=================================================================================================================================================

    Args:
        d_px (Double) delta-x of volume of a pixel
        d_py (Double) delta-y of volume of a pixel
        d_pz (Double) delta-z of volume of a pixel

    Returns:
        true suceeded
        false failed 
";
%feature("docstring") UtsusemiReductionCommon::NormByBinWidth "bool UtsusemiReductionCommon::NormByBinWidth(ElementContainerMatrix *ecm, std::string key=\"\") UtsusemiReductionCommon::NormByBinWidth

    
bool UtsusemiReductionCommon::NormByBinWidth(std::string key=\"\") UtsusemiReductionCommon::NormByBinWidth Intensity normalized by binning width.
==================================================================================================================================================

    Returns:
        true : suceeded
        false failed 
";
%feature("docstring") UtsusemiReductionCommon::NormBySolidAngle "bool UtsusemiReductionCommon::NormBySolidAngle(ElementContainerMatrix *ecm, Double L2=0.0, Double dS=0.0) UtsusemiReductionCommon::NormBySolidAngle

    
bool UtsusemiReductionCommon::NormBySolidAngle(Double L2=0.0, Double dS=0.0) UtsusemiReductionCommon::NormBySolidAngle
";
%feature("docstring") UtsusemiReductionCommon::SolidAngleCorrect "bool UtsusemiReductionCommon::SolidAngleCorrect(ElementContainerMatrix *ecm=NULL) UtsusemiReductionCommon::SolidAngleCorrect

";
%feature("docstring") UtsusemiReductionCommon::NormByKickers "bool UtsusemiReductionCommon::NormByKickers(ElementContainerMatrix *ecm=NULL, Double normFactor=1.0) UtsusemiReductionCommon::NormByKickers

    
bool UtsusemiReductionCommon::NormByKickers(Double normFactor) UtsusemiReductionCommon::NormByKickers
";
// File: classUtsusemiReductionInEla.xml

%feature("docstring") UtsusemiReductionInEla "

    Function to do corrections for inelastic scattering.
    ki/kf term
    1/dhw
    ToPowder
    C++ includes: UtsusemiReductionInEla.hh 

";
%feature("docstring") UtsusemiReductionInEla::UtsusemiReductionInEla "UtsusemiReductionInEla::UtsusemiReductionInEla() UtsusemiReductionInEla::UtsusemiReductionInEla

    
UtsusemiReductionInEla::UtsusemiReductionInEla(ElementContainerMatrix *ecm) UtsusemiReductionInEla::UtsusemiReductionInEla Constructor.
========================================================================================================================================

    Args:
        ecm ElementContainerMatrix for the target 
";
%feature("docstring") UtsusemiReductionInEla::~UtsusemiReductionInEla "UtsusemiReductionInEla::~UtsusemiReductionInEla() UtsusemiReductionInEla::~UtsusemiReductionInEla Destructor. 

";
%feature("docstring") UtsusemiReductionInEla::KiKfCorrect "bool UtsusemiReductionInEla::KiKfCorrect(ElementContainerMatrix *ecm=NULL) UtsusemiReductionInEla::KiKfCorrect executes correction.
====================================================================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiReductionInEla::dHWCorrect "bool UtsusemiReductionInEla::dHWCorrect(ElementContainerMatrix *ecm=NULL) UtsusemiReductionInEla::dHWCorrect

";
%feature("docstring") UtsusemiReductionInEla::ToPowder "bool UtsusemiReductionInEla::ToPowder(ElementContainerMatrix *ret_ecm, Double deltaQ, Double startQ=-1.0, Double endQ=-1.0) UtsusemiReductionInEla::ToPowder

    
bool UtsusemiReductionInEla::ToPowder(ElementContainerMatrix *ecm, ElementContainerMatrix *ret_ecm, Double deltaQ, Double startQ=-1.0, Double endQ=-1.0) UtsusemiReductionInEla::ToPowder
";
%feature("docstring") UtsusemiReductionInEla::BoseFactorCorrect "bool UtsusemiReductionInEla::BoseFactorCorrect(ElementContainerMatrix *ecm, Double T) UtsusemiReductionInEla::BoseFactorCorrect

    
bool UtsusemiReductionInEla::BoseFactorCorrect(Double T) UtsusemiReductionInEla::BoseFactorCorrect
";
%feature("docstring") UtsusemiReductionInEla::BoseFactorCorrectEC "bool UtsusemiReductionInEla::BoseFactorCorrectEC(ElementContainer *ec, Double T) UtsusemiReductionInEla::BoseFactorCorrectEC

";
// File: classUtsusemiRunDataPathDict.xml

%feature("docstring") UtsusemiRunDataPathDict "

    Dictionary for Run data path.
    stores the found run data folders This is executed as a Singlton.
    C++ includes: UtsusemiHeader.hh 

";
%feature("docstring") UtsusemiRunDataPathDict::Add "void UtsusemiRunDataPathDict::Add(const std::string runNo, const std::vector< std::string > runFolders) UtsusemiRunDataPathDict::Add Adds path informations.
=============================================================================================================================================================

    Args:
        runNo (std::string) XXXnnnnnn like SIK012345
        runFolders (std::vector<std::string>) /data/SIK/SIK012345_20181218

    Returns:
        None 

";
%feature("docstring") UtsusemiRunDataPathDict::Put "std::vector< std::string > UtsusemiRunDataPathDict::Put(const std::string runNo) UtsusemiRunDataPathDict::Put Puts path informations.
======================================================================================================================================

    Args:
        runNo (std::string) XXXnnnnnn like SIK012345

    Returns:
        std::vector<std::string> folders for runNo 

";
%feature("docstring") UtsusemiRunDataPathDict::Dump "void UtsusemiRunDataPathDict::Dump() UtsusemiRunDataPathDict::Dump Dumps of dictionary.
========================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiRunDataPathDict::Clear "void UtsusemiRunDataPathDict::Clear() UtsusemiRunDataPathDict::Clear Clears dictionary.
========================================================================================

    Args:
        None

    Returns:
        None 

";
// File: classUtsusemiSetMask.xml

%feature("docstring") UtsusemiSetMask "

    Sets mask flag at data container on Utsusemi environment.
    Mask flags is under the mask rule of Manyo-Library when the HeaderBase of container includes \"MASKED\" with (Int4) 1
    when the error value is minus
    This UtsusemiSetMask can set mask to ElementContainerMatrix using Mask File. Mask File format1 Ignores line which first charactor is #
    text format with space separator <detId> or <detId>.<pixNo> detId is value of key \"DETID\" in HeaderBase of ElementContainerArray pixNo is the index number of ElementContainer stored in ElementContainerArray
    Example of mask.txt
    | # INSTRUMENT SIK |  | | # DATATYPE ELEMENTCONTAINERMATRIX |  | | # TIME 2014 3 10 |  | 0.0 0.99
    | 1.0 1.99
    | 10
    | 11.0 11.1
    Mask File format2 xml format Example of mask.xml
    | <maskInfo>
    |   <masklist n= | \"2\" | >
    |     <mask i= | \"0\" | >
    |       <pixelid> 100-200 </pixelid>
    |       <detector/>
    |       <pixelno/>
    |       <axis key= | \"\" | />
    |     </mask>
    |     <mask i= | \"1\" | >
    |       <pixelid/>
    |       <detector> 32-223 </detector>
    |       <pixelno>All</pixelno>
    |       <axis key= | \"TOF\" | >0:500,1000:1250</axis>
    |     </mask>
    |   </masklist>
    | </maskInfo>
    Mask files must be placed in ${UTSUSEMI_BASE_DIR}/${UTSUSEMI_INST_CODE}/ana/xml
    ${UTSUSEMI_USR_DIR}/ana/xml
    C++ includes: UtsusemiSetMask.hh 

";
%feature("docstring") UtsusemiSetMask::UtsusemiSetMask "UtsusemiSetMask::UtsusemiSetMask() UtsusemiSetMask::UtsusemiSetMask Constructor. 

    
UtsusemiSetMask::UtsusemiSetMask(ElementContainerMatrix *ecm) UtsusemiSetMask::UtsusemiSetMask Constructor.
============================================================================================================

    Args:
        ecm (ElementContainerMatrix*) target data container 
    
UtsusemiSetMask::UtsusemiSetMask(ElementContainerMatrix *ecm, std::string filename) UtsusemiSetMask::UtsusemiSetMask Constructor.
==================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*) target data container
        filename (std::string) Maskfile format1: xxx.txt, format2: xxx.xml 
    
UtsusemiSetMask::UtsusemiSetMask(ElementContainerMatrix *ecm, std::string filename, std::string key) UtsusemiSetMask::UtsusemiSetMask Constructor.
===================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix*) target data container
        filename (std::string) Maskfile format1: xxx.txt, format2: xxx.xml
        key (std::string) key of axis in data container on using format2 
";
%feature("docstring") UtsusemiSetMask::~UtsusemiSetMask "UtsusemiSetMask::~UtsusemiSetMask() UtsusemiSetMask::~UtsusemiSetMask Destructor. 

";
%feature("docstring") UtsusemiSetMask::ReadFile "bool UtsusemiSetMask::ReadFile(std::string filename) UtsusemiSetMask::ReadFile Reads Mask File.
================================================================================================
    bool ReadFile( std::string filename )

    Args:
        filename (std::string) full path to mask file

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiSetMask::SetAxisKey "void UtsusemiSetMask::SetAxisKey(std::string a_key) UtsusemiSetMask::SetAxisKey Sets Axis key in data container on using format2.
==================================================================================================================================
    void SetAxisKey( std::string a_key )

    Args:
        key (std::string) key

    Returns:
        None 

";
%feature("docstring") UtsusemiSetMask::Execute "bool UtsusemiSetMask::Execute() UtsusemiSetMask::Execute Executes Set Mask flags.
==================================================================================
    bool Execute()

    Args:
        None

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiSetMask::MaskRange "void UtsusemiSetMask::MaskRange(ElementContainer *ec, std::string key, std::vector< Double > axrange) UtsusemiSetMask::MaskRange Masks given axis range.
=========================================================================================================================================================
    void MaskRange( ElementContainer* ec, std::string key, std::vector<Double> axrange )

    Args:
        ec (ElementContainer*) target data container
        key (std::string) key of axis to be masked
        axrange (std::vector<Double>) [mask1_start,mask1_end,mask2_start,mask2_end,...]

    Returns:
        None 

";
%feature("docstring") UtsusemiSetMask::UnmaskAll "void UtsusemiSetMask::UnmaskAll() UtsusemiSetMask::UnmaskAll Deletes all masked flag.
======================================================================================
    void UnmaskAll()

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiSetMask::PutListOfTxtMask "bool UtsusemiSetMask::PutListOfTxtMask(std::vector< std::vector< std::vector< Double > * > * > *list) UtsusemiSetMask::PutListOfTxtMask

";
// File: classUtsusemiSqeCalc.xml

%feature("docstring") UtsusemiSqeCalc "

    Class for supporting functions to treat Q value.
    This includes some methods to replace functions in VisualCont2 (VisualContCommon.py)
    C++ includes: UtsusemiSqeCalc.hh 

";
%feature("docstring") UtsusemiSqeCalc::UtsusemiSqeCalc "UtsusemiSqeCalc::UtsusemiSqeCalc() UtsusemiSqeCalc::UtsusemiSqeCalc Constructor. 

    
UtsusemiSqeCalc::UtsusemiSqeCalc(bool isDebug) UtsusemiSqeCalc::UtsusemiSqeCalc Constructor.
=============================================================================================

    Args:
        isDebug when debug mode, set true 
    
UtsusemiSqeCalc::UtsusemiSqeCalc(std::string instType) UtsusemiSqeCalc::UtsusemiSqeCalc Constructor.
=====================================================================================================

    Args:
        instType Direct:direct geometry, Inverted:inverted geometry 
";
%feature("docstring") UtsusemiSqeCalc::~UtsusemiSqeCalc "UtsusemiSqeCalc::~UtsusemiSqeCalc() UtsusemiSqeCalc::~UtsusemiSqeCalc Destructor. 

";
%feature("docstring") UtsusemiSqeCalc::SetInstGeometry "void UtsusemiSqeCalc::SetInstGeometry(std::string instType=\"Direct\") UtsusemiSqeCalc::SetInstGeometry Sets the instrument geometry.
======================================================================================================================================

    Args:
        instType Direct:direct geometry, Inverted:inverted geometry 

";
%feature("docstring") UtsusemiSqeCalc::CalcReciproLattice "std::vector< Double > UtsusemiSqeCalc::CalcReciproLattice(std::vector< Double > latticeConst, std::vector< Double > Uvec, std::vector< Double > Vvec, Double phi) UtsusemiSqeCalc::CalcReciproLattice Calculates reciprocal lattice from parameters.
=====================================================================================================================================================================================================================================================

    Args:
        latticeConst Lattice Constants a,b,c,alpha,beta,gamma
        Uvec U std::vector
        Vvec V std::vector
        phi angle around W axis

    Returns:
        Reciprocal Lattice std::vector 

";
%feature("docstring") UtsusemiSqeCalc::Make4DVect "std::vector< Double > UtsusemiSqeCalc::Make4DVect(std::vector< Double > vaxis, std::vector< Double > lc) UtsusemiSqeCalc::Make4DVect Makes 4 dimension std::vector on Q-E space from 3-D std::vector on Q-space.
=================================================================================================================================================================================================================

    Args:
        vaxis view axes
        lc Reciprocal std::vector infor (returned from CalcReciproLattice)

    Returns:
        None 

";
%feature("docstring") UtsusemiSqeCalc::Projection "std::vector< Double > UtsusemiSqeCalc::Projection(std::vector< Double > vaxis) UtsusemiSqeCalc::Projection Calculates projction of ElementContainerMatrix.
===========================================================================================================================================================

    Args:
        vaxis view axes

    Returns:
        Reciprocal Lattice std::vector 

    
bool UtsusemiSqeCalc::Projection(PyObject *arg_ax1, PyObject *arg_ax2, PyObject *arg_ax3, PyObject *arg_ax4) UtsusemiSqeCalc::Projection
    
bool UtsusemiSqeCalc::Projection() UtsusemiSqeCalc::Projection
";
%feature("docstring") UtsusemiSqeCalc::Projection_QxQyQz "std::vector< Double > UtsusemiSqeCalc::Projection_QxQyQz(std::vector< Double > vaxis) UtsusemiSqeCalc::Projection_QxQyQz Calculates projction of ElementContainerMatrix.
=========================================================================================================================================================================

    Args:
        vaxis view axes

    Returns:
        Reciprocal Lattice std::vector 

";
%feature("docstring") UtsusemiSqeCalc::Slice "Int4 UtsusemiSqeCalc::Slice(std::vector< Double > Ax1range, std::vector< Double > Ax2range, std::vector< Double > Ax3range, std::vector< Double > Ax4range, std::vector< std::string > AxesType, std::vector< Double > Folding, bool isAverageMode=true) UtsusemiSqeCalc::Slice Slice.
=======================================================================================================================================================================================================================================================================================

    Args:
        Ax1range first view axis std::vector
        Ax2range second view axis std::vector
        Ax3range third view axis std::vector
        Ax4range forth view axis std::vector
        AxesType set how to treat each axis. can use only \"X\",\"Y\" or \"T\".
        Folding [0]to[3] are for along-axis-folding 0..off, 1..on, [4]to[6] are parameters for diagonal folding, [4] is type 0..no, 1..1st-3rd quadrant, 2..2nd-4th quadrant, [5]and[6] are axes-id to be used.
        isAverageMode

    Returns:
        -1 Something wrong
        0 No trouble 

    
bool UtsusemiSqeCalc::Slice(PyObject *Ax1, PyObject *Ax2, PyObject *Ax3, PyObject *Ax4, PyObject *DiagFolding, bool isAverageMode=true) UtsusemiSqeCalc::Slice
    
bool UtsusemiSqeCalc::Slice(bool isAverageMode=true) UtsusemiSqeCalc::Slice
";
%feature("docstring") UtsusemiSqeCalc::PutXArray "std::vector< Double > UtsusemiSqeCalc::PutXArray() UtsusemiSqeCalc::PutXArray Puts XArray (X-axis values) calculated at Slice method.
======================================================================================================================================

    Returns:
        < XArray > 

";
%feature("docstring") UtsusemiSqeCalc::PutYArray "std::vector< Double > UtsusemiSqeCalc::PutYArray() UtsusemiSqeCalc::PutYArray Puts YArray (Y-axis values) calculated at Slice method.
======================================================================================================================================

    Returns:
        < YArray > 

";
%feature("docstring") UtsusemiSqeCalc::PutDArray "std::vector< Double > UtsusemiSqeCalc::PutDArray() UtsusemiSqeCalc::PutDArray Puts DArray (Intensity values) calculated at Slice method.
=========================================================================================================================================

    Returns:
        < DArray > 

";
%feature("docstring") UtsusemiSqeCalc::PutEArray "std::vector< Double > UtsusemiSqeCalc::PutEArray() UtsusemiSqeCalc::PutEArray Puts EArray (Error values) calculated at Slice method.
=====================================================================================================================================

    Returns:
        < EArray > 

";
%feature("docstring") UtsusemiSqeCalc::GetAxLimit "std::vector< Double > UtsusemiSqeCalc::GetAxLimit() UtsusemiSqeCalc::GetAxLimit returns Q1,Q2,Q3,hw ranges
===========================================================================================================

    Returns:
        < Q1 min, Q1 max, Q2 min, Q2 max, Q3 min, Q3 max, Q4 min, Q4 max > 

";
%feature("docstring") UtsusemiSqeCalc::PutQRange "PyObject * UtsusemiSqeCalc::PutQRange() UtsusemiSqeCalc::PutQRange Puts axes ranges of D4Mat.
==============================================================================================

    Args:
        None

    Returns:
        python list object [ax1_min, ax1_max, ax2_min, ... , ax4_max] 

";
%feature("docstring") UtsusemiSqeCalc::ConvertToD4Mat "Int4 UtsusemiSqeCalc::ConvertToD4Mat(std::string filepath, std::vector< Double > ax1, std::vector< Double > ax2, std::vector< Double > ax3, std::vector< Double > ax4, std::vector< Double > foldings, bool isAverageMode=true, bool useBinCorr=true) UtsusemiSqeCalc::ConvertToD4Mat Convert and save data using format which D4MatSlicer can load.
=====================================================================================================================================================================================================================================================================================================================================================

    Args:
        filepath Path/to/file
        ax1 first view axis information < min, max, step >
        ax2 second view axis information < min, max, step >
        ax3 third view axis information < min, max, step >
        ax4 forth view axis information < min, max, step >
        foldings folding 0..off, 1..on
        isAverageMode true: average calculation of intensity, false: summation
        useBinCorr true: do bin width correction

    Returns:
        -1 Something wrong
        0 No trouble 

    
Int4 UtsusemiSqeCalc::ConvertToD4Mat(std::string filepath, bool isAverageMode=true, bool useBinCorr=true) UtsusemiSqeCalc::ConvertToD4Mat Convert and save data using format which D4MatSlicer can load.
=========================================================================================================================================================================================================

    Args:
        filepath Path/to/file
        isAverageMode true: average calculation of intensity, false: summation
        useBinCorr true: do bin width correction

    Returns:
        -1 Something wrong
        0 No trouble 
";
%feature("docstring") UtsusemiSqeCalc::Test "void UtsusemiSqeCalc::Test() UtsusemiSqeCalc::Test

";
%feature("docstring") UtsusemiSqeCalc::QConvFromReciprocalToRealSpace "std::vector< Double > UtsusemiSqeCalc::QConvFromReciprocalToRealSpace(std::vector< Double > Qvec, std::vector< Double > LC, std::vector< Double > Uv, std::vector< Double > Vv, std::vector< Double > RS, std::vector< Double > VA) UtsusemiSqeCalc::QConvFromReciprocalToRealSpace Convert list of Qx,Qy,Qz in Qvec to real space using sample information.
=============================================================================================================================================================================================================================================================================================================================================================

    Args:
        Qvec list of Qx,Qy,Qz : Qx0,Qy0,Qz0,Qx1,Qy1,Qz1,Qx2,...,Qxn,Qyn,Qzn
        LC Latice constants
        Uv U std::vector
        Vv V std::vector
        RS Rotation info
        VA View axes info

    Returns:
        list of x,y,z in real space, its size is same as Qvec 

";
%feature("docstring") UtsusemiSqeCalc::MakeProjectionMatrix "std::vector< Double > UtsusemiSqeCalc::MakeProjectionMatrix(std::vector< Double > latticeConst, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > rotateSteps, std::vector< Double > viewAxes) UtsusemiSqeCalc::MakeProjectionMatrix Makes the 4d Matrix for projection from (Qa,Qb,Qc,hw) -> (Vx,Vy,Vz,Vx)
========================================================================================================================================================================================================================================================================================================================================
    Vx = Qz*A[0] + Qx*A[1] + Qy*A[2] + hw*A[3]; Vy = Qz*A[4] + Qx*A[5] + Qy*A[6] + hw*A[7]; Vz = Qz*A[8] + Qx*A[9] + Qy*A[10] + hw*A[11]; Vw = Qz*A[12] + Qx*A[13] + Qy*A[14] + hw*A[15];

    Args:
        laticeConst (std::vector<double>) a,b,c,alpha,beta,gamma
        Uvec (std::vector<double>) U std::vector
        Vvec (std::vector<double>) V std::vector
        rotateSteps (std::vector<double>) axis1, rot1[, axis2, rot2[, axis3, rot3] ] axisX is the number of rotation axis (\"X\":0,\"Y\":1,\"Z\":2) and the rotation value
        viewAxes (std::vector<Double>) View Axes

    Returns:
        std::vector<Double> Matrix A with size of 16 

";
%feature("docstring") UtsusemiSqeCalc::SetSlicedElementContainerArray "bool UtsusemiSqeCalc::SetSlicedElementContainerArray(ElementContainerArray *_eca, std::string _bin_key=\"X\", std::string _xval_key=\"XVAL\", std::string _xrange_key=UTSUSEMI_KEY_HEAD_XRANGE) UtsusemiSqeCalc::SetSlicedElementContainerArray

";
%feature("docstring") UtsusemiSqeCalc::LoadXtalParam "bool UtsusemiSqeCalc::LoadXtalParam(std::string file) UtsusemiSqeCalc::LoadXtalParam

";
%feature("docstring") UtsusemiSqeCalc::SaveXtalParam "bool UtsusemiSqeCalc::SaveXtalParam(std::string file) UtsusemiSqeCalc::SaveXtalParam

";
%feature("docstring") UtsusemiSqeCalc::SetLatticeConstants "bool UtsusemiSqeCalc::SetLatticeConstants(PyObject *LC) UtsusemiSqeCalc::SetLatticeConstants

";
%feature("docstring") UtsusemiSqeCalc::SetUVvector "bool UtsusemiSqeCalc::SetUVvector(PyObject *UV, PyObject *VV) UtsusemiSqeCalc::SetUVvector

";
%feature("docstring") UtsusemiSqeCalc::SetRotationSteps "bool UtsusemiSqeCalc::SetRotationSteps(std::string steps) UtsusemiSqeCalc::SetRotationSteps

";
%feature("docstring") UtsusemiSqeCalc::SetDebugMode "void UtsusemiSqeCalc::SetDebugMode(bool _isDebugMode=true) UtsusemiSqeCalc::SetDebugMode

";
// File: classUtsusemiSqeCalc2.xml

%feature("docstring") UtsusemiSqeCalc2 "

    Class for supporting functions to treat Q value.
    This includes some methods to replace functions in VisualCont2 (VisualContCommon.py)
    C++ includes: UtsusemiSqeCalc2.hh 

";
%feature("docstring") UtsusemiSqeCalc2::UtsusemiSqeCalc2 "UtsusemiSqeCalc2::UtsusemiSqeCalc2() UtsusemiSqeCalc2::UtsusemiSqeCalc2 Constructor. 

    
UtsusemiSqeCalc2::UtsusemiSqeCalc2(bool isDebug) UtsusemiSqeCalc2::UtsusemiSqeCalc2 Constructor.
=================================================================================================

    Args:
        isDebug when debug mode, set true 
    
UtsusemiSqeCalc2::UtsusemiSqeCalc2(std::string instType) UtsusemiSqeCalc2::UtsusemiSqeCalc2 Constructor.
=========================================================================================================

    Args:
        instType Direct:direct geometry, Inverted:inverted geometry 
";
%feature("docstring") UtsusemiSqeCalc2::~UtsusemiSqeCalc2 "UtsusemiSqeCalc2::~UtsusemiSqeCalc2() UtsusemiSqeCalc2::~UtsusemiSqeCalc2 Destructor. 

";
%feature("docstring") UtsusemiSqeCalc2::MakeProjectionMatrix "std::vector< Double > UtsusemiSqeCalc2::MakeProjectionMatrix(std::vector< Double > latticeConst, std::vector< Double > Uvec, std::vector< Double > Vvec, std::vector< Double > rotateSteps, std::vector< Double > viewAxes) UtsusemiSqeCalc2::MakeProjectionMatrix

    
std::vector< Double > UtsusemiSqeCalc2::MakeProjectionMatrix(std::vector< Double > UBmat, std::vector< Double > rotateSteps, std::vector< Double > viewAxes) UtsusemiSqeCalc2::MakeProjectionMatrix Makes the 4d Matrix for projection from (Qa,Qb,Qc,hw) -> (Vx,Vy,Vz,Vx)
===========================================================================================================================================================================================================================================================================
    Vx = Qx*A[0] + Qy*A[1] + Qz*A[2] + hw*A[3]; Vy = Qx*A[4] + Qy*A[5] + Qz*A[6] + hw*A[7]; Vz = Qx*A[8] + Qy*A[9] + Qz*A[10] + hw*A[11]; Vw = Qx*A[12] + Qy*A[13] + Qz*A[14] + hw*A[15];

    Args:
        laticeConst (std::vector<double>) a,b,c,alpha,beta,gamma
        Uvec (std::vector<double>) U std::vector
        Vvec (std::vector<double>) V std::vector
        rotateSteps (std::vector<double>) axis1, rot1[, axis2, rot2[, axis3, rot3] ] axisX is the number of rotation axis (\"X\":0,\"Y\":1,\"Z\":2) and the rotation value
        viewAxes (std::vector<Double>) View Axes

    Returns:
        std::vector<Double> Matrix A with size of 16 
";
%feature("docstring") UtsusemiSqeCalc2::SetInstGeometry "void UtsusemiSqeCalc2::SetInstGeometry(std::string instType=\"Direct\") UtsusemiSqeCalc2::SetInstGeometry Sets the instrument geometry.
========================================================================================================================================

    Args:
        instType Direct:direct geometry, Inverted:inverted geometry 

";
%feature("docstring") UtsusemiSqeCalc2::Projection "std::vector< Double > UtsusemiSqeCalc2::Projection(std::vector< Double > vaxis) UtsusemiSqeCalc2::Projection Calculates projction of ElementContainerMatrix.
=============================================================================================================================================================

    Args:
        vaxis view axes

    Returns:
        Reciprocal Lattice std::vector 

    
bool UtsusemiSqeCalc2::Projection(PyObject *arg_ax1, PyObject *arg_ax2, PyObject *arg_ax3, PyObject *arg_ax4) UtsusemiSqeCalc2::Projection
    
bool UtsusemiSqeCalc2::Projection() UtsusemiSqeCalc2::Projection
";
%feature("docstring") UtsusemiSqeCalc2::Projection_QxQyQz "std::vector< Double > UtsusemiSqeCalc2::Projection_QxQyQz(std::vector< Double > vaxis) UtsusemiSqeCalc2::Projection_QxQyQz Calculates projction of ElementContainerMatrix.
===========================================================================================================================================================================

    Args:
        vaxis view axes

    Returns:
        Reciprocal Lattice std::vector 

";
%feature("docstring") UtsusemiSqeCalc2::Slice "Int4 UtsusemiSqeCalc2::Slice(std::vector< Double > Ax1range, std::vector< Double > Ax2range, std::vector< Double > Ax3range, std::vector< Double > Ax4range, std::vector< std::string > AxesType, std::vector< Double > Folding, bool isAverageMode=true) UtsusemiSqeCalc2::Slice Slice.
=========================================================================================================================================================================================================================================================================================

    Args:
        Ax1range first view axis std::vector
        Ax2range second view axis std::vector
        Ax3range third view axis std::vector
        Ax4range forth view axis std::vector
        AxesType set how to treat each axis. can use only \"X\",\"Y\" or \"T\".
        Folding [0]to[3] are for along-axis-folding 0..off, 1..on, [4]to[6] are parameters for diagonal folding, [4] is type 0..no, 1..1st-3rd quadrant, 2..2nd-4th quadrant, [5]and[6] are axes-id to be used.
        isAverageMode

    Returns:
        -1 Something wrong
        0 No trouble 

    
bool UtsusemiSqeCalc2::Slice(PyObject *Ax1, PyObject *Ax2, PyObject *Ax3, PyObject *Ax4, PyObject *DiagFolding, bool isAverageMode=true) UtsusemiSqeCalc2::Slice
    
bool UtsusemiSqeCalc2::Slice(bool isAverageMode=true) UtsusemiSqeCalc2::Slice
";
%feature("docstring") UtsusemiSqeCalc2::PutXArray "std::vector< Double > UtsusemiSqeCalc2::PutXArray() UtsusemiSqeCalc2::PutXArray Puts XArray (X-axis values) calculated at Slice method.
========================================================================================================================================

    Returns:
        < XArray > 

";
%feature("docstring") UtsusemiSqeCalc2::PutYArray "std::vector< Double > UtsusemiSqeCalc2::PutYArray() UtsusemiSqeCalc2::PutYArray Puts YArray (Y-axis values) calculated at Slice method.
========================================================================================================================================

    Returns:
        < YArray > 

";
%feature("docstring") UtsusemiSqeCalc2::PutDArray "std::vector< Double > UtsusemiSqeCalc2::PutDArray() UtsusemiSqeCalc2::PutDArray Puts DArray (Intensity values) calculated at Slice method.
===========================================================================================================================================

    Returns:
        < DArray > 

";
%feature("docstring") UtsusemiSqeCalc2::PutEArray "std::vector< Double > UtsusemiSqeCalc2::PutEArray() UtsusemiSqeCalc2::PutEArray Puts EArray (Error values) calculated at Slice method.
=======================================================================================================================================

    Returns:
        < EArray > 

";
%feature("docstring") UtsusemiSqeCalc2::GetAxLimit "std::vector< Double > UtsusemiSqeCalc2::GetAxLimit() UtsusemiSqeCalc2::GetAxLimit returns Q1,Q2,Q3,hw ranges
=============================================================================================================

    Returns:
        < Q1 min, Q1 max, Q2 min, Q2 max, Q3 min, Q3 max, Q4 min, Q4 max > 

";
%feature("docstring") UtsusemiSqeCalc2::PutQRange "PyObject * UtsusemiSqeCalc2::PutQRange() UtsusemiSqeCalc2::PutQRange Puts axes ranges of D4Mat.
================================================================================================

    Args:
        None

    Returns:
        python list object [ax1_min, ax1_max, ax2_min, ... , ax4_max] 

";
%feature("docstring") UtsusemiSqeCalc2::ConvertToD4Mat "Int4 UtsusemiSqeCalc2::ConvertToD4Mat(std::string filepath, std::vector< Double > ax1, std::vector< Double > ax2, std::vector< Double > ax3, std::vector< Double > ax4, std::vector< Double > foldings, bool isAverageMode=true) UtsusemiSqeCalc2::ConvertToD4Mat Convert and save data using format which D4MatSlicer can load.
=================================================================================================================================================================================================================================================================================================================================

    Args:
        filepath Path/to/file
        ax1 first view axis information < min, max, step >
        ax2 second view axis information < min, max, step >
        ax3 third view axis information < min, max, step >
        ax4 forth view axis information < min, max, step >
        foldings folding 0..off, 1..on
        isAverageMode true: average calculation of intensity, false: summation

    Returns:
        -1 Something wrong
        0 No trouble 

    
Int4 UtsusemiSqeCalc2::ConvertToD4Mat(std::string filepath, bool isAverageMode=true) UtsusemiSqeCalc2::ConvertToD4Mat Convert and save data using format which D4MatSlicer can load.
=====================================================================================================================================================================================

    Args:
        filepath Path/to/file
        isAverageMode true: average calculation of intensity, false: summation

    Returns:
        -1 Something wrong
        0 No trouble 
";
%feature("docstring") UtsusemiSqeCalc2::Test "void UtsusemiSqeCalc2::Test() UtsusemiSqeCalc2::Test

";
%feature("docstring") UtsusemiSqeCalc2::QConvFromReciprocalToRealSpace "std::vector< Double > UtsusemiSqeCalc2::QConvFromReciprocalToRealSpace(std::vector< Double > Qvec, std::vector< Double > LC, std::vector< Double > Uv, std::vector< Double > Vv, std::vector< Double > RS, std::vector< Double > VA) UtsusemiSqeCalc2::QConvFromReciprocalToRealSpace Convert list of Qx,Qy,Qz in Qvec to real space using sample information.
===============================================================================================================================================================================================================================================================================================================================================================

    Args:
        Qvec list of Qx,Qy,Qz : Qx0,Qy0,Qz0,Qx1,Qy1,Qz1,Qx2,...,Qxn,Qyn,Qzn
        LC Latice constants
        Uv U std::vector
        Vv V std::vector
        RS Rotation info
        VA View axes info

    Returns:
        list of x,y,z in real space, its size is same as Qvec 

";
%feature("docstring") UtsusemiSqeCalc2::SetSlicedElementContainerArray "bool UtsusemiSqeCalc2::SetSlicedElementContainerArray(ElementContainerArray *_eca, std::string _bin_key=\"X\", std::string _xval_key=\"XVAL\", std::string _bin_unit=\"\", std::string _xval_unit=\"\", std::string _xrange_key=UTSUSEMI_KEY_HEAD_XRANGE) UtsusemiSqeCalc2::SetSlicedElementContainerArray

";
%feature("docstring") UtsusemiSqeCalc2::LoadXtalParam "bool UtsusemiSqeCalc2::LoadXtalParam(std::string file) UtsusemiSqeCalc2::LoadXtalParam

";
%feature("docstring") UtsusemiSqeCalc2::SaveXtalParam "bool UtsusemiSqeCalc2::SaveXtalParam(std::string file) UtsusemiSqeCalc2::SaveXtalParam

";
%feature("docstring") UtsusemiSqeCalc2::SetLatticeConstants "bool UtsusemiSqeCalc2::SetLatticeConstants(PyObject *LC) UtsusemiSqeCalc2::SetLatticeConstants

";
%feature("docstring") UtsusemiSqeCalc2::SetUVvector "bool UtsusemiSqeCalc2::SetUVvector(PyObject *UV, PyObject *VV) UtsusemiSqeCalc2::SetUVvector

";
%feature("docstring") UtsusemiSqeCalc2::SetUBMatrix "bool UtsusemiSqeCalc2::SetUBMatrix(PyObject *UBM) UtsusemiSqeCalc2::SetUBMatrix

";
%feature("docstring") UtsusemiSqeCalc2::SetRotationSteps "bool UtsusemiSqeCalc2::SetRotationSteps(std::string steps) UtsusemiSqeCalc2::SetRotationSteps

";
%feature("docstring") UtsusemiSqeCalc2::ConvToUBMatrix "std::vector< Double > UtsusemiSqeCalc2::ConvToUBMatrix(PyObject *LC, PyObject *UV, PyObject *VV, bool flagRound=true) UtsusemiSqeCalc2::ConvToUBMatrix

";
%feature("docstring") UtsusemiSqeCalc2::ConvToUVvector "std::vector< Double > UtsusemiSqeCalc2::ConvToUVvector(PyObject *LC, PyObject *UB, bool flagRound=true) UtsusemiSqeCalc2::ConvToUVvector

";
%feature("docstring") UtsusemiSqeCalc2::InverseMatrix "std::vector< Double > UtsusemiSqeCalc2::InverseMatrix(std::vector< Double > a) UtsusemiSqeCalc2::InverseMatrix

";
%feature("docstring") UtsusemiSqeCalc2::TEST_InverseMatrix "void UtsusemiSqeCalc2::TEST_InverseMatrix(std::vector< Double > a) UtsusemiSqeCalc2::TEST_InverseMatrix

";
%feature("docstring") UtsusemiSqeCalc2::SetDebugMode "void UtsusemiSqeCalc2::SetDebugMode(bool _isDebugMode=true) UtsusemiSqeCalc2::SetDebugMode

";
%feature("docstring") UtsusemiSqeCalc2::PutInnerMatrix "std::vector< Double > UtsusemiSqeCalc2::PutInnerMatrix(std::string M) UtsusemiSqeCalc2::PutInnerMatrix Puts the inner matrix for LatticeConst , U and V, Rotation, View axes and all.
======================================================================================================================================================================================
    argument std::string : \"L\" Matrix of a* b* c* \"U\" Matrix of U and V vectors \"R\" Matrix of rotation \"V\" Matrix of view axes \"A\" A = [V] [L] [U] [R]

    Args:
        M (std::string) \"L\",\"U\",\"R\",\"V\" and \"A\"

    Returns:
        std::vector of matrix. 

";
// File: classUtsusemiSqeCalcXtalParams.xml

%feature("docstring") UtsusemiSqeCalcXtalParams "C++ includes: UtsusemiSqeCalcXtalParams.hh 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::UtsusemiSqeCalcXtalParams "UtsusemiSqeCalcXtalParams::UtsusemiSqeCalcXtalParams(std::string filepath=\"\") UtsusemiSqeCalcXtalParams::UtsusemiSqeCalcXtalParams Constructor.
==================================================================================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::~UtsusemiSqeCalcXtalParams "UtsusemiSqeCalcXtalParams::~UtsusemiSqeCalcXtalParams() UtsusemiSqeCalcXtalParams::~UtsusemiSqeCalcXtalParams Destructor.
==========================================================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetLatticeConstants "bool UtsusemiSqeCalcXtalParams::SetLatticeConstants(Double a, Double b, Double c, Double alpha, Double beta, Double gamma) UtsusemiSqeCalcXtalParams::SetLatticeConstants Sets crystal lattice parameters.
===========================================================================================================================================================================================================
    This sets crystal lattice consts with individual

    Args:
        a (double) Lattice constants a
        b (double) Lattice constants a
        c (double) Lattice constants a
        alpha (double) Lattice constants alpha
        beta (double) Lattice constants beta
        gamma (double) Lattice constants gamma

    Returns:
        true no trouble
        false trouble happened. 

    
bool UtsusemiSqeCalcXtalParams::SetLatticeConstants(PyObject *LC) UtsusemiSqeCalcXtalParams::SetLatticeConstants Sets crystal lattice parameters.
==================================================================================================================================================
    This sets crystal lattice consts by python list object

    Args:
        LC (list of float) Lattice constants [, , ,<alpha>,<beta>,<gamma>]

    Returns:
        true    no trouble
        false    trouble happened. 
";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetUVvector "bool UtsusemiSqeCalcXtalParams::SetUVvector(Double ux, Double uy, Double uz, Double vx, Double vy, Double vz, bool isPriority=true) UtsusemiSqeCalcXtalParams::SetUVvector Sets crystal orientation.
=====================================================================================================================================================================================================

    Args:
        ux (double) U-vector Uh
        uy (double) U-vector Uk
        uz (double) U-vector Ul
        wx (double) V-vector Vh
        wy (double) V-vector Vk
        wz (double) V-vector Vl
        isPriority (bool) true: UV-vector is used to calculate projection instead of UBmatrix

    Returns:
        true no trouble
        false trouble happened. 

    
bool UtsusemiSqeCalcXtalParams::SetUVvector(PyObject *UV, PyObject *VV, bool isPriority=true) UtsusemiSqeCalcXtalParams::SetUVvector Sets crystal orientation.
===============================================================================================================================================================

    Args:
        UV (list of float) U-vector [<Uh>,<Uk>,
        VV (list of float) V-vector [<Vh>,<Vk>,<Vl>]
        isPriority (bool) true: UV-vector is used to calculate projection instead of UBmatrix

    Returns:
        true no trouble
        false trouble happened. 
";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetUBMatrix "bool UtsusemiSqeCalcXtalParams::SetUBMatrix(PyObject *UB, bool isPriority=true) UtsusemiSqeCalcXtalParams::SetUBMatrix Sets UB matrix.
=======================================================================================================================================

    Args:
        UB (list of float) U-vector [<UB11>,<UB12>,<UB13>,<UB21>,<UB22>,<UB23>,<UB31>,<UB32>,<UB33>,]
        isPriority (bool) true: UBmatrix is used to calculate projection instead of UV-vectors

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::AddRotationStep "bool UtsusemiSqeCalcXtalParams::AddRotationStep(std::string axis, double degree) UtsusemiSqeCalcXtalParams::AddRotationStep Sets Rotation angle.
=================================================================================================================================================

    Args:
        axis (std::string) \"Y\" or \"X\" or \"Z\"
        degree (double) angle [degree]

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetRotationSteps "bool UtsusemiSqeCalcXtalParams::SetRotationSteps(std::string steps) UtsusemiSqeCalcXtalParams::SetRotationSteps Sets Rotation angle.
=====================================================================================================================================

    Args:
        steps (std::string) format \"<Axis>:<degree>[,<Axis>:<degree>,...]\"

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetSampleInfoToData "bool UtsusemiSqeCalcXtalParams::SetSampleInfoToData(ElementContainerMatrix *ecm) UtsusemiSqeCalcXtalParams::SetSampleInfoToData Sets Sample information to header in ElementContainerMatrix.
=============================================================================================================================================================================================

    Args:
        ecm (ElementContainerMatrix)

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::ClearRotationStep "bool UtsusemiSqeCalcXtalParams::ClearRotationStep() UtsusemiSqeCalcXtalParams::ClearRotationStep Clears Rotation steps.
========================================================================================================================

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetProjectionAxis "bool UtsusemiSqeCalcXtalParams::SetProjectionAxis(std::string _id, double va, double vb, double vc, double ve, std::string title, std::string unit) UtsusemiSqeCalcXtalParams::SetProjectionAxis Sets Projection information for a axis.
=========================================================================================================================================================================================================================================

    Args:
        _id (std::string) id of Ax
        va (double) a* value of corrdinate axis for projection
        vb (double) b* value of corrdinate axis for projection
        vc (double) c* value of corrdinate axis for projection
        ve (double) Energy value of corrdinate axis for projection
        title (std::string) label of corrdinate axis
        unit (std::string) unit of corrdinate axis

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetProjectionAxes "bool UtsusemiSqeCalcXtalParams::SetProjectionAxes(PyObject *arg_ax1, PyObject *arg_ax2, PyObject *arg_ax3, PyObject *arg_ax4) UtsusemiSqeCalcXtalParams::SetProjectionAxes Sets Projection information for a axis.
===================================================================================================================================================================================================================
    Given list is like [1.0,0.0,0.0,0.0,\"Qh\",\"rlu\"]

    Args:
        arg_ax1 (list) [<a* value>,<b* value>,<c* value>,<energy value>,\"<label>\",\"<unit>\"]
        arg_ax2 (list) [<a* value>,<b* value>,<c* value>,<energy value>,\"<label>\",\"<unit>\"]
        arg_ax3 (list) [<a* value>,<b* value>,<c* value>,<energy value>,\"<label>\",\"<unit>\"]
        arg_ax4 (list) [<a* value>,<b* value>,<c* value>,<energy value>,\"<label>\",\"<unit>\"]

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetSliceAxis "bool UtsusemiSqeCalcXtalParams::SetSliceAxis(std::string _id, std::string _type, double _min, double _max, double _width, double _folding) UtsusemiSqeCalcXtalParams::SetSliceAxis Sets slicing information for a axis.
========================================================================================================================================================================================================================

    Args:
        _id (std::string) id of Ax
        _type (std::string) type of Ax : \"X\",\"Y\" or \"T\"
        _min (double) minimum value of Ax
        _max (double) maximum value of Ax
        _width (double) width value of Ax
        _folding (double) folding info of Ax

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetSliceAxes "bool UtsusemiSqeCalcXtalParams::SetSliceAxes(PyObject *Ax1, PyObject *Ax2, PyObject *Ax3, PyObject *Ax4, bool isForced=false) UtsusemiSqeCalcXtalParams::SetSliceAxes Sets slicing information.
================================================================================================================================================================================================
    \"X\" and \"Y\" axis : [\"X\",<min>,<max>,<width>] \"T\" axis : [\"T\",<min>,<max>]

    Args:
        Ax1 (list) List for Ax1
        Ax2 (list) List for Ax2
        Ax3 (list) List for Ax3
        Ax4 (list) List for Ax4
        isForced (bool) true: ignore the number of axis types (\"X\",\"Y\" and \"T\")

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetDiagFolding "bool UtsusemiSqeCalcXtalParams::SetDiagFolding(std::string _type, UInt4 ax1, UInt4 ax2) UtsusemiSqeCalcXtalParams::SetDiagFolding Sets folding information for a axix.
=======================================================================================================================================================================

    Args:
        type (std::string)
        ax1 (UInt4)
        ax2 (UInt4)

    Returns:
        true no trouble
        false trouble happened. 

    
bool UtsusemiSqeCalcXtalParams::SetDiagFolding(PyObject *Dfold) UtsusemiSqeCalcXtalParams::SetDiagFolding
";
%feature("docstring") UtsusemiSqeCalcXtalParams::LoadFile "bool UtsusemiSqeCalcXtalParams::LoadFile(std::string filepath, UInt4 flags=TOXML_ALL) UtsusemiSqeCalcXtalParams::LoadFile Loads XtalParams.
============================================================================================================================================

    Args:
        filepath (std::string) full path to XtalParam.xml
        flags (UInt4) information to read parameters pertially

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SaveFile "bool UtsusemiSqeCalcXtalParams::SaveFile(std::string filepath, UInt4 flags=TOXML_ALL) UtsusemiSqeCalcXtalParams::SaveFile Save XtalParams.
===========================================================================================================================================

    Args:
        filepath (std::string) full path to XtalParam.xml
        flags (UInt4) information to save parameters pertially

    Returns:
        true no trouble
        false trouble happened. 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::DecodeFromXml "bool UtsusemiSqeCalcXtalParams::DecodeFromXml(std::string conts, UInt4 flags) UtsusemiSqeCalcXtalParams::DecodeFromXml

";
%feature("docstring") UtsusemiSqeCalcXtalParams::EncodeToXml "bool UtsusemiSqeCalcXtalParams::EncodeToXml(UInt4 flags) UtsusemiSqeCalcXtalParams::EncodeToXml

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutXmlString "std::string UtsusemiSqeCalcXtalParams::PutXmlString(UInt4 flags=TOXML_ALL) UtsusemiSqeCalcXtalParams::PutXmlString Put XtalParams info as std::string.
=======================================================================================================================================================

    Args:
        flags (UInt4) information to save parameters pertially

    Returns:
        std::string XtalParam std::string 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::Dump "void UtsusemiSqeCalcXtalParams::Dump() UtsusemiSqeCalcXtalParams::Dump

";
%feature("docstring") UtsusemiSqeCalcXtalParams::SetExampleParams "void UtsusemiSqeCalcXtalParams::SetExampleParams() UtsusemiSqeCalcXtalParams::SetExampleParams

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutLatticeConsts "std::vector< Double > UtsusemiSqeCalcXtalParams::PutLatticeConsts() UtsusemiSqeCalcXtalParams::PutLatticeConsts

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutUVector "std::vector< Double > UtsusemiSqeCalcXtalParams::PutUVector() UtsusemiSqeCalcXtalParams::PutUVector

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutVVector "std::vector< Double > UtsusemiSqeCalcXtalParams::PutVVector() UtsusemiSqeCalcXtalParams::PutVVector

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutUBMatrix "std::vector< Double > UtsusemiSqeCalcXtalParams::PutUBMatrix() UtsusemiSqeCalcXtalParams::PutUBMatrix

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutPriorigy "bool UtsusemiSqeCalcXtalParams::PutPriorigy() UtsusemiSqeCalcXtalParams::PutPriorigy

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutRotateSteps "std::vector< Double > UtsusemiSqeCalcXtalParams::PutRotateSteps() UtsusemiSqeCalcXtalParams::PutRotateSteps

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutViewAxes "std::vector< Double > UtsusemiSqeCalcXtalParams::PutViewAxes() UtsusemiSqeCalcXtalParams::PutViewAxes

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutViewAxesLabels "std::vector< std::string > UtsusemiSqeCalcXtalParams::PutViewAxesLabels() UtsusemiSqeCalcXtalParams::PutViewAxesLabels

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutViewAxesUnits "std::vector< std::string > UtsusemiSqeCalcXtalParams::PutViewAxesUnits() UtsusemiSqeCalcXtalParams::PutViewAxesUnits

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutAxRange "std::vector< Double > UtsusemiSqeCalcXtalParams::PutAxRange(UInt4 ind, bool useAxTypeInfo=false) UtsusemiSqeCalcXtalParams::PutAxRange

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutAxType "std::vector< std::string > UtsusemiSqeCalcXtalParams::PutAxType() UtsusemiSqeCalcXtalParams::PutAxType

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutAxLabels "std::vector< std::string > UtsusemiSqeCalcXtalParams::PutAxLabels() UtsusemiSqeCalcXtalParams::PutAxLabels Returns axes labels for slicing.
============================================================================================================================================
    std::vector of 4 labels, [0]:Label for \"X\" axis, [1]:Label for \"Y\" axis, [2],[3]:labels for \"T\"

    Returns:
        std::vector<std::string> 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutAxUnits "std::vector< std::string > UtsusemiSqeCalcXtalParams::PutAxUnits() UtsusemiSqeCalcXtalParams::PutAxUnits Returns axes units for slicing.
=========================================================================================================================================
    std::vector of 4 units, [0]:unit for \"X\" axis, [1]:unit for \"Y\" axis, [2],[3]:units for \"T\"

    Returns:
        std::vector<std::string> 

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutFolding "std::vector< Double > UtsusemiSqeCalcXtalParams::PutFolding() UtsusemiSqeCalcXtalParams::PutFolding

";
%feature("docstring") UtsusemiSqeCalcXtalParams::PutDiagFolding "std::vector< UInt4 > UtsusemiSqeCalcXtalParams::PutDiagFolding() UtsusemiSqeCalcXtalParams::PutDiagFolding

";
// File: classUtsusemiSubtractDarkBackground.xml

%feature("docstring") UtsusemiSubtractDarkBackground "C++ includes: UtsusemiSubtractDarkBackground.hh 

";
%feature("docstring") UtsusemiSubtractDarkBackground::UtsusemiSubtractDarkBackground "UtsusemiSubtractDarkBackground::UtsusemiSubtractDarkBackground() UtsusemiSubtractDarkBackground::UtsusemiSubtractDarkBackground Constructor.
=============================================================================================================================================

    Returns:
        None 

";
%feature("docstring") UtsusemiSubtractDarkBackground::~UtsusemiSubtractDarkBackground "UtsusemiSubtractDarkBackground::~UtsusemiSubtractDarkBackground() UtsusemiSubtractDarkBackground::~UtsusemiSubtractDarkBackground Destructor. 

";
%feature("docstring") UtsusemiSubtractDarkBackground::Execute "bool UtsusemiSubtractDarkBackground::Execute(ElementContainerMatrix *sam, ElementContainerMatrix *bak) UtsusemiSubtractDarkBackground::Execute Executes subtraction.
=====================================================================================================================================================================
    bool Execute(ElementContainerMatrix *sam, ElementContainerMatrix *bak)

    Args:
        sam (ElementContainermatrix) Sample data
        bak (ElementContainermatrix) Background data
        normFact_ecm (Double) normalize factor for ecm
        normFact_bk (Double) normalize factor for bk

    Returns:
        true : succeeded
        false : failed 

";
// File: classUtsusemiTimeDependBackGround.xml

%feature("docstring") UtsusemiTimeDependBackGround "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiTimeDependBackGround::UtsusemiTimeDependBackGround "UtsusemiTimeDependBackGround::UtsusemiTimeDependBackGround() UtsusemiTimeDependBackGround::UtsusemiTimeDependBackGround

    
UtsusemiTimeDependBackGround::UtsusemiTimeDependBackGround(const UtsusemiTimeDependBackGround &obj) UtsusemiTimeDependBackGround::UtsusemiTimeDependBackGround
";
%feature("docstring") UtsusemiTimeDependBackGround::~UtsusemiTimeDependBackGround "UtsusemiTimeDependBackGround::~UtsusemiTimeDependBackGround() UtsusemiTimeDependBackGround::~UtsusemiTimeDependBackGround

";
// File: classUtsusemiTofBinInfo.xml

%feature("docstring") UtsusemiTofBinInfo "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiTofBinInfo::UtsusemiTofBinInfo "UtsusemiTofBinInfo::UtsusemiTofBinInfo() UtsusemiTofBinInfo::UtsusemiTofBinInfo Constructor. 

    
UtsusemiTofBinInfo::UtsusemiTofBinInfo(const UtsusemiTofBinInfo &obj) UtsusemiTofBinInfo::UtsusemiTofBinInfo Copy Constructor. 
";
%feature("docstring") UtsusemiTofBinInfo::~UtsusemiTofBinInfo "UtsusemiTofBinInfo::~UtsusemiTofBinInfo() UtsusemiTofBinInfo::~UtsusemiTofBinInfo Destructor. 

";
// File: classUtsusemiTofBinPattern.xml

%feature("docstring") UtsusemiTofBinPattern "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiTofBinPattern::UtsusemiTofBinPattern "UtsusemiTofBinPattern::UtsusemiTofBinPattern() UtsusemiTofBinPattern::UtsusemiTofBinPattern

    
UtsusemiTofBinPattern::UtsusemiTofBinPattern(const UtsusemiTofBinPattern &obj) UtsusemiTofBinPattern::UtsusemiTofBinPattern
";
%feature("docstring") UtsusemiTofBinPattern::~UtsusemiTofBinPattern "UtsusemiTofBinPattern::~UtsusemiTofBinPattern() UtsusemiTofBinPattern::~UtsusemiTofBinPattern

";
// File: classUtsusemiTofMaskPattern.xml

%feature("docstring") UtsusemiTofMaskPattern "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") UtsusemiTofMaskPattern::UtsusemiTofMaskPattern "UtsusemiTofMaskPattern::UtsusemiTofMaskPattern() UtsusemiTofMaskPattern::UtsusemiTofMaskPattern

    
UtsusemiTofMaskPattern::UtsusemiTofMaskPattern(const UtsusemiTofMaskPattern &obj) UtsusemiTofMaskPattern::UtsusemiTofMaskPattern
";
%feature("docstring") UtsusemiTofMaskPattern::~UtsusemiTofMaskPattern "UtsusemiTofMaskPattern::~UtsusemiTofMaskPattern() UtsusemiTofMaskPattern::~UtsusemiTofMaskPattern

";
// File: classUtsusemiTofOriginCorrection.xml

%feature("docstring") UtsusemiTofOriginCorrection "

    Calculation of TOF origin Correction.
    C++ includes: UtsusemiTofOriginCorrection.hh 

";
%feature("docstring") UtsusemiTofOriginCorrection::UtsusemiTofOriginCorrection "UtsusemiTofOriginCorrection::UtsusemiTofOriginCorrection() UtsusemiTofOriginCorrection::UtsusemiTofOriginCorrection Constructor. 

";
%feature("docstring") UtsusemiTofOriginCorrection::~UtsusemiTofOriginCorrection "UtsusemiTofOriginCorrection::~UtsusemiTofOriginCorrection() UtsusemiTofOriginCorrection::~UtsusemiTofOriginCorrection Destructor. 

";
%feature("docstring") UtsusemiTofOriginCorrection::SetTofOriginCorrectionType "bool UtsusemiTofOriginCorrection::SetTofOriginCorrectionType(UInt4 cType) UtsusemiTofOriginCorrection::SetTofOriginCorrectionType

    
bool UtsusemiTofOriginCorrection::SetTofOriginCorrectionType(UInt4 cType, std::vector< Double > params) UtsusemiTofOriginCorrection::SetTofOriginCorrectionType Sets type of Tof Origin Correction Function.
=============================================================================================================================================================================================================

    Args:
        type (UInt4) type number for a type of direct conversion

    Returns:
        true
        fales 
";
%feature("docstring") UtsusemiTofOriginCorrection::TofOriginShiftByLambda "Double UtsusemiTofOriginCorrection::TofOriginShiftByLambda(Double lambda) UtsusemiTofOriginCorrection::TofOriginShiftByLambda

    
std::vector< Double > UtsusemiTofOriginCorrection::TofOriginShiftByLambda(std::vector< Double > vlambda) UtsusemiTofOriginCorrection::TofOriginShiftByLambda
";
%feature("docstring") UtsusemiTofOriginCorrection::SetDiscreteData "bool UtsusemiTofOriginCorrection::SetDiscreteData(std::vector< Double > lambda_list, std::vector< Double > tofshift_list) UtsusemiTofOriginCorrection::SetDiscreteData

";
%feature("docstring") UtsusemiTofOriginCorrection::PutNumOfParam "UInt4 UtsusemiTofOriginCorrection::PutNumOfParam() UtsusemiTofOriginCorrection::PutNumOfParam

";
// File: classUtsusemiTrignetCondGroup.xml

%feature("docstring") UtsusemiTrignetCondGroup "

    Group of Conditions for TrigNet.
    This stores several conditions for TrigNET.
    C++ includes: UtsusemiTrignetDictionary.hh 

";
%feature("docstring") UtsusemiTrignetCondGroup::UtsusemiTrignetCondGroup "UtsusemiTrignetCondGroup::UtsusemiTrignetCondGroup() UtsusemiTrignetCondGroup::UtsusemiTrignetCondGroup Constructor. 

    
UtsusemiTrignetCondGroup::UtsusemiTrignetCondGroup(const UtsusemiTrignetCondGroup &obj) UtsusemiTrignetCondGroup::UtsusemiTrignetCondGroup Copy Constructor. 
";
%feature("docstring") UtsusemiTrignetCondGroup::~UtsusemiTrignetCondGroup "UtsusemiTrignetCondGroup::~UtsusemiTrignetCondGroup() UtsusemiTrignetCondGroup::~UtsusemiTrignetCondGroup Destructor. 

";
%feature("docstring") UtsusemiTrignetCondGroup::AppendTofRangeCond "void UtsusemiTrignetCondGroup::AppendTofRangeCond(std::pair< Double, Double > tofrange) UtsusemiTrignetCondGroup::AppendTofRangeCond Appends TOF range condition.
==================================================================================================================================================================

    Args:
        tofrange (std::pair<Double,Double>) start tof and end tof

    Returns:
        None 

";
%feature("docstring") UtsusemiTrignetCondGroup::AppendTimeRangeCond "void UtsusemiTrignetCondGroup::AppendTimeRangeCond(std::string type, std::vector< Double > timerange) UtsusemiTrignetCondGroup::AppendTimeRangeCond Appends Time range condition.
==================================================================================================================================================================================
    type=\"PASS\" : start time is zero, end time is passed time type=\"MLF\" : start time and end time are given MLF clock type=\"DATE\" : start time and end time are given DATE format \"YYYY\",\"MM\",\"DD\",\"hh\",\"mm\",\"ss\",\"sub-sec\"

    Args:
        type (std::string)
        tofrange (std::vector<Double>) start tof and end tof

    Returns:
        None 

";
%feature("docstring") UtsusemiTrignetCondGroup::AppendTrigCond "void UtsusemiTrignetCondGroup::AppendTrigCond(UtsusemiTrignetCondition trigcond) UtsusemiTrignetCondGroup::AppendTrigCond Appends TrigNET condition.
=====================================================================================================================================================

    Args:
        trigcond ( UtsusemiTrignetCondition)

    Returns:
        None 

";
%feature("docstring") UtsusemiTrignetCondGroup::TrigFilter "Int4 UtsusemiTrignetCondGroup::TrigFilter(UInt4 index, UInt4 trig, UInt4 type, const std::vector< UInt4 > *cond) UtsusemiTrignetCondGroup::TrigFilter Checks TrigNET parameters are sutiffied condition(s)
===========================================================================================================================================================================================================

    Args:
        index (UInt4)
        trig (UInt4)
        type (UInt4)
        cond (const std::vector<UInt4>*)

    Returns:
        1 satisfied condition
        -1 not satisfied
        0 ignored 

";
%feature("docstring") UtsusemiTrignetCondGroup::TimeFilter "Int4 UtsusemiTrignetCondGroup::TimeFilter(Double time_in, Double first_clock) UtsusemiTrignetCondGroup::TimeFilter Checks Time parameters are sutiffied condition(s)
=====================================================================================================================================================================

    Args:
        time_in (Double) target clock [MLF clock]
        first_clock (Double) first clock of the measurement [MLF clock]

    Returns:
        1 satisfied condition
        -1 not satisfied
        0 ignored 

";
%feature("docstring") UtsusemiTrignetCondGroup::TofFilter "Int4 UtsusemiTrignetCondGroup::TofFilter(Double tof_in) UtsusemiTrignetCondGroup::TofFilter Checks Tof parameters are sutiffied condition(s)
=============================================================================================================================================

    Args:
        time_in (Double) clock [MLF clock]

    Returns:
        1 satisfied condition
        -1 not satisfied
        0 ignored 

";
%feature("docstring") UtsusemiTrignetCondGroup::MakeCondArrayAndList "void UtsusemiTrignetCondGroup::MakeCondArrayAndList() UtsusemiTrignetCondGroup::MakeCondArrayAndList Makes list of TrigNET indexes under AND condition.
========================================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") UtsusemiTrignetCondGroup::Dump "void UtsusemiTrignetCondGroup::Dump() UtsusemiTrignetCondGroup::Dump

";
// File: classUtsusemiTrignetCondition.xml

%feature("docstring") UtsusemiTrignetCondition "

    TrigNET filter Condition.
    This stores one filter condition for TrigNET.
    C++ includes: UtsusemiTrignetDictionary.hh 

";
%feature("docstring") UtsusemiTrignetCondition::UtsusemiTrignetCondition "UtsusemiTrignetCondition::UtsusemiTrignetCondition() UtsusemiTrignetCondition::UtsusemiTrignetCondition Constructor. 

    
UtsusemiTrignetCondition::UtsusemiTrignetCondition(const UtsusemiTrignetCondition &obj) UtsusemiTrignetCondition::UtsusemiTrignetCondition Copy Constructor. 
";
%feature("docstring") UtsusemiTrignetCondition::~UtsusemiTrignetCondition "UtsusemiTrignetCondition::~UtsusemiTrignetCondition() UtsusemiTrignetCondition::~UtsusemiTrignetCondition Destructor. 

";
%feature("docstring") UtsusemiTrignetCondition::SetIndex "Int4 UtsusemiTrignetCondition::SetIndex(Int4 ind) UtsusemiTrignetCondition::SetIndex Sets Index.
=================================================================================================

    Args:
        ind (Int4)

    Returns:
        -1 given ind is invalid
        0 

";
%feature("docstring") UtsusemiTrignetCondition::SetTrig "Int4 UtsusemiTrignetCondition::SetTrig(std::string trig) UtsusemiTrignetCondition::SetTrig Sets trigger.
=========================================================================================================

    Args:
        trig (std::string)

    Returns:
        -1 given trig is invalid
        0 

";
%feature("docstring") UtsusemiTrignetCondition::SetType "Int4 UtsusemiTrignetCondition::SetType(std::string type) UtsusemiTrignetCondition::SetType Sets type.
======================================================================================================

    Args:
        type (std::string)

    Returns:
        -1 given argument is invalid
        0 

";
%feature("docstring") UtsusemiTrignetCondition::SetTitle "Int4 UtsusemiTrignetCondition::SetTitle(std::string title) UtsusemiTrignetCondition::SetTitle Sets title.
==========================================================================================================

    Args:
        title (std::string)

    Returns:
        0 

";
%feature("docstring") UtsusemiTrignetCondition::SetAttr "Int4 UtsusemiTrignetCondition::SetAttr(std::string attr) UtsusemiTrignetCondition::SetAttr Sets attribute.
===========================================================================================================

    Args:
        attr (std::string)

    Returns:
        0 

";
%feature("docstring") UtsusemiTrignetCondition::SetCont "Int4 UtsusemiTrignetCondition::SetCont(std::vector< UInt4 > cont) UtsusemiTrignetCondition::SetCont Sets contents.
===================================================================================================================

    Args:
        cont (std::vector<std::string>)

    Returns:
        -1 if Trigger/Type is not set
        0 

";
%feature("docstring") UtsusemiTrignetCondition::SetAnd "Int4 UtsusemiTrignetCondition::SetAnd(bool is_and) UtsusemiTrignetCondition::SetAnd Sets AND condition.
========================================================================================================

    Args:
        is_and (bool)

    Returns:
        0 

";
%feature("docstring") UtsusemiTrignetCondition::Check "Int4 UtsusemiTrignetCondition::Check(UInt4 index, UInt4 trig, UInt4 type, const std::vector< UInt4 > *cond, std::string title=\"\") UtsusemiTrignetCondition::Check Checks parameters sutisfies given conditions.
==================================================================================================================================================================================================================

    Args:
        index (UInt4)
        trig (UInt4)
        type (UInt4)
        cond (const std::vector<UInt4>*)
        title (std::string)

    Returns:
        1 satisfied condition
        -1 not satisfied
        0 ignored 

";
%feature("docstring") UtsusemiTrignetCondition::Dump "void UtsusemiTrignetCondition::Dump() UtsusemiTrignetCondition::Dump Shows all conditions.
===========================================================================================

    Args:
        None

    Returns:
        None 

";
// File: classUtsusemiTrignetCounter.xml

%feature("docstring") UtsusemiTrignetCounter "

    TrigNET counter Conditions.
    This stores TrigNET counter conditions.
    type : 0=Encoder ABphase, 1=1DIO, 2=2DIOs ABphases : < DIO Number of A phase, that of B phase >
    Val = OrgVal + ConvVal*(Counts) [Unit] ConditionType : 1: condition range with two values for each case 2: start, end ,step [ caseId = int(( end-start )/step ) ]
    C++ includes: UtsusemiTrignetDictionary.hh 

";
%feature("docstring") UtsusemiTrignetCounter::UtsusemiTrignetCounter "UtsusemiTrignetCounter::UtsusemiTrignetCounter() UtsusemiTrignetCounter::UtsusemiTrignetCounter Constructor. 

    
UtsusemiTrignetCounter::UtsusemiTrignetCounter(const UtsusemiTrignetCounter &obj) UtsusemiTrignetCounter::UtsusemiTrignetCounter Copy Constructor. 
";
%feature("docstring") UtsusemiTrignetCounter::~UtsusemiTrignetCounter "UtsusemiTrignetCounter::~UtsusemiTrignetCounter() UtsusemiTrignetCounter::~UtsusemiTrignetCounter Destructor. 

";
%feature("docstring") UtsusemiTrignetCounter::SetType "Int4 UtsusemiTrignetCounter::SetType(std::string type) UtsusemiTrignetCounter::SetType Sets type of condition format.
======================================================================================================================

    Args:
        type (std::string)

    Returns:
        condition type 

";
%feature("docstring") UtsusemiTrignetCounter::AddAsABphase "Int4 UtsusemiTrignetCounter::AddAsABphase(UtsusemiTrignetCondition trig) UtsusemiTrignetCounter::AddAsABphase Sets AB-phases triggers by by UtsusemiTrignetCondition.
======================================================================================================================================================================
    Using attribute of UtsusemiTrignetCondition, A or B is set.

    Args:
        trig ( UtsusemiTrignetCondition) trigger event

    Returns:
        -1 invalid trigger event @rerval 0 OK 

";
%feature("docstring") UtsusemiTrignetCounter::AddTriggers "Int4 UtsusemiTrignetCounter::AddTriggers(UtsusemiTrignetCondition trig) UtsusemiTrignetCounter::AddTriggers Adds Trigger condition as a trigger for the counter.
=================================================================================================================================================================

    Args:
        trig ( UtsusemiTrignetCondition)

    Returns:
        condition type 

";
%feature("docstring") UtsusemiTrignetCounter::SetConvVal "Int4 UtsusemiTrignetCounter::SetConvVal(std::string convval) UtsusemiTrignetCounter::SetConvVal Sets ConvVal.
==============================================================================================================

    Args:
        ConvVal (std::string)

    Returns:
        0 

";
%feature("docstring") UtsusemiTrignetCounter::SetOrgVal "Int4 UtsusemiTrignetCounter::SetOrgVal(std::string orgval, std::string unit_in) UtsusemiTrignetCounter::SetOrgVal Sets OrgVal.
===============================================================================================================================

    Args:
        OrgVal (std::string)
        unit_in (std::string) unit of OrgVal

    Returns:
        0 

";
%feature("docstring") UtsusemiTrignetCounter::SetVirtualKickerPriority "Int4 UtsusemiTrignetCounter::SetVirtualKickerPriority(std::string val) UtsusemiTrignetCounter::SetVirtualKickerPriority Sets which has the priority on choosing case ID for virtual kicker mode.
=================================================================================================================================================================================================

    Args:
        val (std::string) \"case\" or \"signal\"

    Returns:
        0 

";
%feature("docstring") UtsusemiTrignetCounter::SetConditionType "Int4 UtsusemiTrignetCounter::SetConditionType(std::string val) UtsusemiTrignetCounter::SetConditionType Sets type of condition.
================================================================================================================================

    Args:
        val (std::string)

    Returns:
        ConditionType 

";
%feature("docstring") UtsusemiTrignetCounter::SetConditionList "Int4 UtsusemiTrignetCounter::SetConditionList(UInt4 caseId, std::string conts) UtsusemiTrignetCounter::SetConditionList Sets contents of condition.
====================================================================================================================================================

    Args:
        caseId (UInt4)
        conts (std::string)

    Returns:
        -1 ConditionType is invalid
        0 OK 

";
%feature("docstring") UtsusemiTrignetCounter::SetCyclicRegion "Int4 UtsusemiTrignetCounter::SetCyclicRegion(std::string begin, std::string end) UtsusemiTrignetCounter::SetCyclicRegion

";
%feature("docstring") UtsusemiTrignetCounter::SetClock "UInt4 UtsusemiTrignetCounter::SetClock(Double clock) UtsusemiTrignetCounter::SetClock Sets clock for cyclic time slicing with trignet signal used as start point for time slicing.
===================================================================================================================================================================================
    This returns the caseId calculated from given clock

    Args:
        clock (Double)

    Returns:
        0 to (UTSUSEMIMASKVALUEUINT4-1) :Decided CaseId (last caseId)
        UTSUSEMIMASKVALUEUINT4 :This condition should be ignored. 

";
%feature("docstring") UtsusemiTrignetCounter::CountEvent "UInt4 UtsusemiTrignetCounter::CountEvent(UInt4 index, UInt4 trig, UInt4 type, const std::vector< UInt4 > *cond, double clock=0.0) UtsusemiTrignetCounter::CountEvent

    
UInt4 UtsusemiTrignetCounter::CountEvent(std::vector< UInt4 > index, std::vector< UInt4 > trig, std::vector< UInt4 > type, const std::vector< std::vector< UInt4 > * > &cond) UtsusemiTrignetCounter::CountEvent Sets parameters decoded from TrigNET event(s) to count up.
============================================================================================================================================================================================================================================================================
    This returns the caseId calculated from given conditions

    Args:
        index (UInt4 or std::vector<UInt4>)
        trig (UInt4 or std::vector<UInt4>)
        type (UInt4 or std::vector<UInt4>)
        cond (std::vector<UInt4>* or std::vector< std::vector<UInt4> >)
        clock (Double)

    Returns:
        0 to (UTSUSEMIMASKVALUEUINT4-1) :Decided CaseId (last caseId)
        UTSUSEMIMASKVALUEUINT4 :This condition should be ignored. 
";
%feature("docstring") UtsusemiTrignetCounter::Dump "void UtsusemiTrignetCounter::Dump() UtsusemiTrignetCounter::Dump Shows counter conditions.
===========================================================================================

    Args:
        None

    Returns:
        None 

";
// File: classUtsusemiTrignetDictionary.xml

%feature("docstring") UtsusemiTrignetDictionary "

    Dictionary for TrigNet and Make Case Table.
    C++ includes: UtsusemiTrignetDictionary.hh 

";
%feature("docstring") UtsusemiTrignetDictionary::UtsusemiTrignetDictionary "UtsusemiTrignetDictionary::UtsusemiTrignetDictionary() UtsusemiTrignetDictionary::UtsusemiTrignetDictionary Constructor. 

";
%feature("docstring") UtsusemiTrignetDictionary::~UtsusemiTrignetDictionary "UtsusemiTrignetDictionary::~UtsusemiTrignetDictionary() UtsusemiTrignetDictionary::~UtsusemiTrignetDictionary Destructor. 

";
%feature("docstring") UtsusemiTrignetDictionary::PutTrigString "std::string UtsusemiTrignetDictionary::PutTrigString(UInt4 sid1) UtsusemiTrignetDictionary::PutTrigString Puts charactors code defined for SID1 in TrigDic.
============================================================================================================================================================

    Args:
        sid1 (UInt4) SID1 number @retrun code (std::string) 

";
%feature("docstring") UtsusemiTrignetDictionary::PutTypeString "std::string UtsusemiTrignetDictionary::PutTypeString(UInt4 sid2) UtsusemiTrignetDictionary::PutTypeString Puts charactors code defined for Type in TypeDic.
============================================================================================================================================================
    This Type is used to analyze last 3 bites in TrinNET event

    Args:
        sid2 (UInt4) SID2 number @retrun code (std::string) 

";
%feature("docstring") UtsusemiTrignetDictionary::PutTrigIndex "Int4 UtsusemiTrignetDictionary::PutTrigIndex(std::string trig) UtsusemiTrignetDictionary::PutTrigIndex Puts index number defined for trig code in TrigDic.
===========================================================================================================================================================

    Args:
        trig (std::string) trigger code

    Returns:
        >=0 index number
        -1 invalid trigger code 

";
%feature("docstring") UtsusemiTrignetDictionary::PutTypeIndex "Int4 UtsusemiTrignetDictionary::PutTypeIndex(std::string type) UtsusemiTrignetDictionary::PutTypeIndex Puts index number defined for type code in TypeDic.
===========================================================================================================================================================

    Args:
        type (std::string) type code

    Returns:
        >=0 index number
        -1 invalid trigger code 

";
// File: classUtsusemiTrignetEventDecoderBase.xml

%feature("docstring") UtsusemiTrignetEventDecoderBase "

    Decode Event Data of TrigNet and Store their information.
    C++ includes: UtsusemiTrignetEventDecoderBase.hh 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::UtsusemiTrignetEventDecoderBase "UtsusemiTrignetEventDecoderBase::UtsusemiTrignetEventDecoderBase() UtsusemiTrignetEventDecoderBase::UtsusemiTrignetEventDecoderBase Constructor. 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::~UtsusemiTrignetEventDecoderBase "UtsusemiTrignetEventDecoderBase::~UtsusemiTrignetEventDecoderBase() UtsusemiTrignetEventDecoderBase::~UtsusemiTrignetEventDecoderBase Destructor. 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::_decodePulseIdEvent "UInt8 UtsusemiTrignetEventDecoderBase::_decodePulseIdEvent(UChar buf[]) UtsusemiTrignetEventDecoderBase::_decodePulseIdEvent

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::decodePulseIdEvent "UInt8 UtsusemiTrignetEventDecoderBase::decodePulseIdEvent(const UChar *buf) UtsusemiTrignetEventDecoderBase::decodePulseIdEvent Decods PulseId Event in TrigNET event.
=======================================================================================================================================================================

    Args:
        buf (UChar []) TrigNET event

    Returns:
        PulseId (UInt8) 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::_decodeInstClockEvent "Double UtsusemiTrignetEventDecoderBase::_decodeInstClockEvent(UChar buf[]) UtsusemiTrignetEventDecoderBase::_decodeInstClockEvent

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::decodeInstClockEvent "Double UtsusemiTrignetEventDecoderBase::decodeInstClockEvent(const UChar *buf) UtsusemiTrignetEventDecoderBase::decodeInstClockEvent Decods InstClock Event in TrigNET event.
==============================================================================================================================================================================

    Args:
        buf (UChar []) TrigNET event

    Returns:
        clock (double) 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::isHeaderT0 "bool UtsusemiTrignetEventDecoderBase::isHeaderT0(UChar aByte) UtsusemiTrignetEventDecoderBase::isHeaderT0 Checks whether given UChar is the header of T0 event.
================================================================================================================================================================

    Args:
        aByte (UChar)

    Returns:
        true
        false 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::isHeaderClock "bool UtsusemiTrignetEventDecoderBase::isHeaderClock(UChar aByte) UtsusemiTrignetEventDecoderBase::isHeaderClock Checks whether given UChar is the header of Instrument Clock event.
====================================================================================================================================================================================

    Args:
        aByte (UChar)

    Returns:
        true
        false 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::isTrigEvent "bool UtsusemiTrignetEventDecoderBase::isTrigEvent(UChar buf) UtsusemiTrignetEventDecoderBase::isTrigEvent Checks whether given UChar is the header of TrigNET event.
=====================================================================================================================================================================

    Args:
        buf (UChar)

    Returns:
        true
        false 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::DecodeTrigEvent "Int4 UtsusemiTrignetEventDecoderBase::DecodeTrigEvent(const UChar *data, std::vector< UInt4 > *values, UInt4 index=0) UtsusemiTrignetEventDecoderBase::DecodeTrigEvent Decodes an Event of TrigNET.
====================================================================================================================================================================================================
    Returned values: values[0] = tof [clock(25nano-sec)] values[1] = index values[2] = SID1 (trigger) values[3] = SID2 (type) values[4-11] = contents depends on SID2

    Args:
        data (UChar*) an event with 8bytes
        values (std::vector<UInt4>*) values decoded from an event
        index (UInt4) index of TrigNETs

    Returns:
        -1 given event is not for TrigNET or other errors
        -2 size of given values vector is invalid
        0 successfull 

";
%feature("docstring") UtsusemiTrignetEventDecoderBase::DumpTrigEvent "std::vector< std::string > UtsusemiTrignetEventDecoderBase::DumpTrigEvent(std::vector< UInt4 > evt, bool debug=true) UtsusemiTrignetEventDecoderBase::DumpTrigEvent Dumps decoded TrigNET event given as std::vector<UInt4>
============================================================================================================================================================================================================================

    Args:
        evt (std::vector<UInt4>) TrigNET event
        debug (bool) true if debug mode is on

    Returns:
        decoded event 

";
// File: classUtsusemiUnitConverter.xml

%feature("docstring") UtsusemiUnitConverter "

    Function for offering some constant values and converting units.
    Unit Conversion e=1.602187653e-19 [J]->1meV=1.602187653e-22[J] [J]=[kg(m/2)^2] mn=1.67495e-27 [kg] Basical Units length [meter] time [micro-second] Energy [milli-electron-volt] verocity [meter/micro-second] Wave length [Ang] Wave std::vector [1/Ang]
    C++ includes: UtsusemiUnitConverter.hh 

";
%feature("docstring") UtsusemiUnitConverter::UtsusemiUnitConverter "UtsusemiUnitConverter::UtsusemiUnitConverter() UtsusemiUnitConverter::UtsusemiUnitConverter Constructor.
=========================================================================================================
    used before 0.3.3.0
    Use MlfPhyisicalConstants (0.3.3.1) 

";
%feature("docstring") UtsusemiUnitConverter::~UtsusemiUnitConverter "UtsusemiUnitConverter::~UtsusemiUnitConverter() UtsusemiUnitConverter::~UtsusemiUnitConverter Destructor. 

";
%feature("docstring") UtsusemiUnitConverter::LEtoT "double UtsusemiUnitConverter::LEtoT() UtsusemiUnitConverter::LEtoT Puts conversion parameter from L[m], E[meV] to TOF[micro-sec].
==================================================================================================================================

    Returns:
        cLEtoT 

    
double UtsusemiUnitConverter::LEtoT(double L, double E) UtsusemiUnitConverter::LEtoT Puts Tof[micro-sec] converted from given L[m] and E[meV].
===============================================================================================================================================

    Args:
        L flight path length [meter]
        E energy [meV]

    Returns:
        TOF [micro-sec] 
";
%feature("docstring") UtsusemiUnitConverter::VtoE "double UtsusemiUnitConverter::VtoE() UtsusemiUnitConverter::VtoE Puts conversion parameter from V[meter/micro-sec] to E[meV].
==============================================================================================================================

    Returns:
        cVtoE 

    
double UtsusemiUnitConverter::VtoE(double V) UtsusemiUnitConverter::VtoE Puts Energy[meV] converted from given verocity[meter/micro-sec].
==========================================================================================================================================

    Args:
        V verocity of neutron [meter/micro-sec]

    Returns:
        energy [meV] 
";
%feature("docstring") UtsusemiUnitConverter::VtoK "double UtsusemiUnitConverter::VtoK(double V) UtsusemiUnitConverter::VtoK Puts wave std::vector converted from given verocity.
==============================================================================================================================

    Args:
        V verocity of neutron [m/s]

    Returns:
        wave std::vector [(1/Ang)] 

";
%feature("docstring") UtsusemiUnitConverter::Vmm_msToK "double UtsusemiUnitConverter::Vmm_msToK() UtsusemiUnitConverter::Vmm_msToK Puts wave std::vector converted from given verocity.
================================================================================================================================

    Args:
        V verocity of neutron [mm/micro-sec]

    Returns:
        constant to convert from V[mm/micro-sec] to K [(1/Ang)] 

    
double UtsusemiUnitConverter::Vmm_msToK(double V) UtsusemiUnitConverter::Vmm_msToK Puts wave std::vector converted from given verocity.
========================================================================================================================================

    Args:
        V verocity of neutron [mm/micro-sec]

    Returns:
        wave std::vector [(1/Ang)] 
";
%feature("docstring") UtsusemiUnitConverter::EtoV "double UtsusemiUnitConverter::EtoV() UtsusemiUnitConverter::EtoV Puts conversion parameter from E[meV] to V[meter/micro-sec].
==============================================================================================================================

    Returns:
        cEtoV 

    
double UtsusemiUnitConverter::EtoV(double E) UtsusemiUnitConverter::EtoV Puts verocity[meter/micro-sec] converted from given energy of neutron [meV].
======================================================================================================================================================

    Args:
        E energy of neutron [meV]

    Returns:
        verocity [meter/micro-sec] 
";
%feature("docstring") UtsusemiUnitConverter::Mn "double UtsusemiUnitConverter::Mn() UtsusemiUnitConverter::Mn Puts constant value about mass of a neutron [kg].
===============================================================================================================

    Returns:
        mass of neutron [kg] 

";
%feature("docstring") UtsusemiUnitConverter::KtoE "double UtsusemiUnitConverter::KtoE(double K) UtsusemiUnitConverter::KtoE Puts Energy[meV] converted from given wave std::vector [1/Ang].
=========================================================================================================================================

    Args:
        K wave std::vector length [1/Ang]

    Returns:
        energy [meV] 

";
%feature("docstring") UtsusemiUnitConverter::K2toE "double UtsusemiUnitConverter::K2toE() UtsusemiUnitConverter::K2toE Puts conversion parameter from sqare( K[1/Ang] ) to Energy [meV].
=====================================================================================================================================

    Returns:
        cK2toE 

";
%feature("docstring") UtsusemiUnitConverter::EtoK2 "double UtsusemiUnitConverter::EtoK2(double E) UtsusemiUnitConverter::EtoK2 Puts square of wave std::vector[1/Ang] converted from given energy[meV].
====================================================================================================================================================

    Args:
        E energy of neutron [meV]

    Returns:
        square of wave std::vector [1/Ang] 

";
%feature("docstring") UtsusemiUnitConverter::J2meV "double UtsusemiUnitConverter::J2meV() UtsusemiUnitConverter::J2meV Puts unit conversion parameter from Joule to meV.
=====================================================================================================================

    Returns:
        cnvJ2E 

";
%feature("docstring") UtsusemiUnitConverter::TLtoLambda "double UtsusemiUnitConverter::TLtoLambda(double _tof, double _L) UtsusemiUnitConverter::TLtoLambda Puts lambda [Angs.] from TOF[micro-sec] and L1+L2[m].
=========================================================================================================================================================

    Args:
        _tof time of flight [micro-sec]
        _L length between modelator and detector [m]

    Returns:
        lambda (double) 

";
%feature("docstring") UtsusemiUnitConverter::VtoLambda "double UtsusemiUnitConverter::VtoLambda() UtsusemiUnitConverter::VtoLambda Puts conversion parameter from 1/v[meter/micro-sec] to lambda [Angs.].
==================================================================================================================================================

    Returns:
        ccVtoLambda 

    
double UtsusemiUnitConverter::VtoLambda(double V) UtsusemiUnitConverter::VtoLambda Puts lambda [Ang] from v[meter/micro-sec].
==============================================================================================================================

    Args:
        V (double) verosity [meter/micro-sec]

    Returns:
        lambda (double) 
";
%feature("docstring") UtsusemiUnitConverter::EtoLambda "double UtsusemiUnitConverter::EtoLambda(double E) UtsusemiUnitConverter::EtoLambda Puts lambda [Ang] from E[meV].
==================================================================================================================

    Args:
        E (double) energy [meV]

    Returns:
        lambda (double) 

";
%feature("docstring") UtsusemiUnitConverter::KtoLambda "double UtsusemiUnitConverter::KtoLambda(double K) UtsusemiUnitConverter::KtoLambda Puts lambda [Ang] from K[1/Ang].
====================================================================================================================

    Args:
        K (double) wave number [1/Ang]

    Returns:
        lambda (double) 

";
%feature("docstring") UtsusemiUnitConverter::LambdatoE "double UtsusemiUnitConverter::LambdatoE(double Lam) UtsusemiUnitConverter::LambdatoE Puts E [meV] from lambda [Ang].
=====================================================================================================================

    Args:
        Lam (double) wavelength [Ang]

    Returns:
        energy (double) 

";
// File: classUtsusemiWiringInfoEditorBase.xml

%feature("docstring") UtsusemiWiringInfoEditorBase "C++ includes: UtsusemiWiringInfoEditorBase.hh 

";
%feature("docstring") UtsusemiWiringInfoEditorBase::UtsusemiWiringInfoEditorBase "UtsusemiWiringInfoEditorBase::UtsusemiWiringInfoEditorBase() UtsusemiWiringInfoEditorBase::UtsusemiWiringInfoEditorBase Constructor. 

";
%feature("docstring") UtsusemiWiringInfoEditorBase::~UtsusemiWiringInfoEditorBase "UtsusemiWiringInfoEditorBase::~UtsusemiWiringInfoEditorBase() UtsusemiWiringInfoEditorBase::~UtsusemiWiringInfoEditorBase Destructor. 

";
// File: classUtsusemiWiringInfoEditorNeunet.xml

%feature("docstring") UtsusemiWiringInfoEditorNeunet "C++ includes: UtsusemiWiringInfoEditorNeunet.hh 

";
%feature("docstring") UtsusemiWiringInfoEditorNeunet::UtsusemiWiringInfoEditorNeunet "UtsusemiWiringInfoEditorNeunet::UtsusemiWiringInfoEditorNeunet() UtsusemiWiringInfoEditorNeunet::UtsusemiWiringInfoEditorNeunet Constructor. 

";
%feature("docstring") UtsusemiWiringInfoEditorNeunet::~UtsusemiWiringInfoEditorNeunet "UtsusemiWiringInfoEditorNeunet::~UtsusemiWiringInfoEditorNeunet() UtsusemiWiringInfoEditorNeunet::~UtsusemiWiringInfoEditorNeunet Destructor. 

";
%feature("docstring") UtsusemiWiringInfoEditorNeunet::SetDetParam "bool UtsusemiWiringInfoEditorNeunet::SetDetParam(std::string params=\"psd\") UtsusemiWiringInfoEditorNeunet::SetDetParam sets detector parameter to use for histogram creations
================================================================================================================================================================================
    bool SetDetParam( std::string params=\"psd\" ) Format of params \"<detType>[,<LLD_min> [-<LLD_max>] ]\" detType in {\"psd\",\"n2mon\",\"psd-ph\",\"n2mon-ph\"}
    \"-PH\" means that Pulse Height is calculated at the same time
    default values for LLD are min=0, max=10000

    Args:
        params (std::string) detector parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
// File: classUtsusemiWiringInfoEditorTemplate.xml

%feature("docstring") UtsusemiWiringInfoEditorTemplate "C++ includes: UtsusemiWiringInfoEditorTemplate.hh 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::UtsusemiWiringInfoEditorTemplate "UtsusemiWiringInfoEditorTemplate< T1 >::UtsusemiWiringInfoEditorTemplate() UtsusemiWiringInfoEditorTemplate::UtsusemiWiringInfoEditorTemplate Constructor. 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::~UtsusemiWiringInfoEditorTemplate "UtsusemiWiringInfoEditorTemplate< T1 >::~UtsusemiWiringInfoEditorTemplate() UtsusemiWiringInfoEditorTemplate::~UtsusemiWiringInfoEditorTemplate Destructor. 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetRunNo "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetRunNo(UInt4 runNo, UInt4 mode_no=0, std::string env_file=\"\") UtsusemiWiringInfoEditorTemplate::SetRunNo

    
bool UtsusemiWiringInfoEditorTemplate< T1 >::SetRunNo(std::string runNos, std::string mode_no=\"0\", std::string env_file=\"\") UtsusemiWiringInfoEditorTemplate::SetRunNo
    
bool UtsusemiWiringInfoEditorTemplate< T1 >::SetRunNo(UInt4 runNo, std::string wfile) UtsusemiWiringInfoEditorTemplate::SetRunNo sets run No and environ_ana.xml
=================================================================================================================================================================
    This set run number and read environ_ana.xml to select WiringInfo and DetecorInfo suitable for the run number. If evn_file is empty(), this uses ${UTSUSEMI_BASE_DIR}/${UTSUSEMI_INST_CODE}/ana/xml(_UtsusemiUserXmlPath)/environ_ana.xml. If evn_file is set, the path of env_file is used as _UtsusemiUserXmlPath. bool SetRunNo( UInt4 runNo, std::string env_file=\"\" ) bool SetRunNo( std::string runNos, std::string env_file=\"\" )

    Args:
        runNo (UInt4) run number
        runNos (std::string) run numbers. format : \"1234,1235\"
        env_file (std::string) environ_ana.xml which includes several WiringInfo and DetectorInfo for each run number.
        wfile (std::string) set directly WiringInfo file

    Returns:
        true : succeeded
        false : failed 
";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetRunNoWithWiringInfo "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetRunNoWithWiringInfo(std::string runNos, std::string wfile) UtsusemiWiringInfoEditorTemplate::SetRunNoWithWiringInfo

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetConversionParameter "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetConversionParameter(std::string params, UInt4 _ptnId=0) UtsusemiWiringInfoEditorTemplate::SetConversionParameter sets conversion parameter for histogram creations
===================================================================================================================================================================================================================
    bool SetConversionParameter( std::string params, UInt4 _ptnId=0 ) Format of params TOF delta-TOF const : tof,<min_tof>,<max_tof>,<delta_tof> d-TOF/TOF const : rtof,<min_tof>,<max_tof>,<racio>
    TOF with time forcusing delta-TOF const : tf-tof,<min_tof>,<max_tof>,<delta_tof> d-TOF/TOF const : tf-rtof,<min_tof>,<max_tof>,<racio>
    Lambda delta-lambda const : lambda,<min_lambda>,<max_lambda>,<delta_lambda> delta-lambda/lambda const : rlambda,<min_lambda>,<max_lambda>,<racio>
    Energy energy,<min_energy>,<max_energy>,<delta_energy>
    Momentum Transfer q,<min_Q>,<max_Q>,<delta_Q>[,<ki_x>,<ki_y>,<ki_z>]
    Energy Transfer hw,<Ei>,<min_hw>,<max_hw>,<delta_hw>[,<t0_shift>]
    d-value d,<min_d-val>,<max_d-val>,<delta_d-val>

    Args:
        params (std::string) parameters for histogram ceration
        _ptnId (UInt4) ID of this parameters in WiringInfo

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetDetRange "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetDetRange(std::string params=\"All\") UtsusemiWiringInfoEditorTemplate::SetDetRange sets detector range for histogram creations
===============================================================================================================================================================================
    bool SetDetRange( std::string params=\"All\" ) Format of params \"All[:<number_of_pixels>]\" : use all detectors \"<startDetId>-<endDetId>[:<number_of_pixels>]\" : use detectors from <startDetId> to <endDetId> ( \"X-Y:Z,A-B:C,D-E:F...\" can be used for more settings in my plan )

    Args:
        params (std::string) parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetFrameInfo "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetFrameInfo(std::string params=\"None\") UtsusemiWiringInfoEditorTemplate::SetFrameInfo sets Frame Info for histogram creations
==============================================================================================================================================================================
    bool SetFrameInfo( std::string params ) Format of params

    Args:
        params (std::string) parameters for histogram ceration

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetMaskInfo "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetMaskInfo(std::string params=\"NoFile\", UInt4 _ptnId=0) UtsusemiWiringInfoEditorTemplate::SetMaskInfo sets MASK histogram creations
====================================================================================================================================================================================
    bool SetMaskInfo( std::string params=\"NoFile\", UInt4 _ptnId=0 ) Format of params \"<Mask.xml>[,<TOF-Mask from>-< to > [,<TOF-Mask from>-<to>] ]\" Mask.xml = \"NoFile\" if no mask.

    Args:
        params (std::string) detector parameters for histogram ceration
        _ptnId (UInt4) ID of this parameters in WiringInfo

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetTimeDependBackGroundInfo "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetTimeDependBackGroundInfo(std::string params=\"None\") UtsusemiWiringInfoEditorTemplate::SetTimeDependBackGroundInfo sets Tof region to be used for TimeDependBackground correction
===================================================================================================================================================================================================================================
    bool SetTimeDependBackGroundInfo( std::string params=\"None\" ) Format of params \"None\" : not used this background correction \"tof0-tof1\" : tof0 is start tof of region, tof1 is last of region

    Args:
        params (std::string) TimeDepend BackGroundRegion

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::MakeTempWiringInfo "std::string UtsusemiWiringInfoEditorTemplate< T1 >::MakeTempWiringInfo(std::string _path=\"\", bool asFile=false) UtsusemiWiringInfoEditorTemplate::MakeTempWiringInfo make and save the temporal wiring info to create histogram
==================================================================================================================================================================================================================================
    this returns a path of the saved temporal wiring info file std::string MakeTempWiringInfo()

    Args:
        None

    Returns:
        (std::string) : the path of output wiring info file 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::SetDetParam "bool UtsusemiWiringInfoEditorTemplate< T1 >::SetDetParam(std::string params=\"psd\") UtsusemiWiringInfoEditorTemplate::SetDetParam sets detector type
======================================================================================================================================================
    bool SetDetParam( std::string params=\"psd\" ) Format of params \"<detType>\" detType in {\"psd\",\"n2mon\",\"psd-ph\",\"n2mon-ph\"}

    Args:
        params (std::string) detector type for histogram creation

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") UtsusemiWiringInfoEditorTemplate::PutNumOfPixelForDet "UInt4 UtsusemiWiringInfoEditorTemplate< T1 >::PutNumOfPixelForDet(UInt4 _detId=0) UtsusemiWiringInfoEditorTemplate::PutNumOfPixelForDet

";
// File: classVanadiumToolsChoppers.xml

%feature("docstring") VanadiumToolsChoppers "

    Methods to correct data by Vanadium measurements.
    C++ includes: VanadiumToolsChoppers.hh 

";
%feature("docstring") VanadiumToolsChoppers::VanadiumToolsChoppers "VanadiumToolsChoppers::VanadiumToolsChoppers() VanadiumToolsChoppers::VanadiumToolsChoppers Constructor. 

";
%feature("docstring") VanadiumToolsChoppers::~VanadiumToolsChoppers "VanadiumToolsChoppers::~VanadiumToolsChoppers() VanadiumToolsChoppers::~VanadiumToolsChoppers Destructor. 

";
%feature("docstring") VanadiumToolsChoppers::MakeWhiteVanData "ElementContainer VanadiumToolsChoppers::MakeWhiteVanData(ElementContainerMatrix *ecm, double Emin, double Emax, double tof_offset) VanadiumToolsChoppers::MakeWhiteVanData makes temporary data for white vanadium correction
==============================================================================================================================================================================================================================

    Args:
        ecm Target ElementContainerMatrix
        Emin minimum energy in summation region [meV]
        Emax maximum energy in summation region [meV]
        tof_offset T0 offset value ( has dependency on Energy..)

    Returns:
        ElementContainer for temporary data for white van correction 

    
ElementContainer VanadiumToolsChoppers::MakeWhiteVanData(ElementContainerMatrix *ecm, double Emin, double Emax) VanadiumToolsChoppers::MakeWhiteVanData makes temporary data for white vanadium correction
===========================================================================================================================================================================================================
    This execute MakeWhiteVanData with tof_offset = 0.0

    Args:
        ecm Target ElementContainerMatrix
        Emin minimum energy in summation region [meV]
        Emax maximum energy in summation region [meV]

    Returns:
        ElementContainer for temporary data for white van correction 
";
%feature("docstring") VanadiumToolsChoppers::MakeMonoVanData "ElementContainer VanadiumToolsChoppers::MakeMonoVanData(ElementContainerMatrix *ecm, double Ei, double deltaEi, double tof_offset) VanadiumToolsChoppers::MakeMonoVanData makes temporary data for monochromatic vanadium correction
=====================================================================================================================================================================================================================================

    Args:
        ecm Target ElementContainerMatrix
        Ei Incident energy [meV]
        deltaEi width of integration region around Ei [meV]
        tof_offset T0 offset value ( has dependency on Energy..)

    Returns:
        ElementContainer for temporary data for white van correction 

    
ElementContainer VanadiumToolsChoppers::MakeMonoVanData(ElementContainerMatrix *ecm, double deltaEi) VanadiumToolsChoppers::MakeMonoVanData makes temporary data for monochromatic vanadium correction
=======================================================================================================================================================================================================
    This execute MakeMonoVanData with Ei imported from Header of Target ECM and tof_offset=0.0

    Args:
        ecm Target ElementContainerMatrix
        deltaEi width of integration region around Ei [meV]

    Returns:
        ElementContainer for temporary data for white van correction 
";
%feature("docstring") VanadiumToolsChoppers::CorrectWhiteVan "void VanadiumToolsChoppers::CorrectWhiteVan(ElementContainerMatrix *data, ElementContainer wvdata) VanadiumToolsChoppers::CorrectWhiteVan executes correction by white van temporary data
==========================================================================================================================================================================================
    This divides sample data by white van data

    Args:
        data Target ElementContainerMatrix
        wvdata white vanadium temporary data

    Returns:
        None 

";
%feature("docstring") VanadiumToolsChoppers::CorrectMonVan "ElementContainerMatrix VanadiumToolsChoppers::CorrectMonVan(ElementContainerMatrix data, ElementContainer mvdata) VanadiumToolsChoppers::CorrectMonVan executes correction by mono van temporary data
======================================================================================================================================================================================================
    This divides sample data by mono van data

    Args:
        data Target ElementContainerMatrix
        mvdata monochromatic vanadium temporary data

    Returns:
        corrected ElementContainerMarix 

";
%feature("docstring") VanadiumToolsChoppers::CorrectAllVan "ElementContainerMatrix VanadiumToolsChoppers::CorrectAllVan(ElementContainerMatrix data, ElementContainer wvdata, ElementContainer mvdata, ElementContainer wmvdata) VanadiumToolsChoppers::CorrectAllVan executes correction by both mono and white van temporary data
========================================================================================================================================================================================================================================================================
    This divides sample data by both van temporary data

    Args:
        data Target ElementContainerMatrix
        wvdata white vanadium temporary data
        mvdata monochromatic vanadium temporary data
        wmvdata white vanadium at measurement for monochromatic vanaium

    Returns:
        corrected ElementContainerMarix 

";
%feature("docstring") VanadiumToolsChoppers::MakeVanECM "ElementContainerMatrix VanadiumToolsChoppers::MakeVanECM(ElementContainer ec) VanadiumToolsChoppers::MakeVanECM Puts temporary vanadium data as a format of ElementContainerMatrix.
====================================================================================================================================================================================
    This is used to check how is temporary vanadium data Before executing this, you must do MakeWhiteVanData or MakeMonoVanData.

    Args:
        ec white or mono vanadium temporary data

    Returns:
        None 

    
ElementContainerMatrix VanadiumToolsChoppers::MakeVanECM(ElementContainer ec, ElementContainerMatrix ecm) VanadiumToolsChoppers::MakeVanECM Puts temporary vanadium data as a format of ElementContainerMatrix.
================================================================================================================================================================================================================
    This makes ElementContainerMatrix of temporary vanaium data by using given ElementContainer as a base format.

    Args:
        ec white or mono vanadium temporary data
        ecm ElementContainerMatrix as a base format

    Returns:
        None 
";
// File: classWiringInfoConversionDictionary.xml

%feature("docstring") WiringInfoConversionDictionary "

    Methods for unit conversion on histogram creation.
    puts X-axis bin for direct conversion from event to histogram
    puts TOF bin for histogram according to given conversion
    puts lambda values for each X axis tt = WiringInfoConversionDictionary() tt.SetParams( conv_type, params ) x=tt.PutXaxis() tof_bin = tt.PutTofBin( pixel_id )
    C++ includes: WiringInfoConversionDictionary.hh 

";
%feature("docstring") WiringInfoConversionDictionary::WiringInfoConversionDictionary "WiringInfoConversionDictionary::WiringInfoConversionDictionary() WiringInfoConversionDictionary::WiringInfoConversionDictionary Constructor. 

";
%feature("docstring") WiringInfoConversionDictionary::~WiringInfoConversionDictionary "WiringInfoConversionDictionary::~WiringInfoConversionDictionary() WiringInfoConversionDictionary::~WiringInfoConversionDictionary Destructor. 

";
%feature("docstring") WiringInfoConversionDictionary::isValidConvType "bool WiringInfoConversionDictionary::isValidConvType(Int4 convtype) WiringInfoConversionDictionary::isValidConvType

";
%feature("docstring") WiringInfoConversionDictionary::PutConvType "Int4 WiringInfoConversionDictionary::PutConvType(std::string keycode) WiringInfoConversionDictionary::PutConvType Puts ConvType Number from key code.
======================================================================================================================================================

    Args:
        keycode (std::string) key code for a type of direct conversion

    Returns:
        ConvType (Int4) 

";
%feature("docstring") WiringInfoConversionDictionary::PutKeyCode "std::string WiringInfoConversionDictionary::PutKeyCode(Int4 convtype) WiringInfoConversionDictionary::PutKeyCode Puts Key code from ConvType Number.
=====================================================================================================================================================

    Args:
        convtype (Int4) conversion type number

    Returns:
        KeyCode (std::string) 

";
%feature("docstring") WiringInfoConversionDictionary::CheckParams "bool WiringInfoConversionDictionary::CheckParams(Int4 convtype, std::vector< Double > params) WiringInfoConversionDictionary::CheckParams

";
%feature("docstring") WiringInfoConversionDictionary::PutNumOfParams "std::vector< UInt4 > WiringInfoConversionDictionary::PutNumOfParams(std::string keycode) WiringInfoConversionDictionary::PutNumOfParams

    
std::vector< UInt4 > WiringInfoConversionDictionary::PutNumOfParams(Int4 convtype) WiringInfoConversionDictionary::PutNumOfParams Puts the number of parameters for given conv type.
=====================================================================================================================================================================================
    PutNumOfParams( std::string keycode ); PutNumOfParams( Int4 convtype );

    Args:
        keycode (std::string)
        convtyep (Int4)

    Returns:
        the number of parameters (std::vector<UInt4>) 
";
%feature("docstring") WiringInfoConversionDictionary::PutMemo "std::string WiringInfoConversionDictionary::PutMemo(std::string keycode) WiringInfoConversionDictionary::PutMemo Puts Memo for given ConvType.
===============================================================================================================================================

    Args:
        keycode (std::string) key code for a type of direct conversion

    Returns:
        Memo (std::string) 

";
%feature("docstring") WiringInfoConversionDictionary::isReverseXaxis "bool WiringInfoConversionDictionary::isReverseXaxis(std::string keycode) WiringInfoConversionDictionary::isReverseXaxis

    
bool WiringInfoConversionDictionary::isReverseXaxis(Int4 convtype) WiringInfoConversionDictionary::isReverseXaxis Returns whether converted tof is required to reverse.
========================================================================================================================================================================
    isReverseXaxis( std::string keycode ); isReverseXaxis( Int4 convtype );

    Args:
        keycode (std::string)
        convtyep (Int4)

    Returns:
        (bool) 
";
%feature("docstring") WiringInfoConversionDictionary::SetParams "bool WiringInfoConversionDictionary::SetParams(std::string keycode, std::vector< Double > *params) WiringInfoConversionDictionary::SetParams

    
bool WiringInfoConversionDictionary::SetParams(Int4 convtype, std::vector< Double > *params) WiringInfoConversionDictionary::SetParams Sets conv type and its parameters.
==========================================================================================================================================================================
    SetParams( std::string keycode ); SetParams( Int4 convtype );

    Args:
        keycode (std::string)
        convtyep (Int4)
        params (std::vector<Double>*)

    Returns:
        true : succeed setting
        false : fail setting 
";
%feature("docstring") WiringInfoConversionDictionary::PutParams "std::vector< Double > WiringInfoConversionDictionary::PutParams(Int4 convtype) WiringInfoConversionDictionary::PutParams Puts parametes for given conv type.
=============================================================================================================================================================
    PutParams( Int4 convtype );

    Args:
        convtyep (Int4)

    Returns:
        params (std::vector<Double>*) 

";
%feature("docstring") WiringInfoConversionDictionary::PutXaxis "std::vector< Double > WiringInfoConversionDictionary::PutXaxis(Double tof_offset=0.0) WiringInfoConversionDictionary::PutXaxis Puts X axis for given conv type.
================================================================================================================================================================
    PutXaxis();

    Args:
        tof_offset (Double)

    Returns:
        X axis (std::vector<Double>) 

";
%feature("docstring") WiringInfoConversionDictionary::PutTofBin "std::vector< Double > WiringInfoConversionDictionary::PutTofBin(UInt4 pixelId) WiringInfoConversionDictionary::PutTofBin

    
std::vector< Double > WiringInfoConversionDictionary::PutTofBin(UInt4 pixelId, Int4 convtype, std::vector< Double > *params) WiringInfoConversionDictionary::PutTofBin Puts Tof Binning for given conv type.
=============================================================================================================================================================================================================
    (1) PutTofBin( UInt4 pixelId ) (2) PutTofBin( UInt4 pixelId, Int4 convtype, std::vector<Double> *params ) Both return TOF binning of given pixel ID. (1) requires SetParams(...) before. (2) includes SetParams(...), so you must give convtype and params.

    Args:
        pixelId (UInt4)
        convtype (Int4)
        params (std::vector<Double>*)

    Returns:
        TOF binning (std::vector<Double>) 
";
%feature("docstring") WiringInfoConversionDictionary::PutLambda "std::vector< Double > WiringInfoConversionDictionary::PutLambda(UInt4 pixelId) WiringInfoConversionDictionary::PutLambda Puts Lambda values for given pixel ID and its X axis values.
======================================================================================================================================================================================
    PutLambda( UInt4 pixelId );

    Args:
        pixelId (UInt4)

    Returns:
        Lambda values (std::vector<Double>) 

";
%feature("docstring") WiringInfoConversionDictionary::SetPixelPosition "void WiringInfoConversionDictionary::SetPixelPosition(std::vector< std::vector< Double > * > pixelPositionVect) WiringInfoConversionDictionary::SetPixelPosition

";
%feature("docstring") WiringInfoConversionDictionary::SetTimeFocusingParam "void WiringInfoConversionDictionary::SetTimeFocusingParam(std::vector< std::vector< Double > > *timeFocusParam) WiringInfoConversionDictionary::SetTimeFocusingParam

";
%feature("docstring") WiringInfoConversionDictionary::SetL1 "void WiringInfoConversionDictionary::SetL1(Double L1) WiringInfoConversionDictionary::SetL1

";
%feature("docstring") WiringInfoConversionDictionary::SetSamplePosition "void WiringInfoConversionDictionary::SetSamplePosition(Double px, Double py, Double pz) WiringInfoConversionDictionary::SetSamplePosition

";
%feature("docstring") WiringInfoConversionDictionary::PutXLabel "std::pair< std::string, std::string > WiringInfoConversionDictionary::PutXLabel(Int4 convtype=-1) WiringInfoConversionDictionary::PutXLabel

";
%feature("docstring") WiringInfoConversionDictionary::PutYLabel "std::pair< std::string, std::string > WiringInfoConversionDictionary::PutYLabel(Int4 convtype=-1) WiringInfoConversionDictionary::PutYLabel

";
%feature("docstring") WiringInfoConversionDictionary::PutELabel "std::pair< std::string, std::string > WiringInfoConversionDictionary::PutELabel(Int4 convtype=-1) WiringInfoConversionDictionary::PutELabel

";
%feature("docstring") WiringInfoConversionDictionary::SetTofShift "bool WiringInfoConversionDictionary::SetTofShift(UInt4 cType) WiringInfoConversionDictionary::SetTofShift

    
bool WiringInfoConversionDictionary::SetTofShift(UInt4 cType, std::vector< Double > params) WiringInfoConversionDictionary::SetTofShift
";
%feature("docstring") WiringInfoConversionDictionary::SetTimeDependBackGroundRegion "void WiringInfoConversionDictionary::SetTimeDependBackGroundRegion(Double tof0=0., Double tof1=0.) WiringInfoConversionDictionary::SetTimeDependBackGroundRegion

";
%feature("docstring") WiringInfoConversionDictionary::SetFrameBoundaryInfoList "bool WiringInfoConversionDictionary::SetFrameBoundaryInfoList(UInt4 frameNo, Double boundary, std::string unit) WiringInfoConversionDictionary::SetFrameBoundaryInfoList

";
// File: classWiringInfoConversionTemplate.xml

%feature("docstring") WiringInfoConversionTemplate "

    Template for methods to convert from TOF.
    C++ includes: WiringInfoConversionDictionary.hh 

";
%feature("docstring") WiringInfoConversionTemplate::WiringInfoConversionTemplate "WiringInfoConversionTemplate::WiringInfoConversionTemplate() WiringInfoConversionTemplate::WiringInfoConversionTemplate Constructor. 

    
WiringInfoConversionTemplate::WiringInfoConversionTemplate(const WiringInfoConversionTemplate &obj) WiringInfoConversionTemplate::WiringInfoConversionTemplate Copy Constructor. 
";
%feature("docstring") WiringInfoConversionTemplate::~WiringInfoConversionTemplate "WiringInfoConversionTemplate::~WiringInfoConversionTemplate() WiringInfoConversionTemplate::~WiringInfoConversionTemplate Destructor. 

";
%feature("docstring") WiringInfoConversionTemplate::CheckParams "bool WiringInfoConversionTemplate::CheckParams(std::vector< Double > params) WiringInfoConversionTemplate::CheckParams

";
%feature("docstring") WiringInfoConversionTemplate::PutTofBin "std::vector< Double > WiringInfoConversionTemplate::PutTofBin(std::vector< Double > *xaxis, std::vector< Double > *params, std::vector< Double > *pv, std::vector< Double > *oparams) WiringInfoConversionTemplate::PutTofBin

";
%feature("docstring") WiringInfoConversionTemplate::PutXaxisVect "std::vector< Double > WiringInfoConversionTemplate::PutXaxisVect(std::vector< Double > params, Double tof_offset=0.0) WiringInfoConversionTemplate::PutXaxisVect

";
%feature("docstring") WiringInfoConversionTemplate::PutLambdaVec "std::vector< Double > WiringInfoConversionTemplate::PutLambdaVec(std::vector< Double > *xaxis, std::vector< Double > *params, std::vector< Double > *pv, std::vector< Double > *oparams) WiringInfoConversionTemplate::PutLambdaVec

";
// File: classWiringInfoDefineNeunet.xml

%feature("docstring") WiringInfoDefineNeunet "C++ includes: WiringInfoEditorNeunet.hh 

";
%feature("docstring") WiringInfoDefineNeunet::WiringInfoDefineNeunet "WiringInfoDefineNeunet::WiringInfoDefineNeunet() WiringInfoDefineNeunet::WiringInfoDefineNeunet

";
%feature("docstring") WiringInfoDefineNeunet::~WiringInfoDefineNeunet "WiringInfoDefineNeunet::~WiringInfoDefineNeunet() WiringInfoDefineNeunet::~WiringInfoDefineNeunet

";
// File: classWiringInfoEditorBase.xml

%feature("docstring") WiringInfoEditorBase "

    Codes to treat WiringInfo.
    Reads WiringInfo to be read from histogram creation methods
    Reads WiringInfo to change its contents
    Saves changed WiringInfo
    C++ includes: WiringInfoEditorBase.hh 

";
%feature("docstring") WiringInfoEditorBase::WiringInfoEditorBase "WiringInfoEditorBase::WiringInfoEditorBase() WiringInfoEditorBase::WiringInfoEditorBase Constructor. 

    
WiringInfoEditorBase::WiringInfoEditorBase(std::string _wFile, bool workAsReader=true) WiringInfoEditorBase::WiringInfoEditorBase Constructor.
===============================================================================================================================================

    Args:
        _wFile (std::string)
        workAsReader (bool) 
";
%feature("docstring") WiringInfoEditorBase::~WiringInfoEditorBase "WiringInfoEditorBase::~WiringInfoEditorBase() WiringInfoEditorBase::~WiringInfoEditorBase Destructor. 

";
%feature("docstring") WiringInfoEditorBase::Clear "void WiringInfoEditorBase::Clear(UInt4 index=0) WiringInfoEditorBase::Clear Clears stored parameters.
======================================================================================================
    This deletes information by given index. index = 0 : all (default) index = 1 : PixelInfo ( and DetInfoList ) index = 2 : TofBinPtnInfo index = 3 : TofBinInfo index = 4 : FrameBoundaryInfo

    Args:
        index (UInt4)

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::Read "bool WiringInfoEditorBase::Read(std::string arg) WiringInfoEditorBase::Read Reads WiringInfo.xml and import information.
=========================================================================================================================

    Args:
        arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::Write "bool WiringInfoEditorBase::Write(std::string filepath) WiringInfoEditorBase::Write Writes WiringInfo.xml.
==========================================================================================================

    Args:
        filepath (std::string)

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::OutXml "std::string WiringInfoEditorBase::OutXml(bool withIndent=false) WiringInfoEditorBase::OutXml Returns WiringInfo as std::string.
================================================================================================================================

    Args:
        withIndent(bool) false : output xml without an indent format

    Returns:
        std::string 

";
%feature("docstring") WiringInfoEditorBase::ImportPixelInfo "void WiringInfoEditorBase::ImportPixelInfo() WiringInfoEditorBase::ImportPixelInfo Analyzes xml descriptions for PixelInfo.
============================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::ImportTofBinPattern "void WiringInfoEditorBase::ImportTofBinPattern() WiringInfoEditorBase::ImportTofBinPattern Analyzes xml descriptions for TOF bin patterns.
===========================================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::ImportTofMaskPattern "void WiringInfoEditorBase::ImportTofMaskPattern() WiringInfoEditorBase::ImportTofMaskPattern Analyzes xml descriptions for TOF mask pattern.
=============================================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::ImportTofBinInfo "void WiringInfoEditorBase::ImportTofBinInfo() WiringInfoEditorBase::ImportTofBinInfo Analyzes xml descriptions for TOF bin info.
=================================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::ImportFrameInfo "void WiringInfoEditorBase::ImportFrameInfo() WiringInfoEditorBase::ImportFrameInfo Analyzes xml descriptions for frame info.
=============================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::Dump "void WiringInfoEditorBase::Dump(Int4 index=DUMP_ALL) WiringInfoEditorBase::Dump Shows imported information.
============================================================================================================

    Args:
        index (Int4)

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::ResetHeadPixelId "void WiringInfoEditorBase::ResetHeadPixelId(Int4 first_detId=0, Int4 last_detId=-1, Int4 headPixelId=0) WiringInfoEditorBase::ResetHeadPixelId Re-calculates each headPixelId by numPixel.
===========================================================================================================================================================================================
    ResetHeadPixelId(Int4 first_detId=0, Int4 last_detId=-1, Int4 headPixelId=0 )

    Args:
        first_detId range of detId to apply
        last_detId range of detId to apply
        headPixelId if set, headPixelId starts from this value

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::SetInstInfo "bool WiringInfoEditorBase::SetInstInfo(std::string instCode=\"\", std::string update=\"\", std::string ver=\"\") WiringInfoEditorBase::SetInstInfo Set InstCode and other information.
=======================================================================================================================================================================================
    SetInstInfo( std::string instCode, std::string ver=\"1.5\", std::string update=\"\" );

    Args:
        instCode instrument code
        update date format \"YYYYMMDDhhmmss\"
        ver version

    Returns:
        true : success
        false : false 

";
%feature("docstring") WiringInfoEditorBase::SetPixelInfo "bool WiringInfoEditorBase::SetPixelInfo(UInt4 daqId, UInt4 modNo, UInt4 detId, Int4 headPixelId, UInt4 numPixel, std::string type, UInt4 numAxis=1) WiringInfoEditorBase::SetPixelInfo

    
bool WiringInfoEditorBase::SetPixelInfo(UInt4 daqId, UInt4 modNo) WiringInfoEditorBase::SetPixelInfo
    
bool WiringInfoEditorBase::SetPixelInfo(UInt4 daqId) WiringInfoEditorBase::SetPixelInfo Sets Pixel info.
=========================================================================================================
    This changes or makes pixel information by given parameters
    SetPixelInfo( UInt4 daqId, UInt4 modNo, UInt4 detId, UInt4 headPixelId, UInt4 numPixel, std::string type, UInt4 axis=0 ) SetPixelInfo( UInt4 daqId, UInt4 modNo ) SetPixelInfo( UInt4 daqId )

    Args:
        daqId
        modNo
        detId
        headPixelid
        numPixel
        type
        numAxis

    Returns:
        true : success
        false : false 
";
%feature("docstring") WiringInfoEditorBase::SetAllPixelInfo "bool WiringInfoEditorBase::SetAllPixelInfo(UInt4 numPixel, std::string type=UTSUSEMI_KEY_HEAD_DETTYPE_PSD, UInt4 numAxis=1, Int4 daqId=-1, Int4 modNo=-1) WiringInfoEditorBase::SetAllPixelInfo Sets Pixel info for all or given range.
========================================================================================================================================================================================================================================
    This changes or makes pixel information by given parameters After changed parameter all, this executes ReSetHeadPixelId
    SetAllPixelInfo( UInt4 numPixel, std::string type=\"PSD\", UInt4 axis=0, Int4 daqId=-1, Int4 modNo=-1);

    Args:
        numPixel
        type
        numAxis
        daqId
        modNo

    Returns:
        true : success
        false : false 

";
%feature("docstring") WiringInfoEditorBase::DeleteDetector "bool WiringInfoEditorBase::DeleteDetector(UInt4 detId) WiringInfoEditorBase::DeleteDetector Deletes detector element in Pixel info.
====================================================================================================================================
    This delete detector information
    RemoveDetector( UInt4 detId )

    Args:
        daqId

    Returns:
        true : success
        false : false 

";
%feature("docstring") WiringInfoEditorBase::DeleteModule "bool WiringInfoEditorBase::DeleteModule(UInt4 daqId, UInt4 modNo) WiringInfoEditorBase::DeleteModule Deletes module element in Pixel info.
===========================================================================================================================================
    This delete module element ( also deletes included detectors )
    DeleteModule( UInt4 daqId, UInt4 modNo )

    Args:
        daqId
        modNo

    Returns:
        true : success
        false : false 

";
%feature("docstring") WiringInfoEditorBase::DeleteDaq "bool WiringInfoEditorBase::DeleteDaq(UInt4 daqId) WiringInfoEditorBase::DeleteDaq Deletes daq elements in Pixel info.
======================================================================================================================
    This deletes daq element ( also deletes included modules and detectors )
    DeleteDaq( UInt4 daqId )

    Args:
        daqId

    Returns:
        true : success
        false : false 

";
%feature("docstring") WiringInfoEditorBase::SetDaqAlive "void WiringInfoEditorBase::SetDaqAlive(bool isAlive, UInt4 first_daqId, UInt4 last_daqId=999999999) WiringInfoEditorBase::SetDaqAlive Sets DAQ components status use or not.
=============================================================================================================================================================================
    isAlive info is used when output to xml.
    SetDaqAlive( bool isAlive, UInt4 first_daqId, UInt4 last_daqId=999999999 );

    Args:
        isAlive (bool) true: use, false: not use
        first_daqId (UInt4) first daqId to be set
        last_daqId (UInt4) last daqId to be set, if not set, only first_daqId is set.

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::SetModAlive "void WiringInfoEditorBase::SetModAlive(bool isAlive, UInt4 daqId, UInt4 first_modNo, UInt4 last_modNo=999999999) WiringInfoEditorBase::SetModAlive Sets Module components status use or not.
=============================================================================================================================================================================================
    isAlive info is used when output to xml.
    SetModAlive( bool isAlive, UInt4 daqId, UInt4 first_modNo, UInt4 last_modNo=999999999 )

    Args:
        isAlive (bool) true: use, false: not use
        daqId (UInt4) DAQ ID including target modules
        first_modNo (UInt4) first module No to be set
        last_modNo (UInt4) last module No to be set, if not set, only first_modNo is set.

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::SetDetAlive "void WiringInfoEditorBase::SetDetAlive(bool isAlive, UInt4 first_detId, UInt4 last_detId=999999999) WiringInfoEditorBase::SetDetAlive Sets detector components status use or not.
==================================================================================================================================================================================
    isAlive info is used when output to xml.
    SetDetAlive( bool isAlive, UInt4 first_detId, UInt4 last_detId=999999999 )

    Args:
        isAlive (bool) true: use, false: not use
        first_detId (UInt4) first detId to be set
        last_detId (UInt4) last detId to be set, if not set, only first_detId is set.

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::SetTofBinPattern "bool WiringInfoEditorBase::SetTofBinPattern(UInt4 patternId, UInt4 type, std::vector< Double > params) WiringInfoEditorBase::SetTofBinPattern Sets Tof binning pattern.
========================================================================================================================================================================
    SetTofBinPattern( UInt4 patternId, UInt4 type, std::vector<Double> params )

    Args:
        patternId (UInt4) patternId, if already patternId exists, overwrites
        type (UInt4) TofBin type
        params (std::vector<Double>) parameters for TofBin type)

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::DeleteTofBinPattern "bool WiringInfoEditorBase::DeleteTofBinPattern(UInt4 patternId) WiringInfoEditorBase::DeleteTofBinPattern Deletes Tof binning pattern.
=======================================================================================================================================
    DeleteTofBinPattern( UInt4 patternId )

    Args:
        patternId (UInt4) patternId, if already patternId exists, overwrites

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::DeleteAllTofBinPattern "void WiringInfoEditorBase::DeleteAllTofBinPattern() WiringInfoEditorBase::DeleteAllTofBinPattern Deletes all Tof binning pattern.
==================================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::SetTofBinInfo "bool WiringInfoEditorBase::SetTofBinInfo(UInt4 patternId, Double offsetBin=0.0, Int4 maskPtnId=-1) WiringInfoEditorBase::SetTofBinInfo

    
bool WiringInfoEditorBase::SetTofBinInfo(UInt4 start_detId, UInt4 end_detId, UInt4 patternId, Double offsetBin=0.0, Int4 maskPtnId=-1) WiringInfoEditorBase::SetTofBinInfo
    
bool WiringInfoEditorBase::SetTofBinInfo(std::vector< UInt4 > range, UInt4 patternId, Double offsetBin=0.0, Int4 maskPtnId=-1) WiringInfoEditorBase::SetTofBinInfo Sets Tof binning info.
==========================================================================================================================================================================================
    SetTofBinInfo( UInt4 patternId, UInt4 offsetBin=0 ) this applys all detectors. SetTofBinInfo( UInt4 start_detId, UInt4 end_detId, UInt4 patternId, UInt4 offsetBin=0 ); this applys detectors between start_detid and end_detId SetTofBinInfo( std::vector<UInt4> range, UInt4 patternId, UInt4 offsetBin=0 ); this applys individual, example [0,12,15,16,20,0,25,29] => 0-12,15-16,20,25-29

    Args:
        start_detId (UInt4) detId range
        end_detId (UInt4) detId range
        range (std::vector<UInt4>)
        patternId (UInt4) patternId
        offsetBin (Double) offset value
        maskPtnId (Int4) mask pattern Id

    Returns:
        true succeded
        false failed 
";
%feature("docstring") WiringInfoEditorBase::DeleteAllTofBinInfo "void WiringInfoEditorBase::DeleteAllTofBinInfo() WiringInfoEditorBase::DeleteAllTofBinInfo Deletes all Tof binning info.
=========================================================================================================================

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorBase::SetFrameInfo "bool WiringInfoEditorBase::SetFrameInfo(UInt4 frameNo, Double boundary, std::string type=\"tof\") WiringInfoEditorBase::SetFrameInfo Sets Tof frame boundary parameters.
=========================================================================================================================================================================
    SetFrameInfo( UInt4 frameNo, Double boundary )

    Args:
        frameNo (UInt4) Frame Number
        boundary (Double) TOF boundary
        type (std::string)

    Returns:
        true succeded
        false failed 

    
bool WiringInfoEditorBase::SetFrameInfo(std::string params) WiringInfoEditorBase::SetFrameInfo Sets tof frame treating information.
====================================================================================================================================
    This params can include frame number and boundary tof. [\"None\" or <frameNo>,<boundaryTof> or \"<type>:<boundary>\" where type in (\"tof\",\"lambda\",\"energy\",\"ei\") ]

    Args:
        params (std::string) frame info parameter

    Returns:
        true succeded
        false failed 
";
%feature("docstring") WiringInfoEditorBase::SetUseDetectorType "bool WiringInfoEditorBase::SetUseDetectorType(std::string _detType) WiringInfoEditorBase::SetUseDetectorType Makes detectors alive by given detector type.
===========================================================================================================================================================

    Args:
        _detType (std::string) <detType1>[,<detType2>,...]

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::SetTofMaskPattern "bool WiringInfoEditorBase::SetTofMaskPattern(UInt4 patternId, std::vector< Double > params) WiringInfoEditorBase::SetTofMaskPattern Sets Tof mask Pattern with pattern Id.
===========================================================================================================================================================================

    Args:
        patterinId (UInt4) pattern Id for given params
        params (std::vector<Double>) tof ranges list to be masked, [m1,m2,m3,m4,...,] means region of [m1:m2], [m3:m4] ... are masked.

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::SetDetectorRange "bool WiringInfoEditorBase::SetDetectorRange(std::vector< UInt4 > list_of_num_pixels, std::vector< std::pair< Int4, Int4 > > list_of_det_range, std::string det_type) WiringInfoEditorBase::SetDetectorRange Makes the staus of given detectors alive or not.
=============================================================================================================================================================================================================================================================

    Args:
        list_of_num_pixels (std::vector<UInt4>) the number of pixels of each detector ranges
        list_of_det_range (std::vector< std::pair<Int4,Int4> >) detector ranges
        det_type (std::string) type of all given detectors

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::SetConversionParameter "bool WiringInfoEditorBase::SetConversionParameter(std::string params, UInt4 _ptnId=0) WiringInfoEditorBase::SetConversionParameter Sets conversion parameters for histogram creation from event data.
======================================================================================================================================================================================================
    This params are checked by WiringConversionDictionary class and used to calculate tof_bin_pattern.

    Args:
        params (std::string) parameters to create histogram in string format
        _ptnId (UInt4) given pattern id for this parameter ( normally 1 )

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::SetDetParam "bool WiringInfoEditorBase::SetDetParam(std::string params) WiringInfoEditorBase::SetDetParam Sets detector parameters.
=======================================================================================================================
    This method will be overrided by WiringInfoEditorNeunet to treat Pulse Height. In this class, this methods set only detector type in [\"PSD\",\"uPSD\",\"MON\",\"SCIN1D\",\"RPMT\",\"MWPC\",\"WLSF32\"]

    Args:
        params (std::string) detector type

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::SetDetRange "bool WiringInfoEditorBase::SetDetRange(std::string params) WiringInfoEditorBase::SetDetRange Sets detector ranges to be used for histogram creation.
=====================================================================================================================================================
    This params can include \"All\", range of detector ID, the number of pixels in a detector. [\"All\", <detId>-<detId>, <detId>-<detId>:num,...]

    Args:
        params (std::string) detector range parameter(s)

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorBase::SetMaskInfo "bool WiringInfoEditorBase::SetMaskInfo(std::string params, UInt4 _ptnId) WiringInfoEditorBase::SetMaskInfo sets MASK histogram creations
=========================================================================================================================================
    bool SetMaskInfo( std::string params=\"NoFile\", UInt4 _ptnId=0 ) Format of params \"<Mask.xml>[,<TOF-Mask from>-< to > [,<TOF-Mask from>-<to>] ]\" Mask.xml = \"NoFile\" if no mask.

    Args:
        params (std::string) detector parameters for histogram ceration
        _ptnId (UInt4) ID of this parameters in WiringInfo

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") WiringInfoEditorBase::SetTimeDependBackGroundInfo "bool WiringInfoEditorBase::SetTimeDependBackGroundInfo(std::string params) WiringInfoEditorBase::SetTimeDependBackGroundInfo sets Tof region to be used for TimeDependBackground correction
============================================================================================================================================================================================
    bool SetTimeDependBackGroundInfo( std::string params=\"None\" ) Format of params \"None\" : not used this background correction \"tof0-tof1\" : tof0 is start tof of region, tof1 is last of region

    Args:
        params (std::string) TimeDepend BackGroundRegion

    Returns:
        true : succeeded
        false : failed 

";
%feature("docstring") WiringInfoEditorBase::ImportTimeDependBackGroundInfo "void WiringInfoEditorBase::ImportTimeDependBackGroundInfo() WiringInfoEditorBase::ImportTimeDependBackGroundInfo

";
%feature("docstring") WiringInfoEditorBase::PutTimeDependBackGroundList "std::vector< std::vector< Double > * > * WiringInfoEditorBase::PutTimeDependBackGroundList() WiringInfoEditorBase::PutTimeDependBackGroundList

";
%feature("docstring") WiringInfoEditorBase::ClearReader "void WiringInfoEditorBase::ClearReader(UInt4 index=0) WiringInfoEditorBase::ClearReader

";
%feature("docstring") WiringInfoEditorBase::SetInfoAsReader "bool WiringInfoEditorBase::SetInfoAsReader() WiringInfoEditorBase::SetInfoAsReader

";
%feature("docstring") WiringInfoEditorBase::PutConversionDictionary "WiringInfoConversionDictionary * WiringInfoEditorBase::PutConversionDictionary() WiringInfoEditorBase::PutConversionDictionary

";
%feature("docstring") WiringInfoEditorBase::SetIgnoreModuleType "void WiringInfoEditorBase::SetIgnoreModuleType(std::string tmp) WiringInfoEditorBase::SetIgnoreModuleType

";
%feature("docstring") WiringInfoEditorBase::PutDaqList "std::vector< UInt4 > WiringInfoEditorBase::PutDaqList() WiringInfoEditorBase::PutDaqList Returns list of DAQ ID described in WiringInfo.
=========================================================================================================================================

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") WiringInfoEditorBase::PutModuleList "std::vector< UInt4 > WiringInfoEditorBase::PutModuleList(UInt4 daqId) WiringInfoEditorBase::PutModuleList Returns list of module No in given daqId described in WiringInfo.
============================================================================================================================================================================

    Args:
        daqId (UInt4) DAQ Id

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") WiringInfoEditorBase::PutDetectorList "std::vector< UInt4 > WiringInfoEditorBase::PutDetectorList(UInt4 daqId, UInt4 modNo) WiringInfoEditorBase::PutDetectorList Returns list of detId in given daqId and module No described in WiringInfo.
=======================================================================================================================================================================================================

    Args:
        daqId (UInt4) DAQ Id
        modNo (UInt4) module No

    Returns:
        std::vector<UInt4> 

";
%feature("docstring") WiringInfoEditorBase::PutDetInfo "UtsusemiDetInfo * WiringInfoEditorBase::PutDetInfo(UInt4 daqId, UInt4 modNo, UInt4 detId) WiringInfoEditorBase::PutDetInfo

";
%feature("docstring") WiringInfoEditorBase::PutNumOfPixelForDet "UInt4 WiringInfoEditorBase::PutNumOfPixelForDet(UInt4 _detId=0) WiringInfoEditorBase::PutNumOfPixelForDet

";
%feature("docstring") WiringInfoEditorBase::PutPixelInfoStore "std::vector< Int4 > WiringInfoEditorBase::PutPixelInfoStore(UInt4 daqId, UInt4 modeNo, UInt4 detNo) WiringInfoEditorBase::PutPixelInfoStore

";
%feature("docstring") WiringInfoEditorBase::IgnoredXml "void WiringInfoEditorBase::IgnoredXml(bool isIgnoredXml=true) WiringInfoEditorBase::IgnoredXml

";
%feature("docstring") WiringInfoEditorBase::FixHeadPixelId "void WiringInfoEditorBase::FixHeadPixelId(bool isFixed=true) WiringInfoEditorBase::FixHeadPixelId

";
// File: classWiringInfoEditorNeunet.xml

%feature("docstring") WiringInfoEditorNeunet "C++ includes: WiringInfoEditorNeunet.hh 

";
%feature("docstring") WiringInfoEditorNeunet::WiringInfoEditorNeunet "WiringInfoEditorNeunet::WiringInfoEditorNeunet() WiringInfoEditorNeunet::WiringInfoEditorNeunet Constructor. 

    
WiringInfoEditorNeunet::WiringInfoEditorNeunet(std::string wfile, bool workAsReader=true) WiringInfoEditorNeunet::WiringInfoEditorNeunet Constructor.
======================================================================================================================================================
    @params wfile (std::string) wiring file path

    Args:
        workAsReader (bool) 
";
%feature("docstring") WiringInfoEditorNeunet::~WiringInfoEditorNeunet "WiringInfoEditorNeunet::~WiringInfoEditorNeunet() WiringInfoEditorNeunet::~WiringInfoEditorNeunet Destructor. 

";
%feature("docstring") WiringInfoEditorNeunet::Clear "void WiringInfoEditorNeunet::Clear(UInt4 index=0) WiringInfoEditorNeunet::Clear Clears stored parameters.
==========================================================================================================
    This deletes information by given index. index = 0 : all (default) index = 1 : PixelInfo ( and DetInfoList ) index = 2 : TofBinPtnInfo index = 3 : TofBinInfo index = 4 : FrameBoundaryInfo index = 5 : TrigInfoStore index = 6 : TofMaskPtn index = 7 : PsdParams index = 8 : PsdBinInfo

    Args:
        index (UInt4)

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorNeunet::ClearReader "void WiringInfoEditorNeunet::ClearReader(UInt4 index=0) WiringInfoEditorNeunet::ClearReader

";
%feature("docstring") WiringInfoEditorNeunet::Read "bool WiringInfoEditorNeunet::Read(std::string arg) WiringInfoEditorNeunet::Read Reads WiringInfo.xml and import information.
=============================================================================================================================

    Args:
        arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") WiringInfoEditorNeunet::Write "bool WiringInfoEditorNeunet::Write(std::string filepath) WiringInfoEditorNeunet::Write Writes WiringInfo.xml.
==============================================================================================================

    Args:
        filepath (std::string)

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") WiringInfoEditorNeunet::OutXml "std::string WiringInfoEditorNeunet::OutXml(bool withIndent=false) WiringInfoEditorNeunet::OutXml Returns WiringInfo as std::string.
====================================================================================================================================

    Args:
        withIndent(bool) false : output xml without an indent format

    Returns:
        std::string 

";
%feature("docstring") WiringInfoEditorNeunet::ImportPsdParams "void WiringInfoEditorNeunet::ImportPsdParams() WiringInfoEditorNeunet::ImportPsdParams Analyzes xml descriptions for psd params (A,B,C,LDD)
============================================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorNeunet::ImportPsdInfo "void WiringInfoEditorNeunet::ImportPsdInfo() WiringInfoEditorNeunet::ImportPsdInfo Analyzes xml descriptions for PsdBinInfo.
=============================================================================================================================
    This analyzes read xml descriptions

    Args:
        None

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorNeunet::PutPsdParams "std::vector< Double > WiringInfoEditorNeunet::PutPsdParams(UInt4 detId) WiringInfoEditorNeunet::PutPsdParams Puts PSD parameters for given detector ID.
========================================================================================================================================================
    PutPsdParams( UInt4 detId )

    Args:
        detId (UInt4) detId

    Returns:
        std::vector<Double> with size=0 : no PSD info
        std::vector<Double> with size=5 : [, , , <Lower limit PH>, <Upper limit PH>] 

";
%feature("docstring") WiringInfoEditorNeunet::SetPsdParams "bool WiringInfoEditorNeunet::SetPsdParams(UInt4 detId, Double Aval, Double Bval, Double Cval, Double PHlow, Double PHup) WiringInfoEditorNeunet::SetPsdParams

    
bool WiringInfoEditorNeunet::SetPsdParams(UInt4 detId, std::string tag, Double val) WiringInfoEditorNeunet::SetPsdParams Sets PSD parameters for each detector.
================================================================================================================================================================
    SetPsdParams( UInt4 detId, Double Aval, Double Bval, Double Cval, Double PHlow, Double PHup ) SetPsdParams( UInt4 detId, std::string tag, Double val )

    Args:
        detId (UInt4) detId
        Aval (Double) A value of PSD
        Bval (Double) B value of PSD
        Cval (Double) C value of PSD
        PHlow (Double) lower limit of pulse height value of PSD
        PHup (Double) upper limit of pulse heignt value of PSD
        tag (std::string) Key of parameters which must be \"A\",\"B\",\"C\",\"LLD\",\"HLD\"
        val (Double) value for given Key

    Returns:
        true succeded
        false failed 
";
%feature("docstring") WiringInfoEditorNeunet::SetAllPsdParams "bool WiringInfoEditorNeunet::SetAllPsdParams(std::string tag, Double val) WiringInfoEditorNeunet::SetAllPsdParams Sets PSD parameters to all.
==============================================================================================================================================
    SetAllPsdParams( std::string tag, Double val )

    Args:
        tag (std::string) Key of parameters which must be \"A\",\"B\",\"C\",\"LLD\",\"HLD\"
        val (Double) value for given Key

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorNeunet::DeletePsdParams "bool WiringInfoEditorNeunet::DeletePsdParams(UInt4 start_detId=0, UInt4 end_detId=0) WiringInfoEditorNeunet::DeletePsdParams Deletes PSD parameters.
=====================================================================================================================================================
    DeletePsdParams( UInt4 start_detId=0, UInt4 end_detId=0 )

    Args:
        start_detId (UInt4) range of detId
        end_detId (UInt4) range of detId

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorNeunet::MakePsdInfo "void WiringInfoEditorNeunet::MakePsdInfo(UInt4 numPixel, Double deltaX, Double offsetX) WiringInfoEditorNeunet::MakePsdInfo Makes PSD bin Info.
================================================================================================================================================
    This collects detId which has same numPixel as given numPixel and makes PsdInfo MakePsdInfo( UInt4 numPixel, UInt4 deltaX, UInt4 offsetX )

    Args:
        numPixel (UInt4) number of pixels in a PSD
        deltaX (Double) width on X axis for each pixel
        offsetX (Double) offset value on X axis

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorNeunet::SetPsdInfo "bool WiringInfoEditorNeunet::SetPsdInfo(UInt4 numPixel, Double deltaX, Double offsetX, std::string conts) WiringInfoEditorNeunet::SetPsdInfo

    
bool WiringInfoEditorNeunet::SetPsdInfo(Double deltaX, Double offsetX, UInt4 start_detId=0, UInt4 end_detId=0) WiringInfoEditorNeunet::SetPsdInfo Sets PSD bin Info.
=====================================================================================================================================================================
    This makes PSD info tag by given parameters without checking. SetPsdInfo( UInt4 numPixel, Double deltaX, Double offsetX, std::string conts ) SetPsdInfo( Double deltaX, Double offsetX, UInt4 start_detId=0, UInt4 end_detId=0 )

    Args:
        numPixel (UInt4) number of pixels in a PSD
        deltaX (Double) width on X axis for each pixel
        offsetX (Double) offset value on X axis
        conts (std::string) contents of this tag
        start_detId (UInt4) range of detId
        end_detId (UInt4) range of detId

    Returns:
        true succeded
        false failed 
";
%feature("docstring") WiringInfoEditorNeunet::DeletePsdInfo "bool WiringInfoEditorNeunet::DeletePsdInfo(UInt4 index=999999999) WiringInfoEditorNeunet::DeletePsdInfo Deletes Psd bin info.
==============================================================================================================================
    DeletePsdInfo( UInt4 index=999999999 )

    Args:
        index (UInt4) index for PsdBinInfo to be deleted

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorNeunet::Dump "void WiringInfoEditorNeunet::Dump(Int4 index=DUMP_ALL) WiringInfoEditorNeunet::Dump

";
%feature("docstring") WiringInfoEditorNeunet::SetNumPixelOfPsdBin "bool WiringInfoEditorNeunet::SetNumPixelOfPsdBin(UInt4 num_of_pixel, Int4 start_id=-1, Int4 end_id=-1) WiringInfoEditorNeunet::SetNumPixelOfPsdBin

";
%feature("docstring") WiringInfoEditorNeunet::SetDetectorRange "bool WiringInfoEditorNeunet::SetDetectorRange(std::vector< UInt4 > list_of_num_pixels, std::vector< std::pair< Int4, Int4 > > list_of_det_range, std::string det_type) WiringInfoEditorNeunet::SetDetectorRange Makes the staus of given detectors alive or not.
=================================================================================================================================================================================================================================================================

    Args:
        list_of_num_pixels (std::vector<UInt4>) the number of pixels of each detector ranges
        list_of_det_range (std::vector< std::pair<Int4,Int4> >) detector ranges
        det_type (std::string) type of all given detectors

    Returns:
        true succeded
        false failed 

";
%feature("docstring") WiringInfoEditorNeunet::SetDetParam "bool WiringInfoEditorNeunet::SetDetParam(std::string params=\"psd\") WiringInfoEditorNeunet::SetDetParam

";
%feature("docstring") WiringInfoEditorNeunet::SetInfoAsReader "bool WiringInfoEditorNeunet::SetInfoAsReader() WiringInfoEditorNeunet::SetInfoAsReader

";
// File: classWiringInfoEditorReadout.xml

%feature("docstring") WiringInfoEditorReadout "C++ includes: WiringInfoEditorReadout.hh 

";
%feature("docstring") WiringInfoEditorReadout::WiringInfoEditorReadout "WiringInfoEditorReadout::WiringInfoEditorReadout() WiringInfoEditorReadout::WiringInfoEditorReadout Constructor. 

    
WiringInfoEditorReadout::WiringInfoEditorReadout(std::string wfile, bool workAsReader=true) WiringInfoEditorReadout::WiringInfoEditorReadout Constructor.
==========================================================================================================================================================
    @params wfile (std::string) wiring file path

    Args:
        workAsReader (bool) 
";
%feature("docstring") WiringInfoEditorReadout::~WiringInfoEditorReadout "WiringInfoEditorReadout::~WiringInfoEditorReadout() WiringInfoEditorReadout::~WiringInfoEditorReadout Destructor. 

";
%feature("docstring") WiringInfoEditorReadout::Clear "void WiringInfoEditorReadout::Clear(UInt4 index=0) WiringInfoEditorReadout::Clear Clears stored parameters.
============================================================================================================
    This deletes information by given index. index = 0 : all (default) index = 1 : PixelInfo ( and DetInfoList ) index = 2 : TofBinPtnInfo index = 3 : TofBinInfo index = 4 : FrameBoundaryInfo index = 5 : TrigInfoStore index = 6 : TofMaskPtn index = 7 : PsdParams index = 8 : PsdBinInfo index = 9 : ReadoutGateInfo

    Args:
        index (UInt4)

    Returns:
        None 

";
%feature("docstring") WiringInfoEditorReadout::Read "bool WiringInfoEditorReadout::Read(std::string arg) WiringInfoEditorReadout::Read Reads WiringInfo.xml and import information.
===============================================================================================================================

    Args:
        arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") WiringInfoEditorReadout::Write "bool WiringInfoEditorReadout::Write(std::string filepath) WiringInfoEditorReadout::Write Writes WiringInfo.xml.
================================================================================================================

    Args:
        filepath (std::string)

    Returns:
        true : succeeded
        false failed 

";
%feature("docstring") WiringInfoEditorReadout::OutXml "std::string WiringInfoEditorReadout::OutXml(bool withIndent=false) WiringInfoEditorReadout::OutXml Returns WiringInfo as std::string.
======================================================================================================================================

    Args:
        withIndent(bool) false : output xml without an indent format

    Returns:
        std::string 

";
%feature("docstring") WiringInfoEditorReadout::ImportReadoutGateInfo "void WiringInfoEditorReadout::ImportReadoutGateInfo() WiringInfoEditorReadout::ImportReadoutGateInfo

";
%feature("docstring") WiringInfoEditorReadout::Dump "void WiringInfoEditorReadout::Dump(Int4 index=DUMP_ALL) WiringInfoEditorReadout::Dump

";
%feature("docstring") WiringInfoEditorReadout::SetInfoAsReader "bool WiringInfoEditorReadout::SetInfoAsReader() WiringInfoEditorReadout::SetInfoAsReader

";
// File: classWiringInfoTagDefineBase.xml

%feature("docstring") WiringInfoTagDefineBase "C++ includes: WiringInfoDataBase.hh 

";
%feature("docstring") WiringInfoTagDefineBase::WiringInfoTagDefineBase "WiringInfoTagDefineBase::WiringInfoTagDefineBase() WiringInfoTagDefineBase::WiringInfoTagDefineBase Constructor. 

";
%feature("docstring") WiringInfoTagDefineBase::~WiringInfoTagDefineBase "WiringInfoTagDefineBase::~WiringInfoTagDefineBase() WiringInfoTagDefineBase::~WiringInfoTagDefineBase Destructor. 

";
// File: classmanyo_1_1ConvManyoDoxy2Swig_1_1Doxy2SWIG.xml

%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG "

    Converts Doxygen generated XML files into a file containing docstrings that can be used by SWIG-1.3.x that have support for feature(\"docstring\").  Once the data is parsed it is stored in self.pieces. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::__init__ "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.__init__(self, src) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.__init__ Initialize the instance given a source object (file or filename). 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::generate "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.generate(self) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.generate Parses the file set in the initialization.  The resulting data is stored in `self.pieces`. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::parse "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse Parse a given node.  This function in turn calls the `parse_<nodeType>` functions which handle the respective nodes. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Document "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Text "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::parse_Element "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element Parse an `ELEMENT_NODE`.  This calls specific `do_<tagName>` handers for different elements.  If no handler is available the `generic_parse` method is called.  All tagNames specified in `self.ignores` are simply ignored. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::add_text "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.add_text(self, value) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.add_text Adds text corresponding to `value` into `self.pieces`. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::get_specific_nodes "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes(self, node, names) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes Given a node and a sequence of strings in `names`, return a dictionary containing the names as keys and child `ELEMENT_NODEs`, that have a `tagName` equal to the name. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::generic_parse "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse(self, node, pad=0) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse A Generic parser for arbitrary tags in a node.  Parameters:   - node:  A node in the DOM.  - pad: `int` (default: 0)     If 0 the node data is not padded with newlines.  If 1 it    appends a newline after parsing the childNodes.  If 2 it    pads before and after the nodes are processed.  Defaults to    0. 

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::space_parse "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.space_parse(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.space_parse

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_compoundname "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_compounddef "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_includes "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_includes(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_includes

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterlist "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_para "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_para(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_para

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_parametername "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterdefinition "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_detaileddescription "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_briefdescription "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_memberdef "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_definition "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_definition(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_definition

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_sectiondef "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_simplesect "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_argsstring "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_member "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_member(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_member

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_doxygenindex "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_programlisting "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_programlisting(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_programlisting

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_codeline "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_codeline(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_codeline

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::do_highlight "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_highlight(self, node) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.do_highlight

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::write "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.write(self, fname, mode='w') manyo.ConvManyoDoxy2Swig.Doxy2SWIG.write

";
%feature("docstring") manyo::ConvManyoDoxy2Swig::Doxy2SWIG::clean_pieces "manyo.ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces(self, pieces) manyo.ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces Cleans the list of strings given as `pieces`.  It replaces multiple newlines by a maximum of 2 and returns a new list. It also wraps the paragraphs nicely. 

";
