# nexus.spec.  Generated from nexus_spec.in by configure.
# $Id: nexus_spec.in 1827 2012-07-10 12:02:03Z Freddie Akeroyd $
# Template for NeXus RPM SPEC file
# Copyright (C) 2004 Freddie Akeroyd <freddie.akeroyd@stfc.ac.uk>
#
%define depended_by manyo
%define realname nexus
%define mlfsoft_root /opt/mlfsoft
%define install_path %{mlfsoft_root}/manyo
#%%define install_sitearch %{install_path}/lib/python2.7/site-packages
%define for_manyo 1

Summary: Libraries and utilities for using NeXus format data files
Name: %{depended_by}-deps-nexus
Version: 4.4.3
# Release is the number of times this version of the software was 
# built into an RPM file; it should be incremented each RPM build and
# then reset to 1 when a new version of the software is released
Release: 2%{?dist}
License: LGPL
# Group: there is more than one choice for this - maybe we need to split
# nexus into separate packages (libraries + apps)
Group: Development/Libraries
#Source: https://github.com/nexusformat/code/releases/download/4.3.1/nexus-4.3.1.tar.gz
#Source: https://github.com/nexusformat/code/archive/v4.4.3.tar.gz
Source: nexus-%{version}.tar.gz
URL: http://www.nexusformat.org/
Distribution: Unknown
#Icon: nexus.xpm
Vendor: NeXus International Advisory Committee (NIAC)
Packager: NeXus Developers <nexus-developers@nexusformat.org>
# Prefix allows our package to be relocatable i.e. installable in 
# other than just the /usr/local directory
#Prefix: /usr
Prefix: %{install_path}
# BuildRoot is the root for software installation
# this value will not usually be used, but something must
# be specified here to allow   rpm --buildroot   to be used later
# (it will get used for a   rpmbuild --recompile  of the the src.rpm)
%if 0%{?rhel} == 5
%define is_rhel5 1
%endif
%if 0%{?el5}
%define is_rhel5 1
%endif
%if "0%{?dist}" == "0.el5"
%define is_rhel5 1
%endif

%if 0%{?rhel} == 6
%define is_rhel6 1
%endif
%if 0%{?el6}
%define is_rhel6 1
%endif
%if "0%{?dist}" == "0.el6"
%define is_rhel6 1
%endif

%if 0%{?rhel} == 7
%define is_rhel7 1
%endif
%if 0%{?el7}
%define is_rhel7 1
%endif
%if "0%{?dist}" == "0.el7"
%define is_rhel7 1
%endif

#BuildRoot: %{_tmppath}/nexus-4.3.1
#BuildRequires: python numpy
#BuildRequires: manyo-deps-szip
#BuildRequires: java-1.6.0-openjdk-devel
#BuildRequires: doxygen >= 1.8 doxypy graphviz
BuildRequires: manyo-deps-mxml-devel = 2.9
BuildRequires: cmake
BuildRequires: hdf5-devel >= 1.8 hdf5-devel < 1.9
BuildRequires: libxml2-devel
BuildRequires: readline-devel
# Requires TeX Live for pdflatex
# mxml is not in rhel or epel as yet
# ant on rhel5 is too old to build NXvalidate
#BuildRequires: manyo-deps-mxml-devel = 2.9
#BuildRequires: python-ctypes
#Requires: manyo-deps-mxml = 2.9
#Requires: manyo-deps-szip
Requires: coreutils
Requires: hdf5 >= 1.8 hdf5 < 1.9
Requires: manyo-deps-mxml = 2.9

%description
NeXus is an international standard for exchanging data files
among Neutron, Muon and X-ray science facilities. The underlying
data is stored using the HDF format from NCSA. This package provides
access routines, documentation, examples and a basic NeXus file browser.

%package devel
Summary: Libraries and utilities for using NeXus format data files
Group: Development/Libraries
Requires: %{depended_by}-deps-nexus = %{version}-%{release}

%description devel
NeXus is an international standard for exchanging data files
among Neutron, Muon and X-ray science facilities. The underlying
data is stored using the HDF format from NCSA. This package provides

%if !%{for_manyo}
%package tools
Summary: Libraries and utilities for using NeXus format data files
Group: Development/Libraries
Requires: %{depended_by}-deps-nexus = %{version}-%{release}

%description tools
NeXus is an international standard for exchanging data files
among Neutron, Muon and X-ray science facilities. The underlying
data is stored using the HDF format from NCSA. This package provides

%package doc
Summary: Libraries and utilities for using NeXus format data files
Group: Development/Libraries
Requires: nexus = %{version}-%{release}

%description doc
NeXus is an international standard for exchanging data files
among Neutron, Muon and X-ray science facilities. The underlying
data is stored using the HDF format from NCSA. This package provides

%package python
Summary: Libraries and utilities for using NeXus format data files
Group: Development/Libraries
Requires: nexus = %{version}-%{release}

%description python
NeXus is an international standard for exchanging data files
among Neutron, Muon and X-ray science facilities. The underlying
data is stored using the HDF format from NCSA. This package provides

%package java
Summary: Libraries and utilities for using NeXus format data files
Group: Development/Libraries
Requires: nexus = %{version}-%{release}

%description java
NeXus is an international standard for exchanging data files
among Neutron, Muon and X-ray science facilities. The underlying
data is stored using the HDF format from NCSA. This package provides
%endif # !for_manyo

%prep
%setup -q -n code-%{version}

%build
# RPM_INSTALL_PREFIX - where to install software
# do --prefix last in case also present in passed config options
export ac_cv_func_malloc_0_nonnull=yes

# --with-hdf5=/opt/hdf5-1.8.10-patch1.v18 \
# --with-java-home=/usr/lib/jvm/java-1.6.0-openjdk-1.6.0.0.%{_arch} \

mkdir build
cd build
cmake \
  -DCMAKE_INSTALL_PREFIX:PATH=%{install_path} \
  -DENABLE_MXML=1 \
  -DMXML_INCLUDE_DIRS:PATH=%{install_path}/include \
  -DMXML_LIBRARY:FILEPATH=%{install_path}/lib/libmxml.so \
  ..
##if ! test -z "$RPM_INSTALL_PREFIX"; then
##    ./configure \
##        %{?nexus_config_options} \
##        --prefix="$RPM_INSTALL_PREFIX" \
##        --without-doxygen \
##        --without-java \
##        --without-python \
##        LDFLAGS=-pthread
##else
#    ./configure %{?nexus_config_options} \
#        --prefix=%{install_path} \
#        --without-doxygen \
#        --without-java \
#        --without-python \
#        LDFLAGS=-pthread
##fi
make %{?_smp_mflags}

%install
# RPM_BUILD_ROOT is where to install software to
if test "%{buildroot}" != "/"; then rm -fr "%{buildroot}"; fi
cd build
make DESTDIR=%{buildroot} install
find %{buildroot} -name '*.la' -exec rm -f {} \;
rm -r %{buildroot}%{install_path}/share
pushd %{buildroot}%{install_path}
mv -v lib64 lib
cp -av include/nexus/napi* include

%files
%defattr(-,root,root)
#%doc README NEWS ChangeLog AUTHORS COPYING INSTALL
# %docdir /usr/local/doc
#%{_libdir}/libNeXus*.so*
#%{_libdir}/libnxconvert*.so*
#%ifarch x86_64
#/usr/lib/*.so*
#%endif
%dir %{mlfsoft_root}
%dir %{install_path}
%dir %{install_path}/lib
%{install_path}/lib/libNeXus.so
%{install_path}/lib/libNeXus.so.*
#%{install_path}/lib/libnxconvert*.so.*

%files devel
%defattr(-,root,root)
#%{_libdir}/libNeXus*.a
#%{_libdir}/libnxconvert*.a
#%{_libdir}/pkgconfig
#%{_includedir}/*
%dir %{install_path}/lib/pkgconfig
%dir %{install_path}/include
%{install_path}/lib/pkgconfig/*
%{install_path}/include/*
%{install_path}/lib/libNeXus.a

%if !%{for_manyo}
%files tools
%defattr(-,root,root)
%{_bindir}/*
%{_datadir}/man

%files doc
%defattr(-,root,root)
%{_datadir}/nexus

%files python
%defattr(-,root,root)
/usr/lib/python*/site-packages/nxs

%files java
%defattr(-,root,root)
%{_datadir}/java
%{_libdir}/libjnexus.so*
%{_libdir}/libjnexus.a
%endif

%clean
if test "$RPM_BUILD_ROOT" != "/"; then rm -fr "$RPM_BUILD_ROOT"; fi

%post
if test `whoami` = root; then ldconfig; fi

%if !%{for_manyo}
%post tools
if [ "$RPM_INSTALL_PREFIX" != "" ]; then
    INSTALL_PREFIX=$RPM_INSTALL_PREFIX
else
    INSTALL_PREFIX=%{_prefix}
fi

( cd $INSTALL_PREFIX/bin; for i in nxbuild; do \
  sed -i -e "s|^prefix=.*|prefix=$INSTALL_PREFIX|" $i; done )
%endif

%postun
if test `whoami` = root; then ldconfig; fi
#
# %changelog date format as per  `date +"%a %d %b %Y"`
# first line should be   date  user  email

%changelog
* Wed Dec 22 2022 Nobuo Okazaki - 4.4.3-2
- NeXus 4.4.3 does not support mxml-3.x(EPEL), change mxml to manyo-deps-mxml-2.9
* Mon Dec 16 2019 Nobuo Okazaki - 4.4.3-2
- NeXus 4.4.3 does not support mxml-3.x(EPEL), change mxml to utsusemi-deps-mxml-2.9
* Thu Nov 28 2019 Nobuo Okazaki - 4.4.3
- Build for Manyo/Utsusemi without mxml
- Change manyo-deps-mxml to mxml(EPEL)
* Fri Jul 19 2019 Nobuo Okazaki - 4.3.1-2
- Change mxml to manyo-deps-mxml
* Mon Feb 23 2015 Nobuo Okazaki - 4.3.1-1
- Add Requires coreutils for using 'whoami' in post section
* Mon Nov 17 2014 Nobuo Okazaki - 4.3.1-0
- For 4.3.1
* Tue Sep 10 2013 Nobuo Okazaki - manyo-deps
- Built for Manyo local environment
* Tue Mar 19 2013 Nobuo Okazaki - 4.3.0-2
- Add Requires records for devel, tools, doc, python, java subpackages
* Sat Oct 22 2011 Freddie Akeroyd <freddie.akeroyd@stfc.ac.uk> - 4.3.0
- Split into subpackages
* Thu May 24 2007 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk> - 4.0.0
- Tag and build 4.0.0
* Wed May 16 2007 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk> - 4.0rc3
- Tag and build 4.0rc3
* Fri Mar 30 2007 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk> - 4.0rc2
- Tag and build 4.0rc2
* Thu Mar 15 2007 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk> - 4.0rc1
- Tag and build 4.0rc1
* Wed Jul 27 2005 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk>
- Change Copyright: to License: and add PACKAGE_RELEASE
* Mon Jun  6 2005 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk>
- Add extra documentation and example files to distribution
* Wed May 12 2004 Jens Krueger <jens.krueger@frm2.tum.de>
- Change the License entry to LGPL
- remove /usr/local/nexus /usr/local/doc from the file list
* Wed Mar 24 2004 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk>
- Fix up prefix in nxbuild after an install so the RPM is now relocatable
* Sun Feb 22 2004 Freddie Akeroyd <F.A.Akeroyd@rl.ac.uk>
- Initial RPM kit version
