#! /bin/bash

touch brew.log
date >> brew.log

if [[ -a /usr/local/bin/brew ]]
then 
    echo brew found
else
    /usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"
fi

# skip packages installed by other means
brew tap brewsci/homebrew-science
brew install homebrew/core/cmake homebrew/core/doxygen homebrew/core/swig homebrew/core/boost homebrew/core/gsl homebrew/core/libmxml homebrew/core/python2 homebrew/core/numpy homebrew/core/openssl homebrew/core/hiredis homebrew/core/libevent homebrew/core/llvm@6 homebrew/core/libomp brewsci/science/hdf4 homebrew/core/hdf5 2>&1 | tee brew.log

# link openmp capable clang to clang-omp 
if [[ -a /usr/local/bin/clang-omp ]]
then
    echo clang-omp found
else
    ln -s /usr/local/opt/llvm@6/bin/clang /usr/local/bin/clang-omp 
    ln -s /usr/local/opt/llvm@6/bin/clang++ /usr/local/bin/clang-omp++ 
fi

# nexusformat (needs patching to work with newer hdf5)
# see github.com/nexusformat/code/issues/460
if [[ -a /usr/local/bin/nxbrowse ]]
then
    echo nexus found
else
    git clone https://github.com/nexusformat/code # only once
    patch code/src/napi5.c < nexusformat.diff     # only once
    cd code
    mkdir build
    cd build
    export ENABLE_CXX=yes;cmake -DENABLE_APPS=ON -DENABLE_HDF5=1 -DENABLE_HDF4=1 -DENABLE_MXML=1 ..
    make install
fi

