%global srcname kiwisolver
%define mlfsoft_path /opt/mlfsoft
%define install_root %{mlfsoft_path}/utsusemi
%define with_py2 0

Name:           utsusemi-deps-kiwisolver
Version:        1.1.0
Release:        2%{?dist}
Summary:        A fast implementation of the Cassowary constraint solver
License:        BSD
URL:            https://github.com/nucleic/kiwi
Source0:        https://github.com/nucleic/kiwi/archive/%{version}/%{srcname}-%{version}.tar.gz
BuildRequires:  gcc-c++

%description
Kiwi is an efficient C++ implementation of the Cassowary constraint solving \
algorithm. Kiwi is an implementation of the algorithm based on the seminal \
Cassowary paper. It is *not* a refactoring of the original C++ solver. Kiwi has \
been designed from the ground up to be lightweight and fast.

%if %{with_py2}
%package -n utsusemi-deps-python2-kiwisolver
Summary: %{summary}
BuildRequires: python2-devel
BuildRequires: python-setuptools
BuildRequires: python-pytest

%description -n utsusemi-deps-python2-kiwisolver
%{description}
%endif

%package -n utsusemi-deps-python36-kiwisolver
Summary: %{summary}
BuildRequires: python3-devel
BuildRequires: python36-setuptools
BuildRequires: python36-pytest

%description -n utsusemi-deps-python36-kiwisolver
%{description}

%prep
%autosetup -n %{srcname}-%{version}
# Remove bundled egg-info
rm -rf %{srcname}.egg-info

%build
%if %{with_py2}
%py2_build
%endif
%py3_build

%install
#py3_install -- --install-platlib %{install_root}/lib
%if %{with_py2}
%py2_install -- --prefix %{install_root}
%endif
%py3_install -- --prefix %{install_root}
pushd %{buildroot}%{install_root}
mv lib64 lib

%check
#PYTHONPATH="%{buildroot}%{python3_sitearch}" \
#    py.test-3 py/tests/

%if %{with_py2}
%files -n utsusemi-deps-python2-kiwisolver
%dir %{mlfsoft_path}
%dir %{install_root}
%dir %{install_root}/lib
%dir %{install_root}/lib/python2.7
%dir %{install_root}/lib/python2.7/site-packages
%{install_root}/lib/python2.7/site-packages/%{srcname}.so
%{install_root}/lib/python2.7/site-packages/%{srcname}-%{version}-py?.?.egg-info
%endif

%files -n utsusemi-deps-python36-kiwisolver
%dir %{mlfsoft_path}
%dir %{install_root}
%dir %{install_root}/lib
%dir %{install_root}/lib/python3.6
%dir %{install_root}/lib/python3.6/site-packages
%{install_root}/lib/python3.6/site-packages/%{srcname}.cpython-*.so
%{install_root}/lib/python3.6/site-packages/%{srcname}-%{version}-py?.?.egg-info

%changelog
* Fri Nov 22 2019 Nobuo Okazaki - 1.1.0-2.el7
- Built for CentOS 7

* Fri Jul 26 2019 Fedora Release Engineering <releng@fedoraproject.org> - 1.1.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_31_Mass_Rebuild

* Thu May 16 2019 Elliott Sales de Andrade <quantum.analyst@gmail.com> - 1.1.0-1
- Update to latest version

* Sat Feb 02 2019 Fedora Release Engineering <releng@fedoraproject.org> - 1.0.1-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_30_Mass_Rebuild

* Sat Jul 14 2018 Fedora Release Engineering <releng@fedoraproject.org> - 1.0.1-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_29_Mass_Rebuild

* Tue Jun 19 2018 Miro Hrončok <mhroncok@redhat.com> - 1.0.1-2
- Rebuilt for Python 3.7

* Sat Feb 03 2018 Elliott Sales de Andrade <quantum.analyst@gmail.com> - 1.0.1-1
- Initial package.
