%global srcname kiwisolver

Name:           python36-%{srcname}
Version:        1.1.0
Release:        2%{?dist}.mlf
Summary:        A fast implementation of the Cassowary constraint solver
License:        BSD
URL:            https://github.com/nucleic/kiwi
Source0:        https://github.com/nucleic/kiwi/archive/%{version}/%{srcname}-%{version}.tar.gz
BuildRequires:  gcc-c++
BuildRequires:  python3-devel
BuildRequires:  python36-setuptools
BuildRequires:  python36-pytest

%description
Kiwi is an efficient C++ implementation of the Cassowary constraint solving \
algorithm. Kiwi is an implementation of the algorithm based on the seminal \
Cassowary paper. It is *not* a refactoring of the original C++ solver. Kiwi has \
been designed from the ground up to be lightweight and fast.

%prep
%autosetup -n kiwi-%{version}
# Remove bundled egg-info
rm -rf %{srcname}.egg-info

%build
%py3_build

%install
%py3_install

%check
PYTHONPATH="%{buildroot}%{python3_sitearch}" \
    py.test-3 py/tests/

%files -n python36-%{srcname}
%doc README.rst
%license LICENSE
%{python3_sitearch}/%{srcname}.cpython-*.so
%{python3_sitearch}/%{srcname}-%{version}-py?.?.egg-info

%changelog
* Fri Nov 22 2019 Nobuo Okazaki - 1.1.0-2.el7.mlf
- Built for CentOS 7

* Fri Jul 26 2019 Fedora Release Engineering <releng@fedoraproject.org> - 1.1.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_31_Mass_Rebuild

* Thu May 16 2019 Elliott Sales de Andrade <quantum.analyst@gmail.com> - 1.1.0-1
- Update to latest version

* Sat Feb 02 2019 Fedora Release Engineering <releng@fedoraproject.org> - 1.0.1-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_30_Mass_Rebuild

* Sat Jul 14 2018 Fedora Release Engineering <releng@fedoraproject.org> - 1.0.1-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_29_Mass_Rebuild

* Tue Jun 19 2018 Miro Hrončok <mhroncok@redhat.com> - 1.0.1-2
- Rebuilt for Python 3.7

* Sat Feb 03 2018 Elliott Sales de Andrade <quantum.analyst@gmail.com> - 1.0.1-1
- Initial package.
