#!/bin/bash
# Setup SPEC and source files for Dockerfile
set -e
SRCBASE=$(cd $(dirname $0); pwd)/src
TOOL=$(cd $(dirname $0); pwd)/tools
URLBASE=https://download.mlf.io/pub/utsusemi/build-deps/4.0.0
SPECBASE=contrib/4.0.0/rpm

echo "Setting up SPEC and Manyo/Utsusemi source files to $SRCBASE ..."
echo

mkdir -p $SRCBASE
cp -f $TOOL/mkpkg $SRCBASE

# Sources for Manyo
mkdir -p $SRCBASE/utsusemi-deps-nexus
$TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi-deps-nexus-4.4.3.spec $SRCBASE/utsusemi-deps-nexus

mkdir -p $SRCBASE/utsusemi-deps-manyo
$TOOL/archive-get mlfcomp/manyo master $SRCBASE/utsusemi-deps-manyo
$TOOL/spec-get mlfcomp/manyo master contrib/rpm/manyo-do_make_Manyo.py-stop_on_error.patch $SRCBASE/utsusemi-deps-manyo
$TOOL/spec-get mlfcomp/manyo master contrib/rpm/manyo-py2and3-Makefiles.patch $SRCBASE/utsusemi-deps-manyo
$TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi-deps-manyo.spec $SRCBASE/utsusemi-deps-manyo

# Sources for Utsusemi
for n in cycler kiwisolver matplotlib; do
  mkdir -p $SRCBASE/utsusemi-deps-$n
  $TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi-deps-${n}.spec $SRCBASE/utsusemi-deps-$n
done

mkdir -p $SRCBASE/utsusemi4
$TOOL/archive-get mlfcomp/Utsusemi master $SRCBASE/utsusemi4
$TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi4.spec $SRCBASE/utsusemi4
$TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi4-bashrc.py3.ALL.patch $SRCBASE/utsusemi4
$TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi4-do_make_Utsusemi.py-stop_on_error.patch $SRCBASE/utsusemi4
$TOOL/spec-get mlfcomp/Utsusemi master $SPECBASE/utsusemi4-Makefile.patch $SRCBASE/utsusemi4

echo "Finished."
echo '*********************************************************'
echo "  Now, ready for building utsusemi-builder docker image!!"
echo
echo "  Command line example:"
echo "      docker build -t utsusemi-builder ."
echo 
echo "  Enjoy!!"
echo '*********************************************************'

