# -*- coding: utf-8 -*-
"""

"""

import time
import uGao.MPlot as mp
import uGao.M2PlotPlusCui as mp2
import Manyo

# 予約語の定義
ret = None 
vp1 = None
vp2 = None
vc = None
vc2 = None
vc3 = None
ec = None
earray = None
DAT = None
ECM = None
ECA = None
vcm = None
        
###################################################                            
def DetectMap(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT] ElementContainerMatrix Object 
        @retval vp3
        """
        vp3=mp2.M2PlotPlusCui(matrix)
        vp3.ShowData()
        num_x=matrix.PutSize()
        num_y=matrix(0).PutSize()
        width = int( 1000 )
        height = int( float(width) * float(num_y)/float(num_x) )
        vp3.SetWindowSize( width, height )
        return vp3

###################################################
def DetectMapChangeData(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT] ElementContainerMatrix Object
        @retval vp3
        """
        vp3.ChangeData(matrix)
        

###################################################                         
def MPlot(ec=ec):
        """
        Create 1D Plotter and Draw EC
        @param  ec [Def:EC]  ElementContainer
        @param  psd      PSD No.    
        @param  pixel    Pixel No.    
        @retval vp1    Instance of Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp.MPlot(ec, True)
    
###################################################                            
def AddToMPlot(vp1=vp1, ec=ec):
        """
        Add EC to 1D Plotter
        @param  vp1 [Def:vp1]     Instance of 1D Plotter
        @param  ec [Def:EC]      ElementContainer
        @retval None
        """ 
        vp1.AddData(ec)  
        
###################################################                         
def M2PlotPlus(matrix=ECA):
        """
        Create 2D Plotter and display 2D Map
        @param  matrix [Def:ECA]  ElementContainerArray
        @retval vp2 [Def:vp2]  Instance of 2D Plotter
        """ 
        # 親プロセス終了時に、プロッタを終了      
        return mp2.M2PlotPlusCui(matrix)

###################################################
def ChangeDataM2Plot(vp2=vp2, matrix=ECA):
        """
        Change 2D Map of M2Plot
	@param  vp2 [Def:vp2]     Instance of 2D Plotter
        @param  matrix [Def:ECA]  ElementContainerArray
        @retval None
        """ 
        # Map データの変更
        if isinstance(matrix,Manyo.ElementContainerMatrix):
                vp2.ChangeData(matrix.Put(0))
        elif isinstance(matrix,Manyo.ElementContainerArray):
                vp2.ChangeData(matrix)
        else:
                return


           

# 関数名登録ディクショナリ
_functions = {"DetectMap":DetectMap,
              "DetectMapChangeData":DetectMapChangeData,
              "MPlot":MPlot,
              "AddToMPlot":AddToMPlot,
              "M2PlotPlus":M2PlotPlus,
	      "ChangeDataM2Plot":ChangeDataM2Plot
	      }

_functionsOrder = [
	"DetectMap",
        "DetectMapChangeData",
	"MPlot",
	"AddToMPlot",
	"M2PlotPlus",
	"ChangeDataM2Plot"
	]
         
