#!/usr/bin/python3
# -*- coding: utf-8 -*-

import utsusemi.SAS.ana.Reduction.HistBaseCommands as HBC

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
ret = None
PyObj = None
Iq = None
Tr = None


########################################
def GetHistogramSAS( runNo=0, Xrange="0.7 7.6 0.1 dL", Bank="SM", TimeSlice="-1 -1", frameBoundary="0.0", isTimeFoc=False, SolAngCor=True, paramFiles="- -" ):
    """
    Load EventData to produce histogram
    GetHistogramSAS( runNo=0, AxType="lambda", Xrange="0.7 7.7 0.05", Bank="SM", TimeSlice="-1 -1", frameBoundary="0.0", isTimeFoc=False )
    
    @param runNo     (int)     Run Number
    @param Xrange    (string)  "startX endX widthX type" separated with space (not comma) : type=[dL, dL/L, tof, d]
    @param Bank      (string)  "SM"...  Monitors by "MON1" or "MON2"
    @param TimeSlice (string)  "startTime endTime" separated with space: "-1 -1" means no-setting.
    @param frameBoundary (string) "frameBoundary" or "frameBoundary TofMask_min TofMask_max"
    @param isTimeFoc (bool)    True or False
    @param SolAngCor  (bool)    True or False for Solid Angle Correction
    @param paramFiles (string) "WiringInfo DetectorInfo"
    @retval DAT (ElementContainerMatrix)
    """
    return HBC.GetHistogramSAS( runNo, Xrange, Bank, TimeSlice, frameBoundary, isTimeFoc, SolAngCor, paramFiles )

########################################
def GetMonHistSAS( runNo=0, MonNo=1, AxType="lambda", Xrange="0.7 7.6 0.1", MonIndex=0, TimeSlice="-1 -1", frameBoundary="0.0", CalibEffi=True ):
    """
    Load EventData to produce histogram of monitors
    GetMonHistSAS( runNo=0, MonNo=1, AxType="lambda", Xrange="0.7 7.7 0.05", MonIndex=0, TimeSlice="-1 -1", frameBoundary="0.0", CalibEffi=True )
    
    @param runNo     (int)     Run Number
    @param MonNo     (int)     Monitor Number 1 (up-stream) or 2 (down-stream)
    @param AxType    (string)  Type must be "tof', "lambda" or "lamda2"
    @param Xrange    (string)  "startX endX widthX" separated with space (not comma)
    @param MonIndex  (int)     
    @param TimeSlice (string)  "startTime endTime" separated with space: "-1 -1" means no-setting.
    @param frameBoundary (string) "frameBoundary" or "frameBoundary TofMask_min TofMask_max"
    @param CalibEffi (bool)    Monitor-detector efficiency calibration
    @retval EC (ElementContainer)
    """
    return HBC.GetMonHistSAS( runNo, MonNo, AxType, Xrange, MonIndex, TimeSlice, frameBoundary, CalibEffi )

########################################
def GetPulseHeightSAS( runNo=0, Xrange="0 40000 100", Bank="SM", TimeSlice="-1 -1", frameBoundary="0.0", paramFiles="- -",PHbin=5 ):
    """
    Make Pulse Height data of EventData
    GetPulseHeightSAS( runNo=0, Xrange="0 10000 10", Bank="SM", TimeSlice="-1 -1", paramFiles="- -" ):
    
    @param runNo     (int)     Run Number
    @param Xrange    (string)  "startX endX widthX type" separated with space (not comma) : type=[dL, dL/L, tof, d]
    @param Bank      (string)  "SM"...  Monitors by "MON1" or "MON2"
    @param TimeSlice (string)  "startTime endTime" separated with space: "-1 -1" means no-setting.
    @param frameBoundary (string) "frameBoundary" or "frameBoundary TofMask_min TofMask_max"
    @param paramFiles (string) "WiringInfo DetectorInfo"
    @param PHbin      (int)    Pulse Height bin
    @retval ECM (ElementContainerMatrix)
    """
    return HBC.GetPulseHeightSAS( runNo, Xrange, Bank,TimeSlice, frameBoundary, paramFiles, PHbin)

########################################
def GetMonHistByPhSAS( runNo=0, MonNo=1, Xrange="0.0 40000.0 10.0 tof", phRange="0 10000", MonIndex=0, TimeSlice="-1 -1", frameBoundary=0.0, CalibEffi=True ):
    """
    Load EventData to produce histogram of monitors limited by pulse height
    GetMonHistByPhSAS( runNo=0, MonNo=1, Xrange="0.0 40000.0 10.0 tof", phRange="0 10000", MonIndex=0, TimeSlice="-1 -1", frameBoundary=0.0, CalibEffi=True )
    
    @param runNo     (int)     Run Number
    @param MonNo     (int)     Monitor Number 1 (up-stream) or 2 (down-stream)
    @param Xrange    (string)  "startX endX widthX type" separated with space (not comma) : type=[dL, dL/L, tof, d]
    @param phRange   (string)  "lld hld" 
    @param MonIndex  (int)     0.. digital  1.. analog
    @param TimeSlice (string)  "startTime endTime" separated with space: "-1 -1" means no-setting.
    @param frameBoundary (float) 
    @param CalibEffi (bool)    Monitor-detector efficiency calibration
    @retval EC (ElementContainer)
    """
    return HBC.GetMonHistByPhSAS( runNo, MonNo, Xrange, phRange, MonIndex, TimeSlice, frameBoundary, CalibEffi )

########################################
def MergeSMSC4DetMap(dat=DAT):
    """ 
    Merge Data SM and SC bank into one ElementContainerMatrix 
    to plot using DetectMap
    @param dat  [Def:DAT] (ElementContainerMatrix) 
    @retval ECM (ElementContainerMatrix)
    """
    return HBC.MergeSMSC4DetMap(dat)

########################################
def GetHistogramRPMT( runNo=0, isLambda=True ):
    """
    Load EventData to produce histogram
    GetHistogramSAS( runNo=0, AxType="lambda", Xrange="0.7 7.7 0.05", Bank="SM", TimeSlice="-1 -1", frameBoundary=0.0, isTimeFoc=False )
    
    @param runNo     (int)     Run Number
    @retval DAT (ElementContainerMatrix)
    """
    return HBC.GetHistogramRPMT( runNo, isLambda )

########################################
def RPMTRemoveCenterLine( dat=DAT, PsdRange="200 201", PixelRange="198 199" ):
    """ 
    Merge Data SM and SC bank into one ElementContainerMatrix 
    to plot using DetectMap
    @param dat  [Def:DAT] (ElementContainerMatrix) 
    @param PsdRange
    @param PixelRange
    @retval None
    """
    HBC.RPMTRemoveCenterLine( dat, PsdRange, PixelRange )
     
    
########################################
# Dictionary for entry the name of functions
_functions = {
            "GetHistogramSAS":GetHistogramSAS,
            "GetMonHistSAS":GetMonHistSAS,
            "GetPulseHeightSAS":GetPulseHeightSAS,
            "GetMonHistByPhSAS":GetMonHistByPhSAS,
            "MergeSMSC4DetMap":MergeSMSC4DetMap,
            "GetHistogramRPMT":GetHistogramRPMT,
            "RPMTRemoveCenterLine":RPMTRemoveCenterLine
            }
_functionsOrder = [
    "GetHistogramSAS",
    "GetMonHistSAS",
    "GetPulseHeightSAS",
    "GetMonHistByPhSAS",
    "MergeSMSC4DetMap",
    "GetHistogramRPMT",
    "RPMTRemoveCenterLine"
    ]
    
