#ifndef SASDETECTORINFOEDITORRPMT
#define SASDETECTORINFOEDITORRPMT

#include "UtsusemiDetectorInfoEditorNeunet.hh"

class DetectorInfoTagDefineSAS:
    public DetectorInfoTagDefineBase
{
public:
    DetectorInfoTagDefineSAS();
        //!< Constructor
        /*!<
         */
    ~DetectorInfoTagDefineSAS();
        //!< Destructor
        /*!<
         */
    static const std::string DINFO_INSTRINFO_SASRPMT;
    static const std::string DINFO_INSTRINFO_SASRPMT_NUMLINES;
    static const std::string DINFO_INSTRINFO_SASRPMT_BINWIDTH;
    static const std::string DINFO_INSTRINFO_SASRPMT_SIZEXCH;
    static const std::string DINFO_INSTRINFO_SASRPMT_SIZEYCH;
    static const std::string DINFO_INSTRINFO_SASRPMT_XCHSHIFT;
    static const std::string DINFO_INSTRINFO_SASRPMT_YCHSHIFT;
    static const std::string DINFO_INSTRINFO_SASRPMT_PHRANGEX;
    static const std::string DINFO_INSTRINFO_SASRPMT_PHRANGEY;
    static const std::string DINFO_INSTRINFO_SASRPMT_IGRAVITYPARAM;
};

class SASDetectorInfoInstRPMT:
    public UtsusemiDetectorInfoInstInfo
{
public:
    SASDetectorInfoInstRPMT();
    SASDetectorInfoInstRPMT( const SASDetectorInfoInstRPMT& obj );
    ~SASDetectorInfoInstRPMT();
    UInt4 numOfLines;
    UInt4 binWidth;
    UInt4 sizeXch;
    UInt4 sizeYch;
    Int4 XchShift;
    Int4 YchShift;
    std::pair<UInt4,UInt4> PHRangeX;
    std::pair<UInt4,UInt4> PHRangeY;
    Double incidentGravityParam;
    void Dump();
};

//////////////////////////////////
// SASDetectorInfoEditorRPMT
/////////////////////////////////

//!
/*!
 *
 */
class SASDetectorInfoEditorRPMT:
    public UtsusemiDetectorInfoEditorNeunet
{
private:
    std::string _MessageTag;
    StringTools* _st;
    Double _bcX;
    Double _bcY;
    Double _rotAng;
    Double _unitPixelSizeX;
    Double _unitPixelSizeY;
    std::string _KEY_READ_XML;
    std::string _KEY_WRITE_XML;

protected:
    void Initialize();
    DetectorInfoTagDefineSAS TAGSAS;
    void _makeInstSASRPMTInfo();

public:

    SASDetectorInfoEditorRPMT();
        //!< Constructor
        /*!<
         */
    SASDetectorInfoEditorRPMT( std::string dfile, bool workAsReader=true );
        //!< Constructor
        /*!<
         *   @param dfile (std::string) DetectorInfo file path to be read
         *   @param workAsReader (bool)
         */
    ~SASDetectorInfoEditorRPMT();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////
    SASDetectorInfoInstRPMT* _instRPMT;

    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    void Clear( UInt4 index=0 );
        //!< Clears stored parameters
        /*!<
         *   This deletes information by given index.
         *    index = 0 : all (default)
         *    index = 1 : InstrumentInfo
         *    index = 2 : TfpInfo
         *    index = 3 : TfpCalcParams
         *    index = 4 : PositionInfo
         *    index = 5 : BankInfo
         *
         *   @param index (UInt4)
         *   @return None
         */
    bool Read( std::string arg );
        //!< Reads DetectorInfo.xml and import information
        /*!<
         *   @param arg (std::string) path/to/DetectorInfo.xml or DetectorInfo as std::string
         *   @retval true : succeeded
         *   @retval false: failed
         */
    bool Write( std::string filepath );
        //!< Writes DetectorInfo.xml
        /*!<
         *   @param filepath (std::string)
         *   @retval true : succeeded
         *   @retval false: failed
         */
    std::string OutXml( bool withIndent=false );
        //!< Returns DetectorInfo as std::string
        /*!<
         *   @param withIndent(bool) false : output text without an indent format
         *   @return std::string
         */
    bool _makeOutputXmlSASRPMTInfo();
        //!< Makes XML format from stored information
        /*!<
         *   @param  None
         *   @retval true    succeded
         *   @retval false   failed
         */
    void ImportInstSASRPMTInfo();
    void Dump();
    bool SetBeamCenterPixel( Double x, Double y );
    bool SetRotateAngle( Double ang );
    bool SetChannelShift( Int4 x, Int4 y);
    bool SetIncidentGravityParam( Double b );
    bool _convPositionInfo();

    UInt4 PutNumOfLines();
    UInt4 PutBinWidth();
    UInt4 PutSizeXch();
    UInt4 PutSizeYch();
    Int4 PutXchShift();
    Int4 PutYchShift();
    std::pair<UInt4,UInt4> PutPHRangeX();
    std::pair<UInt4,UInt4> PutPHRangeY();
    Double PutIncidentGravityParam();
    Double PutL2();

    Double PutPixelSizeX(){ return _unitPixelSizeX; }
    Double PutPixelSizeY(){ return _unitPixelSizeY; }

};
#endif
