#ifndef CORRECTEVENTRPMT
#define CORRECTEVENTRPMT

#include "Header.hh"
#include "UtsusemiHeader.hh"

#ifdef _MSC_VER
    #include "msvc/dirent.h"
#else
#include <dirent.h>
#endif

/////////////////////////////
// CorrectEventRPMT
////////////////////////////

//! Function to remove noise events with 4byte from RPMT event data file
/*!
 *
 *
 *
 *
 */

class CorrectEventRPMT
{
private:
    std::string _orgDataDir;
    std::vector<std::string> _targetFiles;
public:
    CorrectEventRPMT();
    ~CorrectEventRPMT();

    bool SetTarget( std::string dataDir, UInt4 runNO, UInt4 daqId, UInt4 modNo, std::string instCode="SAS", std::string ext_code="edb");
    bool Execute( std::string dataDir, UInt4 convRunNo, std::string instCode="SAS", std::string ext_code="edb" );

};
#endif

