#include "CorrectEventRPMT.hh"
//////////////////////////////////////////////////////////
CorrectEventRPMT::
CorrectEventRPMT()
{
}
//////////////////////////////////////////////////////////
CorrectEventRPMT::
~CorrectEventRPMT()
{
}
//////////////////////////////////////////////////////////
bool CorrectEventRPMT::
SetTarget( std::string dataDir, UInt4 runNo, UInt4 daqId, UInt4 modNo, std::string instCode, std::string ext_code)
{
    DIR *dpath;
    if ((dpath=opendir(dataDir.c_str()))==NULL){
        std::cout << "SetTarget : not found dataDir= "+dataDir << std::endl;
        return false;
    }

    std::vector<std::string> _taragetFiles;
    _targetFiles.clear();
    struct dirent *dp;
    while((dp=readdir(dpath))!=NULL){
        std::string tmp( dp->d_name );
        std::cout << "file="+tmp << std::endl;
        char rootName_c[256];
        std::snprintf(rootName_c,sizeof(rootName_c),"%3s%06d_%02d_%03d", instCode.c_str(), runNo, daqId, modNo );
        std::string rootName(rootName_c);
        std::string::size_type ind1 = tmp.find( rootName );
        std::string::size_type ind2 = tmp.find( ext_code );
        if ((ind1!=std::string::npos)&&(ind2!=std::string::npos)&&(tmp.size()==24))
            _targetFiles.push_back(tmp);
    }

    if (_targetFiles.empty()){
        std::cout << "SetTarget : File not found"<<std::endl;
        _orgDataDir="";
        return false;
    }

    sort( _targetFiles.begin(), _targetFiles.end() );
    _orgDataDir=dataDir;

    return true;
}
//////////////////////////////////////////////////////////
bool CorrectEventRPMT::
Execute( std::string dataDir, UInt4 convRunNo, std::string instCode, std::string ext_code )
{
    if (_orgDataDir==""){
        return false;
    }

    std::vector<FILE*> fp_list( _targetFiles.size() );
    for (UInt4 i=0;i<_targetFiles.size();i++){
        std::string fname = _orgDataDir+"/"+_targetFiles[i];
        if (NULL==(fp_list[i]=fopen( fname.c_str(),"rb"))){
            std::cout << "Execute : can not open file="+fname << std::endl;
            return false;
        }
    }

    std::vector<std::string> _saveFiles( _targetFiles.size() );
    std::vector<FILE*> fo_list(_targetFiles.size() );
    for (UInt4 i=0; i<_saveFiles.size(); i++){
        char tmp_c[40];
        std::snprintf(tmp_c,sizeof(tmp_c),"%3s%06d%s.%s",instCode.c_str(),convRunNo,_targetFiles[i].substr(9,11).c_str(),ext_code.c_str());
        std::string tmp(tmp_c);
        std::string fname = dataDir+"/"+tmp;
        if (NULL==(fo_list[i]=fopen( fname.c_str(),"wb"))){
            std::cout << "Execute : can not open file="+fname << std::endl;
            return false;
        }
        _saveFiles[i] = fname;
    }
    for (UInt4 i=0; i<_saveFiles.size(); i++){
        std::cout << _orgDataDir+"/"+_targetFiles[i]+" -->> "+_saveFiles[i] <<std::endl;
    }

    UChar* buf1 = new UChar[4];
    UChar* buf2 = new UChar[4];
    UInt4 ind = 0;
    UInt4 i=0;
    bool isFileEnd=false;
    std::cout << _orgDataDir+"/"+_targetFiles[ind]+" -->> "+_saveFiles[ind] <<std::endl;
    UInt4 b7count=0;
    while(true){
        i=fread(buf1,4,1,fp_list[ind]);
        if (i!=1){
            if (ind==(fp_list.size()-1)){
                isFileEnd=true;
                break;
            }else{
                ind++;
                std::cout << _orgDataDir+"/"+_targetFiles[ind]+" -->> "+_saveFiles[ind] <<std::endl;
                i=fread(buf1,4,1,fp_list[ind]);
                if (i!=1){
                    isFileEnd=true;
                    break;
                }
            }
        }
        if (isFileEnd) break;

        if ((buf1[0]==0xb7)||(buf1[0]==0xb5)){
        }else{
            std::cout << "BUG FOUND" << std::endl;
            while(true){
                i=fread(buf1,4,1,fp_list[ind]);
                if (i!=1){
                    if (ind==(fp_list.size()-1)){
                        isFileEnd=true;
                        break;
                    }else{
                        ind++;
                        std::cout << _orgDataDir+"/"+_targetFiles[ind]+" -->> "+_saveFiles[ind] <<std::endl;
                        i=fread(buf1,4,1,fp_list[ind]);
                        if (i!=1){
                            isFileEnd=true;
                            break;
                        }
                    }
                }
                if ((buf1[0]==0xb7)||(buf1[0]==0xb5)) break;
            }

        }
        if (isFileEnd) break;

        i=fread(buf2,4,1,fp_list[ind]);
        if (i!=1){
            if (ind==(fp_list.size()-1)){
                isFileEnd=true;
                break;
            }else{
                ind++;
                std::cout << _orgDataDir+"/"+_targetFiles[ind]+" -->> "+_saveFiles[ind] <<std::endl;
                i=fread(buf2,4,1,fp_list[ind]);
                if (i!=1){
                    isFileEnd=true;
                    break;
                }
            }
        }else{
            if ((buf2[0]==0xb7)||(buf2[0]==0xb5)){
                std::cout << "BUG FOUND" << std::endl;
                memcpy(buf1,buf2,4);
                i=fread(buf2,4,1,fp_list[ind]);
                if (i!=1){
                    if (ind==(fp_list.size()-1)){
                        isFileEnd=true;
                        break;
                    }else{
                        ind++;
                        std::cout << _orgDataDir+"/"+_targetFiles[ind]+" -->> "+_saveFiles[ind] <<std::endl;
                        i=fread(buf2,4,1,fp_list[ind]);
                        if (i!=1){
                            isFileEnd=true;
                            break;
                        }
                    }
                }
            }
        }
        if (isFileEnd) break;
        if (buf1[0]==0xb7) b7count++;
        std::fwrite(buf1,1,4,fo_list[ind]);
        std::fwrite(buf2,1,4,fo_list[ind]);
    }

    for (UInt4 i=0;i<(fo_list.size());i++){
        fclose( fp_list[i] );
        fclose( fo_list[i] );
    }

    delete [] buf1;
    delete [] buf2;
    std::cout << "b7 count="<<b7count<<std::endl;
    return true;
}
