#include "EmakiDetectorInfoEditorReadout.hh"
//////////////////////////////////////////////////////////
EmakiDetectorInfoEditorReadout::
EmakiDetectorInfoEditorReadout()
{
    Initialize();
}
//////////////////////////////////////////////////////////
EmakiDetectorInfoEditorReadout::
EmakiDetectorInfoEditorReadout( std::string dfile, bool workAsReader){
    Initialize();
    if ( Read(dfile) ){
        if (workAsReader){
            if (SetInfoAsReader()) _Status=true;
            else _Status = false;
        }
    }else{
        std::cout <<_MessageTag+"constructor Base:Read fails"<<std::endl;
        _Status=false;
    }
}
//////////////////////////////////////////////////////////
EmakiDetectorInfoEditorReadout::
~EmakiDetectorInfoEditorReadout()
{
    Clear(0);
    ClearReader(0);
    delete stools;
}

//////////////////////////////////////////////////////////
void EmakiDetectorInfoEditorReadout::
Initialize(){
    _MessageTag = "EmakiDetectorInfoEditorReadout::";
    stools = new StringTools();
}
//////////////////////////////////////////////////////////
void EmakiDetectorInfoEditorReadout::
Clear( UInt4 index ){
    DetectorInfoEditorBase::Clear(index);
}
//////////////////////////////////////////////////////////
bool EmakiDetectorInfoEditorReadout::
Read( std::string filepath ){
    /*
    if (DetectorInfoEditorBase::Read(filepath)){
        // required only for NEUNET
        _Status = true;
    }
    return _Status;
    */
    _Status = false;
    _detectorFilePath = "";
    _parser->Clear();
    if (_parser->Load( KEY_READ_XML, filepath )){

        InstCode = _parser->PutContent( KEY_READ_XML, TAG.DINFO, TAG.DINFO_AT_INST );
        Version = _parser->PutContent( KEY_READ_XML, TAG.DINFO, TAG.DINFO_AT_VER );
        Update = _parser->PutContent( KEY_READ_XML, TAG.DINFO, TAG.DINFO_AT_DATE );


        ImportTfpInfo();
        if (_Status){
            ImportInstInfo();
            if (!_Status)
                UtsusemiError(_MessageTag+"::Read >> failed to import InstInfo ");
        }else{
            UtsusemiError(_MessageTag+"::Read >> failed to import TfpInfo ");
        }
    }else{
        UtsusemiError( _MessageTag+"::Read >> failed to open file = "+filepath );
    }
    _isReadXml = _Status;
    _detectorFilePath = filepath;
    return _Status;
}
//////////////////////////////////////////////////////////
bool EmakiDetectorInfoEditorReadout::
Write( std::string filepath ){
    if (_makeOutputXmlReadout()){
        // required only for Readout
        _parser->Save( KEY_WRITE_XML, filepath );
    }else{
        std::cout << "Write : false to make output XML from given information. " << std::endl;
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
bool EmakiDetectorInfoEditorReadout::
_makeOutputXmlReadout(){
    if (DetectorInfoEditorBase::_makeOutputXml()){
        // codes for Readout Emaki
    }else{
        std::cout << _MessageTag+"_makeOutputXmlReadout >> _makeOutputXml fails" << std::endl;
        return false;
    }
    return true;
}
//////////////////////////////////////////////////////////
void EmakiDetectorInfoEditorReadout::
ClearReader( UInt4 index ){
    DetectorInfoEditorBase::ClearReader(index);

}
//////////////////////////////////////////////////////////
bool EmakiDetectorInfoEditorReadout::
SetInfoAsReader(){
    ClearReader(0);
    if (DetectorInfoEditorBase::SetInfoAsReader()){
        // required for Emaki
        return ImportEfficiency();

    }else{
        std::cout << _MessageTag+"SetInfoAsReader : fails to do Base::SetInfoAsReader "<< std::endl;
        return false;
    }

}

//////////////////////////////////////////////////////////
bool EmakiDetectorInfoEditorReadout::
ImportEfficiency(){
    bool ret = false;
    efficiencyParam.clear();

    UInt4 num_of_param(0);
    //num_of_param = stools->StringToUInt4(_parser->PutContent(KEY_READ_XML, TAG.DINFO+"/efficiency", "n"));
    boost::property_tree::ptree* curNode = _parser->PutNode(TAG.DINFO+"/efficiency","");
    std::vector<boost::property_tree::ptree*> effparams = _parser->PutFoundChildNodes( curNode, "param" );
    num_of_param = effparams.size();
    std::cout << _MessageTag << "Num of efficiency: " << num_of_param << std::endl;

    //std::vector<Double> temp(2, 0.0);
    //temp[1] = 1.0;
    UInt4 MaxPixelId = num_of_param-1;
    if (num_of_param == 0){
        return ret;
    }
    efficiencyParam.resize(num_of_param, 1.0);
    for (UInt4 i=0; i<num_of_param; ++i){
        //std::string tag = TAG.DINFO + "/efficiency/param,i=" + stools->UInt4ToString(i) ;
        //UInt4 pixelId = stools->StringToUInt4(_parser->PutContent(KEY_READ_XML, tag,"pixId" ));
        std::string tag = "param,i=" + stools->UInt4ToString(i);
        boost::property_tree::ptree* curNode2 = _parser->PutNode(curNode,tag,"");
        UInt4 pixelId = stools->StringToUInt4(_parser->PutContent(curNode2, "","pixId" ));
        if (MaxPixelId < pixelId){
            MaxPixelId = pixelId;
            efficiencyParam.resize(MaxPixelId+1, 1.0);
        }
        //efficiencyParam[pixelId] = stools->StringToDouble(_parser->PutContent(KEY_READ_XML, tag, ""));
        efficiencyParam[pixelId] = stools->StringToDouble(_parser->PutContent(curNode2, "",""));
    }
    return true;
}
