#!/usr/bin/python
# -*- coding: utf-8 -*-

from __future__ import print_function
#import time,sys,os,math,glob,datetime,re,urllib,httplib,socket
import time,sys,os,math,glob,datetime,re,urllib,socket
import Manyo as mm
import Manyo.Utsusemi as mu
import Manyo.DNA as md

import utsusemi.ana.Reduction.BaseCommandsInEla as BaseCom
import utsusemi.DNA.ana.Reduction.PeakFit as PF
import shutil
ver = float(sys.version_info[0])+float(sys.version_info[1])*0.1
if ver<2.5:
    from elementtree.ElementTree import ElementTree
else:
    from xml.etree.ElementTree import ElementTree

from utsusemi.DNA.ana.Reduction.DefaultInstParams import *
socket.setdefaulttimeout(1)
#------------------------------------------------------------------------------------------------------------

#------------------------------------------------------------------------------------------------------------
def CheckSampleTempByRunNumber(runNo,temptype): 
        """ 
         Check Sample Temperature by using LakeShore-340 
         @param runNo      (int) 
         @param temptype   (string) 
         @retval EC        (ElementContainer) 
 
        """ 
        TimeParam="-1.0,-1.0" 
        
        from utsusemi.DNA.ana.Reduction.BaseCommandsDNA import CheckRealTime
        startday,starttime,endday,endtime = CheckRealTime(runNo,TimeParam) 
        
        CopyLogFile(startday,endday) 
        import utsusemi.DNA.ana.Reduction.TempMonitor as TM 
        resultEC = TM.CheckSampleTemp(startday,starttime,endday,endtime,temptype,True) 
        resultEC.AddToHeader("RUNNUMBER",str(runNo)) 
        return resultEC
#------------------------------------------------------------------------------------------------------------
def CopyLogFile(startday,endday):

    filename = 'Log_TC_'

    filename1 = filename + startday + ".csv"
    filename2 = filename + endday + ".csv"
    
    orgdatapath = os.path.join(os.environ["UTSUSEMI_DATA_DIR"],"LS340Log")
    #savedatapath = os.path.join(os.environ["HOME"],"ana","tmp")
    savedatapath = os.path.join(mu.UtsusemiEnvGetUserDir(),"ana","tmp")
    
    orgfile1 = os.path.join(orgdatapath,filename1)
    savefile1 = os.path.join(savedatapath,filename1)

    orgfile2 = os.path.join(orgdatapath,filename2)
    savefile2 = os.path.join(savedatapath,filename2)

    cmdheader = "LS340ASMWLogReader >>"
    
    print("%s >> CopyLogFile start" %(cmdheader))
    
    if (not os.path.exists(savefile1) or (os.path.getmtime(savefile1)<os.path.getmtime(orgfile1))):
        print("%s >> Copy %s to %s start" %(cmdheader, orgfile1, savefile1))
        shutil.copy2(orgfile1,savefile1)
    
    else:
        print("%s >> %s is ready for read." %(cmdheader,savefile1))

    if (startday != endday):
        if (not os.path.exists(savefile2) or (os.path.getmtime(savefile2)<os.path.getmtime(orgfile2))):
            print("%s >> Copy %s to %s start" %(cmdheader, orgfile2, savefile2))
            shutil.copy2(orgfile2,savefile2)
        else:
            print("%s >> %s is ready for read." %(cmdheader,savefile1))
    print("%s >> CopyLogFile end" %(cmdheader))

    return
#------------------------------------------------------------------------------------------------------------
