#! /usr/bin/env python
# -*- coding:utf-8 -*-
import Tkinter
import datetime
import time
import os
import shutil
import Manyo as mm
import Cmm
import vis.MPlot as MP
import vis.M2Plot as MP2
import ElasticScanGUIBase as ESB
import T0fileMake as T0M
import subprocess
import ElasticScan 

CommentHeader = "ESCUI -->>  "

def StartElasticScan(RunNo, TimeParam):
    Ebin = 0.002
    Emin = -0.004
    Emax = 0.004
    Qmin = 0.0
    Qmax = 2.0
    Qbin = 0.05 
    LambdaCenter = 6.321
    dLambda = 4.15
    Tch = "D5"
    inifile = "ESCUIParams.ini"

    HWParam ="%.4f,%4f,%.6f" %(Ebin,Emin,Emax)
    HWParam2 ="%.4f,%4f" %(Emin,Emax)
    QParam = "%.2f,%.2f,%s" %(Qmin,Qmax,Qbin)
    LambdaParam = "%.4f,%.4f" %(LambdaCenter,dLambda)
    print CommentHeader, "HWParam: %s" %(HWParam)
    print CommentHeader, "HWParam2: %s" %(HWParam2)
    print CommentHeader, "LambdaParam: %s"  %(LambdaParam)
    print CommentHeader, "Qparam: %s" %(QParam)
   
   
    #TimeParam = "%s,%s,%s" %(self.StartTime,self.EndTime,self.TimeBin)
    #TempParam = "%s,%s,%s" %(self.StartTemp,self.EndTemp,self.TempBin)
    print CommentHeader, "TimeParam: %s" %(TimeParam)
    print CommentHeader, "TempCh: %s" %(Tch)
    #print self.CommentHeader, "TempParam: %s" %(TempParam)

    #dataPath = "/home/dnaadmin/DNA/tmp/" #T.Yamada[130218]
    ECMbstName = "ECM_%d_ES.bst" %(RunNo)
    
    FileHeader = "ESGUIRun"
    ESName = "%s%dES.txt" % (FileHeader, RunNo)
    ESTimeName = "%s%dEStime.txt" % (FileHeader, RunNo)
    TIName = "%s%dTI.txt" % (FileHeader, RunNo)
    TITimeName = "%s%dTItime.txt" % (FileHeader, RunNo)
    TempLogName = "%s%dTempLog.txt" %(FileHeader, RunNo)

    copyresult, messg =CopyEventData(int(RunNo))
    print messg 

    print type(RunNo), RunNo
    T0M.MakeT0file(str("%06d" %int(RunNo)))
#    return -1
    print CommentHeader, "ECM make start"
    ECM = ElasticScan.GetQETimeECMMulth(RunNo, HWParam, LambdaParam, QParam, TimeParam, inifile)
    print CommentHeader, "ECM make end"
    ECM = ElasticScan.ReadECM(ECMbstName)
    EC = ElasticScan.ElasticScanTotalIntensity(ECM, HWParam2, QParam, inifile)
    print CommentHeader, "Total Intensity vs Time"
    ElasticScan.OutputECText(EC, TITimeName)
    ElasticScan.OutPutElasticScanECM(ECM)
    del ECM
#    showplot(EC)
    EC = Cmm.CheckSampleTempByRunNumber(RunNo,Tch)
    Cmm.OutputECText(EC,"_"+Tch)
    print CommentHeader, "Finished"
    return -1
#    #----------------- 
#    #u2 vs time is calculated
#    ECA = ElasticScan.ElasticScanQ2LnI(ECM, HWParam2, QParam, inifile)
#    EC1 = ElasticScan.ElasticScanFit(ECA, "p1")
#    ElasticScan.OutputECText(EC1, ESTimeName)
#    self.showplot(EC1)
#    del ECM
#    del ECA
#    #Time is converted to temperature.
#    EC2 = ElasticScan.ElasticScanCheckTempNew(EC, self.Tch)
#    EC4 = ElasticScan.ElasticScanXAxisChangeToTemp(EC, EC2, TempParam)
#    ElasticScan.OutputECText(EC2,TempLogName) #Temperature log
#    ElasticScan.OutputECText(EC4, TIName) #TotalIntensity vs Temperature
#    EC3 = ElasticScan.ElasticScanXAxisChangeToTemp(EC1, EC2, TempParam)
#    ElasticScan.OutputECText(EC3, ESName) #u2 vs Temperature
#    print self.CommentHeader, "ElasticScan Reduction End"
#    print self.CommentHeader, "I(Q) vs time is saved as \n%sRun%sIQ.txt\n" %(dataPath,self.RunNo) 
#    print self.CommentHeader, "u2 is saved as \n%s%s\n%s%s\n" %(dataPath, ESName, dataPath, ESTimeName)
#    print self.CommentHeader, "Total intensity is saved as \n%s%s\n%s%s\n" %(dataPath, TIName, dataPath, TITimeName)
#    print self.CommentHeader, "Temperature Log is saved as \n%s%s\n" %(dataPath, TempLogName)
#    
#    self.showplot(EC3)

def showplot(dat):
    if type(dat) == type(mm.ElementContainer()):
        MP.MPlot(dat)
    elif type(dat) == type(mm.ElementCotainerArray()):
        MP2.M2Plot(dat)
    else:
        print CommentHeader, "dat is not ElementContainer or ElementContainerArray"
        print CommentHeader, "dat type is ", type(dat)

def CopyEventData(RunNo):
    command = "ssh dnaadmin@192.168.1.10 /home/dnaadmin/Yamada/01_CopyEventData/CopyEventEdata.sh %d" %(RunNo)
    args = command.split(" ")
    proc = subprocess.Popen(args, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE)
    stdout_data, stderr_data = proc.communicate()
    print "stdout_data >>", stdout_data
    print "stderr_data >>", stderr_data.replace("\n","")
    result = proc.returncode
    #proc.close()
    if result == 1:
        messg =  "DNA%06d_* is not found on /data and /ifs_data/DNA/DNA" %RunNo
    else:
        messg =  "DNA%06d_* is ready for the reduction." %RunNo
    return result, messg


if __name__ == "__main__":
    FastChopperUse = True
    print "ElasticScan Reduction ->> Input RunNo"
    RunNo = raw_input()
    print "ElasticScan Reduction ->> Input TimeParam, StartTime,EndTime,TimeBin"
    TimeBin = raw_input()
    StartElasticScan(int(RunNo), TimeBin)
