from __future__ import print_function
import Tkinter
import tkFileDialog
import DiffractionGUIMain as DGM
import DiffractionBase as DB
import vis.DetectMap as DM

class App(Tkinter.Frame):
    def __init__(self,master=None):
        Tkinter.Frame.__init__(self,master)
        self.master.title("DNA Diffraction GUI")
        self.errorstr = Tkinter.StringVar()
        self.errorstr.set("Low Resolution Mode.")

        display=Tkinter.Label(self, textvariable = self.errorstr)
        display.pack(side = Tkinter.TOP)
        f0 = Tkinter.LabelFrame(self)
        rd = Tkinter.Label(f0,text="Run No.:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.RunNo = Tkinter.Spinbox(f0,from_=1000, to=50000,increment = 1, width=5)
        self.RunNo.delete(0, Tkinter.END)
        self.RunNo.insert(0, '3746')
        self.RunNo.pack(pady=2, side= Tkinter.LEFT)
        f0.pack(padx=5,pady=5, fill=Tkinter.BOTH)
        self.pack()

        f2 = Tkinter.LabelFrame(self, text = 'Parameter')
        f20 = Tkinter.LabelFrame( f2, relief = Tkinter.FLAT)
        rd = Tkinter.Label( f20, text="lcenter ")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.lam = Tkinter.Spinbox( f20, from_=0, to=99.999, increment=0.001, width=6, format='%6.3f')
        self.lam.delete( 0, Tkinter.END)
        self.lam.insert( 0, '6.321')
        self.lam.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f20, text="[A] / dl")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.dl = Tkinter.Spinbox( f20, from_=0, to=9.999, increment=0.001, width=5, format='%5.3f')
        self.dl.delete( 0, Tkinter.END)
        self.dl.insert( 0, '3.000')
        self.dl.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f20, text="[A]")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f20.pack(padx=5, pady=2, fill = Tkinter.BOTH)

        f21 = Tkinter.LabelFrame(f2, text = 'Select OutPut Type')
        self.patID = 0
        self.v = Tkinter.IntVar()
        self.v.set(0)
        #Output for TOF
        f211 = Tkinter.LabelFrame(f21, relief = Tkinter.FLAT)
        rd = Tkinter.Radiobutton(f211, text = 'TOF', value = 0, variable = self.v)#, command = self.sel_si)
        rd.pack(padx=0, pady=2,side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f211, text = 'TOF(Min.)')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.TOFmin = Tkinter.Spinbox(f211, from_=0, to = 1000000, increment = 1, width = 7, format='%6.1f')
        self.TOFmin.delete(0, Tkinter.END)
        self.TOFmin.insert(0,'40000.0')
        self.TOFmin.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f211, text = 'TOF(Max.)')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.TOFmax = Tkinter.Spinbox(f211, from_=0, to = 1000000, increment = 1, width = 7, format='%6.1f')
        self.TOFmax.delete(0, Tkinter.END)
        self.TOFmax.insert(0,'80000.0')
        self.TOFmax.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f211, text = 'TOF Bin')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.TOFbin = Tkinter.Spinbox(f211, from_=0, to = 80000, increment = 1, width = 5, format='%6.1f')
        self.TOFbin.delete(0, Tkinter.END)
        self.TOFbin.insert(0,'100.0')
        self.TOFbin.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        f211.pack(padx=0,pady=2, fill = Tkinter.BOTH,anchor=Tkinter.W)
        #Output for Q
        f212 = Tkinter.LabelFrame(f21, relief = Tkinter.FLAT)
        rd = Tkinter.Radiobutton(f212, text = 'Q', value = 1, variable = self.v)#, command = self.sel_si)
        rd.pack(padx=0, pady=2, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f212, text = 'Q(Min.)')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.Qmin = Tkinter.Spinbox(f212, from_=0, to = 100, increment = 0.001, width = 7, format='%6.3f')
        self.Qmin.delete(0, Tkinter.END)
        self.Qmin.insert(0,'0.00')
        self.Qmin.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f212, text = 'Q(Max.)')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.Qmax = Tkinter.Spinbox(f212, from_=0, to = 100, increment = 0.001, width = 7, format='%6.3f')
        self.Qmax.delete(0, Tkinter.END)
        self.Qmax.insert(0,'6.0')
        self.Qmax.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f212, text = 'Q Bin')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.Qbin = Tkinter.Spinbox(f212, from_=0, to = 100, increment = 0.001, width = 5, format='%6.4f')
        self.Qbin.delete(0, Tkinter.END)
        self.Qbin.insert(0,'0.02')
        self.Qbin.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        f212.pack(padx=0,pady=2, fill = Tkinter.BOTH)
        #Output for d
        f213 = Tkinter.LabelFrame(f21, relief = Tkinter.FLAT)
        rd = Tkinter.Radiobutton(f213, text = 'd', value = 2, variable = self.v)#, command = self.sel_si)
        rd.pack(padx=0, pady=2,side=Tkinter.LEFT, anchor=Tkinter.W)
        rd = Tkinter.Label(f213, text = 'd(Min.)')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.dmin = Tkinter.Spinbox(f213, from_=0, to = 100, increment = 0.001, width = 7, format='%6.3f')
        self.dmin.delete(0, Tkinter.END)
        self.dmin.insert(0,'0.00')
        self.dmin.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f213, text = 'd(Max.)')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.dmax = Tkinter.Spinbox(f213, from_=0, to = 100, increment = 0.001, width = 7, format='%6.3f')
        self.dmax.delete(0, Tkinter.END)
        self.dmax.insert(0,'6.0')
        self.dmax.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        rd = Tkinter.Label(f213, text = 'd Bin')
        rd.pack(padx=2, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        self.dbin = Tkinter.Spinbox(f213, from_=0, to = 100, increment = 0.001, width = 5, format='%6.4f')
        self.dbin.delete(0, Tkinter.END)
        self.dbin.insert(0,'0.02')
        self.dbin.pack(padx=0, pady=0, side=Tkinter.LEFT,anchor=Tkinter.W)
        f213.pack(padx=0,pady=2, fill = Tkinter.BOTH)
        f21.pack(padx=5, pady=5, fill = Tkinter.BOTH)
        f2.pack(padx=5, pady=5, fill = Tkinter.BOTH)
        #Time Range
        f3 = Tkinter.LabelFrame(self, text = 'time range') 
        f31 = Tkinter.LabelFrame( f3, relief = Tkinter.FLAT)
        rd = Tkinter.Label( f31, text = "StartTime")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.Sta = Tkinter.Spinbox( f31, from_=0, to=9999999, increment=1, width=7, format='%7.0f')
        self.Sta.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f31, text = "[sec.]/ EndTime ")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.End = Tkinter.Spinbox( f31,from_=0,to=9999999,increment=1,width=7,format='%7.0f')
        self.End.delete( 0, Tkinter.END)
        self.End.insert( 0, '9999999')
        self.End.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f31, text = "[sec.]")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f31.pack(padx=5,pady=2, fill = Tkinter.BOTH)
        f3.pack(padx=5, pady=5, fill = Tkinter.BOTH)

        button1 = Tkinter.Button(self, text = "Launch Data Reduction", command = self.launch)
        button3 = Tkinter.Button(self, text = "Quit", command = self.master.destroy)
        button1.pack(side = Tkinter.LEFT)
        button3.pack(side = Tkinter.RIGHT)
        self.pack()
    
    def GetType(self):
        Type = 2
        if self.v.get() == 1:
            Type = 22
        elif self.v.get() ==2:
            Type = 25

        return Type
    
    def GetParams(self):
        self.params = []
        self.params.append(self.GetType())
        if self.v.get() == 0:
            min_ = float(self.TOFmin.get())
            max_ = float(self.TOFmax.get())
            bin_ = float(self.TOFbin.get())
        elif self.v.get() == 1:
            min_ = float(self.Qmin.get())
            max_ = float(self.Qmax.get())
            bin_ = float(self.Qbin.get())
        elif self.v.get() == 2:
            min_ = float(self.dmin.get())
            max_ = float(self.dmax.get())
            bin_ = float(self.dbin.get())
        
        self.params.append(min_)
        self.params.append(max_)
        self.params.append(bin_)
        self.params.append(float(self.lam.get()))
        self.params.append(float(self.dl.get()))
        print(self.params)

    def launch(self):
        WIorg = "/opt/mlfsoft_dev/python-utsusemi/DNA/ana/xml/WiringInfoGUIBase.xml"
        DIorg = "/opt/mlfsoft_dev/python-utsusemi/DNA/ana/xml/DetectorInfo20140120GUI.xml"
        self.GetParams()
        dgm = DGM.EditWiringInfoForGUI(WIorg,self.params[0],self.params[1],self.params[2],self.params[3],self.params[4],self.params[5])
        WINew = dgm.OutputXml()

        CommentHeader = "Diffraction GUI ->>"
        print(CommentHeader, WINew)
        
        ecm = DB.GetDiffPattern(int(self.RunNo.get()),float(self.Sta.get()),float(self.End.get()),WINew,DIorg)
        DM.DetectMap(ecm)
        

if __name__ == "__main__":
    app = App()
    app.mainloop()
