#include "UtsusemiSetMaskDNA.hh"

//////////////////////////////////////////////////////////
UtsusemiSetMaskDNA::
UtsusemiSetMaskDNA()
    {
    }
//////////////////////////////////////////////////////////
UtsusemiSetMaskDNA::
UtsusemiSetMaskDNA(ElementContainerMatrix *ecm)
    {
    Execute(ecm);
    }
//////////////////////////////////////////////////////////
UtsusemiSetMaskDNA::
UtsusemiSetMaskDNA(ElementContainerArray *eca)
    {
    Execute(eca);
    }
//////////////////////////////////////////////////////////
UtsusemiSetMaskDNA::
UtsusemiSetMaskDNA(ElementContainer *ec)
    {
    Execute(ec);
    }
//////////////////////////////////////////////////////////
UtsusemiSetMaskDNA::
~UtsusemiSetMaskDNA()
    {
    }
//////////////////////////////////////////////////////////
void UtsusemiSetMaskDNA::
Execute(ElementContainerMatrix *ecm)
    {
    UInt4 ecmsize = ecm->PutTableSize();
    if (ecmsize>0)
        for (UInt4 i=0;i<ecmsize;i++)
            {
            ElementContainerArray *eca = ecm->PutPointer(i);
            Execute(eca);
            }
    }
//////////////////////////////////////////////////////////
void UtsusemiSetMaskDNA::
Execute(ElementContainerArray *eca)
    {
    UInt4 ecasize = eca->PutTableSize();
    if (ecasize>0)
        for (UInt4 i=0;i<ecasize;i++)
            {
            ElementContainer *ec = eca->PutPointer(i);
            Execute(ec);
            }
    }
//////////////////////////////////////////////////////////
void UtsusemiSetMaskDNA::
Execute(ElementContainer *ec)
    {
    std::vector<Double> MaskedRanges = ec->PutHeader().PutDoubleVector("MaskedRanges");
    if (MaskedRanges.size()>0)
        {
        std::vector<Double> ecX = ec->PutX();
        std::vector<Double> ecY = ec->PutY();
        std::vector<Double> ecE = ec->PutE();

        std::vector<Double> ecY0 = ec->PutY();
        std::vector<Double> ecE0 = ec->PutE();

        UInt4 j=0;
        for (UInt4 i=0;i<ecY.size();i++)
            {
            Double x = (ecX[i]+ecX[i+1])*0.5;
            if (j>=MaskedRanges.size())
                {
                ecY[i]= 0;
                ecE[i]=-1;
                }
            else
                {
                if(ecX[i] < MaskedRanges[j] || MaskedRanges[j+1] < ecX[i+1])
                    {
                    ecY[i]= 0;
                    ecE[i]=-1;
                    if (MaskedRanges[j+1] < ecX[i+1])
                        j+=2;
                    }
                }
            }
        std::string xkey=ec->PutXKey();
        std::string ykey=ec->PutYKey();
        std::string ekey=ec->PutEKey();

        if (ec->CheckKey(ykey))
            {
            ec->Remove(ykey);
            }
        ec->Add(ykey,ecY);

        if (ec->CheckKey(ekey))
            {
            ec->Remove(ekey);
            }
        ec->Add(ekey,ecE);

        if (ec->CheckKey(ekey + std::string("Org")))
            {
            ec->Remove(ekey + std::string("Org"));
            }
        ec->Add(ykey + std::string("Org"),ecY0);

        if (ec->CheckKey(ekey + std::string("Org")))
            {
            ec->Remove(ekey + std::string("Org"));
            }
        ec->Add(ekey + std::string("Org"),ecE0);

        ec->SetKeys(xkey,ykey,ekey);

        }
    }
//////////////////////////////////////////////////////////
