#ifndef UTSUSEMIEVENTDATACONVERTERDNAWHSC
#define UTSUSEMIEVENTDATACONVERTERDNAWHSC

#include "UtsusemiEventDataConverterTemplate.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "UtsusemiNeunetEventDecoderDNA.hh"
//#include "UtsusemiFilterTrignet.hh"
#include "UtsusemiFilterTrignetDNA.hh"
#include "UtsusemiFilterHSChopperDNA.hh"
#include "T0TreatToolsNeunet.hh"
#include "Header.hh"
#include "HeaderBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "StringTools.hh"
////////////////////////////////////
// UtsusemiEventDataConverterDNAWithHSC
///////////////////////////////////

//! Load Event Data and convert to Histogram for Inelastic scattering
/*!
 *   LoadParamFiles( "WiringInfo.xml", "DetectorInfo.xml", "CaseInfo.xml" )
 *   LoadTrignetEventFile( runNo, "/data", "" )
 *   SetHistAllocation()
 *   ecm = ElementContainerMatrix()
 *   SetElementContainerMatrix( ecm, runNo, "/data", "" )
 */

class UtsusemiEventDataConverterDNAWithHSC:
    public UtsusemiEventDataConverterTemplate< UtsusemiNeunetEventDecoderDNA,
                                               UtsusemiEventCasesDecoderTemplate<T0TreatToolsNeunet,UtsusemiFilterHSChopperDNA>
                                             >
{
private:
    void Initialize();
    std::string _MessageTag;
    StringTools* stools;
    void _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );

    void SetT0Detector();

    void ExecMaskForEC(UInt4 outer_pixel_id, Int4 tof_bin_type, ElementContainer *ec);

    Int8 _find(std::string line,std::vector<std::string> tag,Int4 pos);
    std::vector<std::vector<Double> > ReadTOFOffsetFile(std::string o_file);
public:
    UtsusemiEventDataConverterDNAWithHSC();
        //!< Constructor
        /*!<
         */
    ~UtsusemiEventDataConverterDNAWithHSC();
        //!< Destructor
        /*!<
         */
    void SetLambdaParam(Double LambdaCenter,Double deltaLambda);

    void SetTOFOffset(Double tofOffset);

    void SetTOFResolver(Double tofResolver);

    void SetTOFResolver(Double tofResolver1,Double tofResolver2);

    void SetTimeParamAtSource(Double tofSourceMin, Double tofSourceMax);

    void SetTOFOffsetFile( std::string o_file );

    //void SetInstrumentPosition(Double lchopper, Double lband, Double l1);

    void LoadParamFiles( std::string w_file, std::string d_file, std::string c_file="" );
        //!< Loads parameter files
        /*!< This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.
         *
         *   @param w_file (std::string) Wiring Info file path
         *   @param d_file (std::string) Detector Info file path
         *   @param c_file (std::string) Case Info file path
         *   @return None
         */

    void LoadChopCondFile(std::string w_file, std::string d_file,std::string cc_file);

    void SetFilterHSChopperMode();

    void SetElementContainerDNA( UInt4 outer_pixel_id, ElementContainer* ec, UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainer
        /*!<
         *   @param outer_pixel_id (UInt4) pixel_id
         *   @param ec (ElementContainer*)
         *   @param caseId (UInt4)
         *   @return None
         */
    Int4 LoadEventDataFiles( UInt4 runNumber, std::string pathToData="", std::string pathToT0data="" );
        //!< Loads event data files
        /*!<
         *   @param runNumber (UInt4) run number
         *   @param pathToData (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @return None
         */
    void SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
    void SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNuber, std::string pathToData, std::string pathToT0data="", UInt4 caseId=1 );
        //!< Sets Histogram into ElementContainerMatrix
        /*!<
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 )
         *     SetElementContainerMatrix( ElementContainerMatrix* ecm, std::string instCode, UInt4 runNuber,
         *                                std::string pathToData="", std::string pathToT0data="", UInt4 caseId=1 )
         *
         *   @param ecm          (ElementContainerMatrix*)
         *   @param instCode     (std::string) Instrument code
         *   @param runNumber    (UInt4) run number
         *   @param pathToData   (std::string) path to root directory of instruments event data folders ("/data")
         *   @param pathToT0data (std::string) path to directory to store T0Index event data files
         *   @param caseId       (UInt4) case ID
         *   @return None
         */
//201404 DNA start
    void LoadTrignetChopFile( UInt4 runno, std::string pathToData, std::string pathToT0data );
//201304 DNA end
    void MakeCaseTable( UInt4 runno, std::string pathToData="", std::string pathToT0data="", std::string trigModKey="" );
    void LoadTrignetEventFile( UInt4 runno, std::string pathToData="", std::string pathToT0data="" );
    void ReadTrignetEventFile( std::string pathToTrigData, UInt4 index=0 );
        //!< Reads Trignet Event data file for cases
        /*!<
         *   @param pathToTrigData (std::string) path to TrigNET event data files
         *   @param index (UInt4) event file index
         *   @return None
         */
    void SetRangeOfSingleTimeSlicing( double startSec, double endSec );
       //!< Sets time range for time slice of event data
       /*!< Values for time are indicated the passed time [sec] from head of event data
         *   @param  startSec     start time [sec]
         *   @param  endSec       end time [sec]
         *   @return None
         */
    Int4 SetRangeOfSingleTimeSlicing( std::string startDate, std::string endDate );
        //!< Sets time range for time slice of event data
        /*!< Values for time are indicated the passed time [sec] from head of event data
         *   std::string format : "YYYY,MM,DD,hh,mm,ss,s.ss", "2011,1,22,13,54,22,0.54"
         *   @param  startDate     start date std::string
         *   @param  endDate       end date std::string
         *   @return None
         */
    std::vector<UInt4> DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size );
        //!< Dumps table of cases
        /*!<
         *   @param i1 (UInt4)
         *   @param i2 (UInt4)
         *   @param isI1Size (bool)
         *   @param isI2Size (bool)
         *   @return None
         */
    void SetElementContainerMatrixForPseudOnLineMon( ElementContainerMatrix* ecm, UInt4 caseId=1, UInt4 runNo=999999 );
        //!< Sets histograms to ElementContainermatrix as pseud on-line monitor
        /*!<
         *   @param ecm    (ElementContainerMatrix*)
         *   @param caseId (UInt4) case ID
         *   @param runNo  (UInt4) run number
         *   @param isI2Size (bool)
         *   @return None
         */
    std::vector<UInt4> PutListOfCases(){ return _CaseDecoder->PutListOfCases(); }
        //!< Puts list of cases
        /*!<
         *  @param None
         *  @return list of cases
         */
    Int4 SetDataPathTest( std::string dataPath, std::string t0Path, UInt4 runNo );

};
#endif
