#ifndef AdvSolidAngleCorrectionDNACHOPPER
#define AdvSolidAngleCorrectionDNACHOPPER

#include "Header.hh"
#include "OperatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "StringTools.hh"
#include "AdvDetectorManagerDNA.hh"
#include "AdvCorrectionAbsorptionDNA.hh"

#include <sstream>

//////////////////////////////////
// Solid Angle Correction for DNA
// Advance soft 12/03/06
/////////////////////////////////

//!
/*!
 *
 *
 *
 *
 */
class AdvSolidAngleCorrectionDNA :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::string commentHead;
    void Initialize();
 StringTools *stools;
public:
    AdvSolidAngleCorrectionDNA();
        //!< Constructor
        /*!<
         */
    AdvSolidAngleCorrectionDNA(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~AdvSolidAngleCorrectionDNA();
        //!< Destructor
        /*!<
         */

    ElementContainerMatrix SACorrection(ElementContainerMatrix ecm,bool UseDetectorEfficiency,bool UseSampleAbsoCorr,bool UseCorrEfficiency,std::string sampleType,std::string sampleDataPath,std::string detectorDataPath,char* corrEffDataPath);
    bool SACorrection(ElementContainerMatrix* ret_ecm, ElementContainerMatrix* ecm, bool UseDetectorEfficiency,bool UseSampleAbsoCorr,bool UseCorrEfficiency,std::string sampleType,std::string sampleDataPath,std::string detectorDataPath,char* corrEffDataPath);

  //void ReadEffciencyFile();


};

#endif
