#ifndef SIMULATEDANNEALING_CONSTS
#define SIMULATEDANNEALING_CONSTS

#include "Header.hh"

class AdvSimulatedAnnealingConsts {

    private:
        static const string className; // =string("AdvSimulatedAnnealingConsts");

    public:
        /** key for the kind of the constrain */
        static const string CONSTRAIN;          //=string("constrain");

        static const string USE_DATA_WEIGHTS;  //=string("use data weights");

        /** key for output interval */
        static const string OUTPUT_INTERVAL;    //=string("output interval");

        /* parameters for simulated annealing */
        static const string N_TRIES;        //=string("n_tries");
        static const string ITERS_FIXED_T;  //=string("iters_fixed_t");
        static const string STEP_SIZE;      //=string("step_size");
        static const string K;              //=string("k");
        static const string T_INITIAL;      //=string("t_initial");
        static const string MU_T;           //=string("mu_t");
        static const string T_MIN;          //=string("t_min");

        /** key for fitting function */
        static const string FUNCTIONS;         //= string("function");

        /** ley for the flag of using data weight */
        /** keys for a set of initial values of fitting parameters */
        /** key for initival values for fitting parameters */
        static const string INITIAL_PARAM_VALUES; //=string("initial param values");
        static const string PARAMETER_VALUES;   //=string("parameter values");

        /** key for a set of the refference data */
        static const string REFERENCE_VALUES;   //=string("reference values");

        /** keys for lower bound of box constrains */
        static const string LOWER_BOUNDS;     //=string("lower bound");
        /** keys for upper bound of box constrains */
        static const string UPPER_BOUNDS;     //=string("upper bound");
        /** key for weights of box constrains */
        static const string BOX_WEIGHTS;      //=string("box weight");

        /** iteration count */
        static const string ITERATION_COUNT;    //=string("iteration count");
        /** parameter errors */
        static const string PARAM_ERRORS;       //=string("param. errors");

        /** the number times of function evaluations */
        static const string FUNCTION_EVALUATIONS;  //=string("function evaluations")
        /** the tile of iteration */
        static const string ITERATION_TIME;        //

        /** constrain */
        enum Constrain {
            NO_CONSTRAIN, /* no constrain */
            BOX,          /* box */
        };

        static const Constrain  DEFAULT_CONSTRAIN;          //=BOX;
        static const Bool       DEFAULT_USE_DATA_WEIGHTS;   //=true;

        static const UInt4      DEFAULT_OUTPUT_INTERVAL;    // =1000U;

        static const Int4       DEFAULT_N_TRIES;
        static const Int4       DEFAULT_ITERS_FIXED_T;
        static const Double     DEFAULT_STEP_SIZE;
        static const Double     DEFAULT_K;
        static const Double     DEFAULT_T_INITIAL;
        static const Double     DEFAULT_MU_T;
        static const Double     DEFAULT_T_MIN;

        /** constrain */
        static const string CONSTRAIN_STR[];

        /** stopping stat */
        //enum SimulatedAnnealingStat {
        //    CONTINUE                  = 8,
        //    FORCE_QUIT_BY_USER        = 9,
        //    SUSPEND                   =10,
        //};
        /** termination reason, translate a SimulatedAnnealingStat value to a string */
        //static const string TERMINATION_REASON[];
};

#endif // SIMULATEDANNEALING_CONSTS
