#include "AdvLevmarConsts.hh"

const string AdvLevmarConsts::className=string("AdvLevmarConsts");

/**
 *  keys for contrioling AdvLevmarConsts
 */
/** key for the kind of the constrain */
const string AdvLevmarConsts::CONSTRAIN         =string("constrain");
/** key for the flag of the numerical differential Jaccobian */
const string AdvLevmarConsts::USE_NUMERICAL_DIFF=string("use numerical diff");
/** key for the method of numerical differentiation */
const string AdvLevmarConsts::DIFF_METHOD       =string("diff method");

/** key for the flag of using data weights */
const string AdvLevmarConsts::USE_DATA_WEIGHTS=string("use data weights");

/** key for maxmum iterations */
const string AdvLevmarConsts::MAX_ITERATIONS     =string("max iterations");
/** key for outpur interval */
const string AdvLevmarConsts::OUTPUT_INTERVAL = string("output interval");

/** key for the depth for convergence history */
const string AdvLevmarConsts::HISTORY_CAPACITY = string("history capacity");

/**
 *  key for input data for fitting using AdvLevmarConsts
 */
/** key for fitting function */
const string AdvLevmarConsts::FUNCTIONS= string("functions");

/** key for data mask */
const string AdvLevmarConsts::MASK = string("maxk");

/** keys for a set of values of fitting parameters */
const string AdvLevmarConsts::INITIAL_PARAM_VALUES=string("initial param values");

const string AdvLevmarConsts::PARAMETER_VALUES    =string("parameter values");

const string AdvLevmarConsts::LINK_IDS    =string("link ids");

/** key for a set of the refference data */
const string AdvLevmarConsts::REFERENCE_VALUES  =string("reference values");

/** keys for lower bound of box constrains */
const string AdvLevmarConsts::LOWER_BOUNDS      =string("lower bounds");
/** keys for upper bound of box constrains */
const string AdvLevmarConsts::UPPER_BOUNDS      =string("upper bounds");
/** key for weights of box constrains */
const string AdvLevmarConsts::BOX_WEIGHTS       =string("box weights");
/** key for linear equations */
const string AdvLevmarConsts::EQUATIONS         =string("equations");
/** key for linear inequalities */
const string AdvLevmarConsts::INEQUALITIES      =string("inequalites");

/** key for scaling factor */
const string AdvLevmarConsts::SCALING_FACTOR    =string("scaling factor");
/** key for threshold values for stopping conditions */
const string AdvLevmarConsts::TOLERANCE         =string("tolerance");
const string AdvLevmarConsts::RELATIVE_TOLERANCE=string("relative tolerance");
const string AdvLevmarConsts::GRADIENT_TOLERANCE=string("gradient tolerance");

const string AdvLevmarConsts::RESIDU_ERR_THRESH=string("residu. err. thresh");
const string AdvLevmarConsts::GRADIENT_THRESH  =string("gradient thresh");
const string AdvLevmarConsts::PARAM_DIFF_THRESH=string("param. diff. thresh");

/** key for step width for numerical differential Jaccobian */
const string AdvLevmarConsts::DIFF_DELTA        =string("diff delta");


/** key for current iterations */
const string AdvLevmarConsts::ITERATION_COUNT    =string("iteration count");
/** key for termination stat */
const string AdvLevmarConsts::TERMINATION_STAT   =string("termination stat");
/** key for R-factor */
const string AdvLevmarConsts::R_FACTOR           =string("R factor");
/** key for residual error norm */
const string AdvLevmarConsts::RESIDUAL_ERR_NORM  =string("residual error norm");
/** key for gradient norm */
const string AdvLevmarConsts::GRADIENT_NORM      =string("gradiend norm");
/** key for parameter difference */
const string AdvLevmarConsts::PARAM_DIFF_NORM    =string("param diff norm");
/** key for parameter errors */
const string AdvLevmarConsts::PARAM_ERRORS       =string("param errors");
/** key for covariance matrix */
const string AdvLevmarConsts::COVARIANCE_MATRIX  =string("covariance matrix");
/** mu ratio, i.e. mu/max{ [J^T J]_ii; 0<=i < the number of fitting parameters} */
const string AdvLevmarConsts::MU_RATIO = string("mu ratio");
/** the number times of function evaluations */
const string AdvLevmarConsts::FUNCTION_EVALUATIONS  = string("function evaluations");
/** the number times of Jacobian evaluations */
const string AdvLevmarConsts::JACOBIAN_EVALUATIONS  = string("Jacobian evaluations");
/** the number times of linear systems solved */
const string AdvLevmarConsts::LINEAR_SYSTEMS_SOLVED = string("linear systems solved");
/** iteration time */
const string AdvLevmarConsts::ITERATION_TIME= string("iteration time");

/*
 *  default values of parametes with keys
 */
/** default constrain */
const AdvLevmarConsts::Constrain  AdvLevmarConsts::DEFAULT_CONSTRAIN=AdvLevmarConsts::BOX;

/** default value of the flag to use numerical differential for evaluating Jacobian */
const Bool               AdvLevmarConsts::DEFAULT_USE_NUMERICAL_DIFF=true;
/** default value of the flag to fit with weight */
const Bool               AdvLevmarConsts::DEFAULT_USE_DATA_WEIGHTS  =true;

/** default numerical differential method */
const AdvLevmarConsts::DiffMethod AdvLevmarConsts::DEFAULT_DIFF_METHOD       =AdvLevmarConsts::FORWARD;

/** default value for maximum iterations */
const UInt4 AdvLevmarConsts::DEFAULT_MAX_ITERATIONS  =1000U;
/** default value for output interval */
const UInt4 AdvLevmarConsts::DEFAULT_OUTPUT_INTERVAL =50U;

/** default depth for convergence history */
const UInt4 AdvLevmarConsts::DEFAULT_HISTORY_CAPACITY =50U;

/* for opts[] */
/** default initial value of scaling factro */
const Double AdvLevmarConsts::DEFAULT_SCALING_FACTOR    =LM_INIT_MU;
/** default thresholds to terminate fitteing */
/** \deprecated */
const Double AdvLevmarConsts::DEFAULT_GRADIENT_TOLERANCE=LM_STOP_THRESH;
/** \deprecated */
const Double AdvLevmarConsts::DEFAULT_TOLERANCE         =LM_STOP_THRESH;
/** \deprecated */
const Double AdvLevmarConsts::DEFAULT_RELATIVE_TOLERANCE=LM_STOP_THRESH;

const Double AdvLevmarConsts::DEFAULT_RESIDU_ERR_THRESH =LM_STOP_THRESH;
const Double AdvLevmarConsts::DEFAULT_GRADIENT_THRESH   =LM_STOP_THRESH;
const Double AdvLevmarConsts::DEFAULT_PARAM_DIFF_THRESH =LM_STOP_THRESH;


/** default defference for numerical differential */
const Double AdvLevmarConsts::DEFAULT_DIFF_DELTA        =LM_DIFF_DELTA;

/** constrain string */
const string AdvLevmarConsts::CONSTRAIN_STR[] = {
    *(new string("no constrain")),                                  // Levmar::NO_CONSTRAIN
    *(new string("box")),                                           // Levmar::BOX
#ifdef HAVE_LAPACK
    *(new string("linear equation")),                               // levmar::LEC
    *(new string("linear inequalities")),                           // levmar::LIC
    *(new string("box and linear equations")),                      // levmar::BLEC
    *(new string("box and linear inequalities")),                   // levmar::BLIC
    *(new string("linear equations and linear inequalities")),      // levmar::LEIC
    *(new string("box, linear equations and linear inequalities")), // levmar::BLEIC
#endif //  HAVE_LAPACK
};

/** diferentioan method */
const string AdvLevmarConsts::DIFF_METHOD_STR[] = {
    *(new string("forward")),
    *(new string("central")),
};

/** termination reason */
const string AdvLevmarConsts::TERMINATION_REASON[] = {
    *(new string("")),
    *(new string("small inf. norm for gradient (J^T e)")),
    *(new string("small L2 norm for parameter difference")),
    *(new string("maximum iteraion")),
    *(new string("singular matrix. Restart from current p with increased scaling factor")),
    *(new string("no further error reduction is possible. Restart with increased scaling factor")),
    *(new string("small L2 norm of residual error")),
    *(new string("invalid (i.e. NaN or Inf) \"func\" values")),
    *(new string("continue")),
    *(new string("force-quit by user")),
    *(new string("suspend")),
};

