
#include "Peak.hh"

Int4 main(Int4 argc, Char *argv[]) {

    //                    type           x         h     w     xl   xu
    Peak *peak0 = new Peak(SHOLDER_I, -2.5,  50000.0,  4.5, -7.0, -2.5);
    Peak *peak1 = new Peak(PEAK,       0.0, 100000.0,  2.5, -2.5,  2.5);
    Peak *peak2 = new Peak(SHOLDER_D,  2.5,  50000.0,  4.5,  2.5,  7.0);
    fprintf(stdout, "io using \"cstdio\"\n");
    Peak::title(stdout);
    peak0->dump(stdout);
    peak1->dump(stdout);
    peak2->dump(stdout);

    std::cout << "io using \"iostream\"" << endl;
    Peak::title(&(std::cout));
    peak0->dump(&(std::cout));
    peak1->dump(&(std::cout));
    peak2->dump(&(std::cout));

    Peak *peak4 = new Peak(*peak1);
    peak4->dump(stdout);
    Peak peak5 = *peak2;
    peak5.dump(stdout);

    std::cout << "short size = " << Peak::shortSize << endl;
    std::cout << "full size  = " << Peak::fullSize << endl;

    vector<Double> v;
    v=peak0->toVector();
    std::cout << "size of vector = " << v.size() << endl;
    for (UInt4 i=0; i<v.size(); ++i) {
        std::cout << "v(" << i << ")=" << v.at(i) << endl;
    }

    v=peak0->toFullVector();
    std::cout << "size of full vector = " << v.size() << endl;
    for (UInt4 i=0; i<v.size(); ++i) {
        std::cout << "v(" << i << ")=" << v.at(i) << endl;
    }

}
