#include <iostream>

#include "Header.hh"

#include "ContainerBaseTemplate.hh"

Int4 main(Int4 argc, Char *argv[]) {

    UInt4 indentDepth=4;
    string keyTitle  ="key";
    string sizeTitle ="size";
    string valueTitle="value";

    ContainerForScaler< Int4 > Int4map;

    std::cout << "empty check: " << Int4map.empty() << endl;

    string key1 = string("key1");
    string key2 = string("key2");
    string key3 = string("longkey3");

    Int4map.clear();

    Int4map.add(key1, 0);
    Int4map.add(key2, 1);

    std::cout << "check size: " << Int4map.size() << endl;
    std::cout << "empty check: " << Int4map.empty() << endl;
    std::cout << "check containng: key1 " << Int4map.contain(key1) << endl;
    std::cout << "check containng: key2 " << Int4map.contain(key2) << endl;

    try {
        std::cout << "get the value of key1 " << Int4map.get(key1) << endl;
        std::cout << "get the value of key2 " << Int4map.get(key2) << endl;
        std::cout << "get the value of key3 " << Int4map.get(key3) << endl;
    } catch (invalid_argument iva) {
        std::cout << iva.what() << endl;
    } catch (exception e) {
        std::cout << e.what() << endl;
    }

    Int4map.replace(key3, 5);
    Int4map.replace(key1, 4);

    try {
        std::cout << "get the value of key1 " << Int4map.get(key1) << endl;
        std::cout << "get the value of key2 " << Int4map.get(key2) << endl;
        //std::cout << "get the value of key3 " << Int4map.get("key3") << endl;
    } catch (invalid_argument iva) {
        std::cout << iva.what() << endl;
    } catch (exception e) {
        std::cout << e.what() << endl;
    }

    vector<string> keys = Int4map.getKeys();
    std::cout << "a list of keys" << endl;
    for (std::vector<string>::iterator it = keys.begin(); it != keys.end(); ++it) {
        std::cout << *it << endl;
    }

    Int4map.erase(key3);
    Int4map.erase(key2);

    try {
        std::cout << "get the value of key1 " << Int4map.get(key1) << endl;
        //std::cout << "get the value of key2 " << Int4map.get(key2) << endl;
        //std::cout << "get the value of key3 " << Int4map.get("key3") << endl;
    } catch (invalid_argument iva) {
        std::cout << iva.what() << endl;
    } catch (exception e) {
        std::cout << e.what() << endl;
    }

    Int4map.add(key3, 100);

    Int4map.dump(1, indentDepth, keyTitle, sizeTitle, valueTitle);
    Int4map.dump(0, indentDepth, keyTitle, sizeTitle, valueTitle);
    Int4map.dump();

    exit(EXIT_SUCCESS);
}
