#!/usr/bin/python

import Manyo
import Adv

import PlotElementContainer

########  the linear conbination of built in functions and its parameters ########
# an string expression for the linear combination of built-in functions. ####
# three gaussian functions 
expr="g g g"

# a python list of parameters for the functions,
# paramList[0] : the height for the first gaussian
# paramList[1] : the peak position for the first gaussian
# paramList[2] : the HWHM for the first gaussian
#
# paramList[3] : the height for the second gaussian
# paramList[4] : the peak position for the second gaussian
# paramList[5] : the HWHM for the second gaussian
#
# paramList[6] : the height for the third gaussian
# paramList[7] : the peak position for the third gaussian
# paramList[8] : the HWHM for the third gaussian
paramList =[1.0, 0.0, 1.0, 1.0, 5.0, 1.5, 1.0, 10.0, 1.5]

# a python list of parameter errors for the functions
# paramErrList[i] : error (uncertinity) for  paramList[i]
paramErrList=[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0, 0.0]


#########  bin  ########
lower=-5.0 # the lower bound of a domain
upper=15.0 # the upper bound of a domain
divnum=100 # the number of bins
delta=(upper-lower)/divnum # the width of bins

vtools=Manyo.VectorTool()
bin=vtool.MakeVectorDouble(divnum+1)
for i in range(divnum+1):
    bin[i]=lower + delta*i

########  evaluate the values of functions and export the results to an ElementContainer
funcToEC=Adv.FuncCombToElementContainer(expr, paramList, paramErrList)
keys=["x", "y", "e"]
units=["", ""]   #  units for "x" and "y"
ecc = funcToElementContainer(keys, units, bin)
ecl = funcToElementContainer(keys, units, bin, 0.0)
ecu = funcToElementContainer(keys, units, bin, 1.0)

########  plot results  ########
plotter=PLotElementContainer.PlotElementContainer()
plotter.setSource(ece)
plotter.plot()
plotter.setSource(ecl)
plotter.plot()
plotter.setSource(ecu)
plotter.plot()
