#ifndef POLYNOMIAL3CONV_HH
#define POLYNOMIAL3CONV_HH

#include "Header.hh"
#include "AdvFuncConv.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForPolynomial3Conv 1

class AdvPolynomial3Conv : public AdvFuncBase, public AdvFuncConv{

    public:
        AdvPolynomial3Conv();
        ~AdvPolynomial3Conv();

        Double Polynomial3Func(const Double x, const Double p);
        Double Polynomial3ConvFunc(const Double x, const Double p);

#ifdef USE_POINTER
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double *p);
        Double der2nd(const Double x, const Double *p);
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        Double eval(const Double x, const vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const vector<Double> &p);
        Double der2nd(const Double x, const vector<Double> &p);
        vector<Double> gradient(const Double x, const vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

};
#endif // POLYNOMIAL1_HH

