#include "ThreadBase.hh"
/////////////////////////////////////
#ifndef THREADBASE_CC
#define THREADBASE_CC
void *ThreadBaseRun( void *ptr ){
  ThreadBase *p = (ThreadBase*)ptr;
  p->Run();
  return 0;
}
/////////////////////////////////////
ThreadBase::
ThreadBase(){
  ThreadDescriptor = 0;
  CancelFlag = 0;
}
/////////////////////////////////////
ThreadBase::
~ThreadBase(){
  //pthread_detach( ThreadDescriptor );
}
/////////////////////////////////////
void ThreadBase::
Join(){
  if( CancelFlag == 0 ){
    pthread_join( ThreadDescriptor, NULL );
    pthread_detach( ThreadDescriptor );
  }
}
/////////////////////////////////////
void ThreadBase::
Cancel(){
  pthread_cancel( ThreadDescriptor );
  pthread_detach( ThreadDescriptor );
  CancelFlag = 1;
}
/////////////////////////////////////
void ThreadBase::
Detach(){
  pthread_detach( ThreadDescriptor );
}
/////////////////////////////////////
Int4 ThreadBase::Start(){
  return pthread_create( &ThreadDescriptor, NULL, 
			 ThreadBaseRun, (void*)this );
  // The third argument must be a pointer of the global function not
  // a pointer of the internal method. 
  // The method of "void run()" will be called 
  // in the global function defined in this file.
  // The value of the fourth method is the pointer of this class.
}
/////////////////////////////////////
#endif

