#ifndef TRAPEZOID_H
#define TRAPEZOID_H

#include "Header.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForTrapezoid 5

class AdvTrapezoid : public AdvFuncBase {

    public:
        /** constructor */
        AdvTrapezoid();
        /** destructor */
        ~AdvTrapezoid();

        Double eval(  const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
        Double der2nd(const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
        Double derH(  const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
        Double derT0( const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
        Double derT1( const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
        Double derT2( const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
        Double derT3( const Double x, const Double t0, const Double t1, const Double t2, const Double t3, const Double h);
#endif // HAVE_DIFFERENTIAL_MEMBER

#ifdef USE_POINTER
        /** evaluate the value of the function */
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. derived coefficient  */
        Double der1st(const Double x, const Double *p);
        /** evaluate the value of the 2nd. derived coefficient  */
        Double der2nd(const Double x, const Double *p);
        /** evaluate the gradient of the function for parameters */
        Double * gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        /** evaluate the value of the function */
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. derived coefficient  */
        Double der1st(const Double x, const std::vector<Double> &p);
        /** evaluate the value of the 2nd. derived coefficient  */
        Double der2nd(const Double x, const std::vector<Double> &p);
        /** evaluate the gradient of the function for parameters */
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR
};

#endif
