#ifndef SMOOTHING_H
#define SMOOTHING_H

#include "Header.hh"
#include "HeaderBase.hh"
#include "ElementContainer.hh"
#include "AdvMethod.hh"
#include "AdvMethodType.hh"
#include "AdvOperationBase.hh"



/**
 *  smoothing
 */
class AdvSmoothing : virtual public AdvOperationBase {

    private:
        static const std::string className; //=sreing("AdvSmoothing");

    public:
        /**
         *  default constructor
         */
        AdvSmoothing();

        /** constructor */
        AdvSmoothing(ElementContainer *src) ;
#ifndef SWIGPYTHON
        AdvSmoothing(ElementContainer *src,       AdvMethod     *method) ;
#endif
        AdvSmoothing(ElementContainer *src, const AdvMethodType &methodType) ;
        AdvSmoothing(ElementContainer *src, const std::string     &methodName) ;
#ifndef SWIGPYTHON
        AdvSmoothing(ElementContainer *src,       AdvMethod     *method,     const Double xLower, const Double xUpper) ;
#endif
        AdvSmoothing(ElementContainer *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper) ;
        AdvSmoothing(ElementContainer *src, const std::string     &methodName, const Double xLower, const Double xUpper) ;
#ifndef SWIGPYTHON
        AdvSmoothing(ElementContainer *src,       AdvMethod     *method,     const UInt4  lower,  const UInt4  upper) ;
#endif
        AdvSmoothing(ElementContainer *src, const AdvMethodType &methodType, const UInt4  lower,  const UInt4  upper) ;
        AdvSmoothing(ElementContainer *src, const std::string     &methodName, const UInt4  lower,  const UInt4  upper) ;

        /**
         *  destructor
         */
        ~AdvSmoothing();

        /**
         *  chi square for moving average
         */
        Double chiSq();

        /**
         *  do smoothing
         */
        void execute();

        ///**
        // * file output of result
        // */
        //void put(std::string filePath);
};

#endif
