#ifndef SIMULATEDANNEALING_CONSTS
#define SIMULATEDANNEALING_CONSTS

#include "Header.hh"

class AdvSimulatedAnnealingConsts {

    private:
        static const std::string className; // =std::string("AdvSimulatedAnnealingConsts");

    public:
        /** key for the kind of the constrain */
        static const std::string CONSTRAIN;          //=std::string("constrain");

        static const std::string USE_DATA_WEIGHTS;  //=std::string("use data weights");

        /** key for output interval */
        static const std::string OUTPUT_INTERVAL;    //=std::string("output interval");

        /* parameters for simulated annealing */
        static const std::string N_TRIES;        //=std::string("n_tries");
        static const std::string ITERS_FIXED_T;  //=std::string("iters_fixed_t");
        static const std::string STEP_SIZE;      //=std::string("step_size");
        static const std::string K;              //=std::string("k");
        static const std::string T_INITIAL;      //=std::string("t_initial");
        static const std::string MU_T;           //=std::string("mu_t");
        static const std::string T_MIN;          //=std::string("t_min");

        /** key for fitting function */
        static const std::string FUNCTIONS;         //= std::string("function");

        /** ley for the flag of using data weight */
        /** keys for a set of initial values of fitting parameters */
        /** key for initival values for fitting parameters */
        static const std::string INITIAL_PARAM_VALUES; //=std::string("initial param values");
        static const std::string PARAMETER_VALUES;   //=std::string("parameter values");

        /** key for a set of the refference data */
        static const std::string REFERENCE_VALUES;   //=std::string("reference values");

        /** keys for lower bound of box constrains */
        static const std::string LOWER_BOUNDS;     //=std::string("lower bound");
        /** keys for upper bound of box constrains */
        static const std::string UPPER_BOUNDS;     //=std::string("upper bound");
        /** key for weights of box constrains */
        static const std::string BOX_WEIGHTS;      //=std::string("box weight");

        /** iteration count */
        static const std::string ITERATION_COUNT;    //=std::string("iteration count");
        /** parameter errors */
        static const std::string PARAM_ERRORS;       //=std::string("param. errors");

        /** the number times of function evaluations */
        static const std::string FUNCTION_EVALUATIONS;  //=std::string("function evaluations")
        /** the tile of iteration */
        static const std::string ITERATION_TIME;        //

        /** constrain */
        enum Constrain {
            NO_CONSTRAIN, /* no constrain */
            BOX,          /* box */
        };

        static const Constrain  DEFAULT_CONSTRAIN;          //=BOX;
        static const Bool       DEFAULT_USE_DATA_WEIGHTS;   //=true;

        static const UInt4      DEFAULT_OUTPUT_INTERVAL;    // =1000U;

        static const Int4       DEFAULT_N_TRIES;
        static const Int4       DEFAULT_ITERS_FIXED_T;
        static const Double     DEFAULT_STEP_SIZE;
        static const Double     DEFAULT_K;
        static const Double     DEFAULT_T_INITIAL;
        static const Double     DEFAULT_MU_T;
        static const Double     DEFAULT_T_MIN;

        /** constrain */
        static const std::string CONSTRAIN_STR[];

        /** stopping stat */
        //enum SimulatedAnnealingStat {
        //    CONTINUE                  = 8,
        //    FORCE_QUIT_BY_USER        = 9,
        //    SUSPEND                   =10,
        //};
        /** termination reason, translate a SimulatedAnnealingStat value to a string */
        //static const std::string TERMINATION_REASON[];
};

#endif // SIMULATEDANNEALING_CONSTS
