#ifndef POLYNOMIAL2CONV_HH
#define POLYNOMIAL2CONV_HH

#include "Header.hh"
#include "AdvFuncConv.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForPolynomial2Conv 1

class AdvPolynomial2Conv : public AdvFuncBase, public AdvFuncConv{

    public:
        AdvPolynomial2Conv();
        ~AdvPolynomial2Conv();

        Double Polynomial2Func(const Double x, const Double p);
        Double Polynomial2ConvFunc(const Double x, const Double p);

#ifdef USE_POINTER
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double *p);
        Double der2nd(const Double x, const Double *p);
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const std::vector<Double> &p);
        Double der2nd(const Double x, const std::vector<Double> &p);
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

};
#endif // POLYNOMIAL1_HH

