#ifndef POLYNOMIAL1_HH
#define POLYNOMIAL1_HH

#include "Header.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForPolynomial1 1

class AdvPolynomial1 : public AdvFuncBase {

    public:
        AdvPolynomial1();
        ~AdvPolynomial1();

#ifdef USE_POINTER
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double *p);
        Double der2nd(const Double x, const Double *p);
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const std::vector<Double> &p);
        Double der2nd(const Double x, const std::vector<Double> &p);
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

};
#endif // POLYNOMIAL1_HH

