#include "AdvPolynomial1.hh"

#define NumberOfParamForPolynomial1 1

AdvPolynomial1::AdvPolynomial1() : AdvFuncBase(std::string("polynomial1"), std::string("p1"), NumberOfParamForPolynomial1)  {
}

AdvPolynomial1::~AdvPolynomial1() {
}

#ifdef USE_POINTER
Double AdvPolynomial1::eval(const Double x, const Double *p) {
    return p[0]*x;
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvPolynomial1::der1st(const Double x, const Double *p) {
    return p[0];
}

Double AdvPolynomial1::der2nd(const Double x, const Double *p) {
    return 0.0;
}

Double *AdvPolynomial1::gradient(const Double x, const Double *p) {
    Double *v=new Double[NumberOfParamForPolynomial1];
    v[0]=x;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
Double AdvPolynomial1::eval(const Double x, const std::vector<Double> &p) {
    return p.at(0)*x;
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvPolynomial1::der1st(const Double x, const std::vector<Double> &p) {
    return p.at(0);
}

Double AdvPolynomial1::der2nd(const Double x, const std::vector<Double> &p) {
    return 0.0;
}

std::vector<Double> AdvPolynomial1::gradient(const Double x, const std::vector<Double> &p) {
    std::vector<Double> *v=new std::vector<Double>(1);
    v->at(0)=x;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

