#ifndef PEAK_TYPE_H
#define PEAK_TYPE_H 1

#include <string>

enum peakTypeID {
    UNKNOWN_PEAK_TYPE_ID, /* unknown */
    PEAK_ID,              /* ordinal peak */
    SHOLDER_I_ID,         /* sholder in increase region */
    SHOLDER_D_ID,         /* sholder in decrease region */
};

struct _peakType {
    enum peakTypeID id;
    std::string symbol;
};

typedef struct _peakType AdvPeakType;

/*
const AdvPeakType UNKNOWN_PEAK_TYPE={ UNKNOWN_PEAK_TYPE_ID, std::string("uk") };
const AdvPeakType PEAK             ={ PEAK_ID,              std::string("p")  };
const AdvPeakType SHOLDER_I        ={ SHOLDER_I_ID,         std::string("si") };
const AdvPeakType SHOLDER_D        ={ SHOLDER_D_ID,         std::string("sd") };
*/

extern const AdvPeakType UNKNOWN_PEAK_TYPE;
extern const AdvPeakType PEAK;
extern const AdvPeakType SHOLDER_I;
extern const AdvPeakType SHOLDER_D;

#endif // PEAK_TYPE_H
