#ifndef OPERATION_TYPE_HH
#define OPERATION_TYPE_HH

#include <string>
#include "Header.hh"

enum OperationID {
    UNKNOWN_OPERATION_ID,
    SMOOTHING_ID,
    PEAK_SEARCH_ID,
    PEAK_FIT_ID,
    MULTI_DATA_PEAK_FIT_ID,
    BACK_GROUND_ESTIMATION_ID,
};

struct _AdvOperationType {
    enum OperationID id;
    std::string name;
};

typedef struct _AdvOperationType AdvOperationType;

extern const AdvOperationType UNKNOWN_OPERATION;
extern const AdvOperationType SMOOTHING;
extern const AdvOperationType PEAK_SEARCH;
extern const AdvOperationType PEAK_FIT;
extern const AdvOperationType MULTI_DATA_PEAK_FIT;
extern const AdvOperationType BACK_GROUND_ESTIMATION;

#endif // OPERATION_TYPE_HH
