#ifndef MULTI_DATA_METHOD_FACTORY_H
#define MULTI_DATA_METHOD_FACTORY_H

#ifdef SWIGPYTHON
class AdvMultiDataMethodFactory;
#else //  SWIGPYTHON

#include "Header.hh"

#include "AdvMultiDataMethod.hh"

#include "AdvMultiDataLevmar.hh"
#include "AdvConvolutionByFFT.hh"
#include "AdvDeconvolutionByFFT.hh"
#include "AdvEqualSpacing.hh"

#include "AdvMethodType.hh"

class AdvMultiDataMethodFactory {

    private:
        static const std::string className; //=std::string("AdvMultiDataMethodFactory");

    private:
        //static AdvMultiDataMethodFactory *instance = static_cast<AdvMultiDataMethodFactory*>(NULL);
        //static AdvMultiDataMethodFactory *instance = NULL;
        static AdvMultiDataMethodFactory *instance; // = intial value is NULL

    protected:
        /** cefault constructor */
        AdvMultiDataMethodFactory();

    public:
        /** return singlton instance */
        static AdvMultiDataMethodFactory *getInstance();

        AdvMultiDataMethod *createMethod(const AdvMethodType &type);
        AdvMultiDataMethod *createMethod(std::string methodName);

};

#endif // SWIGPYTHON

#endif // MULTI_DATA_METHOD_FACTORY_H
