#ifndef MODELPARAMSET_HH
#define MODELPARAMSET_HH

#include "Header.hh"
#include <vector>
#include <list>

class AdvModelParam;

/**
    AdvModelParamSet
      Function のパラメータを一箇所にまとめたパラメータセットのクラス
*/
class AdvModelParamSet {
public:
    AdvModelParamSet();
    virtual ~AdvModelParamSet();

    /** 新しいパラメータを用意し、パラメータセットへ登録 */
    AdvModelParam* NewParam(std::string s);
    AdvModelParam* NewParam();

    /** パラメータを削除 */
    void DeleteParam(AdvModelParam* p);
    void DeleteAll();

    /** フィット対象のパラメータ数を返す */
    Int4 GetNumParam ();
    Int4 GetNumFitParam ();

    /**
     * フィッティングルーチンへ渡すための
     * パラメータの初期値・上限値・下限値を返す
     */
    std::vector<Double> GetParamValues ();
    std::vector<Double> GetUpperValues ();
    std::vector<Double> GetLowerValues ();

    /**
     * フィッティングルーチンから与えられた値を
     * パラメータへ渡す
     */
    void SetParamValues (const std::vector<Double> v);
    void SetParamValues (const Double v[]);

protected:
    Bool modify;

    void PrepareFit ();
	
    std::list<AdvModelParam*> m_Params;      //!  パラメータの(ポインタの)リスト

    std::vector<std::vector<AdvModelParam*> > m_fitParams;

};

#endif

